/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;

public abstract class AbstractViewAction
extends AbstractAction {
    private Application app;
    private String propertyName;
    public static final String VIEW_PROPERTY = "view";
    public static final String ENABLED_PROPERTY = "enabled";
    private PropertyChangeListener applicationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "activeView") {
                AbstractViewAction.this.updateView((View)evt.getOldValue(), (View)evt.getNewValue());
            }
        }
    };
    private PropertyChangeListener viewListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == AbstractViewAction.ENABLED_PROPERTY) {
                AbstractViewAction.this.updateEnabled((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
            } else if (name == AbstractViewAction.this.propertyName) {
                AbstractViewAction.this.updateView();
            }
        }
    };

    public AbstractViewAction(Application app) {
        this.app = app;
        this.enabled = true;
        if (app != null) {
            app.addPropertyChangeListener(this.applicationListener);
            this.updateView(null, app.getActiveView());
        }
    }

    protected void updateView(View oldValue, View newValue) {
        if (oldValue != null) {
            this.uninstallViewListeners(oldValue);
        }
        if (newValue != null) {
            this.installViewListeners(newValue);
        }
        this.firePropertyChange(VIEW_PROPERTY, oldValue, newValue);
        this.updateEnabled(oldValue != null && oldValue.isEnabled(), newValue != null && newValue.isEnabled());
        this.updateView();
    }

    protected void setPropertyName(String name) {
        this.propertyName = name;
        if (name != null) {
            this.updateView();
        }
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected void updateView() {
    }

    protected void installViewListeners(View p) {
        p.addPropertyChangeListener(this.viewListener);
    }

    protected void uninstallViewListeners(View p) {
        p.removePropertyChangeListener(this.viewListener);
    }

    protected void updateEnabled(boolean oldValue, boolean newValue) {
        this.firePropertyChange(ENABLED_PROPERTY, oldValue, newValue && this.isEnabled());
    }

    public Application getApplication() {
        return this.app;
    }

    public View getActiveView() {
        return this.app.getActiveView();
    }

    @Override
    public boolean isEnabled() {
        return this.getActiveView() != null && this.getActiveView().isEnabled() && this.enabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        boolean projIsEnabled = this.getActiveView() != null && this.getActiveView().isEnabled();
        this.firePropertyChange(ENABLED_PROPERTY, oldValue && projIsEnabled, newValue && projIsEnabled);
    }
}

