/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import org.jhotdraw.color.ColorSystem;

public class CompositeColor
implements Cloneable {
    private ColorSystem system;
    private float[] components;
    private Color color;

    public CompositeColor(ColorSystem system, float ... components) {
        this.system = system;
        this.components = (float[])components.clone();
    }

    public CompositeColor(ColorSystem system, Color color) {
        this.system = system;
        this.components = system.toComponents(color.getRGB(), null);
    }

    public float[] getComponents() {
        return (float[])this.components.clone();
    }

    public float getComponent(int i) {
        return this.components[i];
    }

    public float[] getComponents(float[] reuse) {
        if (reuse == null || reuse.length != this.system.getComponentCount()) {
            reuse = new float[this.system.getComponentCount()];
        }
        System.arraycopy(this.components, 0, reuse, 0, this.system.getComponentCount());
        return reuse;
    }

    public Color getColor() {
        if (this.color == null) {
            this.color = new Color(this.system.toRGB(this.components));
        }
        return this.color;
    }

    public ColorSystem getSystem() {
        return this.system;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CompositeColor[");
        for (int i = 0; i < this.components.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append((int)(this.components[i] * 100.0f));
        }
        buf.append("]");
        return buf.toString();
    }

    public CompositeColor clone() {
        try {
            CompositeColor that = (CompositeColor)super.clone();
            that.components = (float[])this.components.clone();
            return that;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("CompositeColor not cloneable.");
        }
    }
}

