/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.Point;
import org.jhotdraw.color.ColorWheelImageProducer;
import org.jhotdraw.color.HSVRYBColorSystem;

public class HSVHarmonicColorWheelImageProducer
extends ColorWheelImageProducer {
    private float wheelScaleFactor;
    private float[] brights;
    private boolean isDiscrete = true;

    public HSVHarmonicColorWheelImageProducer(int w, int h) {
        super(new HSVRYBColorSystem(), w, h);
    }

    @Override
    protected void generateLookupTables() {
        this.wheelScaleFactor = 1.35f;
        this.isDiscrete = false;
        if (this.isDiscrete) {
            this.generateDiscreteLookupTables();
        } else {
            this.generateContiguousLookupTables();
        }
    }

    protected void generateContiguousLookupTables() {
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.brights = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.w / 2;
        int cy = this.h / 2;
        for (int x = 0; x < this.w; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.h; ++y) {
                int ky = cy - y;
                int index = x + y * this.w;
                float r = (float)Math.sqrt(squarekx + ky * ky) / radius;
                float sat = r * this.wheelScaleFactor;
                if (r <= 1.0f) {
                    this.alphas[index] = -16777216;
                    this.radials[index] = Math.min(1.0f, sat * 2.0f);
                    this.brights[index] = Math.min(1.0f, 1.5f - sat);
                } else {
                    this.alphas[index] = (int)((blend - Math.min(blend, r - 1.0f)) * 255.0f / blend) << 24;
                    this.radials[index] = 1.0f;
                    this.brights[index] = Math.max(0.0f, Math.min(1.0f, 1.5f - sat));
                }
                if (this.alphas[index] == 0) continue;
                this.angulars[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0);
            }
        }
    }

    protected void generateDiscreteLookupTables() {
        this.radials = new float[this.w * this.h];
        this.angulars = new float[this.w * this.h];
        this.brights = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.w / 2;
        int cy = this.h / 2;
        for (int x = 0; x < this.w; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.h; ++y) {
                int ky = cy - y;
                int index = x + y * this.w;
                float r = (float)Math.sqrt(squarekx + ky * ky) / radius;
                float sat = r * this.wheelScaleFactor;
                if (r <= 1.0f) {
                    this.alphas[index] = -16777216;
                    this.radials[index] = (float)Math.round(Math.min(1.0f, sat * 2.0f) * 5.0f) / 5.0f;
                    this.brights[index] = (float)Math.round(Math.min(1.0f, 1.5f - sat) * 10.0f) / 10.0f;
                } else {
                    this.alphas[index] = (int)((blend - Math.min(blend, r - 1.0f)) * 255.0f / blend) << 24;
                    this.radials[index] = 1.0f;
                    this.brights[index] = Math.max(0.0f, (float)Math.round(Math.min(1.0f, 1.5f - sat * 1.0f) * 10.0f) / 10.0f);
                }
                if (this.alphas[index] == 0) continue;
                this.angulars[index] = (float)Math.round((float)(Math.atan2(ky, kx) / Math.PI / 2.0) * 12.0f) / 12.0f;
            }
        }
    }

    @Override
    public void generateColorWheel() {
        float radius = Math.min(this.w, this.h);
        for (int index = 0; index < this.pixels.length; ++index) {
            if (this.alphas[index] == 0) continue;
            this.pixels[index] = this.alphas[index] | 0xFFFFFF & this.colorSystem.toRGB(this.angulars[index], this.radials[index], this.brights[index]);
        }
        this.newPixels();
        this.isPixelsValid = false;
    }

    @Override
    protected Point getColorLocation(Color c, int width, int height) {
        float[] hsb = new float[3];
        hsb = this.colorSystem.toComponents(c.getRGB(), hsb);
        return this.getColorLocation(hsb[0], hsb[1], hsb[2], width, height);
    }

    @Override
    protected Point getColorLocation(float hue, float saturation, float brightness, int width, int height) {
        float radius = (float)Math.min(width, height) / 2.0f;
        float radiusH = radius / 2.0f;
        saturation = Math.max(0.0f, Math.min(1.0f, saturation));
        Point p = (brightness = Math.max(0.0f, Math.min(1.0f, brightness))) == 1.0f ? new Point(width / 2 + (int)((double)(radiusH * saturation) * Math.cos((double)hue * Math.PI * 2.0) / (double)this.wheelScaleFactor), height / 2 - (int)((double)(radiusH * saturation) * Math.sin((double)hue * Math.PI * 2.0) / (double)this.wheelScaleFactor)) : new Point(width / 2 + (int)((double)(radius + radiusH - radius * brightness) * Math.cos((double)hue * Math.PI * 2.0) / (double)this.wheelScaleFactor), height / 2 - (int)((double)(radius + radiusH - radius * brightness) * Math.sin((double)hue * Math.PI * 2.0) / (double)this.wheelScaleFactor));
        return p;
    }

    @Override
    protected float[] getColorAt(int x, int y, int width, int height) {
        float r = (float)Math.sqrt((x -= width / 2) * x + (y -= height / 2) * y);
        float theta = (float)Math.atan2(-y, x);
        float radius = (float)Math.min(width, height) / 2.0f;
        float sat = r / radius * this.wheelScaleFactor;
        float hue = (float)((double)theta / Math.PI / 2.0);
        if (hue < 0.0f) {
            hue += 1.0f;
        }
        float[] hsb = new float[]{hue, Math.min(1.0f, sat * 2.0f), Math.min(1.0f, 1.5f - sat)};
        return hsb;
    }
}

