/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.CompositeColor;
import org.jhotdraw.color.DefaultHarmonicColorModel;
import org.jhotdraw.color.HSLRYBColorSystem;
import org.jhotdraw.color.HarmonicColorModel;
import org.jhotdraw.color.JColorWheel;

public class JHarmonicColorWheel
extends JColorWheel {
    public static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private HarmonicColorModel harmonicModel;
    private int selectedIndex = -1;
    private float handleRadius = 4.0f;
    private float baseRadius = 7.0f;
    private MouseHandler mouseHandler;
    private ModelHandler modelHandler;

    public JHarmonicColorWheel() {
        super(new HSLRYBColorSystem());
        this.initComponents();
        this.setRadialComponentIndex(2);
        this.setVerticalComponentIndex(1);
        this.getModel().setComponentValue(1, 1.0f);
        this.setWheelInsets(new Insets(5, 5, 5, 5));
        this.modelHandler = new ModelHandler();
        DefaultHarmonicColorModel p = new DefaultHarmonicColorModel();
        this.setHarmonicColorModel(p);
        this.setToolTipText("");
    }

    public void setColorSystem(ColorSystem newValue) {
        this.harmonicModel.setColorSystem(newValue);
        this.getModel().setColorSystem(newValue);
        this.getModel().setComponentValue(1, 1.0f);
    }

    public HarmonicColorModel getHarmonicColorModel() {
        return this.harmonicModel;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        float[] hsb = this.getColorAt(evt.getX(), evt.getY());
        if (hsb == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(Math.round(hsb[0] * 360.0f));
        buf.append(",");
        buf.append(Math.round(hsb[1] * 100.0f));
        buf.append(",");
        buf.append(Math.round(hsb[2] * 100.0f));
        if (buf.length() > 0) {
            buf.insert(0, "<html>");
            return buf.toString();
        }
        return null;
    }

    @Override
    protected void installMouseListeners() {
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
    }

    public void setHarmonicColorModel(HarmonicColorModel newValue) {
        HarmonicColorModel oldValue = this.harmonicModel;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.modelHandler);
            oldValue.removeListDataListener(this.modelHandler);
        }
        this.harmonicModel = newValue;
        if (newValue != null) {
            newValue.addPropertyChangeListener(this.modelHandler);
            newValue.addListDataListener(this.modelHandler);
            this.colorWheelProducer = this.createWheelProducer(this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        super.paintComponent(g);
    }

    @Override
    protected void paintThumb(Graphics2D g) {
        this.paintTicks(g);
        if (this.harmonicModel != null) {
            Point p;
            int i;
            Point center = this.getCenter();
            Ellipse2D.Float oval = new Ellipse2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
            float[] comp = null;
            float wheelBrightness = (float)this.model.getBoundedRangeModel(2).getValue() / 100.0f;
            for (i = this.harmonicModel.size() - 1; i >= 0; --i) {
                if (this.harmonicModel.get(i) == null) continue;
                p = this.getColorLocation(this.harmonicModel.get(i));
                g.setColor(Color.black);
                g.drawLine(center.x, center.y, p.x, p.y);
            }
            for (i = this.harmonicModel.size() - 1; i >= 0; --i) {
                if (this.harmonicModel.get(i) == null) continue;
                p = this.getColorLocation(this.harmonicModel.get(i));
                CompositeColor mixerColor = this.harmonicModel.get(i);
                comp = mixerColor.getComponents();
                if (i == this.selectedIndex) {
                    g.setColor(Color.white);
                    oval.x = (float)p.x - this.baseRadius;
                    oval.y = (float)p.y - this.baseRadius;
                    oval.width = this.baseRadius * 2.0f;
                    oval.height = this.baseRadius * 2.0f;
                    g.fill(oval);
                }
                g.setColor(mixerColor.getColor());
                oval.x = (float)p.x - this.handleRadius;
                oval.y = (float)p.y - this.handleRadius;
                oval.width = this.handleRadius * 2.0f;
                oval.height = this.handleRadius * 2.0f;
                g.fill(oval);
                g.setColor(Color.black);
                g.draw(oval);
                if (i != this.harmonicModel.getBase()) continue;
                oval.x = (float)p.x - this.baseRadius;
                oval.y = (float)p.y - this.baseRadius;
                oval.width = this.baseRadius * 2.0f;
                oval.height = this.baseRadius * 2.0f;
                g.draw(oval);
            }
        }
    }

    protected void paintTicks(Graphics2D g) {
    }

    public void setSelectedIndex(int newValue) {
        int oldValue = this.selectedIndex;
        this.selectedIndex = newValue;
        this.firePropertyChange(SELECTED_INDEX_PROPERTY, oldValue, newValue);
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    protected Point getColorLocation(CompositeColor c) {
        Point p = this.colorWheelProducer.getColorLocation(c, this.getWidth() - this.wheelInsets.left - this.wheelInsets.right, this.getHeight() - this.wheelInsets.top - this.wheelInsets.bottom);
        p.x += this.wheelInsets.left;
        p.y += this.wheelInsets.top;
        return p;
    }

    private void initComponents() {
        this.setLayout(new FlowLayout());
    }

    private class ModelHandler
    implements PropertyChangeListener,
    ListDataListener {
        private ModelHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "colorSystem") {
                JHarmonicColorWheel.this.model.setColorSystem(JHarmonicColorWheel.this.harmonicModel.getColorSystem());
                JHarmonicColorWheel.this.model.setComponentValue(1, 1.0f);
                JHarmonicColorWheel.this.colorWheelProducer = JHarmonicColorWheel.this.createWheelProducer(JHarmonicColorWheel.this.getWidth(), JHarmonicColorWheel.this.getHeight());
                JHarmonicColorWheel.this.colorWheelImage = null;
            }
            JHarmonicColorWheel.this.repaint();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            JHarmonicColorWheel.this.repaint();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            JHarmonicColorWheel.this.repaint();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            JHarmonicColorWheel.this.repaint();
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.update(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int closestIndex = -1;
            if (JHarmonicColorWheel.this.harmonicModel != null && JHarmonicColorWheel.this.harmonicModel.size() > 0) {
                int closestError = Integer.MAX_VALUE;
                int n = JHarmonicColorWheel.this.harmonicModel.size();
                for (int i = 0; i < n; ++i) {
                    CompositeColor c = JHarmonicColorWheel.this.harmonicModel.get(i);
                    if (c == null) continue;
                    Point p = JHarmonicColorWheel.this.getColorLocation(JHarmonicColorWheel.this.harmonicModel.get(i));
                    int error = (p.x - x) * (p.x - x) + (p.y - y) * (p.y - y);
                    if (error >= closestError) continue;
                    closestIndex = i;
                    closestError = error;
                }
                if (closestIndex != -1 && closestError > 20) {
                    closestIndex = -1;
                }
            }
            JHarmonicColorWheel.this.setSelectedIndex(closestIndex);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private void update(MouseEvent e) {
            if (JHarmonicColorWheel.this.selectedIndex != -1) {
                float[] hsb = JHarmonicColorWheel.this.getColorAt(e.getX(), e.getY());
                hsb[1] = JHarmonicColorWheel.this.harmonicModel.get(JHarmonicColorWheel.this.selectedIndex).getComponent(1);
                JHarmonicColorWheel.this.harmonicModel.set(JHarmonicColorWheel.this.selectedIndex, new CompositeColor(JHarmonicColorWheel.this.harmonicModel.getColorSystem(), hsb));
                JHarmonicColorWheel.this.repaint();
            }
        }
    }
}

