/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.util.ResourceBundleUtil;

public class GeometryEdit
extends AbstractUndoableEdit {
    private Figure owner;
    private Object oldGeometry;
    private Object newGeometry;

    public GeometryEdit(Figure owner, Object oldGeometry, Object newGeometry) {
        this.owner = owner;
        this.oldGeometry = oldGeometry;
        this.newGeometry = newGeometry;
    }

    @Override
    public String getPresentationName() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
        return labels.getString("edit.transform.text");
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        this.owner.restoreTransformTo(this.oldGeometry);
        this.owner.changed();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.restoreTransformTo(this.newGeometry);
        this.owner.changed();
    }
}

