/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.geom.Geom;

public class RectangleFigure
extends AbstractAttributedFigure {
    protected Rectangle2D.Double rectangle;

    public RectangleFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public RectangleFigure(double x, double y, double width, double height) {
        this.rectangle = new Rectangle2D.Double(x, y, width, height);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularFillGrowth(this);
        Geom.grow(r, grow, grow);
        g.fill(r);
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularDrawGrowth(this);
        Geom.grow(r, grow, grow);
        g.draw(r);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double bounds = (Rectangle2D.Double)this.rectangle.clone();
        return bounds;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
        Geom.grow(r, grow, grow);
        return r;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.rectangle.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth(this) + 1.0;
        Geom.grow(r, grow, grow);
        return r.contains(p);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.rectangle.x = Math.min(anchor.x, lead.x);
        this.rectangle.y = Math.min(anchor.y, lead.y);
        this.rectangle.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.rectangle.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
    }

    @Override
    public void transform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Rectangle2D.Double r = (Rectangle2D.Double)geometry;
        this.rectangle.x = r.x;
        this.rectangle.y = r.y;
        this.rectangle.width = r.width;
        this.rectangle.height = r.height;
    }

    @Override
    public Object getTransformRestoreData() {
        return this.rectangle.clone();
    }

    @Override
    public RectangleFigure clone() {
        RectangleFigure that = (RectangleFigure)super.clone();
        that.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        return that;
    }
}

