/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.datatransfer.AbstractTransferable;
import org.jhotdraw.io.ExtensionFileFilter;

public class SerializationInputOutputFormat
implements InputFormat,
OutputFormat {
    private String description;
    private String fileExtension;
    private String formatName;
    private String mimeType;
    private DataFlavor dataFlavor;
    private Drawing prototype;

    public SerializationInputOutputFormat() {
        this("Drawing", "ser", new DefaultDrawing());
    }

    public SerializationInputOutputFormat(String description, String fileExtension, Drawing prototype) {
        this.description = description;
        this.fileExtension = fileExtension;
        this.mimeType = "application/x-java-serialized-object";
        this.prototype = prototype;
        this.dataFlavor = new DataFlavor(prototype.getClass(), description);
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file, Drawing drawing, boolean replace) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.read(in, drawing, replace);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public void read(InputStream in, Drawing drawing, boolean replace) throws IOException {
        try {
            ObjectInputStream oin = new ObjectInputStream(in);
            Drawing d = (Drawing)oin.readObject();
            if (replace) {
                for (Map.Entry entry : d.getAttributes().entrySet()) {
                    ((AttributeKey)entry.getKey()).basicSet(drawing, entry.getValue());
                }
            }
            for (Figure figure : d.getChildren()) {
                drawing.add(figure);
            }
        }
        catch (ClassNotFoundException ex) {
            IOException ioe = new IOException("Couldn't read drawing.");
            ioe.initCause(ex);
            throw ioe;
        }
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.dataFlavor);
    }

    @Override
    public void read(Transferable t, Drawing drawing, boolean replace) throws UnsupportedFlavorException, IOException {
        try {
            Drawing d = (Drawing)t.getTransferData(this.dataFlavor);
            if (replace) {
                for (Map.Entry entry : d.getAttributes().entrySet()) {
                    ((AttributeKey)entry.getKey()).basicSet(drawing, entry.getValue());
                }
            }
            for (Figure figure : d.getChildren()) {
                drawing.add(figure);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file, Drawing drawing) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.write(out, drawing);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void write(OutputStream out, Drawing drawing) throws IOException {
        ObjectOutputStream oout = new ObjectOutputStream(out);
        oout.writeObject(drawing);
        oout.flush();
    }

    @Override
    public Transferable createTransferable(Drawing drawing, List<Figure> figures, double scaleFactor) throws IOException {
        final Drawing d = (Drawing)this.prototype.clone();
        HashMap<Figure, Figure> originalToDuplicateMap = new HashMap<Figure, Figure>(figures.size());
        ArrayList<Figure> duplicates = new ArrayList<Figure>(figures.size());
        for (Figure f : figures) {
            Figure df = (Figure)f.clone();
            d.add(df);
            duplicates.add(df);
            originalToDuplicateMap.put(f, df);
        }
        for (Figure f : duplicates) {
            f.remap(originalToDuplicateMap, true);
        }
        return new AbstractTransferable(this.dataFlavor){

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(flavor)) {
                    return d;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
    }
}

