/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeometryEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.RotateHandle;
import org.jhotdraw.util.ResourceBundleUtil;

public class TransformHandleKit {
    public static void addCornerTransformHandles(Figure f, Collection<Handle> handles) {
        handles.add(TransformHandleKit.southEast(f));
        handles.add(TransformHandleKit.southWest(f));
        handles.add(TransformHandleKit.northEast(f));
        handles.add(TransformHandleKit.northWest(f));
    }

    public static void addEdgeTransformHandles(Figure f, Collection<Handle> handles) {
        handles.add(TransformHandleKit.south(f));
        handles.add(TransformHandleKit.north(f));
        handles.add(TransformHandleKit.east(f));
        handles.add(TransformHandleKit.west(f));
    }

    public static void addScaleMoveTransformHandles(Figure f, Collection<Handle> handles) {
        TransformHandleKit.addCornerTransformHandles(f, handles);
        TransformHandleKit.addEdgeTransformHandles(f, handles);
    }

    public static void addTransformHandles(Figure f, Collection<Handle> handles) {
        handles.add(new BoundsOutlineHandle(f, true, false));
        TransformHandleKit.addCornerTransformHandles(f, handles);
        TransformHandleKit.addEdgeTransformHandles(f, handles);
        handles.add(new RotateHandle(f));
    }

    public static void addGroupTransformHandles(Figure f, Collection<Handle> handles) {
        handles.add(new BoundsOutlineHandle(f, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2_DISABLED));
        TransformHandleKit.addCornerTransformHandles(f, handles);
        TransformHandleKit.addEdgeTransformHandles(f, handles);
        handles.add(new RotateHandle(f));
    }

    public static void addGroupHoverHandles(Figure f, Collection<Handle> handles) {
        handles.add(new BoundsOutlineHandle(f, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1_HOVER, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1_HOVER, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2_HOVER, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2_HOVER, HandleAttributeKeys.GROUP_BOUNDS_STROKE_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_1_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_STROKE_2_DISABLED, HandleAttributeKeys.GROUP_BOUNDS_COLOR_2_DISABLED));
    }

    public static Handle south(Figure owner) {
        return new SouthHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    public static Handle north(Figure owner) {
        return new NorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new EastHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new WestHandle(owner);
    }

    private static class WestHandle
    extends TransformHandle {
        WestHandle(Figure owner) {
            super(owner, RelativeLocator.west());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    evt.consume();
                    break;
                }
                case 40: {
                    evt.consume();
                    break;
                }
                case 37: {
                    this.transform(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.transform(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }

    private static class SouthWestHandle
    extends TransformHandle {
        SouthWestHandle(Figure owner) {
            super(owner, RelativeLocator.southWest());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    this.transform(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.transform(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(4);
        }
    }

    private static class SouthHandle
    extends TransformHandle {
        SouthHandle(Figure owner) {
            super(owner, RelativeLocator.south());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    evt.consume();
                    break;
                }
                case 39: {
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(9);
        }
    }

    private static class SouthEastHandle
    extends TransformHandle {
        SouthEastHandle(Figure owner) {
            super(owner, RelativeLocator.southEast());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), Math.max(r.y + 1.0, p.y)));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    if (r.height > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height - 1.0));
                    }
                    evt.consume();
                    break;
                }
                case 40: {
                    this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width, r.y + r.height + 1.0));
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(5);
        }
    }

    private static class NorthWestHandle
    extends TransformHandle {
        NorthWestHandle(Figure owner) {
            super(owner, RelativeLocator.northWest());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(Math.min(r.x + r.width - 1.0, p.x), Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.transform(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    this.transform(new Point2D.Double(r.x - 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 39: {
                    if (r.width > 1.0) {
                        this.transform(new Point2D.Double(r.x + 1.0, r.y), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(6);
        }
    }

    private static class NorthHandle
    extends TransformHandle {
        NorthHandle(Figure owner) {
            super(owner, RelativeLocator.north());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(r.x + r.width, r.y + r.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.transform(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    evt.consume();
                    break;
                }
                case 39: {
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(8);
        }
    }

    private static class EastHandle
    extends TransformHandle {
        EastHandle(Figure owner) {
            super(owner, RelativeLocator.east());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(Math.max(r.x + 1.0, p.x), r.y + r.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    evt.consume();
                    break;
                }
                case 40: {
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(11);
        }
    }

    private static class NorthEastHandle
    extends TransformHandle {
        NorthEastHandle(Figure owner) {
            super(owner, RelativeLocator.northEast());
        }

        @Override
        protected void trackStepNormalized(Point2D.Double p) {
            Rectangle2D.Double r = this.getTransformedBounds();
            this.transform(new Point2D.Double(r.x, Math.min(r.y + r.height - 1.0, p.y)), new Point2D.Double(Math.max(r.x, p.x), r.y + r.height));
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            Object geom = this.getOwner().getTransformRestoreData();
            Rectangle2D.Double r = this.getTransformedBounds();
            switch (evt.getKeyCode()) {
                case 38: {
                    this.transform(new Point2D.Double(r.x, r.y - 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    evt.consume();
                    break;
                }
                case 40: {
                    if (r.height > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y + 1.0), new Point2D.Double(r.x + r.width, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 37: {
                    if (r.width > 1.0) {
                        this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width - 1.0, r.y + r.height));
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    this.transform(new Point2D.Double(r.x, r.y), new Point2D.Double(r.x + r.width + 1.0, r.y + r.height));
                    evt.consume();
                }
            }
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), geom, this.getOwner().getTransformRestoreData()));
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(7);
        }
    }

    private static class TransformHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        private Object geometry;

        TransformHandle(Figure owner, Locator loc) {
            super(owner, loc);
        }

        @Override
        public String getToolTipText(Point p) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            return labels.getString("handle.transform.toolTipText");
        }

        @Override
        public void draw(Graphics2D g) {
            if (this.getEditor().getTool().supportsHandleInteraction()) {
                this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_STROKE_COLOR));
            } else {
                this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.TRANSFORM_HANDLE_STROKE_COLOR_DISABLED));
            }
        }

        protected void drawArc(Graphics2D g) {
            Point p = this.getLocation();
            g.drawArc(p.x, p.y, 6, 6, 0, 180);
        }

        protected Rectangle2D.Double getTransformedBounds() {
            Figure owner = this.getOwner();
            Rectangle2D.Double bounds = owner.getBounds();
            if (AttributeKeys.TRANSFORM.get(owner) != null) {
                Rectangle2D r = AttributeKeys.TRANSFORM.get(owner).createTransformedShape(bounds).getBounds2D();
                bounds.x = r.getX();
                bounds.y = r.getY();
                bounds.width = r.getWidth();
                bounds.height = r.getHeight();
            }
            return bounds;
        }

        @Override
        public void trackStart(Point anchor, int modifiersEx) {
            this.geometry = this.getOwner().getTransformRestoreData();
            Point location = this.getLocation();
            this.dx = -anchor.x + location.x;
            this.dy = -anchor.y + location.y;
        }

        @Override
        public void trackStep(Point anchor, Point lead, int modifiersEx) {
            Point2D.Double p = this.view.viewToDrawing(new Point(lead.x + this.dx, lead.y + this.dy));
            this.view.getConstrainer().constrainPoint(p);
            this.trackStepNormalized(p);
        }

        @Override
        public void trackEnd(Point anchor, Point lead, int modifiersEx) {
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), this.geometry, this.getOwner().getTransformRestoreData()));
        }

        protected void trackStepNormalized(Point2D.Double p) {
        }

        protected void transform(Point2D.Double anchor, Point2D.Double lead) {
            Figure f = this.getOwner();
            f.willChange();
            Rectangle2D.Double oldBounds = this.getTransformedBounds();
            Rectangle2D.Double newBounds = new Rectangle2D.Double(Math.min(anchor.x, lead.x), Math.min(anchor.y, lead.y), Math.abs(anchor.x - lead.x), Math.abs(anchor.y - lead.y));
            double sx = newBounds.width / oldBounds.width;
            double sy = newBounds.height / oldBounds.height;
            AffineTransform tx = new AffineTransform();
            tx.translate(-oldBounds.x, -oldBounds.y);
            if (!(Double.isNaN(sx) || Double.isNaN(sy) || sx == 1.0 && sy == 1.0 || sx < 1.0E-4 || sy < 1.0E-4)) {
                f.transform(tx);
                tx.setToIdentity();
                tx.scale(sx, sy);
                f.transform(tx);
                tx.setToIdentity();
            }
            tx.translate(newBounds.x, newBounds.y);
            f.transform(tx);
            f.changed();
        }
    }
}

