/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public class GroupAction
extends AbstractSelectedAction {
    public static final String ID = "edit.groupSelection";
    private CompositeFigure prototype;
    private boolean isGroupingAction;

    public GroupAction(DrawingEditor editor) {
        this(editor, new GroupFigure(), true);
    }

    public GroupAction(DrawingEditor editor, CompositeFigure prototype) {
        this(editor, prototype, true);
    }

    public GroupAction(DrawingEditor editor, CompositeFigure prototype, boolean isGroupingAction) {
        super(editor);
        this.prototype = prototype;
        this.isGroupingAction = isGroupingAction;
        this.labels.configureAction(this, ID);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.isGroupingAction ? this.canGroup() : this.canUngroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canGroup() {
        return this.getView() != null && this.getView().getSelectionCount() > 1;
    }

    protected boolean canUngroup() {
        return this.getView() != null && this.getView().getSelectionCount() == 1 && this.prototype != null && this.getView().getSelectedFigures().iterator().next().getClass().equals(this.prototype.getClass());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isGroupingAction) {
            if (this.canGroup()) {
                final DrawingView view = this.getView();
                final LinkedList<Figure> ungroupedFigures = new LinkedList<Figure>(view.getSelectedFigures());
                final CompositeFigure group = (CompositeFigure)this.prototype.clone();
                AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        return GroupAction.this.labels.getString("edit.groupSelection.text");
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        GroupAction.this.groupFigures(view, group, ungroupedFigures);
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        GroupAction.this.ungroupFigures(view, group);
                        super.undo();
                    }

                    @Override
                    public boolean addEdit(UndoableEdit anEdit) {
                        return super.addEdit(anEdit);
                    }
                };
                this.groupFigures(view, group, ungroupedFigures);
                this.fireUndoableEditHappened(edit);
            }
        } else if (this.canUngroup()) {
            final DrawingView view = this.getView();
            final CompositeFigure group = (CompositeFigure)this.getView().getSelectedFigures().iterator().next();
            final LinkedList<Figure> ungroupedFigures = new LinkedList<Figure>();
            AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return GroupAction.this.labels.getString("edit.ungroupSelection.text");
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    GroupAction.this.ungroupFigures(view, group);
                }

                @Override
                public void undo() throws CannotUndoException {
                    GroupAction.this.groupFigures(view, group, ungroupedFigures);
                    super.undo();
                }
            };
            ungroupedFigures.addAll(this.ungroupFigures(view, group));
            this.fireUndoableEditHappened(edit);
        }
    }

    public Collection<Figure> ungroupFigures(DrawingView view, CompositeFigure group) {
        LinkedList<Figure> figures = new LinkedList<Figure>(group.getChildren());
        view.clearSelection();
        group.basicRemoveAllChildren();
        view.getDrawing().basicAddAll(view.getDrawing().indexOf(group), figures);
        view.getDrawing().remove(group);
        view.addToSelection(figures);
        return figures;
    }

    public void groupFigures(DrawingView view, CompositeFigure group, Collection<Figure> figures) {
        List<Figure> sorted = view.getDrawing().sort(figures);
        int index = view.getDrawing().indexOf((Figure)sorted.iterator().next());
        view.getDrawing().basicRemoveAll(figures);
        view.clearSelection();
        view.getDrawing().add(index, group);
        group.willChange();
        for (Figure f : sorted) {
            group.basicAdd(f);
        }
        group.changed();
        view.addToSelection(group);
    }
}

