/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.draw.TranslationDirection;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public abstract class MoveConstrainedAction
extends AbstractSelectedAction {
    private TranslationDirection dir;

    public MoveConstrainedAction(DrawingEditor editor, TranslationDirection dir) {
        super(editor);
        this.dir = dir;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getView().getSelectionCount() > 0) {
            Rectangle2D.Double r = null;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (r == null) {
                    r = f.getBounds();
                    continue;
                }
                r.add(f.getBounds());
            }
            Point2D.Double p0 = new Point2D.Double(r.x, r.y);
            if (this.getView().getConstrainer() != null) {
                this.getView().getConstrainer().translateRectangle(r, this.dir);
            } else {
                switch (this.dir) {
                    case NORTH: {
                        r.y -= 1.0;
                        break;
                    }
                    case SOUTH: {
                        r.y += 1.0;
                        break;
                    }
                    case WEST: {
                        r.x -= 1.0;
                        break;
                    }
                    case EAST: {
                        r.x += 1.0;
                    }
                }
            }
            AffineTransform tx = new AffineTransform();
            tx.translate(r.x - p0.x, r.y - p0.y);
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                f.transform(tx);
                f.changed();
            }
            this.fireUndoableEditHappened(new TransformEdit(this.getView().getSelectedFigures(), tx));
        }
    }

    public static class South
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedSouth";

        public South(DrawingEditor editor) {
            super(editor, TranslationDirection.SOUTH);
            this.labels.configureAction(this, ID);
        }
    }

    public static class North
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedNorth";

        public North(DrawingEditor editor) {
            super(editor, TranslationDirection.NORTH);
            this.labels.configureAction(this, ID);
        }
    }

    public static class West
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedWest";

        public West(DrawingEditor editor) {
            super(editor, TranslationDirection.WEST);
            this.labels.configureAction(this, ID);
        }
    }

    public static class East
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedEast";

        public East(DrawingEditor editor) {
            super(editor, TranslationDirection.EAST);
            this.labels.configureAction(this, ID);
        }
    }
}

