/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.jhotdraw.geom.BezierPath;

public class BezierPathIterator
implements PathIterator {
    private int index = 0;
    private BezierPath path;
    private AffineTransform affine;
    private static final int[] curvesize = new int[]{2, 2, 4, 6, 0};

    public BezierPathIterator(BezierPath path) {
        this(path, null);
    }

    public BezierPathIterator(BezierPath path, AffineTransform at) {
        this.path = path;
        this.affine = at;
    }

    @Override
    public int getWindingRule() {
        return this.path.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.index >= this.path.size() + (this.path.isClosed() ? 2 : 0);
    }

    @Override
    public void next() {
        if (!this.isDone()) {
            ++this.index;
        }
    }

    @Override
    public int currentSegment(float[] coords) {
        int numCoords = 0;
        int type = 0;
        if (this.index == this.path.size()) {
            if (this.path.size() > 1) {
                BezierPath.Node previous = (BezierPath.Node)this.path.get(this.path.size() - 1);
                BezierPath.Node current = (BezierPath.Node)this.path.get(0);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        numCoords = 1;
                        type = 1;
                        coords[0] = (float)current.x[0];
                        coords[1] = (float)current.y[0];
                    } else {
                        numCoords = 2;
                        type = 2;
                        coords[0] = (float)current.x[1];
                        coords[1] = (float)current.y[1];
                        coords[2] = (float)current.x[0];
                        coords[3] = (float)current.y[0];
                    }
                } else if ((current.mask & 1) == 0) {
                    numCoords = 2;
                    type = 2;
                    coords[0] = (float)previous.x[2];
                    coords[1] = (float)previous.y[2];
                    coords[2] = (float)current.x[0];
                    coords[3] = (float)current.y[0];
                } else {
                    numCoords = 3;
                    type = 3;
                    coords[0] = (float)previous.x[2];
                    coords[1] = (float)previous.y[2];
                    coords[2] = (float)current.x[1];
                    coords[3] = (float)current.y[1];
                    coords[4] = (float)current.x[0];
                    coords[5] = (float)current.y[0];
                }
            }
        } else {
            if (this.index > this.path.size()) {
                return 4;
            }
            if (this.index == 0) {
                BezierPath.Node current = (BezierPath.Node)this.path.get(this.index);
                coords[0] = (float)current.x[0];
                coords[1] = (float)current.y[0];
                numCoords = 1;
                type = 0;
            } else if (this.index < this.path.size()) {
                BezierPath.Node current = (BezierPath.Node)this.path.get(this.index);
                BezierPath.Node previous = (BezierPath.Node)this.path.get(this.index - 1);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        numCoords = 1;
                        type = 1;
                        coords[0] = (float)current.x[0];
                        coords[1] = (float)current.y[0];
                    } else {
                        numCoords = 2;
                        type = 2;
                        coords[0] = (float)current.x[1];
                        coords[1] = (float)current.y[1];
                        coords[2] = (float)current.x[0];
                        coords[3] = (float)current.y[0];
                    }
                } else if ((current.mask & 1) == 0) {
                    numCoords = 2;
                    type = 2;
                    coords[0] = (float)previous.x[2];
                    coords[1] = (float)previous.y[2];
                    coords[2] = (float)current.x[0];
                    coords[3] = (float)current.y[0];
                } else {
                    numCoords = 3;
                    type = 3;
                    coords[0] = (float)previous.x[2];
                    coords[1] = (float)previous.y[2];
                    coords[2] = (float)current.x[1];
                    coords[3] = (float)current.y[1];
                    coords[4] = (float)current.x[0];
                    coords[5] = (float)current.y[0];
                }
            }
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, numCoords);
        }
        return type;
    }

    @Override
    public int currentSegment(double[] coords) {
        int numCoords = 0;
        int type = 0;
        if (this.index == this.path.size()) {
            if (this.path.size() > 1) {
                BezierPath.Node previous = (BezierPath.Node)this.path.get(this.path.size() - 1);
                BezierPath.Node current = (BezierPath.Node)this.path.get(0);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        numCoords = 1;
                        type = 1;
                        coords[0] = current.x[0];
                        coords[1] = current.y[0];
                    } else {
                        numCoords = 2;
                        type = 2;
                        coords[0] = current.x[1];
                        coords[1] = current.y[1];
                        coords[2] = current.x[0];
                        coords[3] = current.y[0];
                    }
                } else if ((current.mask & 1) == 0) {
                    numCoords = 2;
                    type = 2;
                    coords[0] = previous.x[2];
                    coords[1] = previous.y[2];
                    coords[2] = current.x[0];
                    coords[3] = current.y[0];
                } else {
                    numCoords = 3;
                    type = 3;
                    coords[0] = previous.x[2];
                    coords[1] = previous.y[2];
                    coords[2] = current.x[1];
                    coords[3] = current.y[1];
                    coords[4] = current.x[0];
                    coords[5] = current.y[0];
                }
            }
        } else {
            if (this.index > this.path.size()) {
                return 4;
            }
            if (this.index == 0) {
                BezierPath.Node current = (BezierPath.Node)this.path.get(this.index);
                coords[0] = current.x[0];
                coords[1] = current.y[0];
                numCoords = 1;
                type = 0;
            } else if (this.index < this.path.size()) {
                BezierPath.Node current = (BezierPath.Node)this.path.get(this.index);
                BezierPath.Node previous = (BezierPath.Node)this.path.get(this.index - 1);
                if ((previous.mask & 2) == 0) {
                    if ((current.mask & 1) == 0) {
                        numCoords = 1;
                        type = 1;
                        coords[0] = current.x[0];
                        coords[1] = current.y[0];
                    } else {
                        numCoords = 2;
                        type = 2;
                        coords[0] = current.x[1];
                        coords[1] = current.y[1];
                        coords[2] = current.x[0];
                        coords[3] = current.y[0];
                    }
                } else if ((current.mask & 1) == 0) {
                    numCoords = 2;
                    type = 2;
                    coords[0] = previous.x[2];
                    coords[1] = previous.y[2];
                    coords[2] = current.x[0];
                    coords[3] = current.y[0];
                } else {
                    numCoords = 3;
                    type = 3;
                    coords[0] = previous.x[2];
                    coords[1] = previous.y[2];
                    coords[2] = current.x[1];
                    coords[3] = current.y[1];
                    coords[4] = current.x[0];
                    coords[5] = current.y[0];
                }
            }
        }
        if (this.affine != null) {
            this.affine.transform(coords, 0, coords, 0, numCoords);
        } else {
            System.arraycopy(coords, 0, coords, 0, numCoords);
        }
        return type;
    }
}

