/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.odg.Gradient;
import org.jhotdraw.samples.odg.ODGConstants;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGAttributeKeys
extends AttributeKeys {
    private static final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
    public static final AttributeKey<String> NAME = new AttributeKey<Object>("name", String.class, null, true, labels);
    public static final AttributeKey<Double> OPACITY = new AttributeKey<Double>("opacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<ODGConstants.FillStyle> FILL_STYLE = new AttributeKey<ODGConstants.FillStyle>("fill", ODGConstants.FillStyle.class, ODGConstants.FillStyle.SOLID, false, labels);
    public static final AttributeKey<Gradient> FILL_GRADIENT = new AttributeKey<Object>("fillGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> FILL_OPACITY = new AttributeKey<Double>("fillOpacity", Double.class, 1.0, false, labels);
    public static final AttributeKey<ODGConstants.StrokeStyle> STROKE_STYLE = new AttributeKey<ODGConstants.StrokeStyle>("stroke", ODGConstants.StrokeStyle.class, ODGConstants.StrokeStyle.SOLID, false, labels);
    public static final AttributeKey<Gradient> STROKE_GRADIENT = new AttributeKey<Object>("strokeGradient", Gradient.class, null, true, labels);
    public static final AttributeKey<Double> STROKE_OPACITY = new AttributeKey<Double>("strokeOpacity", Double.class, 1.0, false, labels);

    private ODGAttributeKeys() {
    }

    public static Paint getFillPaint(Figure f) {
        double opacity = FILL_OPACITY.get(f);
        if (FILL_GRADIENT.get(f) != null) {
            return FILL_GRADIENT.get(f).getPaint(f, opacity);
        }
        Color color = (Color)FILL_COLOR.get(f);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    public static Paint getStrokePaint(Figure f) {
        double opacity = STROKE_OPACITY.get(f);
        if (STROKE_GRADIENT.get(f) != null) {
            return STROKE_GRADIENT.get(f).getPaint(f, opacity);
        }
        Color color = (Color)STROKE_COLOR.get(f);
        if (color != null && opacity != 1.0) {
            color = new Color(color.getRGB() & 0xFFFFFF | (int)(opacity * 255.0) << 24, true);
        }
        return color;
    }

    public static Stroke getStroke(Figure f) {
        double strokeWidth = (Double)STROKE_WIDTH.get(f);
        if (strokeWidth == 0.0) {
            strokeWidth = 1.0;
        }
        return new BasicStroke((float)strokeWidth);
    }

    public static void setDefaults(Figure f) {
        FILL_COLOR.basicSet(f, Color.black);
        WINDING_RULE.basicSet(f, AttributeKeys.WindingRule.NON_ZERO);
        STROKE_COLOR.basicSet(f, null);
        STROKE_WIDTH.basicSet(f, 1.0);
        STROKE_CAP.basicSet(f, 0);
        STROKE_JOIN.basicSet(f, 0);
        STROKE_MITER_LIMIT.basicSet(f, 4.0);
        IS_STROKE_MITER_LIMIT_FACTOR.basicSet(f, false);
        STROKE_DASHES.basicSet(f, null);
        STROKE_DASH_PHASE.basicSet(f, 0.0);
        IS_STROKE_DASH_FACTOR.basicSet(f, false);
    }
}

