/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util.prefs;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.prefs.Preferences;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jhotdraw.util.prefs.ToolBarPrefsHandler;

public class PreferencesUtil {
    public static void installPrefsHandler(Preferences prefs, String string, JTabbedPane tabbedPane) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private PreferencesUtil() {
    }

    public static void installFramePrefsHandler(final Preferences prefs, final String name, Window window) {
        GraphicsConfiguration conf = window.getGraphicsConfiguration();
        Rectangle screenBounds = conf.getBounds();
        Insets screenInsets = window.getToolkit().getScreenInsets(conf);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Dimension preferredSize = window.getPreferredSize();
        Dimension minSize = window.getMinimumSize();
        Rectangle bounds = new Rectangle(prefs.getInt(name + ".x", 0), prefs.getInt(name + ".y", 0), Math.max(minSize.width, prefs.getInt(name + ".width", preferredSize.width)), Math.max(minSize.height, prefs.getInt(name + ".height", preferredSize.height)));
        if (!screenBounds.contains(bounds)) {
            bounds.x = screenBounds.x + (screenBounds.width - bounds.width) / 2;
            bounds.y = screenBounds.y + (screenBounds.height - bounds.height) / 2;
            Rectangle.intersect(screenBounds, bounds, bounds);
        }
        window.setBounds(bounds);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                prefs.putInt(name + ".x", evt.getComponent().getX());
                prefs.putInt(name + ".y", evt.getComponent().getY());
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                prefs.putInt(name + ".width", evt.getComponent().getWidth());
                prefs.putInt(name + ".height", evt.getComponent().getHeight());
            }
        });
    }

    public static void installPalettePrefsHandler(Preferences prefs, String name, Window window) {
        PreferencesUtil.installPalettePrefsHandler(prefs, name, window, 0);
    }

    public static void installPalettePrefsHandler(final Preferences prefs, final String name, Window window, int x) {
        GraphicsConfiguration conf = window.getGraphicsConfiguration();
        Rectangle screenBounds = conf.getBounds();
        Insets screenInsets = window.getToolkit().getScreenInsets(conf);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Dimension preferredSize = window.getPreferredSize();
        Rectangle bounds = new Rectangle(prefs.getInt(name + ".x", x + screenBounds.x), prefs.getInt(name + ".y", 0 + screenBounds.y), preferredSize.width, preferredSize.height);
        if (!screenBounds.contains(bounds)) {
            bounds.x = screenBounds.x;
            bounds.y = screenBounds.y;
        }
        window.setBounds(bounds);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                prefs.putInt(name + ".x", evt.getComponent().getX());
                prefs.putInt(name + ".y", evt.getComponent().getY());
            }
        });
    }

    public static void installInternalFramePrefsHandler(final Preferences prefs, final String name, JInternalFrame window, JDesktopPane desktop) {
        Rectangle screenBounds = desktop.getBounds();
        screenBounds.setLocation(0, 0);
        Insets screenInsets = desktop.getInsets();
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Dimension preferredSize = window.getPreferredSize();
        Dimension minSize = window.getMinimumSize();
        Rectangle bounds = new Rectangle(prefs.getInt(name + ".x", 0), prefs.getInt(name + ".y", 0), Math.max(minSize.width, prefs.getInt(name + ".width", preferredSize.width)), Math.max(minSize.height, prefs.getInt(name + ".height", preferredSize.height)));
        if (!screenBounds.contains(bounds)) {
            bounds.x = screenBounds.x + (screenBounds.width - bounds.width) / 2;
            bounds.y = screenBounds.y + (screenBounds.height - bounds.height) / 2;
            Rectangle.intersect(screenBounds, bounds, bounds);
        }
        window.setBounds(bounds);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                prefs.putInt(name + ".x", evt.getComponent().getX());
                prefs.putInt(name + ".y", evt.getComponent().getY());
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                prefs.putInt(name + ".width", evt.getComponent().getWidth());
                prefs.putInt(name + ".height", evt.getComponent().getHeight());
            }
        });
    }

    public static void installToolBarPrefsHandler(Preferences prefs, String name, JToolBar toolbar) {
        new ToolBarPrefsHandler(toolbar, name, prefs);
    }

    public static void installTabbedPanePrefsHandler(final Preferences prefs, final String name, final JTabbedPane tabbedPane) {
        int selectedTab = prefs.getInt(name, 0);
        try {
            tabbedPane.setSelectedIndex(selectedTab);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                prefs.putInt(name, tabbedPane.getSelectedIndex());
            }
        });
    }
}

