/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public final class CRNCountRecord
extends Record {
    public static final short sid = 89;
    private static final short BASE_RECORD_SIZE = 4;
    private int field_1_number_crn_records;
    private int field_2_sheet_table_index;

    public CRNCountRecord() {
        throw new RuntimeException("incomplete code");
    }

    public int getNumberOfCRNs() {
        return this.field_1_number_crn_records;
    }

    public CRNCountRecord(RecordInputStream in) {
        this.field_1_number_crn_records = in.readShort();
        if (this.field_1_number_crn_records < 0) {
            this.field_1_number_crn_records = (short)(-this.field_1_number_crn_records);
        }
        this.field_2_sheet_table_index = in.readShort();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [XCT");
        sb.append(" nCRNs=").append(this.field_1_number_crn_records);
        sb.append(" sheetIx=").append(this.field_2_sheet_table_index);
        sb.append("]");
        return sb.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)89);
        LittleEndian.putShort(data, 2 + offset, (short)4);
        LittleEndian.putShort(data, 4 + offset, (short)this.field_1_number_crn_records);
        LittleEndian.putShort(data, 6 + offset, (short)this.field_2_sheet_table_index);
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 89;
    }
}

