/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap
	  from lib/kbmaps/yudit/ArabicKeyboard.kmap
	* with one bug fix for "E" -> U+064F ARABIC DAMMA
*/
struct keymap keymap_ArabicKeyboard [] = {
	{"q", "ض"},	/* dad (ض) */
	{"w", "ص"},	/* sad (ص) */
	{"e", "ث"},	/* theh (ث) */
	{"r", "ق"},	/* qaf (ق) */
	{"t", "ف"},	/* feh (ف) */
	{"y", "غ"},	/* ghain  (غ) */
	{"u", "ع"},	/* ain (ع) */
	{"i", "ه"},	/* heh (ه) */
	{"o", "خ"},	/* khah (خ) */
	{"p", "ح"},	/* hah (ح) */
	{"[", "ج"},	/* jeem (ج) */
	{"]", "د"},	/* dal (د) */
	{"a", "ش"},	/* sheen (ش) */
	{"s", "س"},	/* seen (س) */
	{"d", "ي"},	/* yeh (ي) */
	{"f", "ب"},	/* beh (ب) */
	{"g", "ل"},	/* lam (ل) */
	{"h", "ا"},	/* alef (ا) */
	{"j", "ت"},	/* teh (ت) */
	{"k", "ن"},	/* noon (ن) */
	{"l", "م"},	/* meem (م) */
	{";", "ك"},	/* kaf (ك) */
	{"'", "ط"},	/* tah (ط) */
	{"z", "ئ"},	/* yeh with hamza above (ئ) */
	{"x", "ء"},	/* Hamza (ء) */
	{"c", "ؤ"},	/* waw with hamza above (ؤ) */
	{"v", "ر"},	/* reh (ر) */
	{"b", "لا"},	/* lam alef (لا) */
	{"n", "ى"},	/* alef maksura (ى) */
	{"m", "ة"},	/* teh marbuta (ة) */
	{",", "و"},	/* waw (و) */
	{".", "ز"},	/* zain (ز) */
	{"/", "ظ"},	/* zah (ظ) */
	{"`", "ذ"},	/* thal (ذ) */
	{"~", "ّ"},	/* shadda ( ّ ) */
	{"Q", "َ"},	/* fatha ( َ ) */
	{"W", "ً"},	/* fatahtan (ً) */
	{"E", "ُ"},	/* damma (ُ) */
	{"R", "ٌ"},	/* dammatan (ٌ) */
	{"T", "لإ"},	/* laa (alef lam) with hamza below (لإ) */
	{"Y", "إ"},	/* alef with hamza below (إ) */
	{"A", "ِ"},	/* kasra (ِ) */
	{"S", "ٍ"},	/* kasratan (ٍ) */
	{"D", "["},	/* [ */
	{"F", "]"},	/* ] */
	{"G", "لأ"},	/* laa (alef lam) with hamza above (لأ) */
	{"H", "أ"},	/* alef with hamza above (أ) */
	{"J", "ـ"},	/* tatweel (ـ) */
	{"X", "ْ"},	/* sukun (ْ) */
	{"C", "{"},	/* { */
	{"V", "}"},	/* } */
	{"B", "لآ"},	/* laa (alef lam) with madda above (لآ) */
	{"N", "آ"},	/* alef with madda (آ) */
	{"Z", "~"},	/* ~ */
	{"<", ","},	/* decimal (٫) */
	{">", "."},	/* period */
	{"P", "؛"},	/* semi-colon (؛) */
	{"K", "،"},	/* comma (،) */
	{"?", "؟"},	/* question mark (؟) */
	{"L", "/"},	/* forward slash (/) */
	{"0", "٠"},	/* 0  (٠) */
	{"1", "١"},	/* 1  (١) */
	{"2", "٢"},	/* 2  (٢) */
	{"3", "٣"},	/* 3  (٣) */
	{"4", "٤"},	/* 4  (٤) */
	{"5", "٥"},	/* 5  (٥) */
	{"6", "٦"},	/* 6  (٦) */
	{"7", "٧"},	/* 7  (٧) */
	{"8", "٨"},	/* 8  (٨) */
	{"9", "٩"},	/* 9  (٩) */
	{"%", "٪"},	/* percent  (٪) */
	{NIL_PTR}
};
