/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt;

import com.pt.awt.font.CMap;
import com.pt.awt.font.CMapUTF16BE;
import com.pt.awt.font.NFontManager;
import com.pt.awt.font.NFontRec;
import com.pt.io.RandomAccessMultiplex;
import com.pt.lang.UnicodeBlock;
import com.pt.lang.UnicodeBlocks;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class NFont {
    static final boolean DEBUG = false;
    public static final int FLAG_NONE = -1;
    public static final int FLAG_FIXEDPITCH = 1;
    public static final int FLAG_SERIF = 2;
    public static final int FLAG_SANSSERIF = 0;
    public static final int FLAG_SYMBOLIC = 4;
    public static final int FLAG_SCRIPT = 8;
    public static final int FLAG_NONSYMBOLIC = 32;
    public static final int FLAG_ITALIC = 64;
    public static final int FLAG_ALLCAP = 65536;
    public static final int FLAG_SMALLCAP = 131072;
    public static final int FLAG_FORCEBOLD = 262144;
    public static final int FLAG_CONDENSED = 0x4000000;
    public static final int FLAG_EXPANDED = 0x8000000;
    public static final int FLAG_ORNAMENTAL = 0x10000000;
    public static final int FLAG_DEFAULT = 2;
    public static final int WEIGHT_THIN = 100;
    public static final int WEIGHT_EXTRALIGHT = 200;
    public static final int WEIGHT_LIGHT = 300;
    public static final int WEIGHT_NORMAL = 400;
    public static final int WEIGHT_MEDIUM = 500;
    public static final int WEIGHT_SEMIBOLD = 600;
    public static final int WEIGHT_BOLD = 700;
    public static final int WEIGHT_EXTRABOLD = 800;
    public static final int WEIGHT_BLACK = 900;
    public static final int MODE_FILL = 0;
    public static final int MODE_STROKE = 1;
    public static final int MODE_FILL_STROKE = 2;
    public static final int MODE_INVISIBLE = 3;
    public static final int MODE_FILL_ADD = 4;
    public static final int MODE_STROKE_ADD = 5;
    public static final int MODE_FILL_STROKE_ADD = 6;
    public static final int MODE_ADD = 7;
    public static final int MODE_INVALID = -1;
    public static final int RIGHT_INSTALL = 0;
    public static final int RIGHT_LICENSED = 1;
    public static final int RIGHT_RESTRICTED = 2;
    public static final int RIGHT_PREVIEW_PRINT = 4;
    public static final int RIGHT_EDITABLE = 8;
    public static final int RIGHT_NOSUBSET = 256;
    public static final int RIGHT_BITMAP = 512;
    public static final int RIGHT_NONCOMMERCIAL = 65536;
    public static final int RIGHT_HEURISTIC = 131072;
    public static final int RIGHT_UNKNOWN = -1;
    public static final long LAYOUT_NONE = 0L;
    public static final long LAYOUT_FALLBACK = 1L;
    public static final long LAYOUT_LIGATURE = 32L;
    public static final long LAYOUT_SMALLCAPS = 64L;
    public static final long LAYOUT_SWASH = 128L;
    public static final long LAYOUT_KERN = 1024L;
    public static final long LAYOUT_MINIMUM = 1L;
    public static final long LAYOUT_NORMAL = 1057L;
    public static final UnicodeBlocks[] MASKS_NONE;
    public static final String SUBFORMAT_NONE = "none";
    public static final String NOTDEF = ".notdef";
    public static final char NOTDEF_CHAR = '\u0000';
    public static final char NOTVALID_CHAR = '\ufffe';
    public static final double AFM_SCALE = 0.001;
    private static final AffineTransform TRANSFORM_IDENTITY;
    private static boolean usebitmaps_;
    private static RandomAccessMultiplex plex_;
    private static final String[] WEIGHT;
    protected CMap touni_ = null;
    protected float size_ = 1.0f;
    protected AffineTransform at_ = TRANSFORM_IDENTITY;
    protected Rectangle2D max_ = null;
    private URL source_;
    private NFontManager fm_ = null;
    private List<NFont> fallback_;
    private UnicodeBlocks fallstop_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static NFont getInstance(String string, int n, int n2, float f) {
        return NFontManager.getDefault().getFont(string, null, -1, n, n2, f);
    }

    public static void setUseBitmaps(boolean bl) {
        usebitmaps_ = bl;
    }

    public static boolean isUseBitmaps() {
        return usebitmaps_;
    }

    protected NFont(URL uRL) {
        this.source_ = uRL;
    }

    public NFont deriveFont(float f) {
        NFont nFont = null;
        try {
            nFont = (NFont)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println(this.getClass().getName() + " must 'implements Cloneable'");
            System.exit(1);
        }
        nFont.size_ = f;
        nFont.max_ = null;
        if (this.fallback_ != null && f != this.getSize()) {
            int n = this.fallback_.size();
            for (int i = 0; i < n; ++i) {
                this.fallback_.set(i, this.fallback_.get(i).deriveFont(f));
            }
        }
        return nFont;
    }

    public NFont deriveFont(AffineTransform affineTransform) {
        NFont nFont = this.deriveFont(this.size_);
        AffineTransform affineTransform2 = nFont.at_ = affineTransform.isIdentity() ? TRANSFORM_IDENTITY : new AffineTransform(affineTransform);
        if (this.fallback_ != null && !this.at_.equals(affineTransform)) {
            int n = this.fallback_.size();
            for (int i = 0; i < n; ++i) {
                this.fallback_.set(i, this.fallback_.get(i).deriveFont(affineTransform));
            }
        }
        return nFont;
    }

    public abstract String getName();

    public abstract String getFamily();

    public URL getSource() {
        return this.source_;
    }

    public String getVersion() {
        return null;
    }

    public String getDesigner() {
        return null;
    }

    public String getCopyright() {
        return null;
    }

    public int getRights() {
        return -1;
    }

    public abstract String getFormat();

    public String getSubformat() {
        return SUBFORMAT_NONE;
    }

    public abstract int getNumGlyphs();

    public int getMaxGlyphNum() {
        return this.getNumGlyphs();
    }

    public UnicodeBlocks[] getUnicode() {
        return MASKS_NONE;
    }

    public boolean isHinted() {
        return false;
    }

    public float getSize() {
        return this.size_;
    }

    public int getWeight() {
        return 400;
    }

    public int getFlags() {
        return -1;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.at_);
    }

    public boolean isTransformed() {
        return !this.at_.isIdentity();
    }

    public void setManager(NFontManager nFontManager) {
        this.fm_ = nFontManager;
        this.fallback_ = nFontManager != null ? new ArrayList(5) : null;
        this.fallstop_ = UnicodeBlocks.NONE;
    }

    public String toUnicode(String string) {
        return this.touni_ != null ? this.touni_.toSelector(string) : string;
    }

    public String fromUnicode(String string) {
        return this.touni_ != null ? this.touni_.fromSelector(string) : string;
    }

    public abstract char getSpaceEchar();

    public Point2D stringAdvance(String string) {
        return this.stringAdvance(string, 0, string != null ? string.length() : 0);
    }

    public Point2D stringAdvance(String string, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        if (string != null) {
            int n3 = Math.min(n2, string.length());
            for (int i = Math.max(n, 0); i < n3; ++i) {
                int n4 = string.charAt(i);
                if (55296 <= n4 && n4 <= 56320) {
                    n4 = (n4 & 0x3FF) + 64 << 10 | string.charAt(++i) & 0x3FF;
                }
                Point2D point2D = this.charAdvance(n4);
                d += point2D.getX();
                d2 += point2D.getY();
            }
        }
        return new Point2D.Double(d, d2);
    }

    public Point2D estringAdvance(String string, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        if (string != null) {
            int n3 = Math.min(n2, string.length());
            for (int i = Math.max(n, 0); i < n3; ++i) {
                Point2D point2D = this.echarAdvance(string.charAt(i));
                d += point2D.getX();
                d2 += point2D.getY();
            }
        }
        return new Point2D.Double(d, d2);
    }

    public Point2D charAdvance(int n) {
        Point2D point2D;
        switch (Character.getType((char)n)) {
            case 6: 
            case 8: 
            case 15: 
            case 16: {
                point2D = new Point2D.Double(0.0, 0.0);
                break;
            }
            case 12: {
                point2D = this.echarAdvance(this.touni_.fromSelector(this.canDisplay(n) ? n : 32));
                if (point2D.getX() != 0.0 || point2D.getY() != 0.0) break;
                point2D = new Point2D.Double((double)this.getSize() / 2.0, 0.0);
                break;
            }
            default: {
                NFont nFont = null;
                if (!this.canDisplay(n)) {
                    nFont = this.getFallback(n);
                }
                if (nFont == null) {
                    nFont = this;
                }
                point2D = nFont.echarAdvance(this.touni_ != null ? (int)this.touni_.fromSelector(n) : n);
            }
        }
        return point2D;
    }

    public abstract Point2D echarAdvance(int var1);

    public Rectangle2D getStringBounds(String string) {
        return this.getStringBounds(string, 0, string != null ? string.length() : 0);
    }

    public Rectangle2D getStringBounds(String string, int n, int n2) {
        return this.getEstringBounds(this.fromUnicode(string.substring(n, n2)), n, n2);
    }

    public Rectangle2D getEstringBounds(String string, int n, int n2) {
        Rectangle2D rectangle2D = this.getMaxCharBounds();
        rectangle2D.setRect(0.0, rectangle2D.getY(), this.estringAdvance(string, n, n2).getX(), rectangle2D.getHeight());
        return rectangle2D;
    }

    public abstract Rectangle2D getMaxCharBounds();

    public float getHeight() {
        return this.getSize();
    }

    public float getAscent() {
        return this.getSize() * 0.8f;
    }

    public float getDescent() {
        return this.getSize() * 0.2f;
    }

    public float getLeading() {
        return this.getSize() * 0.2f;
    }

    public boolean canDisplay(int n) {
        int n2 = this.touni_ == null || this.touni_ == CMap.IDENTITY ? n : (int)this.fromUnicode(CMapUTF16BE.encode(n)).charAt(0);
        return this.canDisplayEchar(n2);
    }

    public abstract boolean canDisplayEchar(int var1);

    public void drawString(Graphics2D graphics2D, String string, float f, float f2) {
        this.drawString(graphics2D, string, f, f2, 1057L, 0, null);
    }

    public void drawString(Graphics2D graphics2D, String string, float f, float f2, long l, int n, Color color) {
        if (string == null || string.length() == 0) {
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            NFont nFont;
            int n6;
            int n7;
            if (55296 <= (n7 = string.charAt(n6 = i++)) && n7 <= 56320) {
                n7 = (n7 & 0x3FF) + 64 << 10 | string.charAt(i) & 0x3FF;
            }
            int n8 = Character.getType((char)n7);
            if (0L != l && ((15 == n8 || 12 == n8) && (nFont = this) != null || !this.canDisplay(n7) && (1L & l) != 0L && (nFont = this.getFallback(n7)) != null || (6 == n8 || 8 == n8) && Character.isLetterOrDigit((char)n5) && (nFont = this) != null)) {
                Point2D point2D;
                String string2;
                if (n2 < n6) {
                    string2 = string.substring(n2, n6);
                    this.drawEstring(graphics2D, this.fromUnicode(string2), f, f2, l, n, color);
                    point2D = this.stringAdvance(string2);
                    f = (float)((double)f + point2D.getX());
                    f2 = (float)((double)f2 + point2D.getY());
                }
                string2 = string.substring(n6, i + 1);
                if (15 == n8 || n7 == 173) {
                    if (9 == n7) {
                        float f3 = (float)nFont.charAdvance(32).getX();
                        float f4 = f3 * 8.0f;
                        f = f + f4 - (f + f4) % f4;
                    }
                } else if (6 == n8) {
                    nFont.drawEstring(graphics2D, this.fromUnicode(string2), f, f2, l, n, color);
                } else if (12 == n8) {
                    f += (float)this.charAdvance(n7).getX();
                } else {
                    nFont.drawEstring(graphics2D, this.fromUnicode(string2), f, f2, l, n, color);
                    point2D = nFont.charAdvance(n7);
                    f = (float)((double)f + point2D.getX());
                    f2 = (float)((double)f2 + point2D.getY());
                }
                n2 = i + 1;
            }
            n5 = n7;
            n4 = n8;
        }
        if (n2 < n3) {
            this.drawEstring(graphics2D, this.fromUnicode(string.substring(n2, n3)), f, f2, l, n, color);
        }
    }

    private NFont getFallback(int n) {
        Object object;
        int n2;
        if (this.fm_ == null) {
            return null;
        }
        UnicodeBlock unicodeBlock = UnicodeBlock.of(n);
        if (unicodeBlock == null) {
            return null;
        }
        Object object2 = null;
        NFont nFont = null;
        int n3 = -1;
        int n4 = this.fallback_.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object = this.fallback_.get(n2);
            if (!((NFont)object).canDisplay(n)) continue;
            int n5 = this.score((NFont)object);
            if (n5 == 3) {
                object2 = object;
                break;
            }
            if (n5 <= n3) continue;
            nFont = object;
            n3 = n5;
        }
        if (object2 == null) {
            if (this.fallstop_.covers(unicodeBlock)) {
                object2 = nFont;
            } else {
                object2 = nFont;
                n2 = 0;
                NFontRec nFontRec = this.fm_.match(null, null, n, this.getWeight(), this.getFlags());
                if (nFontRec != null) {
                    try {
                        object = this.fm_.getFont(nFontRec);
                        n2 = this.score((NFont)object);
                        if (n2 > n3) {
                            object2 = object;
                            if (!$assertionsDisabled && ((NFont)object2).getSize() != 1.0f) {
                                throw new AssertionError();
                            }
                            object2 = ((NFont)object2).deriveFont(this.getSize());
                            ((NFont)object2).setManager(null);
                            this.fallback_.add((NFont)object2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n2 < 3) {
                    object = UnicodeBlocks.getInstance(unicodeBlock);
                    this.fallstop_ = this.fallstop_.or((UnicodeBlocks)object);
                    NFontRec nFontRec2 = this.fm_.match(null, (UnicodeBlocks)object, -1, this.getWeight(), this.getFlags());
                    if (nFontRec2 != null && (nFontRec2 != nFontRec || n2 <= n3)) {
                        try {
                            NFont nFont2 = this.fm_.getFont(nFontRec2);
                            nFont2 = nFont2.deriveFont(this.getSize());
                            nFont2.setManager(null);
                            this.fallback_.add(nFont2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return object2;
    }

    private int score(NFont nFont) {
        int n = 0;
        if ((1 & nFont.getFlags()) == (1 & this.getFlags())) {
            ++n;
        }
        if ((0x40 & nFont.getFlags()) == (0x40 & this.getFlags())) {
            ++n;
        }
        if (Math.abs(nFont.getWeight() - this.getWeight()) <= 200) {
            ++n;
        }
        return n;
    }

    public abstract void drawEstring(Graphics2D var1, String var2, float var3, float var4, long var5, int var7, Color var8);

    public static String strFlags(int n) {
        if (-1 == n) {
            return "/none";
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        if ((1 & n) != 0) {
            stringBuffer.append("/fix");
        }
        if ((2 & n) == 0) {
            stringBuffer.append("/sans");
        }
        if ((4 & n) != 0) {
            stringBuffer.append("/sym");
        }
        if ((8 & n) != 0) {
            stringBuffer.append("/script");
        }
        if ((0x40 & n) != 0) {
            stringBuffer.append("/ital");
        }
        if ((0x10000 & n) != 0) {
            stringBuffer.append("/allcap");
        }
        if ((0x20000 & n) != 0) {
            stringBuffer.append("/smcap");
        }
        if ((0x40000 & n) != 0) {
            stringBuffer.append("/force");
        }
        if ((0x4000000 & n) != 0) {
            stringBuffer.append("/cond");
        }
        if ((0x8000000 & n) != 0) {
            stringBuffer.append("/expand");
        }
        if ((0x10000000 & n) != 0) {
            stringBuffer.append("/ornamental");
        }
        return stringBuffer.toString();
    }

    public static String strWeight(int n) {
        if (n < 0 || n >= 1000) {
            n = 1000;
        }
        int n2 = n / 100;
        int n3 = n - n2 * 100;
        return WEIGHT[n2 + (n3 <= 50 ? 0 : -1)] + (n3 == 0 ? "" : (n3 <= 50 ? "+" : "-"));
    }

    public static String strRights(int n) {
        String string;
        if (-1 == n) {
            string = "unknown";
        } else {
            StringBuffer stringBuffer = new StringBuffer(20);
            if (0 == (n & 0xFFFF)) {
                stringBuffer.append(" installable");
            }
            if ((8 & n) != 0) {
                stringBuffer.append(" editable");
            } else if ((4 & n) != 0) {
                stringBuffer.append(" preview/print");
            } else if ((2 & n) != 0) {
                stringBuffer.append(" restricted");
            } else if ((1 & n) != 0) {
                stringBuffer.append(" licensed");
            }
            if ((0x100 & n) != 0) {
                stringBuffer.append(" no-subset");
            } else if ((0x200 & n) != 0) {
                stringBuffer.append(" bitmap-only");
            }
            if ((0x10000 & n) != 0) {
                stringBuffer.append(" non-commercial use only");
            }
            if ((0x20000 & n) != 0) {
                stringBuffer.append(" (estimated)");
            }
            string = stringBuffer.substring(1);
        }
        return string;
    }

    public String toString() {
        return this.getName() + "/" + this.getSize() + " " + NFont.strFlags(this.getFlags()) + " " + this.getFormat() + "/" + this.getSubformat();
    }

    protected static RandomAccessMultiplex getMultiplex() {
        return plex_;
    }

    public static Logger getLogger() {
        return Logger.getLogger("com.pt.awt.font");
    }

    static {
        $assertionsDisabled = !NFont.class.desiredAssertionStatus();
        MASKS_NONE = new UnicodeBlocks[]{UnicodeBlocks.NONE, UnicodeBlocks.NONE, UnicodeBlocks.NONE};
        TRANSFORM_IDENTITY = new AffineTransform();
        usebitmaps_ = "true".equals(System.getProperty("font.usebitmaps")) || !"false".equals(System.getProperty("font.usebitmaps"));
        plex_ = new RandomAccessMultiplex(8, 32768L);
        WEIGHT = new String[]{"extrathin", "thin", "extralight", "light", "normal", "medium", "semibold", "bold", "extrabold", "black", "ERROR"};
    }
}

