/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.NFont;
import com.pt.awt.font.CMap;
import com.pt.awt.font.Encoding;
import com.pt.awt.font.NFontRec;
import com.pt.awt.font.NFontSimple;
import com.pt.awt.font.NFontTrueType;
import com.pt.awt.font.SfntDirectory;
import com.pt.io.FileLog;
import com.pt.io.FileLogRecord;
import com.pt.io.RandomAccessByteArray;
import com.pt.io.Rez;
import com.pt.lang.Mac;
import com.pt.lang.UnicodeBlock;
import com.pt.lang.UnicodeBlocks;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import multivalent.std.adaptor.pdf.Fonts;
import phelps.io.Files;
import phelps.lang.Classes;
import phelps.lang.Integers;
import phelps.lang.Strings;
import phelps.util.Arrayss;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFontManager
implements Observer {
    private static final boolean DEBUG = false;
    public static final String COPYRIGHT = "Copyright (c) 2003 - 2005  Thomas A. Phelps.  All rights reserved.";
    static final String PROPERTY_FONTPATH = "font.path";
    private static final String[] FONTPATH;
    private static final String[] SPOT;
    public static final int CONFLICT_KEEP_EXISTING = -1;
    public static final int CONFLICT_BEST = 0;
    public static final int CONFLICT_OVERRIDE = 1;
    private static final int FORMAT_VERSION = 14;
    private static long AGE_MAX;
    private static final String[] OPENTYPE_TABLE;
    private static final String[] AAT_TABLE;
    private static final String[] MM_TABLE;
    private String[] allname_ = null;
    private String[] allfam_ = null;
    private String[] allnorm_ = null;
    private final Map<String, String> eqfam_ = new HashMap<String, String>(13);
    private static final String[] MACDOZE;
    private static final String[] FOUNDARY;
    private List[] cjk_ = null;
    public static final String FAMILY_CHINESE_SIMPLIFIED = " Chinese (Simplified)";
    public static final String FAMILY_CHINESE_TRADITIONAL = " Chinese (Traditional)";
    public static final String FAMILY_JAPANESE = " Japanese";
    public static final String FAMILY_KOREAN = " Korean";
    private static final Class[] NFONT_SIG;
    private static final Class[] NFONT_SIG_DATA;
    private static final Map<String, String> handlers_;
    private static final List<String> suffixes_;
    private static final int TAG_SFNT;
    private static final int TAG_POST;
    private static final int TAG_NFNT;
    private static final Map<URL, SoftReference<NFont>> cache_;
    private static final int FONTCACHE_MAX = 40;
    private static final int FONTCACHE_CORE = 10;
    private List<NFontRec> req_ = new ArrayList<NFontRec>(40);
    private static NFontManager def_;
    private static boolean fmacos_;
    private List<NFontRec> db_ = new ArrayList<NFontRec>(100);
    private List<NFontRec> active_ = new ArrayList<NFontRec>(100);
    private String[] paths_;
    private File cachedir_;
    private File log_;
    private FileFilter filter_;
    private boolean fpost_ = false;
    private boolean fstrong_;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$pt$awt$font$NFontManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFontManager(File file, String[] stringArray, FileFilter fileFilter) {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = FONTPATH;
        }
        this.filter_ = fileFilter != null ? fileFilter : NFontManager.getFilter();
        this.config(file, stringArray);
    }

    public NFontManager() {
        this.cachedir_ = null;
        this.fstrong_ = true;
    }

    public static NFontManager getDefault() {
        if (def_ == null) {
            String string = System.getProperty(PROPERTY_FONTPATH);
            String[] stringArray = string == null ? null : string.split(File.pathSeparator);
            File file = new File(System.getProperty("java.io.tmpdir"));
            def_ = new NFontManager(file, stringArray, null);
            def_.mapURW();
            def_.mapMacDoze();
            def_.mapJavaLogical();
            if (File.separatorChar == '\\') {
                def_.map("Symbol", "Symbol", "StandardSymL", 1);
            }
        }
        return def_;
    }

    /*
     * WARNING - void declaration
     */
    private void config(File file, String[] stringArray) {
        boolean bl;
        int object3;
        this.cachedir_ = file;
        if (file != null) {
            if (!this.cachedir_.exists()) {
                this.cachedir_.mkdir();
            }
            if (!this.cachedir_.canWrite()) {
                this.cachedir_ = new File(Classes.getRootDir(class$com$pt$awt$font$NFontManager == null ? (class$com$pt$awt$font$NFontManager = NFontManager.class$("com.pt.awt.font.NFontManager")) : class$com$pt$awt$font$NFontManager), "vfonts");
                if (!this.cachedir_.exists()) {
                    this.cachedir_.mkdir();
                }
            }
            if (!this.cachedir_.canRead()) {
                this.cachedir_ = null;
            }
        }
        NFont.getLogger().config(new StringBuffer().append("font cache: ").append(this.cachedir_).toString());
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (String string : stringArray) {
            if ("system".equals(string)) {
                arrayList.addAll(Arrays.asList(FONTPATH));
                continue;
            }
            arrayList.add(string);
        }
        boolean n = false;
        while (object3 < arrayList.size()) {
            void var7_22;
            void var7_20;
            String string = (String)arrayList.get(object3);
            File file2 = Files.getFile(string);
            Object var7_17 = null;
            if (string.startsWith("@")) {
                String string2 = string;
            } else if (file2.canRead() && file2.isDirectory()) {
                try {
                    String string3 = file2.getCanonicalFile().getPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (var7_20 != null) {
                for (int i = 0; i < object3; ++i) {
                    if (!((String)arrayList.get(i)).startsWith((String)var7_20)) continue;
                    arrayList.set(i, var7_20);
                    Object var7_21 = null;
                    break;
                }
            }
            if (var7_22 != null) {
                arrayList.set(object3, var7_22);
                ++object3;
                continue;
            }
            arrayList.remove(object3);
        }
        for (String string : this.paths_ = arrayList.toArray(new String[arrayList.size()])) {
            NFont.getLogger().config(new StringBuffer().append("font path ").append(string).toString());
        }
        String string4 = "fonts.fl";
        string4 = new StringBuffer().append(string4).append(".gz").toString();
        this.log_ = this.cachedir_ != null ? new File(this.cachedir_, string4) : null;
        long l = System.currentTimeMillis();
        FileLog fileLog = new FileLog(this.log_, this.paths_, true, 14);
        fileLog.setHash(false);
        long l2 = fileLog.lastModified();
        boolean bl2 = bl = l2 > 0L;
        if (bl) {
            for (String string5 : SPOT) {
                File file3 = new File(string5);
                if (!file3.exists() || file3.lastModified() <= l2) continue;
                bl = false;
                break;
            }
        }
        this.fstrong_ = !bl;
        try {
            void var7_27;
            fileLog.report(this, this.filter_, bl ? AGE_MAX : 0L);
            if (this.active_.size() == 0) {
                this.paths_ = new String[]{new StringBuffer().append(System.getProperty("java.home")).append("/lib/fonts").toString()};
                NFont.getLogger().warning("no fonts in FONTPATH; using ${java.home}/lib/fonts");
                FileLog fileLog2 = new FileLog(this.log_, this.paths_, true, 14);
                fileLog2.setHash(false);
                fileLog2.update(this, this.filter_);
            }
            if (l2 != var7_27.lastModified()) {
                var7_27.write();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis();
        NFont.getLogger().finer(new StringBuffer().append("built font database in ").append(l3 - l).append("ms").toString());
    }

    private void xref() {
        Object object;
        int n;
        if (this.fpost_) {
            return;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(100);
        List<NFontRec> list = this.active_;
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            object = list.get(n).getFamily();
            Integer n3 = (Integer)hashMap.get(object);
            n3 = n3 == null ? Integers.ONE : Integers.getInteger(n3 + 1);
            hashMap.put(object, n3);
        }
        n2 = list.size();
        for (n = 0; n < n2; ++n) {
            object = list.get(n);
            ((NFontRec)object).setFamilySize((Integer)hashMap.get(((NFontRec)object).getFamily()));
        }
        this.fpost_ = true;
    }

    @Override
    public void update(Observable observable, Object object) {
        Object[] objectArray = (Object[])object;
        Object object2 = objectArray[0];
        FileLogRecord fileLogRecord = (FileLogRecord)objectArray[1];
        URL uRL = null;
        try {
            uRL = new File(fileLogRecord.path).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        long l = fileLogRecord.mod;
        if ("new" == object2 || "changed" == object2) {
            try {
                NFontRec[] nFontRecArray = this.mapAll(uRL, l, 0);
                StringBuffer stringBuffer = new StringBuffer(40 * nFontRecArray.length);
                for (NFontRec nFontRec : nFontRecArray) {
                    stringBuffer.append(nFontRec.getName()).append("\t").append(nFontRec.getFamily()).append("\t").append(nFontRec.getWeight()).append("\t").append(Integer.toHexString(nFontRec.getFlags())).append("\t").append(nFontRec.getNumGlyphs()).append("\t").append(nFontRec.getFormat()).append("\t").append(nFontRec.getSubformat()).append("\t").append(this.zap(nFontRec.getVersion())).append("\t").append(this.zap(nFontRec.getDesigner())).append("\t").append(this.zap(nFontRec.getCopyright()));
                    for (UnicodeBlocks unicodeBlocks : nFontRec.getUnicode()) {
                        stringBuffer.append("\t").append(unicodeBlocks);
                    }
                    stringBuffer.append("\n");
                }
                fileLogRecord.data = stringBuffer.substring(0, stringBuffer.length() - 1);
            }
            catch (Exception exception) {
                String string = "Bad";
                String string2 = exception.getMessage();
                if (string2 == null) {
                    string2 = "X";
                } else if (string2.startsWith("unsupported:")) {
                    string = "Unsupported";
                    string2 = string2.substring("unsupported:".length());
                }
                string2 = string2.trim();
                fileLogRecord.data = new StringBuffer().append(string2).append("\t").append(string).toString();
                this.db_.add(new NFontRec(uRL, l, string, string2));
            }
            catch (Error error) {
                error.printStackTrace();
            }
        } else if (object2 != "deleted") {
            int n = NFont.MASKS_NONE.length;
            int n2 = 0;
            for (String string : fileLogRecord.data.split("\n")) {
                String[] stringArray = string.split("\t");
                if (stringArray.length == 10 + n) {
                    int n3 = 400;
                    try {
                        n3 = Integer.parseInt(stringArray[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int n4 = 0;
                    try {
                        n4 = Integer.parseInt(stringArray[3], 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int n5 = 0;
                    try {
                        n5 = Integer.parseInt(stringArray[4], 10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    UnicodeBlocks[] unicodeBlocksArray = new UnicodeBlocks[n];
                    for (int i = 0; i < n; ++i) {
                        try {
                            unicodeBlocksArray[i] = new UnicodeBlocks(stringArray[10 + i]);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            unicodeBlocksArray[i] = UnicodeBlocks.NONE;
                        }
                    }
                    this.map(new NFontRec(stringArray[0], stringArray[1], 1, n3, n4, n5, unicodeBlocksArray, uRL, l, stringArray[5], stringArray[6], n2++, stringArray[7], stringArray[8], stringArray[9]), 0);
                    continue;
                }
                String string3 = stringArray.length >= 2 ? stringArray[1] : "Bad";
                this.db_.add(new NFontRec(uRL, l, string3, stringArray[0]));
            }
        }
    }

    private String zap(String string) {
        if (string != null) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    stringBuffer.append("  ");
                    continue;
                }
                if (c == '\r' || c == '\t') continue;
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private NFontRec[] mapAll(URL uRL, long l, int n) throws FontFormatException, IOException {
        int n2;
        NFont[] nFontArray;
        Object object;
        NFont nFont = NFontManager.createFont(uRL, null);
        int n3 = 1;
        if (nFont instanceof NFontTrueType) {
            object = (NFontTrueType)nFont;
            n3 = ((NFontTrueType)object).getCount();
            nFontArray = new NFont[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                nFontArray[n2] = ((NFontTrueType)object).getSubfont(n2);
            }
        } else {
            nFontArray = new NFont[]{nFont};
        }
        object = null;
        if ("TrueType" == nFont.getFormat()) {
            block1: for (n2 = 0; object == null && n2 < n3; ++n2) {
                SfntDirectory sfntDirectory;
                NFontTrueType nFontTrueType = (NFontTrueType)nFontArray[n2];
                for (String string : OPENTYPE_TABLE) {
                    sfntDirectory = nFontTrueType.getTableDirectory(string);
                    if (sfntDirectory == null || sfntDirectory.length <= 4) continue;
                    object = "OpenType";
                    break;
                }
                if (object == null) {
                    for (String string : AAT_TABLE) {
                        sfntDirectory = nFontTrueType.getTableDirectory(string);
                        if (sfntDirectory == null || sfntDirectory.length <= 4) continue;
                        object = "AAT";
                        break;
                    }
                }
                if (object != null) continue;
                for (String string : MM_TABLE) {
                    sfntDirectory = nFontTrueType.getTableDirectory(string);
                    if (sfntDirectory == null || sfntDirectory.length <= 4) continue;
                    object = "MM";
                    continue block1;
                }
            }
        }
        NFontRec[] nFontRecArray = new NFontRec[n3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            String string;
            NFont nFont2 = nFontArray[i];
            String string2 = nFont2.getName();
            if (!$assertionsDisabled && string2.indexOf(9) != -1) {
                throw new AssertionError((Object)string2);
            }
            string = nFont2.getFamily();
            nFontRecArray[i] = new NFontRec(string2, string, 1, nFont2.getWeight(), nFont2.getFlags(), nFont2.getNumGlyphs(), nFont2.getUnicode(), uRL, l, (String)(object == null ? nFont2.getFormat() : object), nFont2.getSubformat(), n4, nFont2.getVersion(), nFont2.getDesigner(), nFont2.getCopyright());
            this.map(nFontRecArray[i], n);
            ++n4;
        }
        return nFontRecArray;
    }

    public void map(NFontRec nFontRec, int n) {
        boolean bl = true;
        this.db_.add(nFontRec);
        int n2 = this.getNameIndex(nFontRec.getName());
        String string = nFontRec.getFormat();
        String string2 = nFontRec.getSubformat();
        if (handlers_.get("TrueType") == handlers_.get(string) && "bitmap" == string2) {
            nFontRec.setStatus("Unsupported", "TrueType bitmap");
        } else if (nFontRec.getStatus() == "Active") {
            if (n2 == -1) {
                this.active_.add(nFontRec);
            } else {
                String string3;
                NFontRec nFontRec2 = this.active_.get(n2);
                NFontRec nFontRec3 = nFontRec;
                if (0 == n) {
                    if (nFontRec.quality() == nFontRec2.quality()) {
                        string3 = "follows";
                    } else {
                        string3 = "lower quality than";
                        if (nFontRec.quality() > nFontRec2.quality()) {
                            nFontRec3 = nFontRec2;
                        }
                    }
                } else {
                    string3 = "overridden by";
                    if (1 == n) {
                        nFontRec3 = nFontRec2;
                    }
                }
                nFontRec3.setStatus("Duplicate", new StringBuffer().append(string3).append(" ").append((nFontRec3 == nFontRec2 ? nFontRec : nFontRec2).getSourceShort()).toString());
                if (nFontRec3 == nFontRec2) {
                    this.active_.remove(nFontRec3);
                    this.active_.add(nFontRec);
                }
            }
        }
        this.allnorm_ = null;
        this.allfam_ = null;
        this.allname_ = null;
        this.cjk_ = null;
        this.fpost_ = false;
    }

    public void map(String string, String string2, String string3, int n) {
        boolean bl;
        int n2 = this.getNameIndex(string);
        int n3 = this.getNameIndex(string3);
        boolean bl2 = bl = (n2 == -1 || 1 == n) && n3 != -1;
        if (bl) {
            NFontRec nFontRec = this.active_.get(n3);
            NFontRec nFontRec2 = new NFontRec(string, string2, nFontRec.getFamilySize(), nFontRec.getWeight(), nFontRec.getFlags(), nFontRec.getNumGlyphs(), nFontRec.getUnicode(), nFontRec.getSource(), nFontRec.getLastModified(), nFontRec.getFormat(), nFontRec.getSubformat(), nFontRec.getNum(), nFontRec.getVersion(), nFontRec.getDesigner(), nFontRec.getCopyright());
            nFontRec2.setStatus("Active", new StringBuffer().append("mapped from ").append(string3).toString());
            this.map(nFontRec2, n);
        }
    }

    public void mapURW() {
        InputStream inputStream = this.getClass().getResourceAsStream("/com/urw/font/map.txt");
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#") || string.length() < 10) continue;
                String[] stringArray = string.split("\\s*\t\\s*");
                this.map(stringArray[0], stringArray[1], stringArray[2], -1);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void mapJavaLogical() {
        if (this.allfam_ == null) {
            this.getAvailableFamilies();
        }
        for (String string : "Times,Luxi Serif,Lucida Bright".split(",")) {
            if (!this.isAvailableFamily(string)) continue;
            this.eqfam_.put("Serif", string);
            break;
        }
        for (String string : "Helvetica,Helvetica Neue,Luxi Sans,Lucida Sans".split(",")) {
            if (!this.isAvailableFamily(string)) continue;
            this.eqfam_.put("SansSerif", string);
            break;
        }
        for (String string : "Courier,Courier New,Lucida Sans Typewriter".split(",")) {
            if (!this.isAvailableFamily(string)) continue;
            this.eqfam_.put("Monospaced", string);
            break;
        }
        if (GraphicsEnvironment.isHeadless()) {
            // empty if block
        }
        int n = this.getNameIndex(new Font("Dialog", 0, 1).getPSName());
        for (String string : "Arial,Helvetica,Helvetica Neue,Luxi Sans,Lucida Sans".split(",")) {
            if (!this.isAvailableFamily(string)) continue;
            this.eqfam_.put("Dialog", string);
            break;
        }
        this.eqfam_.put("DialogInput", this.eqfam_.get("Monospaced"));
    }

    public void mapMacDoze() {
        int n = MACDOZE.length;
        for (int i = 0; i < n; i += 2) {
            String string = MACDOZE[i];
            String string2 = MACDOZE[i + 1];
            this.eqfam_.put(string, string2);
            this.eqfam_.put(string2, string);
        }
    }

    public String[] getAvailableNames() {
        if (this.allname_ == null) {
            List<NFontRec> list = this.active_;
            Object[] objectArray = new String[list.size()];
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                objectArray[i] = list.get(i).getName();
            }
            Arrays.sort(objectArray);
            this.allname_ = objectArray;
        }
        return (String[])this.allname_.clone();
    }

    public String[] getAvailableFamilies() {
        if (this.allfam_ == null) {
            int n;
            List<NFontRec> list = this.active_;
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                String string = list.get(n).getFamily();
                if (arrayList.indexOf(string) != -1) continue;
                arrayList.add(string);
            }
            n = arrayList.size();
            this.allfam_ = arrayList.toArray(new String[n]);
            Arrays.sort(this.allfam_);
        }
        return (String[])this.allfam_.clone();
    }

    public List<NFontRec> getDatabase() {
        this.xref();
        return Collections.unmodifiableList(this.db_);
    }

    public List<NFontRec> getActive() {
        this.xref();
        return Collections.unmodifiableList(this.active_);
    }

    private int getNameIndex(String string) {
        List<NFontRec> list = this.active_;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(list.get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public boolean isAvailableName(String string) {
        if (string == null) {
            return false;
        }
        if (this.allname_ == null) {
            this.getAvailableNames();
        }
        return Arrays.binarySearch(this.allname_, string) >= 0;
    }

    public boolean isAvailableFamily(String string) {
        if (string == null) {
            return false;
        }
        if (this.allfam_ == null) {
            this.getAvailableFamilies();
        }
        return Arrays.binarySearch(this.allfam_, string) >= 0;
    }

    public String[] getPaths() {
        return (String[])this.paths_.clone();
    }

    public String getAvailableFamily(String string, int n) {
        String string2;
        String string3;
        int n2;
        String string4 = null;
        String string5 = this.eqfam_.get(string);
        if (string != null) {
            if (this.isAvailableFamily(string)) {
                string4 = string;
            } else {
                n2 = this.getNormFamily(string);
                if (n2 >= 0) {
                    string4 = this.allfam_[n2];
                } else if (string5 != null && this.isAvailableFamily(string5)) {
                    string4 = string5;
                }
            }
        }
        if (string4 == null) {
            for (int i = string.length() - 1; i > 0; --i) {
                int n3 = string.charAt(i);
                if (Character.isUpperCase((char)n3) || Character.isWhitespace((char)n3)) continue;
                if (++i >= string.length() || (n2 = this.getNormFamily(string.substring(0, i).trim())) < 0) break;
                string4 = this.allfam_[n2];
                break;
            }
        }
        if (string4 == null) {
            for (String string6 : FOUNDARY) {
                String string7;
                if (!string.startsWith(string6) || !this.isAvailableFamily(string7 = string.substring(string6.length()).trim())) continue;
                string4 = string7;
                break;
            }
        }
        if (string4 == null && (n2 = string.indexOf(45)) != -1 && this.isAvailableFamily(string3 = string.substring(0, n2))) {
            string4 = string.substring(0, n2);
        }
        if (string4 == null && (string.endsWith("Pro") || string.endsWith("Std")) && this.isAvailableFamily(string2 = string.substring(string.length() - "Pro".length()).trim())) {
            string4 = string2;
        }
        if (string4 == null) {
            for (String string6 : this.allfam_) {
                if (!string6.startsWith(string) || string6.length() <= string.length() || Character.isLowerCase(string6.charAt(string.length()))) continue;
                string4 = string6;
                break;
            }
        }
        if (string4 == null) {
            NFontRec nFontRec = null;
            if ("Symbol".equals(string)) {
                nFontRec = this.match(null, UnicodeBlocks.SYMBOL, -1, 400, n | 4);
            } else if ("ZapfDingbats".equals(string) || "Dingbats".equals(string)) {
                nFontRec = this.match(null, UnicodeBlocks.DINGBATS, -1, 400, n | 4);
            }
            if (nFontRec != null) {
                string4 = nFontRec.getFamily();
            }
        }
        if (string4 == null && n != -1) {
            if (string.startsWith("Minion") || string.equals("Serif")) {
                n |= 2;
            } else if (string.startsWith("Myriad") || string.equals("SansSerif")) {
                n &= 0xFFFFFFFD;
            } else if (string.equals("Monospaced")) {
                n |= 1;
            }
            string4 = (1 & n) != 0 ? (this.isAvailableFamily("Courier") ? "Courier" : "Lucida Sans Typewriter") : ((2 & n) != 0 ? (this.isAvailableFamily("Times") ? "Times" : (this.isAvailableFamily("Times New Roman") ? "Times New Roman" : "Lucida Bright")) : (this.isAvailableFamily("Helvetica") ? "Helvetica" : (this.isAvailableFamily("Arial") ? "Arial" : (this.isAvailableFamily("Helvetica Neue") ? "Helvetica Neue" : "Lucida Sans"))));
            if (!this.isAvailableFamily(string4)) {
                string4 = this.match(null, null, -1, 400, n).getFamily();
            }
        }
        if (!$assertionsDisabled && string4 == null && n != -1) {
            throw new AssertionError();
        }
        return string4;
    }

    private int getNormFamily(String string) {
        int n;
        if (this.allnorm_ == null) {
            this.getAvailableFamilies();
            int n2 = this.allfam_.length;
            this.allnorm_ = new String[n2];
            for (n = 0; n < n2; ++n) {
                this.allnorm_[n] = NFontManager.normalizeFamily(this.allfam_[n]);
            }
        }
        String string2 = NFontManager.normalizeFamily(string);
        int n3 = this.allnorm_.length;
        for (n = 0; n < n3; ++n) {
            if (!string2.equals(this.allnorm_[n])) continue;
            return n;
        }
        return -1;
    }

    private static String normalizeFamily(String string) {
        int n;
        for (n = string.length(); n > 0 && Character.isUpperCase(string.charAt(n - 1)); --n) {
        }
        if (n == 0) {
            n = string.length();
        }
        if (string.endsWith("Pro") || string.endsWith("Std")) {
            n -= "Pro".length();
        }
        return Strings.removeWhitespace(string.substring(0, n).toLowerCase());
    }

    private List<NFontRec> getCJK(String string) {
        if (this.cjk_ == null) {
            long l = System.currentTimeMillis();
            ArrayList<NFontRec> arrayList = new ArrayList<NFontRec>(10);
            ArrayList<NFontRec> arrayList2 = new ArrayList<NFontRec>(10);
            ArrayList<NFontRec> arrayList3 = new ArrayList<NFontRec>(10);
            UnicodeBlock unicodeBlock = UnicodeBlock.getInstance("CJK Unified Ideographs");
            for (NFontRec nFontRec : this.active_) {
                if ("LastResort".equals(nFontRec.getName())) continue;
                if (nFontRec.getUnicodeExist().covers(unicodeBlock)) {
                    NFont nFont = null;
                    try {
                        nFont = this.getFont(nFontRec);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nFont.canDisplay(12289) && nFont.canDisplay(19968) && nFont.canDisplay(19969)) {
                        if (this.hits(nFont, "\u4e00-\u4eff") >= 250) {
                            arrayList2.add(nFontRec);
                        }
                        if (this.hits(nFont, "\u4e00-\u4e01,\u4e03-\u4e04,\u4e07-\u4e11,\u4e14-\u4e16,\u4e18-\u4e1a,\u4e1c,\u4e1e-\u4e1f,\u4e21,\u4e24,\u4e26,\u4e28,\u4e2a-\u4e2e,\u4e30-\u4e33") >= 35) {
                            arrayList.add(nFontRec);
                        }
                        if (this.hits(nFont, "\u4e00-\u4e01,\u4e03-\u4e05,\u4e07-\u4e0b,\u4e0d-\u4e0e,\u4e10-\u4e11,\u4e14-\u4e19,\u4e1e-\u4e1f,\u4e21,\u4e26,\u4e28,\u4e2a-\u4e2d,\u4e2f-\u4e32,\u4e36-\u4e39,\u4e3b-\u4e3c,\u4e3f-\u4e45,\u4e48,\u4e4b,\u4e4d-\u4e4f,\u4e55-\u4e5a,\u4e5d-\u4e5f,\u4e62,\u4e71,\u4e73,\u4e7e-\u4e80") >= 63) {
                            arrayList3.add(nFontRec);
                        }
                    }
                }
                this.cjk_ = new List[]{arrayList2, arrayList, arrayList3};
            }
            long l2 = System.currentTimeMillis();
        }
        int n = FAMILY_CHINESE_SIMPLIFIED.equals(string) ? 0 : (FAMILY_CHINESE_TRADITIONAL.equals(string) ? 1 : (FAMILY_JAPANESE.equals(string) ? 2 : -1));
        return n >= 0 ? this.cjk_[n] : null;
    }

    private int hits(NFont nFont, String string) {
        int n = 0;
        int n2 = 0;
        for (String string2 : string.split(",")) {
            int n3 = string2.charAt(0);
            int n4 = string2.length() == 3 && string2.charAt(1) == '-' ? string2.charAt(2) : n3;
            for (int i = n3; i <= n4; ++i) {
                if (nFont.canDisplay(i)) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public synchronized NFontRec match(String string, UnicodeBlocks unicodeBlocks, int n, int n2, int n3) {
        Object object;
        int n4;
        if (unicodeBlocks == UnicodeBlocks.NONE) {
            unicodeBlocks = null;
        }
        this.xref();
        List<NFontRec> list = this.active_;
        String string2 = null;
        if (string != null) {
            if (FAMILY_CHINESE_SIMPLIFIED.equals(string) || FAMILY_CHINESE_TRADITIONAL.equals(string) || FAMILY_JAPANESE.equals(string)) {
                list = this.getCJK(string);
            } else if (FAMILY_KOREAN.equals(string)) {
                unicodeBlocks = UnicodeBlocks.getInstance(UnicodeBlock.getInstance("Hangul Syllables"));
            } else {
                string2 = this.getAvailableFamily(string, -1);
            }
        }
        Object object2 = null;
        int n5 = Integer.MIN_VALUE;
        Object object3 = null;
        ArrayList<Object> arrayList = null;
        if (n != -1) {
            if (!$assertionsDisabled && unicodeBlocks != null) {
                throw new AssertionError();
            }
            unicodeBlocks = UnicodeBlocks.getInstance(UnicodeBlock.of(n));
            arrayList = new ArrayList<Object>(list.size());
        }
        int n6 = list.size();
        for (n4 = 0; n4 < n6; ++n4) {
            int n7;
            int n8 = 0;
            object = list.get(n4);
            String string3 = ((NFontRec)object).getFamily();
            if (string3.equals(string2)) {
                n8 += 2000;
            } else if (string2 != null && string3.startsWith(string2)) {
                n8 += 1920;
            } else if ("LastResort".equals(string3) && !"LastResort".equals(string)) {
                if (object3 != null) continue;
                object3 = object;
                continue;
            }
            if (unicodeBlocks != null) {
                n7 = unicodeBlocks.and(((NFontRec)object).getUnicodeFull()).bitCount();
                if (n7 > 0) {
                    n8 += n7 * 1000;
                } else {
                    n7 = unicodeBlocks.and(((NFontRec)object).getUnicodeCoverage()).bitCount();
                    if (n7 > 0) {
                        n8 += n7 * 500;
                    } else {
                        n7 = unicodeBlocks.and(((NFontRec)object).getUnicodeExist()).bitCount();
                        if (n7 > 0) {
                            n8 += n7 * 250;
                        }
                    }
                }
                if (n != -1 && n8 >= 250) {
                    arrayList.add(object);
                    n8 /= 10;
                }
            }
            if (n2 > 0) {
                n8 += 80 - Math.abs(n2 - ((NFontRec)object).getWeight()) / 10;
            }
            if (n3 != -1) {
                n7 = ((NFontRec)object).getFlags();
                if ((1 & n3) == (1 & n7)) {
                    n8 += 200;
                }
                if ((8 & n3) == (8 & n7)) {
                    n8 += 150;
                }
                if ((0x40 & n3) == (0x40 & n7)) {
                    n8 += 80;
                }
                if ((2 & n3) == (2 & n7)) {
                    n8 += 70;
                }
                if ((4 & n3) == (4 & n7)) {
                    n8 += 60;
                }
                if ((0x4000000 & n3) == (0x4000000 & n7)) {
                    n8 += 60;
                }
            }
            if (string3.startsWith("Times") || string3.startsWith("Helvetica") || string3.startsWith("Courier")) {
                n8 += 20;
            }
            n8 += Math.min(5, ((NFontRec)object).getFamilySize()) * 5;
            if ("OpenType" == ((NFontRec)object).getFormat()) {
                n8 += 2;
            } else if ("TrueType" == ((NFontRec)object).getFormat()) {
                ++n8;
            }
            ((NFontRec)object).setScore(n8);
            if (n8 <= n5) continue;
            object2 = object;
            n5 = n8;
        }
        if (n != -1) {
            Collections.sort(arrayList);
            n6 = arrayList.size();
            for (n4 = 0; n4 < n6; ++n4) {
                NFontRec nFontRec = (NFontRec)arrayList.get(n4);
                try {
                    object = this.getFont(nFontRec);
                    if (!((NFont)object).canDisplay(n)) continue;
                    object2 = nFontRec;
                    n5 += 3000;
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (unicodeBlocks != null && n5 < 1000) {
            object2 = null;
        }
        NFont.getLogger().finer(new StringBuffer().append("font matching: ").append(string).append(" ").append(n2).append(" ").append(NFont.strFlags(n3)).append(" => ").append(string2).append(" => ").append(object2).append(", score=").append(n5).toString());
        return object2;
    }

    public static UnicodeBlocks[] createMasks(CMap cMap) {
        int n = UnicodeBlock.COUNT;
        StringBuffer stringBuffer = new StringBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer(n);
        StringBuffer stringBuffer3 = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            UnicodeBlock unicodeBlock = UnicodeBlock.getInstance(i);
            int n2 = unicodeBlock.getVisible();
            int n3 = n2 < 10 ? n2 : n2 / 5;
            int n4 = cMap.census(unicodeBlock.getFirst(), unicodeBlock.getLast());
            stringBuffer.append(n4 > 0 ? "1" : "0");
            stringBuffer2.append(n4 > 0 && n4 >= n3 ? "1" : "0");
            stringBuffer3.append(n4 > 0 && n4 >= n2 ? "1" : "0");
        }
        return new UnicodeBlocks[]{new UnicodeBlocks(new BigInteger(stringBuffer.reverse().toString(), 2)), new UnicodeBlocks(new BigInteger(stringBuffer2.reverse().toString(), 2)), new UnicodeBlocks(new BigInteger(stringBuffer3.reverse().toString(), 2))};
    }

    public static String guessFamily(String string) {
        String string2;
        int n;
        if (Fonts.isSubset(string)) {
            string = string.substring(7);
        }
        if ((n = (string2 = string).indexOf(44)) > 0) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.lastIndexOf(45)) > 0) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static int guessFlags(String string, String string2) {
        int n = 0;
        if (!string2.matches("Helvetica.*|Arial.*|URW Gothic L|.+Sans.*")) {
            n |= 2;
        }
        n = string2.matches("Symbol.*|Standard Symbols L|ZapfDingbats|Dingbats|Wingdings|Webdings|.+Bats.*|Cursor") ? (n |= 4) : (n |= 0x20);
        if (string.matches(".+(Script|Hand|Chancery).*")) {
            n |= 8;
        }
        if (string.indexOf("Cond") > 0 || string.indexOf("Narrow") > 0) {
            n |= 0x4000000;
        } else if (string.indexOf("Expanded") > 0 || string.indexOf("Wide") > 0) {
            n |= 0x8000000;
        }
        return NFontManager.fixFlags(n, string, string2);
    }

    public static int fixFlags(int n, String string, String string2) {
        int n2 = n;
        if (string.startsWith("Courier") || string2.equals("Nimbus Mono L")) {
            n |= 1;
        }
        if (string2.indexOf("Gothic") > 0) {
            n &= 0xFFFFFFFD;
        }
        if (string.indexOf("Italic") > 0 || string.indexOf("Obli") > 0) {
            n |= 0x40;
        }
        if (string.indexOf("Display") > 0 || string.indexOf("Ornament") > 0) {
            n |= 0x10000000;
        }
        return n;
    }

    public static int guessWeight(String string) {
        if (string == null) {
            return 400;
        }
        String string2 = string;
        boolean bl = false;
        int n = string2.indexOf(44);
        if (n != -1) {
            string2 = string2.substring(n + 1);
            bl = true;
        }
        if ((n = string2.lastIndexOf(45)) != -1) {
            string2 = string2.substring(n + 1);
            bl = true;
        }
        if (!bl) {
            int n2;
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && Character.isUpperCase(string.charAt(n2)); ++n2) {
            }
            while (n2 < n3 && Character.isLowerCase(string.charAt(n2))) {
                ++n2;
            }
            if (0 < n2 && n2 < n3 && Character.isUpperCase(string.charAt(n2))) {
                string2 = string2.substring(n2);
                bl = true;
            }
        }
        return !bl ? 400 : (string2.indexOf("Black") != -1 || string2.indexOf("Heavy") != -1 ? 900 : (string2.indexOf("Extralight") != -1 ? 100 : (string2.indexOf("Extra") != -1 && string2.indexOf("ExtraCondensed") == -1 || string2.indexOf("Ultra") != -1 ? 800 : (string2.indexOf("Demi") != -1 || string2.indexOf("Semi") != -1 ? 600 : (string2.indexOf("Bold") != -1 ? 700 : (string2.indexOf("Medium") != -1 ? 500 : (string2.indexOf("Light") != -1 ? 300 : 400)))))));
    }

    public static int guessRights(String string) {
        int n;
        if (string == null || string.trim().length() == 0) {
            return 131072;
        }
        int n2 = (string = string.trim().toLowerCase()).indexOf("freeware") != -1 || string.indexOf("copyright") == -1 && string.indexOf(169) == -1 ? 0 : (string.indexOf("adobe") != -1 || string.indexOf("monotype") != -1 ? 4 : (string.indexOf("apple") != -1 || string.indexOf("sun microsystems") != -1 || string.indexOf("microsoft") != -1 ? 4 : (n = string.indexOf("permission is granted to include this font program in a postscript or pdf") != -1 ? 4 : 1)));
        if (string.indexOf("non-commercial") != -1 || string.indexOf("noncommercial") != -1) {
            n |= 0x10000;
        }
        return n | 0x20000;
    }

    public static void register(String string, String string2, String string3) {
        handlers_.put(string2, string);
        if (string3 != null) {
            for (String string4 : string3.toLowerCase().split("\\|")) {
                handlers_.put(string4, string);
                if (suffixes_.indexOf(string4) != -1) continue;
                suffixes_.add(string4);
            }
        }
    }

    public static String[] getSuffixes() {
        return suffixes_.toArray(new String[suffixes_.size()]);
    }

    public static FileFilter getFilter() {
        return new FileFilter(){
            final Matcher m_ = Pattern.compile("(?i)\\.(" + Strings.join(NFontManager.getSuffixes(), "|") + ")$").matcher("");

            public boolean accept(File file) {
                boolean bl = this.m_.reset(file.getPath()).find();
                if (!bl && fmacos_) {
                    try {
                        bl = NFontManager.readResource(file) != null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return bl;
            }
        };
    }

    public static NFont createFont(URL uRL, String string) throws FontFormatException, IOException {
        Object object;
        Object object2;
        byte[] byArray = null;
        String string2 = uRL.toString();
        if (string2.startsWith("file:") && ((File)(object2 = new File(string2.substring("file:".length())))).canRead() && ((File)object2).length() == 0L && (object = NFontManager.readResource((File)object2)) != null) {
            byArray = (byte[])object[0];
            string = (String)object[1];
            if ("NFNT".equals(string)) {
                throw new FontFormatException("unsupported: NFNT bitmap");
            }
        }
        Object object3 = object2 = string != null ? handlers_.get(string) : null;
        if (object2 == null) {
            object = Files.getSuffix(string2).toLowerCase();
            object2 = handlers_.get(object);
        }
        if (object2 == null) {
            throw new FontFormatException(new StringBuffer().append("unknown format: ").append(string).toString());
        }
        object = null;
        try {
            Class<?> clazz = Class.forName((String)object2);
            Object obj = byArray == null ? clazz.getConstructor(NFONT_SIG).newInstance(uRL) : clazz.getConstructor(NFONT_SIG_DATA).newInstance(uRL, byArray);
            object = (NFont)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof FontFormatException) {
                throw (FontFormatException)throwable;
            }
            if (throwable instanceof AssertionError) {
                throw new FontFormatException(new StringBuffer().append(throwable.getMessage()).append(" ").append(throwable.getStackTrace()[0]).toString());
            }
            if (!$assertionsDisabled && !(throwable instanceof IOException)) {
                throw new AssertionError((Object)throwable);
            }
            throw (IOException)throwable;
        }
        return object;
    }

    public static Object[] readResource(File file) throws IOException {
        Object[] objectArray;
        if (!fmacos_ || !file.isFile() || file.length() != 0L) {
            return null;
        }
        File file2 = new File(new StringBuffer(file.getPath()).append("/").append("..").append("name").append("d").append("fork").append("/").append("r").append("s").append("r").append("c").toString());
        if (!file2.canRead() || file2.length() == 0L) {
            return null;
        }
        byte[] byArray = Files.toByteArray(file2);
        byte[] byArray2 = null;
        String string = null;
        Rez rez = new Rez(new RandomAccessByteArray(byArray, "r"), 0L);
        int[] nArray = rez.getTypes();
        if (Arrayss.indexOf(nArray, TAG_SFNT) != -1) {
            byArray2 = byArray;
            string = "TrueType";
        } else if (Arrayss.indexOf(nArray, TAG_POST) != -1) {
            int n;
            long[] lArray = rez.getResources(TAG_POST);
            long l = 0L;
            int n2 = lArray.length;
            for (n = 0; n < n2; n += 2) {
                l += lArray[n + 1] - 2L;
            }
            byArray2 = new byte[(int)l];
            n2 = lArray.length;
            int n3 = 0;
            for (n = 0; n < n2; n += 2) {
                int n4 = (int)lArray[n + 1] - 2;
                System.arraycopy(byArray, (int)lArray[n] + 2, byArray2, n3, n4);
                n3 += n4;
            }
            string = "Type1";
        } else if (Arrayss.indexOf(nArray, TAG_NFNT) != -1) {
            byArray2 = new byte[]{};
            string = "NFNT";
        }
        if (byArray2 != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = byArray2;
            objectArray = objectArray2;
            objectArray2[1] = string;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public NFont getFont(String string) throws FontFormatException, IOException {
        int n = this.getNameIndex(string);
        return n != -1 ? this.getFont(this.active_.get(n)) : null;
    }

    public NFont getFont(NFontRec nFontRec) throws FontFormatException, IOException {
        SoftReference<NFont> softReference = cache_.get(nFontRec.getSource());
        NFont nFont = softReference != null ? softReference.get() : null;
        String string = nFontRec.getStatus();
        if ("Bad" == string || "Unsupported" == string) {
            throw new FontFormatException(nFontRec.getMessage());
        }
        if (nFont == null) {
            try {
                nFont = NFontManager.createFont(nFontRec.getSource(), nFontRec.getFormat());
                cache_.put(nFontRec.getSource(), new SoftReference<NFont>(nFont));
            }
            catch (FontFormatException fontFormatException) {
                nFontRec.setStatus("Bad", fontFormatException.getMessage());
                this.active_.remove(nFontRec);
            }
            catch (IOException iOException) {
                if (!this.fstrong_) {
                    this.fstrong_ = true;
                    try {
                        NFont.getLogger().severe(new StringBuffer().append("fail (").append(iOException.getMessage()).append(") and database check was weak => updating database").toString());
                        this.db_.clear();
                        this.active_.clear();
                        this.req_.clear();
                        FileLog fileLog = new FileLog(this.log_, this.paths_, true, 14);
                        fileLog.setHash(false);
                        fileLog.update(this, this.filter_);
                        fileLog.write();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    nFont = this.getFont(nFontRec.getName());
                }
                nFontRec.setStatus("Bad", iOException.getMessage());
                this.active_.remove(nFontRec);
                NFont.getLogger().severe(new StringBuffer().append("bad font: ").append(nFontRec.getSource()).append(" ").append(nFontRec.getFormat()).append(": ").append(iOException.getCause()).toString());
                throw iOException;
            }
        }
        if (nFont != null) {
            if (nFontRec.getNum() > 0) {
                nFont = ((NFontTrueType)nFont).getSubfont(nFontRec.getNum());
            }
            if ("Type1" == nFont.getFormat()) {
                nFont = ((NFontSimple)nFont).deriveFont(Encoding.UNICODE, CMap.IDENTITY);
            }
            nFont.setManager(this);
        }
        return nFont;
    }

    public NFont getFont(String string, UnicodeBlocks unicodeBlocks, int n, int n2, int n3, float f) {
        NFont nFont = null;
        NFont nFont2 = null;
        int n4 = -1;
        for (int i = this.req_.size() - 1; i >= 0; --i) {
            NFontRec nFontRec = this.req_.get(i);
            NFont nFont3 = nFontRec.getCache();
            if (string != null && !string.equals(nFontRec.getFamily()) && !string.equals(nFont3.getFamily()) || n2 != nFontRec.getWeight() && n2 != nFont3.getWeight() || n3 != nFontRec.getFlags() && n3 != nFont3.getFlags() || unicodeBlocks != null && !unicodeBlocks.and(nFontRec.getUnicodeExist()).equals(unicodeBlocks) && !unicodeBlocks.and(nFont3.getUnicode()[1]).equals(unicodeBlocks) || n != -1 && !nFont3.canDisplay(n)) continue;
            if ((double)Math.abs(nFont3.getSize() - f) < 0.01) {
                nFont = nFont3;
                n4 = i;
                break;
            }
            nFont2 = nFont3;
        }
        if (nFont == null && nFont2 != null) {
            nFont = nFont2.deriveFont(f);
        }
        while (nFont == null && this.active_.size() > 0) {
            NFontRec nFontRec = this.match(string, unicodeBlocks, n, n2, n3);
            try {
                nFont = this.getFont(nFontRec);
                if (!$assertionsDisabled && nFont.getSize() != 1.0f) {
                    throw new AssertionError(nFont.getSize());
                }
                if (f == 1.0f) continue;
                nFont = nFont.deriveFont(f);
            }
            catch (Exception exception) {}
        }
        if (n4 == -1) {
            NFontRec nFontRec = new NFontRec(nFont, string, n2, n3, unicodeBlocks);
            if (this.req_.size() >= 40) {
                this.req_.remove(0);
            }
            this.req_.add(nFontRec);
        } else if (this.req_.size() - n4 >= 10) {
            NFontRec nFontRec = this.req_.remove(n4);
            this.req_.add(nFontRec);
        }
        if (n4 == -1) {
            NFont.getLogger().fine(new StringBuffer().append(string).append(" ").append(f).append(" ").append(n2).append(" ").append(NFont.strFlags(n3)).append(" => ").append(nFont).append(n4 != -1 ? new StringBuffer().append(", cached @ ").append(n4).toString() : (nFont2 != null ? ", derived size" : ", created")).toString());
        }
        return nFont;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$com$pt$awt$font$NFontManager == null ? (class$com$pt$awt$font$NFontManager = NFontManager.class$("com.pt.awt.font.NFontManager")) : class$com$pt$awt$font$NFontManager).desiredAssertionStatus();
        FONTPATH = new String[]{"~/.Multivalent/fonts", "~/Library/Fonts", new StringBuffer().append(System.getProperty("java.home")).append("/lib/fonts").toString(), "/Library/Application Support/Adobe/Fonts", "/Library/Fonts", "/Network/Library/Fonts", "/System/Library/Fonts", "/System Folder/Fonts", "/usr/openwin/lib/locale", "/usr/openwin/lib/fonts", "/usr/openwin/lib/X11/fonts", "/C:/WINDOWS/Fonts", "/C:/WINNT/Fonts", "/usr/share/fonts", "/var/lib/defoma/x-ttcidfont-conf.d/dirs/TrueType", "/usr/X11R6/lib/X11/fonts"};
        SPOT = new String[]{"/usr/X11R6/lib/X11/fonts/Type1/fonts.dir", "/usr/X11R6/lib/X11/fonts/TrueType/fonts.dir"};
        AGE_MAX = 1209600000L;
        OPENTYPE_TABLE = new String[]{"GSUB", "GPOS", "GDEF", "BASE", "JSTF", "CFF"};
        AAT_TABLE = new String[]{"mort", "morx", "Zapf"};
        MM_TABLE = new String[]{"fvar", "gvar", "MMSD", "MMFX"};
        MACDOZE = new String[]{"Avant Garde", "Century Gothic", "Bookman", "Bookman Old Style", "Helvetica", "Arial", "Helvetica Narrow", "Arial Narrow", "New Century Schlbk", "Century Schoolbook", "Palatino", "Book Antiqua", "Times", "Times New Roman", "Zapf Chancery", "Monotype Corsiva", "Zapf Dingbats", "Monotype Sorts"};
        FOUNDARY = new String[]{"Apple", "Adobe", "AdobeCorpID", "Microsoft", "MS", "ITC", "MM"};
        NFONT_SIG = new Class[]{class$java$net$URL == null ? (class$java$net$URL = NFontManager.class$("java.net.URL")) : class$java$net$URL};
        NFONT_SIG_DATA = new Class[]{class$java$net$URL == null ? (class$java$net$URL = NFontManager.class$("java.net.URL")) : class$java$net$URL, array$B == null ? (array$B = NFontManager.class$("[B")) : array$B};
        handlers_ = new HashMap<String, String>(7);
        suffixes_ = new ArrayList<String>(7);
        NFontManager.register("com.pt.awt.font.NFontType1", "Type1", "pfa|pfb");
        NFontManager.register("com.pt.awt.font.NFontType1", "MM", null);
        NFontManager.register("com.pt.awt.font.NFontTrueType", "TrueType", "ttf|dfont|ttc");
        NFontManager.register("com.pt.awt.font.NFontOpenType", "OpenType", "otf|otc");
        NFontManager.register("com.pt.awt.font.NFontTrueType", "AAT", null);
        TAG_SFNT = Mac.intTag("sfnt");
        TAG_POST = Mac.intTag("POST");
        TAG_NFNT = Mac.intTag("NFNT");
        cache_ = new HashMap<URL, SoftReference<NFont>>(13);
        def_ = null;
        fmacos_ = new File("/System Folder/Fonts").canRead();
    }
}

