/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.font.CMap;
import com.pt.awt.font.NFontSimple;
import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessByteArray;
import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import phelps.io.Files;

public class NFontPFR
extends NFontSimple
implements Cloneable {
    static final boolean DEBUG = false;
    public static final String COPYRIGHT = "Copyright (c) 2004  Thomas A. Phelps.  All rights reserved.";
    public static final String FORMAT = "PFR";
    public static final int HEAD_SIG = 1346785840;
    private static final int LINE_JOIN_MITER = 0;
    private static final int LINE_JOIN_ROUND = 1;
    private static final int LINE_JOIN_BEVEL = 2;
    private static final GeneralPath GLYPH_ZERO_CONTOUR;
    private static final byte[] TABLE_EMPTY;
    private URL source_;
    private NFontPFR[] urs_;
    private int[] goffset_;
    private int[] glength_;
    private NFontPFR ur_;
    private long raoff_;
    private int version_;
    private String ID_;
    private int ascent_;
    private int descent_;
    private int maxGlyph_;
    private int glyphcnt_;
    private String[] names_ = null;
    protected CMap c2g_;
    private RandomAccess ra_;
    private byte[] data_;
    private AffineTransform mw_;
    int offset_;
    private SoftReference[] paths_ = null;
    private int hint_ = -1;
    private int[] widths_ = null;
    private Shape notdef_ = null;
    private int flags_;
    private int weight_;
    private int spacech_ = Integer.MIN_VALUE;
    private String name_ = "[PFR]";
    private String family_ = "[PFR]";
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFontPFR(URL uRL) throws FontFormatException, IOException {
        super(uRL);
        this.ur_ = this;
        this.getRA();
        if (!$assertionsDisabled && this.ra_.getFilePointer() != 0L) {
            throw new AssertionError();
        }
        try {
            this.parse();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.releaseRA();
        }
    }

    public NFontPFR(URL uRL, byte[] byArray) throws FontFormatException, IOException {
        super(uRL);
        this.ur_ = this;
        this.ra_ = new RandomAccessByteArray(byArray, "r");
        this.parse();
    }

    private NFontPFR() {
        super(null);
    }

    private void parse() throws FontFormatException, IOException {
        this.data_ = this.readRaw(0L, 58);
        this.offset_ = 0;
        if (!$assertionsDisabled && this.data_.length != 58) {
            throw new AssertionError();
        }
        int n = this.readUint32();
        if (n != 1346785840) {
            throw new FontFormatException("not a PFR font (header signature " + Integer.toHexString(n) + ")");
        }
        int n2 = this.readUint16();
        if (!$assertionsDisabled && n2 != 4) {
            throw new AssertionError();
        }
        int n3 = this.readUint16();
        if (!$assertionsDisabled && n3 != 3338) {
            throw new AssertionError();
        }
        int n4 = this.readUint16();
        if (!$assertionsDisabled && n4 != 58) {
            throw new AssertionError();
        }
        int n5 = this.readUint16();
        int n6 = this.readUint16();
        int n7 = this.readUint16();
        int n8 = this.readUint24();
        int n9 = this.readUint24();
        int n10 = this.readUint16();
        int n11 = this.readUint24();
        int n12 = this.readUint24();
        int n13 = this.readUint16();
        int n14 = this.readUint24();
        int n15 = this.readUint24();
        int n16 = this.readUint8();
        int n17 = this.readUint8();
        int n18 = this.readUint8();
        int n19 = this.readUint8();
        int n20 = this.readUint8();
        if (!$assertionsDisabled && (n20 & 0xFC) != 0) {
            throw new AssertionError();
        }
        boolean bl = (n20 & 2) != 0;
        boolean bl2 = (n20 & 1) != 0;
        int n21 = this.readUint24();
        int n22 = this.readUint24();
        int n23 = this.readUint24();
        int n24 = this.readUint16();
        int n25 = this.readUint8();
        int n26 = this.readUint8();
        int n27 = this.readUint16();
        System.out.println("log dir " + n5 + " @ " + n6);
        this.data_ = this.readRaw(0L + (long)n6, n5);
        this.offset_ = 0;
        if (!$assertionsDisabled && this.data_.length != n5) {
            throw new AssertionError();
        }
        int n28 = this.readUint16();
        System.out.println("cnt = " + n28);
        Object[] objectArray = this.parseLogical(n28, n24, n19);
        LogRec[] logRecArray = (LogRec[])objectArray[0];
        int[] nArray = (int[])objectArray[1];
        int[] nArray2 = (int[])objectArray[2];
        PhysRec[] physRecArray = this.parsePhysical(n24, nArray, nArray2);
        this.urs_ = new NFontPFR[n28];
        for (int i = 0; i < n28; ++i) {
            LogRec logRec = logRecArray[i];
            PhysRec physRec = physRecArray[logRec.physical];
            NFontPFR nFontPFR = this.urs_[i] = new NFontPFR();
            nFontPFR.c2g_ = physRec.c2g;
            AffineTransform affineTransform = new AffineTransform(logRec.atm);
            affineTransform.concatenate(physRec.atmg);
            nFontPFR.m_ = affineTransform;
            affineTransform = new AffineTransform(logRec.atm);
            affineTransform.concatenate(physRec.atmw);
            nFontPFR.mw_ = affineTransform;
            nFontPFR.widths_ = physRec.width;
            nFontPFR.goffset_ = physRec.goffset;
            nFontPFR.glength_ = physRec.glength;
            nFontPFR.bbox_ = physRec.bbox;
            nFontPFR.name_ = physRec.ID;
            nFontPFR.paths_ = physRec.paths;
        }
    }

    private Object[] parseLogical(int n, int n2, int n3) throws IOException {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readUint16();
            nArray2[i] = this.readUint24();
        }
        LogRec[] logRecArray = new LogRec[n];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            this.data_ = this.readRaw(0L + (long)nArray2[i], nArray[i]);
            this.offset_ = 0;
            int[] nArray5 = new int[4];
            for (n8 = 0; n8 < 4; ++n8) {
                nArray5[n8] = this.readInt24();
            }
            n8 = this.readUint8();
            if (!$assertionsDisabled && (n8 & 0x80) != 0) {
                throw new AssertionError();
            }
            boolean bl = (n8 & 0x40) != 0;
            boolean bl2 = (n8 & 0x20) != 0;
            boolean bl3 = (n8 & 0x10) != 0;
            boolean bl4 = (n8 & 8) != 0;
            boolean bl5 = (n8 & 4) != 0;
            int n9 = n8 & 3;
            int n10 = 0;
            float f = 0.0f;
            if (bl5) {
                int n11 = n10 = bl4 ? this.readInt16() : this.readUint8();
                if (0 == n9) {
                    f = (float)this.readInt24() / 65536.0f;
                }
            } else if (bl3) {
                int n12 = n10 = bl2 ? this.readInt16() : this.readUint8();
            }
            if (bl) {
                n7 = this.readUint8();
                for (n6 = 0; n6 < n7; ++n6) {
                    n5 = this.readUint8();
                    n4 = this.readUint8();
                    this.offset_ += n5;
                }
            }
            n6 = this.readUint16();
            n7 = this.readUint24();
            if (n3 != 0) {
                n6 |= this.readUint8() << 16;
            }
            n5 = -1;
            for (n4 = 0; n4 < n2; ++n4) {
                if (nArray4[n4] == 0) {
                    n5 = n4;
                    nArray4[n4] = n7;
                    nArray3[n4] = n6;
                    break;
                }
                if (n7 != nArray4[n4]) continue;
                n5 = n4;
                break;
            }
            if (!$assertionsDisabled && n5 == -1) {
                throw new AssertionError();
            }
            AffineTransform affineTransform = new AffineTransform((double)nArray5[0] / 256.0, (double)nArray5[1] / 256.0, (double)nArray5[2] / 256.0, (double)nArray5[3] / 256.0, 0.0, 0.0);
            logRecArray[i] = new LogRec(affineTransform, bl3, bl5, n10, n9, f, n5);
        }
        return new Object[]{logRecArray, nArray4, nArray3};
    }

    private PhysRec[] parsePhysical(int n, int[] nArray, int[] nArray2) throws IOException {
        PhysRec[] physRecArray = new PhysRec[n];
        for (int i = 0; i < n && nArray[i] != 0; ++i) {
            int n2;
            int n3;
            int n4;
            boolean bl;
            this.data_ = this.readRaw(0L + (long)nArray[i], nArray2[i]);
            this.offset_ = 0;
            int n5 = this.readUint16();
            int n6 = this.readInt16();
            int n7 = this.readInt16();
            int n8 = this.readInt16();
            int n9 = this.readInt16();
            int n10 = this.readInt16();
            int n11 = this.readInt16();
            int n12 = this.readUint8();
            boolean bl2 = bl = (n12 & 0x80) != 0;
            if (!$assertionsDisabled && !bl) {
                throw new AssertionError();
            }
            boolean bl3 = (n12 & 0x20) != 0;
            boolean bl4 = (n12 & 0x10) != 0;
            boolean bl5 = (n12 & 8) != 0;
            boolean bl6 = (n12 & 4) != 0;
            boolean bl7 = (n12 & 2) != 0;
            boolean bl8 = (n12 & 1) != 0;
            int n13 = !bl6 ? this.readUint16() : 0;
            String string = null;
            if (bl) {
                n4 = this.readUint8();
                block4: for (n3 = 0; n3 < n4; ++n3) {
                    int n14 = this.readUint8();
                    n2 = this.readUint8();
                    switch (n2) {
                        case 2: {
                            string = this.readString();
                            continue block4;
                        }
                        default: {
                            this.offset_ += n14;
                        }
                    }
                }
            }
            n3 = this.readUint24();
            this.offset_ += n3;
            n4 = this.readUint8();
            int[] nArray3 = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray3[i] = this.readUint16();
            }
            n2 = this.readUint8();
            int n15 = this.readUint8();
            int n16 = this.readUint16();
            int n17 = this.readUint16();
            int n18 = this.readUint16();
            char[] cArray = new char[n18];
            int[] nArray4 = new int[bl6 ? n18 : 1];
            if (bl6) {
                nArray4[0] = n13;
            }
            int[] nArray5 = new int[n18];
            int[] nArray6 = new int[n18];
            for (int j = 0; j < n18; ++j) {
                cArray[j] = (char)(bl7 ? this.readUint16() : this.readUint8());
                if (bl6) {
                    nArray4[j] = this.readUint16();
                }
                if (bl5) {
                    this.readUint8();
                }
                int n19 = bl4 ? this.readUint16() : this.readUint8();
                int n20 = bl3 ? this.readUint24() : this.readUint16();
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(n8, n9, n10, n11);
            physRecArray[i] = new PhysRec(n6, n7, nArray4, cArray, nArray5, nArray6, double_, string);
        }
        return physRecArray;
    }

    public String getName() {
        return this.name_;
    }

    public String getFamily() {
        return this.family_;
    }

    public String getVersion() {
        return this.names_[5] != null ? this.names_[5] : super.getVersion();
    }

    public int getRights() {
        return 4;
    }

    public NFontPFR getFont(int n) {
        return 0 <= n && n < this.getCount() ? this.urs_[n] : null;
    }

    public int getCount() {
        return this.urs_.length;
    }

    public String getFormat() {
        return FORMAT;
    }

    public int getFlags() {
        return this.flags_;
    }

    public int getWeight() {
        return this.weight_;
    }

    public boolean isHinted() {
        if (this.hint_ == -1) {
            this.hint_ = 0;
            int n = this.getMaxGlyphNum();
            for (int i = 1; i < n && this.hint_ != 1; ++i) {
                this.getGlyphRec(i);
            }
            this.releaseRA();
        }
        return this.hint_ == 1;
    }

    public int getMaxGlyphNum() {
        return this.widths_.length;
    }

    public int getNumGlyphs() {
        return this.widths_.length;
    }

    public boolean canDisplayEchar(int n) {
        return this.canDisplayGID(this.c2g_.toSelector(n));
    }

    private boolean canDisplayGID(int n) {
        return 0 <= n && n < this.getMaxGlyphNum();
    }

    public char getSpaceEchar() {
        if (this.spacech_ == Integer.MIN_VALUE) {
            char c;
            if (this.encoding_ != null && "space".equals(this.encoding_.getName(32)) && this.canDisplayEchar(32)) {
                this.spacech_ = 32;
            } else if (this.touni_ != null) {
                this.spacech_ = this.touni_.fromSelector(32);
            } else if (this.encoding_ != null && (c = this.encoding_.getChar("space")) != '\u0000' && this.canDisplayEchar(c)) {
                this.spacech_ = c;
            } else {
                char c2 = this.c2g_.toSelector(32);
                if (c2 != '\u0000' && this.canDisplayGID(c2)) {
                    boolean bl = this.ra_ == null;
                    int n = this.spacech_ = ((GeneralPath)this.getGlyphRec(c2)).getPathIterator(new AffineTransform()).isDone() ? 32 : 0;
                    if (bl) {
                        this.releaseRA();
                    }
                } else {
                    this.spacech_ = 65534;
                }
            }
        }
        return (char)this.spacech_;
    }

    private int readUint8() {
        int n = this.data_[this.offset_] & 0xFF;
        ++this.offset_;
        return n;
    }

    private int readInt8() {
        byte by = this.data_[this.offset_];
        ++this.offset_;
        return by;
    }

    private int readUint16() {
        int n = (this.data_[this.offset_] & 0xFF) << 8 | this.data_[this.offset_ + 1] & 0xFF;
        this.offset_ += 2;
        return n;
    }

    private int readInt16() {
        int n = this.data_[this.offset_] << 8 | this.data_[this.offset_ + 1] & 0xFF;
        this.offset_ += 2;
        return n;
    }

    private int readUint24() {
        int n = (this.data_[this.offset_] & 0xFF) << 16 | (this.data_[this.offset_ + 1] & 0xFF) << 8 | this.data_[this.offset_ + 2] & 0xFF;
        this.offset_ += 3;
        return n;
    }

    private int readInt24() {
        int n = this.data_[this.offset_] << 16 | (this.data_[this.offset_ + 1] & 0xFF) << 8 | this.data_[this.offset_ + 2] & 0xFF;
        this.offset_ += 3;
        return n;
    }

    private int readUint32() {
        int n = (this.data_[this.offset_] & 0xFF) << 24 | (this.data_[this.offset_ + 1] & 0xFF) << 16 | (this.data_[this.offset_ + 2] & 0xFF) << 8 | this.data_[this.offset_ + 3] & 0xFF;
        this.offset_ += 4;
        return n;
    }

    private String readString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        int n = this.readUint8();
        while (n != 0) {
            stringBuffer.append((char)n);
            n = this.readUint8();
        }
        System.out.println("str = " + stringBuffer);
        return stringBuffer.toString();
    }

    private void getRA() throws IOException {
        if (this.ra_ == null) {
            if (!$assertionsDisabled && this.getSource() == null) {
                throw new AssertionError();
            }
            this.ra_ = NFontPFR.getMultiplex().getRA(this, this.getSource());
        }
    }

    private void releaseRA() {
        if (this.ra_ != null && !(this.ra_ instanceof RandomAccessByteArray)) {
            NFontPFR.getMultiplex().releaseRA(this.ra_);
            this.ra_ = null;
        }
    }

    private byte[] readRaw(long l, int n) throws IOException {
        if (!$assertionsDisabled && this.ra_ == null) {
            throw new AssertionError();
        }
        if (n <= 0) {
            return TABLE_EMPTY;
        }
        byte[] byArray = new byte[n];
        this.ra_.seek(l);
        this.ra_.readFully(byArray);
        return byArray;
    }

    private Shape getGlyphRec(int n) {
        Shape shape;
        if (!this.canDisplayGID(n)) {
            if (this.notdef_ == null) {
                this.notdef_ = this.canDisplayGID(0) ? this.getGlyphRec(0) : GLYPH_ZERO_CONTOUR;
            }
            return this.notdef_;
        }
        SoftReference softReference = this.paths_[n];
        Shape shape2 = shape = softReference != null ? (Shape)softReference.get() : null;
        if (shape == null) {
            shape = this.buildChar(n);
            this.paths_[n] = new SoftReference<Shape>(shape);
        }
        return shape;
    }

    private GeneralPath buildChar(int n) {
        if (!this.canDisplayGID(n)) {
            return GLYPH_ZERO_CONTOUR;
        }
        return this.buildChar(this.goffset_[n], this.glength_[n]);
    }

    private GeneralPath buildChar(int n, int n2) {
        GeneralPath generalPath = GLYPH_ZERO_CONTOUR;
        if (this.ra_ == null) {
            try {
                this.getRA();
                this.data_ = this.readRaw(n, n2);
                this.offset_ = 0;
                generalPath = (this.data_[0] & 0x80) == 0 ? this.buildSimple() : this.buildComposite();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return generalPath;
    }

    private GeneralPath buildSimple() {
        int n;
        int n2;
        int n3;
        int n4 = this.readUint8();
        boolean bl = (n4 & 8) != 0;
        boolean bl2 = (n4 & 4) != 0;
        boolean bl3 = (n4 & 2) != 0;
        boolean bl4 = (n4 & 1) != 0;
        int n5 = 0;
        int n6 = 0;
        if (bl2) {
            n4 = this.readUint8();
            n5 = n4 >> 4;
            n6 = n4 & 0xF;
        } else {
            if (bl4) {
                n6 = this.readUint8();
            }
            if (bl3) {
                n5 = this.readUint8();
            }
        }
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n5];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n6; ++n3) {
            if (n7 != 0) {
                n8 >>= 1;
            } else {
                n8 = this.readUint8();
                n7 = 8;
            }
            n9 = nArray[n3] = (n2 = (n8 & 1) != 0 ? this.readInt16() : n9 + this.readUint8());
        }
        n9 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (n7 != 0) {
                n8 >>= 1;
            } else {
                n8 = this.readUint8();
                n7 = 8;
            }
            n9 = nArray2[n3] = (n2 = (n8 & 1) != 0 ? this.readInt16() : n9 + this.readUint8());
        }
        if (bl) {
            n9 = this.readUint8();
            for (n3 = 0; n3 < n9; ++n3) {
                n2 = this.readUint8();
                n = this.readUint8();
                switch (n) {
                    default: 
                }
                this.offset_ += n2;
            }
        }
        GeneralPath generalPath = new GeneralPath();
        n9 = 0;
        n2 = 0;
        boolean bl5 = false;
        block14: while (!bl5) {
            int n10;
            int n11;
            int n12;
            n4 = this.readUint8();
            switch (n4 >> 4) {
                case 0: {
                    if (!$assertionsDisabled && n4 != 0) {
                        throw new AssertionError(n4);
                    }
                    generalPath.closePath();
                    bl5 = true;
                    continue block14;
                }
                case 1: {
                    n9 = this.coordArg(n4, n9, nArray);
                    n2 = this.coordArg(n4 >> 2, n2, nArray2);
                    generalPath.lineTo(n9, n2);
                    continue block14;
                }
                case 2: {
                    generalPath.lineTo(n9 += nArray[n4 & 0xF], n2);
                    continue block14;
                }
                case 3: {
                    generalPath.lineTo(n9, n2 += nArray2[n4 & 0xF]);
                    continue block14;
                }
                case 4: 
                case 5: {
                    n9 = this.coordArg(n4, n9, nArray);
                    n2 = this.coordArg(n4 >> 2, n2, nArray2);
                    generalPath.moveTo(n9, n2);
                    continue block14;
                }
                case 6: {
                    n = n9 + this.readInt8();
                    n12 = n2;
                    System.out.println("hvCurveTo inx = " + this.data_[this.offset_]);
                    n11 = nArray[this.readUint8() >> 4];
                    n10 = n2 + this.readInt8();
                    n9 = n11;
                    n2 = n10 + this.readInt8();
                    generalPath.curveTo(n, n12, n11, n10, n9, n2);
                    continue block14;
                }
                case 7: {
                    n = n9;
                    n12 = n2 + this.readInt8();
                    n11 = n + this.readInt8();
                    n10 = nArray2[this.readUint8() >> 4];
                    n9 = n11 + this.readInt8();
                    n2 = n10;
                    generalPath.curveTo(n, n12, n11, n10, n9, n2);
                    continue block14;
                }
            }
            n = this.coordArg(n4, n9, nArray);
            n12 = this.coordArg(n4 >> 2, n2, nArray2);
            n4 = this.readUint8();
            n11 = this.coordArg(n4, n, nArray);
            n10 = this.coordArg(n4 >> 2, n12, nArray2);
            n9 = this.coordArg(n4 >> 4, n11, nArray);
            n2 = this.coordArg(n4 >> 6, n10, nArray2);
            generalPath.curveTo(n, n12, n11, n10, n9, n2);
        }
        return generalPath;
    }

    private int coordArg(int n, int n2, int[] nArray) {
        int n3;
        switch (n & 3) {
            case 0: {
                n3 = nArray[this.readUint8()];
                break;
            }
            case 1: {
                n3 = this.readInt16();
                break;
            }
            case 2: {
                n3 = n2 + this.readInt8();
                break;
            }
            default: {
                n3 = n2;
                if (!$assertionsDisabled) {
                    throw new AssertionError(n);
                }
                break;
            }
        }
        return n3;
    }

    private GeneralPath buildComposite() {
        GeneralPath generalPath = new GeneralPath();
        int n = this.readUint8();
        boolean bl = (n & 0x40) != 0;
        int n2 = n & 0x3F;
        if (bl) {
            int n3;
            int n4;
            int n5;
            int n6 = this.readUint8();
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = this.readUint8();
                n3 = this.readUint8();
                switch (n3) {
                    default: 
                }
                this.offset_ += n4;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                n = this.readUint8();
                n6 = (n & 0x80) != 0 ? 1 : 0;
                n4 = (n & 0x40) != 0 ? 1 : 0;
                n3 = (n & 0x20) != 0 ? 1 : 0;
                boolean bl2 = (n & 0x10) != 0;
                int n7 = n >> 2 & 3;
                int n8 = n & 3;
                int n9 = bl2 ? this.readInt16() : 4096;
                int n10 = n3 != 0 ? this.readInt16() : 4096;
                int n11 = 0;
                int n12 = 0;
                switch (n8) {
                    case 1: {
                        n11 = this.readInt16();
                        break;
                    }
                    case 2: {
                        n11 = this.readInt8();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(n11);
                        }
                        break;
                    }
                }
                switch (n7) {
                    case 1: {
                        n12 = this.readInt16();
                        break;
                    }
                    case 2: {
                        n12 = this.readInt8();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(n12);
                        }
                        break;
                    }
                }
                int n13 = n4 != 0 ? this.readUint16() : this.readUint8();
                int n14 = n6 != 0 ? this.readUint24() : this.readUint16();
                GeneralPath generalPath2 = this.buildChar(n14, n13);
                AffineTransform affineTransform = new AffineTransform((double)n9 / 4096.0, 0.0, 0.0, (double)n10 / 4096.0, (double)n11, (double)n12);
                PathIterator pathIterator = generalPath2.getPathIterator(affineTransform.isIdentity() ? null : affineTransform);
                generalPath.append(pathIterator, false);
            }
        }
        return generalPath;
    }

    public Point2D echarAdvance(int n) {
        char c = this.c2g_.toSelector(n);
        double d = !this.canDisplayGID(c) ? 0.0 : (this.newwidths_ != null && n >= this.firstch_ && n <= this.lastch_ && this.newwidths_[n - this.firstch_] > 1 ? (double)this.newwidths_[n - this.firstch_] * 0.001 : (double)this.widths_[Math.min(c, this.widths_.length - 1)] * this.m_.getScaleX());
        double d2 = d * (double)this.size_ * this.at_.getScaleX();
        double d3 = d * (double)this.size_ * this.at_.getShearY();
        return new Point2D.Double(d2, d3);
    }

    public Rectangle2D getEstringBounds(String string, int n, int n2) {
        Cloneable cloneable;
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c >= this.getMaxGlyphNum()) continue;
            cloneable = this.getGlyphRec(c).getBounds2D();
            ((Rectangle2D)cloneable).setRect(d + ((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight());
            rectangle2D = rectangle2D.createUnion((Rectangle2D)cloneable);
            d += (double)this.widths_[Math.min(c, this.widths_.length - 1)];
        }
        this.releaseRA();
        AffineTransform affineTransform = new AffineTransform(this.m_);
        affineTransform.concatenate(this.at_);
        affineTransform.scale(this.size_, -this.size_);
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        cloneable = new Point2D.Double(rectangle2D.getWidth(), rectangle2D.getHeight());
        affineTransform.transform(double_, double_);
        affineTransform.transform((Point2D)cloneable, (Point2D)cloneable);
        rectangle2D.setRect(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)cloneable).getX(), ((Point2D)cloneable).getY());
        return rectangle2D;
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f, float f2, long l, int n, Color color) {
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "~/data/font/pfr/AmeriGarmnd.pfr";
        NFontPFR nFontPFR = new NFontPFR(Files.getFile(string).toURL());
        nFontPFR.buildChar(1);
        System.exit(0);
    }

    static {
        $assertionsDisabled = !NFontPFR.class.desiredAssertionStatus();
        GLYPH_ZERO_CONTOUR = new GeneralPath(1, 1);
        TABLE_EMPTY = new byte[0];
    }

    class PhysRec {
        AffineTransform atmg;
        AffineTransform atmw;
        int[] width;
        int[] goffset;
        int[] glength;
        Rectangle2D bbox;
        CMap c2g;
        String ID;
        SoftReference[] paths;

        PhysRec(int n, int n2, int[] nArray, char[] cArray, int[] nArray2, int[] nArray3, Rectangle2D rectangle2D, String string) {
            this.width = nArray;
            this.goffset = nArray2;
            this.glength = nArray3;
            this.bbox = rectangle2D;
            this.ID = string;
            this.atmg = AffineTransform.getScaleInstance(1.0f / (float)n, 1.0 / (double)n);
            this.atmw = AffineTransform.getScaleInstance(1.0 / (double)n2, 1.0 / (double)n);
            this.c2g = new CMap(cArray).reverse();
            this.paths = new SoftReference[nArray.length];
        }
    }

    class LogRec {
        AffineTransform atm;
        boolean bold;
        boolean stroke;
        int thickness;
        int linejoin;
        float miterlimit;
        int physical;

        LogRec(AffineTransform affineTransform, boolean bl, boolean bl2, int n, int n2, float f, int n3) {
            this.atm = affineTransform;
            this.bold = bl;
            this.stroke = bl2;
            this.thickness = n;
            this.linejoin = n2;
            this.miterlimit = f;
            this.physical = n3;
            System.out.println(this.atm + " " + this.bold + "/" + this.stroke + " " + n + " " + this.linejoin + " " + this.miterlimit + " " + this.physical);
        }
    }
}

