/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.Cache;
import com.pt.io.InputStreamTee;
import com.pt.io.InputUni;
import com.pt.io.InputUniFile;
import com.pt.io.InputUniInputStream;
import com.pt.io.InputUniString;
import com.pt.io.ObserverIO;
import com.pt.io.RandomAccess;
import com.pt.net.HTTP;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.ParseException;
import phelps.net.URIs;
import phelps.net.URLs;

public class InputUniURI
extends InputUni
implements ObserverIO {
    public static final String ATTR_POST_DATA = "post-data";
    private static final int REDIRECT_MAX = 10;
    private static final String[] HEADERS_REQUEST;
    private static final String[] HEADERS_OVERRIDE;
    private static final String[] HEADERS_HOP;
    private URI uri_;
    private String method_;
    private long length_ = -1L;
    private long lastmod_ = -1L;
    private InputUni local_ = null;
    private int returncode_ = -1;
    private int redirectcnt_ = 0;
    private boolean fslow_ = false;
    private BufferedWriter head_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InputUniURI(URI uRI) {
        this(uRI, Cache.NONE, null);
    }

    public InputUniURI(URI uRI, Cache cache) {
        this(uRI, cache, null);
    }

    public InputUniURI(URI uRI, Cache cache, String string) {
        super(uRI.isOpaque() ? uRI : null, cache);
        if (!$assertionsDisabled && (uRI == null || "file".equals(uRI.getScheme()))) {
            throw new AssertionError(uRI);
        }
        this.logical_ = URIs.canonicalize(uRI);
        this.uri_ = uRI;
        this.method_ = string != null ? string.toUpperCase() : "GET";
    }

    public InputUniURI(URL uRL, Cache cache, String string) throws URISyntaxException {
        this(URLs.toURI(uRL), cache, string);
    }

    public Object getSource() {
        return this.uri_;
    }

    public URI getURI() {
        try {
            this.getLocal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.getURI();
    }

    public long length() {
        try {
            this.getLocal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.length_;
    }

    public long lastModified() {
        try {
            this.getLocal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.lastmod_;
    }

    public int getReturnCode() {
        try {
            this.getLocal();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.returncode_;
    }

    public String getAttr(String string) {
        return this.local_ != null ? this.local_.getAttr(string) : super.getAttr(string);
    }

    public void putAttr(String string, String string2) {
        if (this.local_ != null) {
            this.local_.putAttr(string, string2);
        } else {
            super.putAttr(string, string2);
        }
    }

    public InputStream getInputStreamRaw() throws IOException {
        return this.getLocal().getInputStreamRaw();
    }

    public RandomAccess getRandomAccessRaw() throws IOException {
        InputUni inputUni;
        RandomAccess randomAccess = this.getLocal().getRandomAccessRaw();
        if (this.fslow_ && randomAccess.length() > 51200L && (inputUni = this.getCache().getInputUni(this.getURI(), null, "general")) != null) {
            randomAccess.close();
            randomAccess = inputUni.getRandomAccess();
        }
        return randomAccess;
    }

    private InputUni getLocal() throws IOException {
        Object object;
        int n;
        String string;
        Object object2;
        Object object3;
        if (this.local_ != null) {
            return this.local_;
        }
        this.local_ = DEVNULL;
        URI uRI = this.getURI();
        Cache cache = this.getCache();
        String string2 = uRI.getHost();
        if (string2 != null) {
            if (uRI.getPort() != -1) {
                string2 = string2 + ":" + uRI.getPort();
            }
            super.putAttr("Host", string2);
        }
        this.returncode_ = -1;
        this.length_ = -1L;
        this.lastmod_ = -1L;
        InputUni inputUni = cache.getInputUni(uRI, null, "general");
        LOGGER.finest(uRI + ", cache=" + inputUni);
        if (inputUni != null && (object3 = cache.getInputUni(uRI, "headers.txt", "general")) != null) {
            object2 = new BufferedReader(((InputUni)object3).getReader());
            string = ((BufferedReader)object2).readLine();
            if (string != null) {
                try {
                    this.returncode_ = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            while ((string = ((BufferedReader)object2).readLine()) != null) {
                n = string.indexOf(58);
                if (n == -1) continue;
                inputUni.putAttr(string.substring(0, n), string.substring(n + 1 + 1));
            }
            ((BufferedReader)object2).close();
            object = HEADERS_OVERRIDE;
            int n2 = ((String[])object).length;
            for (int i = 0; i < n2; ++i) {
                String string3 = object[i];
                string2 = super.getAttr(string3);
                if (string2 == null) continue;
                inputUni.putAttr(string3, string2);
            }
        }
        object3 = uRI.getScheme();
        if (uRI.isOpaque()) {
            inputUni = DEVNULL;
        } else if ("jar".equals(object3) || "jar:file".equals(object3) || "systemresource".equals(object3)) {
            string = "";
            if ("jar".equals(object3) || "jar:file".equals(object3)) {
                object2 = uRI.getPath();
            } else {
                if (!$assertionsDisabled && !"systemresource".equals(object3)) {
                    throw new AssertionError();
                }
                try {
                    object2 = URLs.toURI(this.getClass().getResource(uRI.getPath())).getPath();
                }
                catch (URISyntaxException uRISyntaxException) {
                    object2 = null;
                }
            }
            n = ((String)object2).indexOf(33);
            if (n == -1) {
                inputUni = new InputUniFile((String)object2);
            } else {
                string = ((String)object2).substring(n + 1);
                object2 = ((String)object2).substring(0, n);
                if (inputUni != null && new File((String)object2).lastModified() > inputUni.lastModified()) {
                    inputUni.close();
                    inputUni = null;
                    cache.delete(uRI, null, "general");
                }
            }
            if (inputUni != null) {
                this.length_ = inputUni.length();
                this.lastmod_ = inputUni.lastModified();
                this.returncode_ = 200;
            } else {
                if (new File(string).canRead()) {
                    // empty if block
                }
                object = new URL("jar:file:" + (String)object2 + "!" + string).openStream();
                if (!$assertionsDisabled && object == null) {
                    throw new AssertionError(uRI);
                }
                if (object != null) {
                    inputUni = new InputUniInputStream((InputStream)object, uRI, cache);
                    this.returncode_ = 200;
                } else {
                    inputUni = new InputUniString("File Not Found " + uRI, "text/plain", uRI, null);
                    this.returncode_ = 404;
                }
            }
        } else if ("http".equals(object3) || "https".equals(object3) || "ftp".equals(object3)) {
            object2 = cache.getPolicy();
            boolean bl = true;
            long l = System.currentTimeMillis();
            if (inputUni == null) {
                if (Cache.POLICY_OFFLINE == object2) {
                    this.returncode_ = 404;
                    inputUni = new InputUniString("<p>Offline and not in cache.", "text/html", uRI, null);
                }
            } else if (Cache.POLICY_OFFLINE != object2) {
                if (Cache.POLICY_CHECK_ALWAYS == object2 || Cache.POLICY_CHECK_ONCE == object2 && !cache.isSeen(uRI) || Cache.POLICY_IF_OLD == object2 && inputUni.lastModified() + 1209600L < l && !cache.isSeen(uRI)) {
                    bl = false;
                } else if (!"GET".equals(this.method_)) {
                    bl = false;
                } else if (this.length() == -1L || inputUni.length() < this.length()) {
                    bl = false;
                } else if (!"ftp".equals(object3)) {
                    String string4;
                    int n3;
                    if (!$assertionsDisabled && !((String)object3).startsWith("http")) {
                        throw new AssertionError();
                    }
                    string2 = inputUni.getAttr("Vary");
                    if (string2 != null) {
                        String[] stringArray = string2.split("\\s+");
                        int n4 = stringArray.length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            String string5;
                            string4 = stringArray[n3];
                            String string6 = super.getAttr(string4);
                            if (string6 == (string5 = inputUni.getAttr(string4)) || string6 != null && string6.equals(string5)) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (bl) {
                        string2 = inputUni.getAttr("Cache-Control");
                        if (string2 != null) {
                            String[] stringArray = string2.split("\\s*,\\s*");
                            int n5 = stringArray.length;
                            for (n3 = 0; n3 < n5; ++n3) {
                                string4 = stringArray[n3];
                                System.out.println("cache-control: |" + string4 + "|");
                                if ("public".equals(string2) || string2.startsWith("private")) continue;
                                if (string2.startsWith("no-cache")) {
                                    bl = false;
                                    continue;
                                }
                                if ("no-store".equals(string2) || "no-transform".equals(string2)) continue;
                                if ("must-revalidate".equals(string2)) {
                                    bl = false;
                                    continue;
                                }
                                if ("proxy-revalidate".equals(string2)) continue;
                                if ("max-age".equals(string2)) {
                                    if (!$assertionsDisabled && this.lastmod_ <= 0L) {
                                        throw new AssertionError();
                                    }
                                    n = string2.indexOf(61);
                                    if (n == -1) continue;
                                    try {
                                        bl = this.lastmod_ + 1000L * Long.parseLong(string2.substring(n + 1).trim()) > l;
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                    continue;
                                }
                                if (!"s-maxage".equals(string2) || (n = string2.indexOf(61)) == -1) continue;
                                try {
                                    bl = this.lastmod_ + 1000L * Long.parseLong(string2.substring(n + 1).trim()) > l;
                                    continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        } else {
                            string2 = inputUni.getAttr("Expires");
                            if (string2 != null) {
                                try {
                                    bl = l < HTTP.parseDate(string2);
                                }
                                catch (ParseException parseException) {
                                    bl = false;
                                }
                            }
                        }
                    }
                }
            }
            LOGGER.finest("checking cache, " + (inputUni != null ? "FOUND " + (bl ? "and VALID" : "but expired") : "not found") + ", seen? " + cache.isSeen(uRI));
            if (inputUni == null || !bl) {
                inputUni = this.readNetwork(uRI, inputUni);
            }
        } else {
            inputUni = new InputUniInputStream(URIs.toURL(uRI).openStream(), uRI, cache);
            LOGGER.finer("unknown protocol: " + this.getURI());
        }
        if (!$assertionsDisabled && inputUni == null) {
            throw new AssertionError(uRI);
        }
        cache.setSeen(uRI);
        LOGGER.finer("return code = " + this.returncode_);
        switch (this.returncode_) {
            case 303: {
                this.method_ = "GET";
            }
            case 301: 
            case 302: 
            case 307: {
                object2 = inputUni.getAttr("Location");
                inputUni.close();
                ++this.redirectcnt_;
                if (this.redirectcnt_ > 10) {
                    throw new IOException("Too many redirects");
                }
                if (object2 == null) {
                    throw new IOException("Redirect but no Location field");
                }
                LOGGER.finest("redirecting (" + this.returncode_ + ") to " + (String)object2);
                this.logical_ = uRI.resolve((String)object2);
                this.local_ = null;
                super.putAttr("Referer", uRI.toString());
                return this.getLocal();
            }
        }
        LOGGER.finest(" => " + inputUni);
        if ("ftp".equals(uRI.getScheme()) && inputUni.getAttr("Content-Type") == null && uRI.getPath().endsWith("/")) {
            inputUni.putAttr("Content-Type", "DirectoryFTP");
        }
        this.local_ = inputUni;
        if (!$assertionsDisabled && inputUni == null) {
            throw new AssertionError(this.getURI());
        }
        if (this.length_ == -1L) {
            this.length_ = super.length();
        }
        if (this.lastmod_ == -1L) {
            this.lastmod_ = super.lastModified();
        }
        if (this.lastmod_ == -1L) {
            this.lastmod_ = inputUni.lastModified();
        }
        if (this.lastmod_ == -1L) {
            this.lastmod_ = System.currentTimeMillis();
        }
        return inputUni;
    }

    private InputUni readNetwork(URI uRI, InputUni inputUni) throws IOException {
        int n;
        Object object;
        String string;
        Object object2;
        LOGGER.finer("openConnection() " + uRI);
        URLConnection uRLConnection = URIs.toURL(uRI).openConnection();
        if (!$assertionsDisabled && uRLConnection == null) {
            throw new AssertionError(uRI);
        }
        uRLConnection.setUseCaches(false);
        uRLConnection.setDoInput(true);
        uRLConnection.setAllowUserInteraction(false);
        Cache cache = this.getCache();
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod(this.method_);
            if ("POST".equals(this.method_) && (object2 = super.getAttr(ATTR_POST_DATA)) instanceof String) {
                LOGGER.finest("POST, " + ((String)object2).length() + " bytes of data");
                uRLConnection.setDoOutput(true);
                uRLConnection.setRequestProperty("Content-Length", Integer.toString(((String)object2).length()));
            }
            if (inputUni != null) {
                string = inputUni.getAttr("ETag");
                if (string != null) {
                    uRLConnection.setRequestProperty("If-None-Match", string);
                } else {
                    string = inputUni.getAttr("Last-Modified");
                    if (string != null) {
                        uRLConnection.setRequestProperty("If-Modified-Since", string);
                    }
                }
            }
            if (inputUni != null) {
                System.out.println("etag = " + inputUni.getAttr("ETag") + ", lastmod = " + inputUni.getAttr("Last-Modified"));
            }
            object2 = HEADERS_REQUEST;
            int n2 = ((String[])object2).length;
            for (int i = 0; i < n2; ++i) {
                object = object2[i];
                string = super.getAttr((String)object);
                if (string == null) continue;
                uRLConnection.setRequestProperty((String)object, string);
            }
        }
        LOGGER.finest("trying to connect");
        try {
            uRLConnection.connect();
        }
        catch (UnknownHostException unknownHostException) {
            this.returncode_ = 404;
            return new InputUniString("Unknown host: " + unknownHostException.toString());
        }
        catch (IOException iOException) {
            this.returncode_ = 401;
            return new InputUniString("Unauthorized: " + iOException.toString());
        }
        LOGGER.finer("connected, class=" + uRLConnection.getClass().getName());
        if (uRLConnection instanceof HttpURLConnection) {
            LOGGER.finest("HTTP connection, getting response");
            if ("POST".equals(this.method_)) {
                object2 = new DataOutputStream(new BufferedOutputStream(uRLConnection.getOutputStream()));
                ((DataOutputStream)object2).writeBytes(super.getAttr(ATTR_POST_DATA));
                ((FilterOutputStream)object2).close();
            }
            object2 = (HttpURLConnection)uRLConnection;
            try {
                n = ((HttpURLConnection)object2).getResponseCode();
            }
            catch (IOException iOException) {
                n = 404;
                System.err.println("i/o: " + iOException);
            }
            LOGGER.finest("HTTP connection, code=" + n + " vs " + uRLConnection.getHeaderFieldKey(0) + ", method=" + this.method_);
        } else {
            if (!$assertionsDisabled && !(uRLConnection instanceof URLConnection)) {
                throw new AssertionError(uRLConnection);
            }
            LOGGER.finest("FTP connection type? " + uRLConnection);
            n = 200;
        }
        this.returncode_ = n;
        if (n == -1) {
            return new InputUniString("Unknown connection type");
        }
        boolean bl = false;
        switch (n) {
            case 304: {
                uRLConnection.getInputStream().close();
                object2 = inputUni;
                break;
            }
            default: {
                String string2;
                String string3;
                if ("HEAD" == this.method_ || 100 <= n && n <= 199 || 204 == n || 205 == n) {
                    object2 = new InputUniString("no body");
                    this.update(null, "close");
                } else {
                    try {
                        LOGGER.finest("con.getInputStream()");
                        InputStream inputStream = uRLConnection.getInputStream();
                        object = cache.getOutputStream(uRI, null, "general");
                        if (object != null) {
                            InputStreamTee inputStreamTee = new InputStreamTee(inputStream, this.length_, "MD5", (OutputStream)object);
                            inputStreamTee.addObserver(this);
                            inputStream = inputStreamTee;
                        }
                        object2 = new InputUniInputStream(inputStream, uRI, cache);
                        this.fslow_ = true;
                    }
                    catch (IOException iOException) {
                        this.update(null, "close");
                        object2 = new InputUniString("<p><h1>" + n + "</h1>\n<p>Could not connect to " + uRI + ": " + iOException.toString(), "text/html");
                    }
                }
                OutputStream outputStream = cache.getOutputStream(uRI, "headers.txt", "general");
                this.head_ = outputStream != null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : null;
                object = this.head_;
                if (object != null) {
                    ((Writer)object).write(Integer.toString(n));
                    ((BufferedWriter)object).newLine();
                }
                int n3 = 1;
                while ((string3 = uRLConnection.getHeaderFieldKey(n3)) != null && (string2 = uRLConnection.getHeaderField(n3)) != null && !string3.startsWith("<")) {
                    LOGGER.finest("<- |" + string3 + "| = |" + string2 + "|");
                    if (!"set-cookie".equalsIgnoreCase(string3)) {
                        ((InputUni)object2).putAttr(string3, string2);
                        if (object != null) {
                            this.writeHeader((BufferedWriter)object, string3, string2);
                        }
                    }
                    ++n3;
                }
                if (object != null) {
                    ((BufferedWriter)object).newLine();
                }
                String[] stringArray = HEADERS_OVERRIDE;
                int n4 = stringArray.length;
                for (int i = 0; i < n4; ++i) {
                    String string4 = stringArray[i];
                    string = super.getAttr(string4);
                    if (string == null) continue;
                    ((InputUni)object2).putAttr(string4, string);
                }
            }
        }
        return object2;
    }

    public void update(Object object, Object object2) {
        InputStreamTee inputStreamTee = (InputStreamTee)object;
        boolean bl = false;
        if (this.head_ != null) {
            if (object == null) {
                bl = true;
            } else if ("close" == object2) {
                Object object3;
                if (!$assertionsDisabled && this.local_ == null) {
                    throw new AssertionError();
                }
                if (this.getAttr("Content-Length") == null || this.length_ != inputStreamTee.getCount()) {
                    if (this.length_ != -1L) {
                        System.out.println("*** Tee " + this.getURI() + ": " + this.getAttr("Content-Length") + "/" + this.length_ + " => " + inputStreamTee.getCount());
                    }
                    this.length_ = inputStreamTee.getCount();
                    object3 = Long.toString(this.length_);
                    this.putAttr("Content-Length", (String)object3);
                    this.writeHeader(this.head_, "Content-Length", (String)object3);
                }
                if ((object3 = inputStreamTee.getDigest()) != null && ((byte[])object3).length >= 16) {
                    System.out.print("MD5: " + this.getAttr("Content-MD5") + " vs ");
                    int n = ((byte[])object3).length;
                    for (int i = 0; i < n; ++i) {
                        System.out.print(Integer.toHexString(object3[i] & 0xFF));
                    }
                    System.out.println();
                }
                bl = true;
            } else if ("cancel" == object2) {
                try {
                    this.head_.write("cancelled");
                    this.head_.newLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            try {
                this.head_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.head_ = null;
        }
    }

    private void writeHeader(BufferedWriter bufferedWriter, String string, String string2) {
        try {
            bufferedWriter.write(string);
            bufferedWriter.write(": ");
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        if (this.local_ != null) {
            this.local_.close();
            this.local_ = null;
        }
        super.close();
    }

    static {
        $assertionsDisabled = !InputUniURI.class.desiredAssertionStatus();
        HEADERS_REQUEST = new String[]{"Accept", "Accept-Language", "Accept-Charset", "Accept-Encoding", "Keep-Alive", "Connection", "User-Agent", "Referer", "If-Modified-Since", "If-Unmodified-Since", "If-Match", "If-None-Match", "If-Range", "Proxy-Authorization", "Host"};
        HEADERS_OVERRIDE = new String[]{"Cache-Control", "Expires"};
        HEADERS_HOP = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"};
        HttpURLConnection.setFollowRedirects(false);
    }
}

