/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley;

import multivalent.Behavior;
import multivalent.Document;
import multivalent.INode;
import multivalent.SemanticEvent;
import multivalent.gui.VCheckbox;
import phelps.lang.Booleans;
import phelps.net.RobustHyperlink;

public class RobustUI
extends Behavior {
    static boolean verbose_ = true;
    public static final String MSG_DUMP = "robustSignatureDump";
    public static final String MSG_SET_ACTIVE = "robustSignatureSetActive";

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            this.createUI("button", "Dump Robust Signature", "event robustSignatureDump", iNode, "View", false);
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Verbose Robust Information", "event robustSignatureSetActive", iNode, "View", false);
            vCheckbox.setState(verbose_);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_SET_ACTIVE == string) {
            verbose_ = Booleans.parseBoolean(semanticEvent.getArg(), !verbose_);
        } else if (MSG_DUMP == string) {
            Document document = this.getBrowser().getCurDocument();
            RobustHyperlink.Verbose = verbose_;
            String string2 = RobustHyperlink.computeSignature(document);
            System.out.println("Signature for " + document.getURI() + "\n\t" + string2);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

