/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.Color;
import java.awt.Graphics2D;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Context;
import multivalent.Document;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VScrollbar;

public class BrowseScrollViz
extends Behavior {
    static final int MAXHISTORY = 5;
    static final int CLOSE = 50;
    Map<URI, int[]> doc2y_ = new HashMap<URI, int[]>(20);

    int[] getYs(URI uRI) {
        int[] nArray = this.doc2y_.get(uRI);
        if (nArray == null) {
            nArray = new int[5];
            this.doc2y_.put(uRI, nArray);
        }
        return nArray;
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("formattedDocument" == string && object instanceof Document) {
            ((Document)object).getVsb().addObserver(this);
        } else if ("closeDocument" == string && object instanceof Document) {
            Document document = (Document)object;
            VScrollbar vScrollbar = document.getVsb();
            vScrollbar.deleteObserver(this);
            int n = vScrollbar.getValue();
            if (n > vScrollbar.getMin()) {
                int[] nArray = this.getYs(document.getURI());
                boolean bl = false;
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (Math.abs(nArray[i] - n) >= 50) continue;
                    nArray[i] = n;
                    bl = true;
                    break;
                }
                if (!bl) {
                    System.arraycopy(nArray, 0, nArray, 1, nArray.length - 1);
                    nArray[0] = n;
                }
            }
        }
        return false;
    }

    public boolean paintAfter(Context context, Node node) {
        int n;
        Document document = node.getDocument();
        VScrollbar vScrollbar = (VScrollbar)node;
        int[] nArray = this.getYs(document.getURI());
        int n2 = vScrollbar.getMax() - vScrollbar.getMin();
        int n3 = vScrollbar.bbox.height;
        int n4 = vScrollbar.bbox.width;
        int n5 = vScrollbar.getMin();
        int n6 = vScrollbar.getMax();
        Graphics2D graphics2D = context.g;
        graphics2D.setColor(Color.BLACK);
        int n7 = nArray.length;
        for (int i = 0; i < n7 && (n = nArray[i]) > n5; ++i) {
            if (n > n6) continue;
            graphics2D.drawRect(0, n * n3 / n2, n4, 1);
        }
        return false;
    }
}

