/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor;

import com.pt.io.Cache;
import com.pt.io.InputUni;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.SemanticEvent;

public class PersonalAnnos
extends Behavior {
    static final boolean DEBUG = false;
    static final String PREFIX = "annos/";
    static final String FILENAME = "annos.hub";

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("openedDocument" == string) {
            DocInfo docInfo = (DocInfo)semanticEvent.getArg();
            Document document = docInfo.doc;
            URI uRI = document.getURI();
            InputUni inputUni = this.getGlobal().getCache().getInputUni(uRI, FILENAME, "personal");
            if (inputUni != null) {
                browser.eventq(new SemanticEvent(browser, "loadLayer", inputUni.getURI(), null, document));
                try {
                    inputUni.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if ("closeDocument" == string) {
            Document document = (Document)semanticEvent.getArg();
            if (document == null) {
                document = browser.getCurDocument();
            }
            if (document.getAttr("loading") == null) {
                Cache cache = this.getGlobal().getCache();
                URI uRI = document.getURI();
                Layer layer = document.getLayer("personal");
                ESISNode eSISNode = layer.save();
                if (eSISNode != null) {
                    if (eSISNode.getAttr("uri") == null) {
                        eSISNode.putAttr("uri", uRI.toString());
                    }
                    try {
                        OutputStream outputStream = cache.getOutputStream(uRI, FILENAME, "personal");
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                        String string2 = eSISNode.writeXML();
                        bufferedWriter.write(string2);
                        ((Writer)bufferedWriter).close();
                    }
                    catch (IOException iOException) {
                        System.err.println("couldn't write hub: " + iOException);
                    }
                } else {
                    cache.delete(uRI, FILENAME, "personal");
                }
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

