/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class DecodeRunLength
extends FilterInputStream {
    public static final int EOD = 128;
    private int litcnt_ = 0;
    private int dupcnt_ = 0;
    private int dupbyte_ = 0;
    private boolean eof_ = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DecodeRunLength(InputStream inputStream) {
        super(inputStream);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (this.eof_) {
            return -1;
        }
        n2 = Math.min(n2, byArray.length - n);
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            if (this.dupcnt_ > 0) {
                int n4 = Math.min(n3 - i, this.dupcnt_);
                Arrays.fill(byArray, i, i + n4, (byte)this.dupbyte_);
                this.dupcnt_ -= n4;
                i += n4 - 1;
                continue;
            }
            int n5 = this.read();
            if (n5 != -1) {
                byArray[i] = (byte)n5;
                continue;
            }
            return i - n;
        }
        return n2;
    }

    public int read() throws IOException {
        int n;
        if (this.litcnt_ > 0) {
            n = this.in.read();
            --this.litcnt_;
        } else if (this.dupcnt_ > 0) {
            n = this.dupbyte_;
            --this.dupcnt_;
        } else if (this.eof_) {
            n = -1;
        } else {
            n = this.in.read();
            if (n != -1) {
                if (n < 128) {
                    this.litcnt_ = 1 + n;
                    n = this.read();
                } else if (n > 128) {
                    this.dupcnt_ = 257 - n - 1;
                    n = this.dupbyte_ = this.in.read();
                } else {
                    this.eof_ = true;
                    n = -1;
                }
            }
        }
        return n;
    }

    public boolean markSupported() {
        return false;
    }

    static {
        $assertionsDisabled = !DecodeRunLength.class.desiredAssertionStatus();
    }
}

