/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.COSSource;
import multivalent.std.adaptor.pdf.Dict;

public abstract class SecurityHandler
implements Cloneable {
    private static final Class[] SH_SIG;
    private static Map<String, String> handlers_;
    public static final SecurityHandler IDENTITY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void register(String string, String string2) {
        if (!($assertionsDisabled || string != null && string2 != null)) {
            throw new AssertionError();
        }
        handlers_.put(string, string2);
    }

    public static SecurityHandler getInstance(String string, Dict dict, COSSource cOSSource) {
        if ("Identity".equals(string) || null == string) {
            return IDENTITY;
        }
        SecurityHandler securityHandler = null;
        String string2 = handlers_.get(string);
        Exception exception = null;
        String string3 = null;
        if (string2 == null) {
            string3 = "Unregistered filter";
            exception = new UnsupportedOperationException();
        } else {
            try {
                Class<?> clazz = Class.forName(string2);
                Constructor<?> constructor = clazz.getConstructor(SH_SIG);
                securityHandler = (SecurityHandler)constructor.newInstance(dict, cOSSource);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string3 = "class " + string2 + " not found -- is it in CLASSPATH?";
                exception = classNotFoundException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                string3 = "need constructor " + string2 + "(Dict, COSSouce)";
                exception = noSuchMethodException;
            }
            catch (IllegalAccessException illegalAccessException) {
                string3 = string2 + " must be public";
                exception = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                string3 = string2 + " must be public and non-abstract";
                exception = instantiationException;
            }
            catch (InvocationTargetException invocationTargetException) {
                string3 = "error in " + string2 + "'s constructor";
                exception = invocationTargetException;
            }
        }
        if (string3 != null) {
            System.err.println("couldn't make security handler " + string + ": " + string3);
        }
        boolean bl = securityHandler.authOwner("") || securityHandler.authUser("");
        return securityHandler;
    }

    public SecurityHandler(Dict dict, COSSource cOSSource) {
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public abstract boolean authUser(String var1);

    public abstract boolean authOwner(String var1);

    public abstract boolean isAuthorized();

    public abstract byte[] computeKey(String var1);

    public abstract byte[] getKey();

    public abstract byte[] decrypt(byte[] var1, int var2, int var3);

    public abstract byte[] encrypt(byte[] var1, int var2, int var3);

    public abstract SecurityHandler reset(int var1, int var2);

    static {
        $assertionsDisabled = !SecurityHandler.class.desiredAssertionStatus();
        SH_SIG = new Class[]{COS.CLASS_DICTIONARY, COSSource.class};
        handlers_ = new HashMap<String, String>(7);
        SecurityHandler.register("Standard", "multivalent.std.adaptor.pdf.SecurityHandlerStandard");
        IDENTITY = new SecurityHandler(null, null){

            public boolean authUser(String string) {
                return true;
            }

            public boolean authOwner(String string) {
                return true;
            }

            public boolean isAuthorized() {
                return true;
            }

            public byte[] computeKey(String string) {
                return null;
            }

            public byte[] getKey() {
                return null;
            }

            public byte[] decrypt(byte[] byArray, int n, int n2) {
                return byArray;
            }

            public byte[] encrypt(byte[] byArray, int n, int n2) {
                return byArray;
            }

            public SecurityHandler reset(int n, int n2) {
                return this;
            }

            public String toString() {
                return "IDENTITY";
            }
        };
    }
}

