/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.IOException;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Function;
import multivalent.std.adaptor.pdf.PDFReader;

class Stitching
extends Function {
    Function[] funs_;
    float[] bounds_;
    float[] encode_;
    int n_;
    static final /* synthetic */ boolean $assertionsDisabled;

    Stitching(Dict dict, PDFReader pDFReader) throws IOException {
        super(dict, pDFReader);
        Object[] objectArray = (Object[])pDFReader.getObject(dict.get("Functions"));
        this.funs_ = new Function[objectArray.length];
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.funs_[i] = Function.getInstance(objectArray[i], pDFReader);
        }
        this.n_ = this.funs_[0].getN();
        this.bounds_ = this.toFloatArray((Object[])pDFReader.getObject(dict.get("Bounds")), null);
        if (!$assertionsDisabled && this.bounds_.length != this.funs_.length - 1) {
            throw new AssertionError();
        }
        this.encode_ = this.toFloatArray((Object[])pDFReader.getObject(dict.get("Encode")), null);
        if (!$assertionsDisabled && this.encode_.length != this.funs_.length * 2) {
            throw new AssertionError();
        }
    }

    public int getN() {
        return this.n_;
    }

    public void compute(float[] fArray, float[] fArray2) {
        int n;
        this.clip(fArray, this.domain_);
        float f = fArray[0];
        for (n = this.bounds_.length - 1; n >= 0 && !(f >= this.bounds_[n]); --n) {
        }
        float[] fArray3 = new float[1];
        float f2 = ++n > 0 ? this.bounds_[n - 1] : this.domain_[0];
        float f3 = n < this.bounds_.length ? this.bounds_[n] : this.domain_[1];
        float f4 = this.encode_[n * 2];
        float f5 = this.encode_[n * 2 + 1];
        fArray3[0] = f4 + (f - f2) * (f5 - f4) / (f3 - f2);
        this.funs_[n].compute(fArray3, fArray2);
        if (this.range_ != null) {
            this.clip(fArray2, this.range_);
        }
    }

    static {
        $assertionsDisabled = !Stitching.class.desiredAssertionStatus();
    }
}

