/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import multivalent.Behavior;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.SemanticEvent;

public class Annos
extends Behavior {
    public static final String MSG_WIPEPAGE = "wipeAnnos";
    public static final String MSG_WIPEALL = "wipeAllAnnos";
    public static final String CATEGORY_ZAP = "zap";
    protected static final Color[] annoColors_ = new Color[]{new Color(0x800000), new Color(128), Color.RED, Color.BLUE, new Color(0x800080), new Color(32896), new Color(0xFF00FF), new Color(65535)};
    protected List<Color> availableColors_ = new ArrayList<Color>(annoColors_.length);

    public Color getAnnoColor(Color color) {
        int n = this.availableColors_.size();
        for (int i = 0; i < n; ++i) {
            if (!color.equals(this.availableColors_.get(i))) continue;
            this.availableColors_.remove(i);
            return color;
        }
        return null;
    }

    public Color getAnnoColor() {
        Color color = this.availableColors_.get(0);
        this.availableColors_.remove(0);
        return color;
    }

    public void restoreAnnoColor(Color color) {
        this.availableColors_.add(color);
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Anno" == string) {
            Document document = this.getBrowser().getCurDocument();
            Layer layer = document.getLayer("personal");
            INode iNode = (INode)semanticEvent.getOut();
            this.createUI("button", "Wipe Annos from Page", "event wipeAnnos", iNode, CATEGORY_ZAP, layer.size() == 0);
            String string2 = document.getAttr("page");
            if (string2 != null) {
                this.createUI("button", "Wipe Annos from All Pages", "event wipeAllAnnos", iNode, CATEGORY_ZAP, layer.size() == 0 && layer.auxSize() == 0);
            }
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_WIPEPAGE == string || MSG_WIPEALL == string) {
            Document document = this.getBrowser().getCurDocument();
            String string2 = document.getAttr("page");
            Layer layer = document.getLayer("personal");
            if (string2 == null) {
                layer.clear();
            } else if (MSG_WIPEALL == string) {
                layer.clear();
            } else {
                layer.clearBehaviors();
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

