/*
 * Decompiled with CFR 0.152.
 */
package tool.lucene;

import com.pt.io.FileList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import phelps.io.Files;
import tool.doc.ExtractText;
import tool.lucene.Search;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    public static final String VERSION = "1.0.1 of $Date: 2003/08/28 20:31:26 $";
    public static final String USAGE = "java tool.lucene.Index [<options>] <file/directory ...>\n\t[-new] [-refresh] [-exclude] [-optimize]\n\t[-index <directory>]";
    File index_;
    boolean fverbose_ = false;
    boolean fnew_ = false;
    boolean fmonitor_ = false;
    IndexWriter w_;
    Pattern ex_ = null;

    public Index(File file) {
        this.index_ = file;
    }

    public void close() throws IOException {
        if (this.w_ != null) {
            this.w_.close();
        }
    }

    public IndexWriter getIndexWriter() throws IOException {
        if (this.w_ == null) {
            this.w_ = new IndexWriter(this.index_, Search.ANALYZER, this.fnew_);
        }
        return this.w_;
    }

    boolean index1(File file) throws IOException {
        ExtractText extractText;
        if (file.isDirectory()) {
            return false;
        }
        String string = file.getCanonicalFile().toURI().toString();
        if (this.ex_ != null && this.ex_.matcher(string).find()) {
            if (this.fverbose_) {
                System.out.print(" -- excluded");
            }
            return false;
        }
        long l = file.lastModified();
        String string2 = null;
        try {
            extractText = new ExtractText();
            string2 = extractText.extract(file.toURI());
        }
        catch (Exception exception) {
            if (this.fverbose_) {
                System.err.print(new StringBuffer().append(string).append(" -- error extracting text: ").append(exception).toString());
            }
            return false;
        }
        if (string2 == null) {
            if (this.fverbose_) {
                System.out.print(" -- no text");
            }
            return false;
        }
        extractText = new Document();
        extractText.add(new Field("mod", DateField.timeToString((long)l), true, true, false));
        extractText.add(new Field("uri", string, true, true, false));
        extractText.add(new Field("body", string2, false, true, true));
        if (this.fverbose_) {
            System.out.print(new StringBuffer().append("\t").append(string2.length()).toString());
        }
        this.getIndexWriter().addDocument((Document)extractText);
        return true;
    }

    List<File> incremental(Iterator<File> iterator) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>(10000);
        IndexReader indexReader = IndexReader.open((File)this.index_);
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        while (iterator.hasNext()) {
            File file = iterator.next();
            String string = file.getCanonicalFile().toURI().toString();
            long l = file.lastModified();
            Term term = new Term("uri", string);
            TermQuery termQuery = new TermQuery(term);
            Hits hits = indexSearcher.search((Query)termQuery);
            if (hits.length() == 0) {
                arrayList.add(file);
                continue;
            }
            Document document = hits.doc(0);
            if (DateField.timeToString((long)l).equals(document.get("mod"))) continue;
            if (this.fmonitor_) {
                System.out.println(" -- modified");
            } else {
                indexReader.delete(term);
            }
            arrayList.add(file);
        }
        indexSearcher.close();
        indexReader.close();
        return arrayList;
    }

    List<File> refresh() throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>(100);
        IndexReader indexReader = IndexReader.open((File)this.index_);
        int n = indexReader.maxDoc();
        for (int i = 0; i < n; ++i) {
            Document document;
            String string;
            if (indexReader.isDeleted(i) || !(string = (document = indexReader.document(i)).get("uri")).startsWith("file:")) continue;
            File file = new File(string.substring("file:".length()));
            if (!file.exists()) {
                if (this.fmonitor_) {
                    indexReader.delete(i);
                }
                if (!this.fverbose_ && !this.fmonitor_) continue;
                System.out.println(new StringBuffer().append(file).append(" -- deleted").toString());
                continue;
            }
            if (file.lastModified() <= DateField.stringToTime((String)document.get("mod"))) continue;
            if (!this.fmonitor_) {
                indexReader.delete(i);
            }
            arrayList.add(file);
            if (!this.fverbose_ && !this.fmonitor_) continue;
            System.out.println(new StringBuffer().append(file).append(" -- modified").toString());
        }
        indexReader.close();
        return arrayList;
    }

    int delete(Pattern pattern) throws IOException {
        int n = 0;
        Matcher matcher = pattern.matcher("");
        IndexReader indexReader = IndexReader.open((File)this.index_);
        int n2 = indexReader.maxDoc();
        for (int i = 0; i < n2; ++i) {
            Document document;
            String string;
            if (indexReader.isDeleted(i) || !matcher.reset(string = (document = indexReader.document(i)).get("uri")).find()) continue;
            if (!this.fmonitor_) {
                indexReader.delete(i);
            }
            if (this.fverbose_ || this.fmonitor_) {
                System.out.println(new StringBuffer().append(string).append(" -- deleted").toString());
            }
            ++n;
        }
        indexReader.close();
        return n;
    }

    public void checkLock(boolean bl) {
        boolean bl2 = false;
        try {
            bl2 = IndexReader.isLocked((String)this.index_.toString());
        }
        catch (IOException iOException) {
            System.err.println(new StringBuffer().append("error checking lock: ").append(iOException).toString());
            System.exit(1);
        }
        if (bl2) {
            if (bl) {
                try {
                    IndexReader.unlock((Directory)FSDirectory.getDirectory((File)this.index_, (boolean)false));
                }
                catch (IOException iOException) {
                    System.err.println(new StringBuffer().append("couldn't unlock ").append(this.index_).append(": ").append(iOException).toString());
                    System.exit(1);
                }
            } else {
                System.err.println(new StringBuffer().append("Index in ").append(this.index_).append(" is locked.").toString());
                System.err.println("Another indexer may be running.  If not, remove lock with -force.");
                System.exit(1);
            }
        }
    }

    public static void main(String[] stringArray) {
        String string;
        int n;
        File file = Files.getFile("~/.lucene");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        Pattern pattern = null;
        String string2 = null;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if (string.startsWith("-ind")) {
                file = Files.getFile(stringArray[++n]);
                continue;
            }
            if (string.equals("-new")) {
                bl4 = true;
                continue;
            }
            if (string.startsWith("-opt")) {
                bl3 = true;
                continue;
            }
            if (string.equals("-refresh") || string.startsWith("-sync") || string.equals("-update")) {
                bl5 = true;
                continue;
            }
            if (string.equals("-force")) {
                bl6 = true;
                continue;
            }
            if (string.equals("-kill") || string.startsWith("-del")) {
                try {
                    pattern = Pattern.compile(stringArray[++n]);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    System.err.println(new StringBuffer().append("invalid regex: ").append(patternSyntaxException).toString());
                    System.exit(1);
                }
                continue;
            }
            if (string.equals("-x") || string.equals("-exclude")) {
                string2 = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                bl2 = true;
                bl = false;
                continue;
            }
            if (string.equals("-monitor")) {
                bl7 = true;
                continue;
            }
            if (string.startsWith("-q")) {
                bl = true;
                bl2 = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.equals("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println(USAGE);
            System.exit(1);
        }
        if (bl2) {
            System.out.println(new StringBuffer().append("index in ").append(file).toString());
        }
        long l = System.currentTimeMillis();
        Index index = new Index(file);
        index.fverbose_ = bl2;
        index.fmonitor_ = bl7;
        index.checkLock(bl6);
        if (string2 != null) {
            try {
                index.ex_ = Pattern.compile(string2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                System.err.println(new StringBuffer().append("invalid regex: ").append(patternSyntaxException).toString());
                System.exit(1);
            }
        }
        int n3 = 0;
        if (pattern != null) {
            try {
                n3 -= index.delete(pattern);
            }
            catch (IOException iOException) {
                System.err.println(new StringBuffer().append("couldn't delete: ").append(iOException).toString());
            }
        }
        try {
            Iterator<File> iterator;
            if (bl4 || !IndexReader.indexExists((File)file)) {
                iterator = new FileList(stringArray, n, null).iterator();
                bl4 = true;
            } else {
                iterator = bl5 ? index.refresh().iterator() : index.incremental(new FileList(stringArray, n, null).iterator()).iterator();
            }
            index.fnew_ = bl4;
            while (iterator.hasNext()) {
                File file2 = iterator.next();
                if (!bl) {
                    System.out.println();
                    System.out.print(file2);
                }
                if (bl7) {
                    // empty if block
                }
                try {
                    boolean bl8 = index.index1(file2);
                    if (!bl8) continue;
                    ++n3;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (bl) continue;
                    System.out.println(new StringBuffer().append(" -- skipped: ").append(iOException).toString());
                }
                catch (Throwable throwable) {
                    System.err.println(new StringBuffer().append("ERROR: ").append(throwable).toString());
                    throwable.printStackTrace();
                }
            }
            if (bl3) {
                index.getIndexWriter().optimize();
            }
            index.close();
            long l2 = System.currentTimeMillis();
            System.out.println();
            if (bl2) {
                System.out.println(new StringBuffer().append(n3).append(" document").append(n3 == 1 ? "" : "s").append(" indexed, in ").append((l2 - l + 500L) / 1000L).append(" seconds").toString());
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace();
        }
        catch (Error error) {
            System.err.println(new StringBuffer().append("ERROR: ").append(error).toString());
        }
        System.exit(0);
    }
}

