/*
 * Decompiled with CFR 0.152.
 */
package tool.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import phelps.io.Files;
import tool.lucene.AccentFilter;
import tool.lucene.ShortFilter;

public class Search {
    public static final String VERSION = "1.1 of $Date: 2003/08/28 20:31:42 $";
    public static final String USAGE = "java tool.lucene.Search [<options>] <search-expression>\n\t[-maxhits <max-hits>] [-index <directory>]";
    static final String[] STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    public static final Analyzer ANALYZER = new Analyzer(){

        public final TokenStream tokenStream(String string, Reader reader) {
            Object object = new StandardTokenizer(reader);
            object = new StandardFilter((TokenStream)object);
            object = new ShortFilter((TokenStream)object, 3);
            object = new AccentFilter((TokenStream)object);
            object = new LowerCaseFilter((TokenStream)object);
            object = new StopFilter((TokenStream)object, STOP_WORDS);
            object = new PorterStemFilter((TokenStream)object);
            return object;
        }
    };
    private File index_;
    private int hitsmax_;
    private boolean fverbose_;
    private IndexReader r_ = null;

    public Search() {
        this.defaults();
    }

    public void defaults() {
        this.index_ = Files.getFile("~/.lucene");
        this.hitsmax_ = 10;
        this.fverbose_ = false;
    }

    public void search(String string) throws IOException, ParseException {
        if (this.r_ == null) {
            this.r_ = IndexReader.open((File)this.index_);
        }
        QueryParser queryParser = new QueryParser("body", ANALYZER);
        Query query = queryParser.parse(string);
        if (this.fverbose_) {
            System.out.println("input query: |" + string + "|");
            System.out.println("parsed query: " + query);
        }
        IndexSearcher indexSearcher = new IndexSearcher(this.r_);
        Hits hits = indexSearcher.search(query);
        int n = hits.length();
        if (this.fverbose_) {
            System.out.println(this.r_.numDocs() + " documents indexed");
        }
        int n2 = Math.min(n, this.hitsmax_);
        for (int i = 0; i < n2; ++i) {
            Document document = hits.doc(i);
            String string2 = document.get("uri");
            if (string2.startsWith("file:")) {
                string2 = string2.substring("file:".length());
            }
            System.out.println(hits.score(i) + "   " + string2);
        }
        indexSearcher.close();
        System.out.println(n + " Results" + (n <= this.hitsmax_ ? "" : ", first " + this.hitsmax_ + " (-maxhits <num> for more)") + ":");
    }

    public void close() throws IOException {
        this.r_.close();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-ind")) {
                this.index_ = Files.getFile(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-hit") || string.startsWith("-max")) {
                String string2;
                if ((string2 = stringArray[++n]).equals("all")) {
                    this.hitsmax_ = Integer.MAX_VALUE;
                    continue;
                }
                try {
                    this.hitsmax_ = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("can't parse \"" + stringArray[n] + "\" as number");
                    System.exit(1);
                }
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) continue;
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Search search = new Search();
        int n = search.commandLine(stringArray);
        int n2 = stringArray.length - n;
        String string = stringArray[n];
        if (n2 > 1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n3 = stringArray.length;
            for (int i = n + 1; i < n3; ++i) {
                stringBuffer.append(' ').append(stringArray[i]);
            }
            string = stringBuffer.toString();
        }
        try {
            search.search(string);
            search.close();
        }
        catch (ParseException parseException) {
            System.out.println("invalid query: " + (Object)((Object)parseException));
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            iOException.printStackTrace();
        }
    }
}

