/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Cmd;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Encrypt;
import multivalent.std.adaptor.pdf.Fonts;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.awt.geom.Rectangles2D;
import phelps.io.Files;
import phelps.io.PrintStreams;
import phelps.lang.Integers;
import phelps.lang.Strings;
import phelps.util.Units;

public class Info {
    static final boolean DEBUG = true;
    public static final String VERSION = "1.4 of $Date: 2005/07/26 21:18:26 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Info [<information>] [<options>] <PDF-file-or-directory...>\n\tinfo: [-general] [-image] [-anno] [-fonts] [-metadata] [-objects] [-content]\n\t      [-all]\n\toptions: [-label] [-password <password>]";
    private static final String[] KEYS_TXT = new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer"};
    private static final String[] CLASS_NAMES = new String[]{"null", "iref 0 R", "<<dict>>", "[array]", "/name", "(string)", "double", "long", "boolean", "data"};
    private static final List<Class> DATA_TYPES = Collections.unmodifiableList(Arrays.asList(null, COS.CLASS_IREF, COS.CLASS_DICTIONARY, COS.CLASS_ARRAY, COS.CLASS_NAME, COS.CLASS_STRING, COS.CLASS_REAL, COS.CLASS_INTEGER, COS.CLASS_BOOLEAN, COS.CLASS_DATA));
    private static final String FONT_HEADER = "FONT NAME                        TYPE          ENCODING      EMB SUB UNI   OBJ#  #glyphs  pages";
    private static final String[] PDF_CMDS = new String[]{"w", "J", "j", "M", "d", "ri", "i", "gs", "q", "Q", "cm", "m", "l", "c", "v", "y", "h", "re", "S", "s", "f", "F", "f*", "B", "B*", "b", "b*", "n", "W", "W*", "BT", "ET", "Tc", "Tw", "Tz", "TL", "Tf", "Tr", "Ts", "Td", "TD", "Tm", "T*", "Tj", "TJ", "'", "\"", "d0", "d1", "CS", "cs", "SC", "SCN", "sc", "scn", "G", "g", "RG", "rg", "K", "k", "sh", "BI", "ID", "EI", "Do", "MP", "DP", "BMC", "BDC", "EMC", "BX", "EX", "%", "PS"};
    static Comparator<FontInfo> FontInfoByName = new Comparator<FontInfo>(){

        @Override
        public int compare(FontInfo fontInfo, FontInfo fontInfo2) {
            return Strings.DICTIONARY_ORDER.compare(fontInfo.name, fontInfo2.name);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.compare((FontInfo)object, (FontInfo)object2);
        }
    };
    private String password_ = null;
    private boolean fgeneral_ = false;
    private boolean fimage_ = false;
    private boolean fanno_ = false;
    private boolean ffont_ = false;
    private boolean fmeta_ = false;
    private boolean fobjects_ = false;
    private boolean fcontent_ = false;
    private boolean fjava_ = false;
    private boolean fhist_ = false;
    private String label_ = null;
    private boolean flabel_ = false;
    private File dirbase_ = new File(".").getAbsoluteFile();
    private boolean fverbose_ = false;
    private boolean fmonitor_ = false;
    private boolean fquiet_ = false;
    private PrintStream out_ = PrintStreams.DEVNULL;
    private PDFReader pdfr_;

    public Info(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Info(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Info(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Info(PDFReader pDFReader) {
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    private void print(String string) {
        if (this.flabel_) {
            this.out_.print(this.label_);
        }
        if (string != null) {
            this.out_.print(string);
        }
    }

    private void println(String string) {
        this.print(string);
        this.out_.println();
    }

    private void println() {
        this.println("");
    }

    public void info() throws IOException, ParseException {
        PDFReader pDFReader = this.pdfr_;
        if (this.flabel_) {
            this.label_ = Files.relative(this.dirbase_, new File(pDFReader.getURI())) + ": ";
        }
        if (!(this.fgeneral_ || this.fimage_ || this.fanno_ || this.ffont_ || this.fcontent_)) {
            this.fgeneral_ = true;
        }
        pDFReader.setPassword(this.password_);
        pDFReader.setExact(true);
        if (this.fgeneral_) {
            this.general(pDFReader);
        }
        pDFReader.fault();
        if (this.fimage_) {
            this.image(pDFReader);
        }
        if (this.fanno_) {
            this.anno(pDFReader);
        }
        if (this.ffont_) {
            this.font(pDFReader);
        }
        if (this.fobjects_) {
            this.objects(pDFReader);
        }
        if (this.fcontent_) {
            this.content(pDFReader);
        }
        if (this.fjava_) {
            this.profileJava(pDFReader);
        }
    }

    void general(PDFReader pDFReader) throws IOException {
        String string;
        Dict dict;
        Object object;
        Dict dict2 = pDFReader.getTrailer();
        Dict dict3 = pDFReader.getCatalog();
        Dict dict4 = pDFReader.getInfo();
        if (dict4 != null) {
            int n = KEYS_TXT.length;
            for (int i = 0; i < n; ++i) {
                String string2 = KEYS_TXT[i];
                object = pDFReader.getObject(dict4.get(string2));
                if (object == null) continue;
                this.println(string2 + ": " + object);
            }
            long l = -1L;
            object = pDFReader.getObject(dict4.get("CreationDate"));
            if (object != null) {
                try {
                    l = COS.parseDate((StringBuffer)object);
                    this.println("Created: " + new Date(l));
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
            if ((object = pDFReader.getObject(dict4.get("ModDate"))) != null) {
                try {
                    long l2 = COS.parseDate((StringBuffer)object);
                    if (l2 != l) {
                        this.println("Modified: " + new Date(l2));
                    }
                }
                catch (InstantiationException instantiationException) {
                    // empty catch block
                }
            }
        }
        this.println("Page count: " + pDFReader.getPageCnt());
        this.println("PDF version: " + pDFReader.getVersion());
        if (dict3.get("Outlines") != null) {
            this.println("outline");
        }
        if (dict3.get("Metadata") != null) {
            this.println("metadata");
        }
        if (dict3.get("StructTreeRoot") != null) {
            this.println("structured");
        }
        if (dict3.get("SpiderInfo") != null) {
            this.println("converted from HTML");
        }
        if (dict3.get("AcroForm") != null) {
            this.println("forms");
        }
        if (pDFReader.getLinearized() > 0) {
            object = (Dict)pDFReader.getObject(pDFReader.getLinearized());
            this.println("Linearized: version " + ((Dict)object).get("Linearized"));
        }
        object = pDFReader.getEncrypt();
        Dict dict5 = (Dict)pDFReader.getObject(dict2.get("Encrypt"));
        SecurityHandler securityHandler = ((Encrypt)object).getSecurityHandler();
        if (securityHandler != SecurityHandler.IDENTITY) {
            this.print("Encrypted: filter ");
            if (securityHandler instanceof SecurityHandlerStandard) {
                SecurityHandlerStandard securityHandlerStandard = (SecurityHandlerStandard)securityHandler;
                int n = securityHandlerStandard.getR();
                int n2 = securityHandlerStandard.getP();
                this.println("Standard (revision " + n + "), " + securityHandlerStandard.getLength() + "-bit key" + (securityHandler.isAuthorized() ? ", null password" : ""));
                if ((0xFFFFFFFC & n2) != -4) {
                    this.print("    restrictions:");
                    if ((4 & n2) == 0) {
                        this.out_.print("  print");
                    }
                    if ((8 & n2) == 0) {
                        this.out_.print("  modify");
                    }
                    if ((0x10 & n2) == 0) {
                        this.out_.print("  copy/extract");
                    }
                    if ((0x20 & n2) == 0) {
                        this.out_.print("  annotate");
                    }
                    if (n < 3 || (0x100 & n2) == 0) {
                        this.out_.print("  fill forms");
                    }
                    if (n < 3 || (0x200 & n2) == 0) {
                        this.out_.print("  accessibility");
                    }
                    if (n < 3 || (0x400 & n2) == 0) {
                        this.out_.print("  assemble");
                    }
                    if (n >= 3 && (0x800 & n2) == 0) {
                        this.out_.print("  high-quality print");
                    }
                    this.println();
                }
            } else {
                this.println(dict5.get("Filter") + ", " + (securityHandler.isAuthorized() ? ", null password" : ""));
            }
        }
        if ((dict = (Dict)dict2.get("Compress")) != null) {
            Object object2;
            StringBuffer stringBuffer = new StringBuffer(80);
            stringBuffer.append("Compressed:");
            Number number = (Number)dict.get("LengthO");
            if (number != null) {
                int n = (int)pDFReader.getRA().length();
                stringBuffer.append(" ").append((number.intValue() - n) * 100 / number.intValue()).append("%");
            }
            if ((object2 = dict.get("Filter")) != null) {
                stringBuffer.append(", ").append(object2).append(" format");
            }
            if ((object2 = dict.get("V")) != null) {
                stringBuffer.append(" v").append(object2);
            }
            if ((object2 = dict.get("Producer")) != null) {
                stringBuffer.append(", by ").append(object2);
            }
            this.println(stringBuffer.toString());
        }
        if (this.fmeta_ && (string = pDFReader.getMetadata(dict3)).length() > 0) {
            this.println(string);
        }
    }

    void image(PDFReader pDFReader) throws IOException {
        int n = pDFReader.getObjCnt();
        for (int i = 0; i < n; ++i) {
            Object object = pDFReader.getObject(i);
            if (COS.CLASS_DICTIONARY != object.getClass()) continue;
            Dict dict = (Dict)object;
            Object object2 = pDFReader.getObject(dict.get("Type"));
            Object object3 = pDFReader.getObject(dict.get("Subtype"));
            if (!"XObject".equals(object2) && object2 != null || !"Image".equals(object3)) continue;
            this.print("image: object " + i + ", " + pDFReader.getObject(dict.get("Width")) + "x" + pDFReader.getObject(dict.get("Height")));
            String string = Images.getFilter(dict, pDFReader);
            this.out_.print(", " + (string != null ? string : "raw samples"));
            object = pDFReader.getObject(dict.get("BitsPerComponent"));
            if (object != null) {
                this.out_.print(", depth = " + object);
            }
            if ((object = pDFReader.getObject(dict.get("ColorSpace"))) != null) {
                Object object4 = COS.CLASS_ARRAY == object.getClass() ? ((Object[])object)[0] : object;
                this.out_.print(", colorspace = " + object4);
            }
            this.println(", length = " + pDFReader.getObject(dict.get("Length")));
        }
    }

    void anno(PDFReader pDFReader) throws IOException, ParseException {
        int n = pDFReader.getPageCnt();
        for (int i = 0; i < n; ++i) {
            Dict dict = (Dict)pDFReader.getObject(pDFReader.getPageRef(i + 1));
            Object[] objectArray = (Object[])pDFReader.getObject(dict.get("Annots"));
            if (objectArray == null) continue;
            int n2 = objectArray.length;
            for (int j = 0; j < n2; ++j) {
                this.print("anno: page " + (i + 1) + ", ");
                Object object = objectArray[j];
                if (COS.CLASS_IREF == object.getClass()) {
                    this.out_.print("object " + ((IRef)object).id + ", ");
                }
                Dict dict2 = (Dict)pDFReader.getObject(objectArray[j]);
                Object object2 = pDFReader.getObject(dict2.get("Subtype"));
                this.out_.print(object2);
                object = pDFReader.getObject(dict2.get("Rect"));
                if (object != null) {
                    this.out_.print(", bounds " + Rectangles2D.pretty(COS.array2Rectangle((Object[])object, null)));
                }
                this.println();
            }
        }
    }

    void font(PDFReader pDFReader) throws IOException, ParseException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n = pDFReader.getObjCnt();
        Set[] setArray = new Set[n];
        int n2 = pDFReader.getPageCnt();
        for (int i = 0; i < n2; ++i) {
            Dict dict;
            object4 = pDFReader.getPage(i + 1);
            object3 = pDFReader.getObject(((Dict)object4).get("Resources"));
            if (object3 == null || COS.OBJECT_NULL == object3 || (dict = (Dict)pDFReader.getObject(((Dict)(object2 = (Dict)object3)).get("Font"))) == null) continue;
            object = dict.values().iterator();
            while (object.hasNext()) {
                IRef iRef = (IRef)object.next();
                int n3 = iRef.id;
                if (setArray[n3] == null) {
                    setArray[n3] = new HashSet(5);
                }
                setArray[n3].add(Integers.getInteger(i + 1));
            }
        }
        ArrayList<FontInfo> arrayList = new ArrayList<FontInfo>(50);
        for (n2 = 1; n2 < n; ++n2) {
            int n4;
            Object[] objectArray;
            Object object5;
            String string;
            int n5;
            Object object6;
            object4 = pDFReader.getObject(n2);
            if (COS.CLASS_DICTIONARY != object4.getClass() || !"Font".equals(pDFReader.getObject(((Dict)(object3 = (Dict)object4)).get("Type")))) continue;
            object2 = (String)pDFReader.getObject(((Dict)object3).get("Subtype"));
            boolean bl = "Type3".equals(object2) || "Type0".equals(object2);
            object = (String)pDFReader.getObject(((Dict)object3).get("BaseFont"));
            if (object == null) {
                object = "<none>";
            }
            boolean bl2 = false;
            if (Fonts.isSubset((String)object)) {
                bl2 = true;
                object = ((String)object).substring("SIXCAP+".length());
            }
            Dict dict = (Dict)pDFReader.getObject(((Dict)object3).get("FontDescriptor"));
            String string2 = null;
            Object object7 = null;
            if (dict != null) {
                object7 = dict.get("FontFile");
                if (object7 != null || (object7 = dict.get("FontFile2")) != null || (object7 = dict.get("FontFile3")) != null) {
                    object6 = (Dict)pDFReader.getObject(object7);
                    string2 = (String)((Dict)object6).get("Subtype");
                    bl = true;
                }
                if (dict.get("Charset") != null) {
                    bl2 = true;
                }
            }
            if ((n5 = (string = (object6 = pDFReader.getObject(((Dict)object3).get("Encoding"))) == null ? "<intrinsic>" : (COS.CLASS_NAME == object6.getClass() ? (String)object6 : "<custom>")).indexOf("Encoding")) > 0) {
                string = string.substring(0, n5);
            }
            boolean bl3 = ((Dict)object3).get("ToUnicode") != null;
            int n6 = -1;
            if ("Type3".equals(object2)) {
                object5 = (Object[])pDFReader.getObject(((Dict)object3).get("CharProcs"));
                n6 = object5.size();
            } else if (("Type1".equals(object2) || "TrueType".equals(object2)) && (object5 = (Object[])pDFReader.getObject(((Dict)object3).get("Widths"))) != null) {
                n6 = 0;
                objectArray = object5;
                n4 = objectArray.length;
                for (int i = 0; i < n4; ++i) {
                    Object object8 = objectArray[i];
                    if (((Number)object8).intValue() == 0) continue;
                    ++n6;
                }
            }
            objectArray = setArray[n2];
            int n7 = n4 = objectArray != null ? objectArray.size() : 0;
            if (object2 != null && ((String)object2).startsWith("CIDFont")) {
                object5 = "";
            } else if (n4 == 0) {
                object5 = "*unused*";
            } else if (n4 == 1) {
                object5 = ((Integer)objectArray.iterator().next()).toString();
            } else {
                int[] nArray = new int[n4];
                int n8 = 0;
                Iterator iterator = objectArray.iterator();
                while (iterator.hasNext()) {
                    nArray[n8++] = (Integer)iterator.next();
                }
                Arrays.sort(nArray);
                object5 = Units.toRange(nArray);
            }
            arrayList.add(new FontInfo((String)object, (String)(string2 != null ? string2 : object2), string, bl, bl2, bl3, n2, n6, (String)object5));
        }
        Collections.sort(arrayList, FontInfoByName);
        if (arrayList.size() > 0) {
            this.println(FONT_HEADER.substring(0, !this.fverbose_ ? 80 : FONT_HEADER.length()));
        }
        int n9 = arrayList.size();
        for (n2 = 0; n2 < n9; ++n2) {
            object3 = (FontInfo)arrayList.get(n2);
            object2 = new StringBuffer(80);
            ((StringBuffer)object2).append(((FontInfo)object3).name);
            this.tab((StringBuffer)object2, FONT_HEADER.indexOf("TYPE"));
            ((StringBuffer)object2).append(((FontInfo)object3).type);
            this.tab((StringBuffer)object2, FONT_HEADER.indexOf("ENC"));
            ((StringBuffer)object2).append(((FontInfo)object3).encoding);
            this.tab((StringBuffer)object2, FONT_HEADER.indexOf("EMB"));
            if (!((FontInfo)object3).embedded && Fonts.isCore14(((FontInfo)object3).name)) {
                ((StringBuffer)object2).append("--core 14--");
            } else {
                ((StringBuffer)object2).append("Type0".equals(((FontInfo)object3).type) ? "n/a" : (((FontInfo)object3).embedded ? " Y " : " N ")).append(" ");
                if (!((FontInfo)object3).embedded || "Type3".equals(((FontInfo)object3).type) || "Type0".equals(((FontInfo)object3).type)) {
                    ((StringBuffer)object2).append("n/a ");
                } else {
                    ((StringBuffer)object2).append(" ").append(((FontInfo)object3).subset ? "Y" : "N").append("  ");
                }
                ((StringBuffer)object2).append(" ").append(((FontInfo)object3).toUnicode ? "Y" : "N").append(" ");
            }
            this.right((StringBuffer)object2, 7, ((FontInfo)object3).objnum);
            if (this.fverbose_) {
                this.tab((StringBuffer)object2, FONT_HEADER.indexOf("#gly"));
                if (((FontInfo)object3).glyphcnt >= 0) {
                    this.right((StringBuffer)object2, 7, ((FontInfo)object3).glyphcnt);
                }
                this.tab((StringBuffer)object2, FONT_HEADER.indexOf("pages"));
                ((StringBuffer)object2).append(((FontInfo)object3).inpages);
            }
            this.println(((StringBuffer)object2).toString());
        }
    }

    void objects(PDFReader pDFReader) throws IOException {
        int n = pDFReader.getObjCnt();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>(20);
        for (int i = 1; i < n; ++i) {
            Object object = pDFReader.getObject(i);
            if (object == null || object.getClass() != COS.CLASS_DICTIONARY) continue;
            Dict dict = (Dict)object;
            String string = (String)dict.get("Type");
            String string2 = (String)dict.get("Subtype");
            if ("Font".equals(string)) {
                ++n2;
                arrayList.add(dict.get("BaseFont"));
                if ("Type1".equals(string2)) {
                    ++n3;
                } else if ("TrueType".equals(string2)) {
                    ++n4;
                } else if ("Type3".equals(string2)) {
                    ++n5;
                } else {
                    ++n6;
                }
            }
            if ("FontDescriptor".equals(string)) {
                if (dict.get("FontFile") == null && dict.get("FontFile2") == null && dict.get("FontFile3") == null) continue;
                ++n7;
                continue;
            }
            if ("XObject".equals(string)) {
                if ("Image".equals(string2)) {
                    ++n8;
                    continue;
                }
                if (!"Form".equals(string2)) continue;
                ++n9;
                continue;
            }
            if ("Page".equals(string)) {
                if (dict.get("Thumb") == null) continue;
                ++n10;
                continue;
            }
            if (!"Annot".equals(string)) continue;
            ++n11;
            if (!"Link".equals(string2)) continue;
            ++n12;
        }
        System.out.println(n + " objects");
        if (n2 > 0) {
            System.out.print("\t" + n2 + " fonts:  ");
            if (n3 > 0) {
                System.out.print(n3 + " Type 1   ");
            }
            if (n4 > 0) {
                System.out.print(n4 + " TrueType   ");
            }
            if (n5 > 0) {
                System.out.print(n5 + " Type 3   ");
            }
            if (n7 > 0) {
                System.out.print(n7 + " embedded   ");
            }
            System.out.print(arrayList);
            System.out.println();
        }
        if (n8 > 0) {
            System.out.println(n8 + " images");
        }
        if (n9 > 0) {
            System.out.println(n9 + " forms");
        }
        if (n10 > 0) {
            System.out.println(n10 + " thumbnails");
        }
        if (n11 > 0) {
            System.out.print("\t" + n11 + " annotations:   ");
            if (n12 > 0) {
                System.out.print(n12 + " hyperlinks   ");
            }
            System.out.println();
        }
    }

    void content(PDFReader pDFReader) throws IOException {
        Object object;
        Object object2;
        int n;
        this.print(" (" + pDFReader.getPageCnt() + " pages)  ");
        HashMap<String, Stat> hashMap = new HashMap<String, Stat>(150);
        int n2 = pDFReader.getPageCnt();
        for (int i = 0; i < n2; ++i) {
            Cmd cmd;
            n = i + 1;
            object2 = (Dict)pDFReader.getObject(pDFReader.getPageRef(n));
            object = pDFReader.getInputStream(((Dict)object2).get("Contents"), true);
            while ((cmd = pDFReader.readCommand((InputStreamComposite)object)) != null) {
                Stat stat = (Stat)hashMap.get(cmd.op);
                if (stat == null) {
                    stat = new Stat();
                    hashMap.put(cmd.op, stat);
                }
                ++stat.cnt;
            }
            ((InputStreamComposite)object).close();
        }
        this.out_.print("Content streams command usage:");
        String[] stringArray = PDF_CMDS;
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            object2 = stringArray[n];
            object = (Stat)hashMap.get(object2);
            if (object == null || ((Stat)object).cnt <= 0) continue;
            this.out_.print("   " + (String)object2 + " " + ((Stat)object).cnt);
        }
        this.out_.println();
    }

    void profileJava(PDFReader pDFReader) throws IOException {
        int n;
        Stat[] statArray = new Stat[DATA_TYPES.size()];
        int n2 = DATA_TYPES.size();
        for (n = 0; n < n2; ++n) {
            statArray[n] = new Stat();
        }
        n = pDFReader.getObjCnt();
        this.profileJava(pDFReader.getTrailer(), statArray, new boolean[n]);
        int n3 = DATA_TYPES.size();
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.println(CLASS_NAMES[n2] + " " + statArray[n2]);
        }
    }

    protected void profileJava(Object object, Stat[] statArray, boolean[] blArray) throws IOException {
        Class<?> clazz = object != null ? object.getClass() : null;
        int n = DATA_TYPES.indexOf(clazz);
        Stat stat = statArray[n];
        ++stat.cnt;
        stat.space += 4;
        if (COS.CLASS_IREF == clazz) {
            stat.space += 8;
            stat.wasted += 4;
            int n2 = ((IRef)object).id;
            if (!blArray[n2]) {
                blArray[n2] = true;
            }
        } else if (COS.CLASS_ARRAY == clazz) {
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length;
            stat.space += n3 * 4 + 4;
            stat.size += n3;
            stat.min = Math.min(stat.min, n3);
            stat.max = Math.max(stat.max, n3);
            int n4 = objectArray.length;
            for (int i = 0; i < n4; ++i) {
                this.profileJava(objectArray[i], statArray, blArray);
            }
        } else if (COS.CLASS_DICTIONARY == clazz) {
            Dict dict = (Dict)object;
            int n5 = 16;
            int n6 = dict.size();
            while ((double)n5 * 0.75 < (double)n6) {
                n5 <<= 1;
            }
            stat.space += 20 + dict.size() * (20 + 4 * n5);
            stat.wasted += (n5 - n6) * 3;
            stat.size += n6;
            stat.min = Math.min(stat.min, n6);
            stat.max = Math.max(stat.max, n6);
            Iterator iterator = dict.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.profileJava(entry.getValue(), statArray, blArray);
            }
        } else if (COS.CLASS_NAME == clazz) {
            String string = (String)object;
            int n7 = string.length();
            stat.space += n7 * 2 + 16;
            stat.size += n7;
            stat.min = Math.min(stat.min, n7);
            stat.max = Math.max(stat.max, n7);
        } else if (COS.CLASS_STRING == clazz) {
            StringBuffer stringBuffer = (StringBuffer)object;
            int n8 = stringBuffer.capacity();
            int n9 = stringBuffer.length();
            stat.space += n8 * 2 + 12;
            stat.wasted += (n8 - n9) * 2;
            stat.size += n9;
            stat.min = Math.min(stat.min, n9);
            stat.max = Math.max(stat.max, n9);
        } else if (COS.CLASS_REAL == clazz) {
            stat.space += 8;
        } else if (COS.CLASS_INTEGER == clazz) {
            stat.space += 4;
        } else if (COS.CLASS_BOOLEAN == clazz) {
            stat.space += 4;
        }
    }

    void hist(PDFReader pDFReader) throws IOException {
        int n = pDFReader.getObjCnt();
        for (int i = 1; i < n; ++i) {
            Object object = pDFReader.getObject(i);
            if (object.getClass() != COS.CLASS_DICTIONARY || !"Image".equals(pDFReader.getObject(((Dict)object).get("Subtype")))) continue;
            Dict dict = (Dict)object;
            System.out.print(i + "  " + dict.get("Width") + "x" + dict.get("Height") + ", " + dict.get("ColorSpace") + ":  ");
            int n2 = ((Number)dict.get("BitsPerComponent")).intValue();
            if (n2 == 8) {
                int n3;
                int n4;
                int[] nArray = new int[256];
                InputStreamComposite inputStreamComposite = pDFReader.getInputStream(dict);
                while ((n4 = ((InputStream)inputStreamComposite).read()) != -1) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                }
                ((InputStream)inputStreamComposite).close();
                n4 = 0;
                int n6 = nArray.length;
                for (n3 = 0; n3 < n6; ++n3) {
                    if (nArray[n3] <= 0) continue;
                    ++n4;
                }
                Arrays.sort(nArray);
                System.out.print("(" + n4 + ")  ");
                n6 = 240;
                for (n3 = 255; n3 >= n6; --n3) {
                    System.out.print(" " + nArray[n3]);
                }
                System.out.println();
                continue;
            }
            System.out.println("bpc = " + n2);
        }
    }

    private void tab(StringBuffer stringBuffer, int n) {
        for (int i = stringBuffer.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
    }

    private void right(StringBuffer stringBuffer, int n, int n2) {
        String string = Integer.toString(n2);
        this.tab(stringBuffer, stringBuffer.length() + n - string.length());
        stringBuffer.append(string);
    }

    public void close() throws IOException {
        if (this.pdfr_ != null) {
            this.pdfr_.close();
        }
        this.pdfr_ = null;
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.setOut(System.out);
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-gen")) {
                this.fgeneral_ = true;
                continue;
            }
            if (string.startsWith("-im")) {
                this.fimage_ = true;
                continue;
            }
            if (string.startsWith("-anno")) {
                this.fanno_ = true;
                continue;
            }
            if (string.startsWith("-font")) {
                this.ffont_ = true;
                continue;
            }
            if (string.startsWith("-meta")) {
                this.fmeta_ = true;
                continue;
            }
            if (string.startsWith("-obj")) {
                this.fobjects_ = true;
                continue;
            }
            if (string.startsWith("-con")) {
                this.fcontent_ = true;
                continue;
            }
            if (string.startsWith("-prof") || string.startsWith("-java")) {
                this.fjava_ = true;
                continue;
            }
            if (string.equals("-all")) {
                this.fcontent_ = true;
                this.fobjects_ = true;
                this.ffont_ = true;
                this.fanno_ = true;
                this.fimage_ = true;
                this.fgeneral_ = true;
                continue;
            }
            if (string.startsWith("-l")) {
                this.flabel_ = true;
                continue;
            }
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.equals("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        Info info = new Info((PDFReader)null);
        int n = info.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                if (!info.flabel_) {
                    info.println("Filename: " + file);
                }
                info.pdfr_ = new PDFReader(file);
                info.info();
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    info.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.exit(0);
    }

    static class FontInfo {
        String name;
        String type;
        String encoding;
        boolean embedded;
        boolean subset;
        boolean toUnicode;
        int objnum;
        int glyphcnt;
        String inpages;

        FontInfo(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n, int n2, String string4) {
            this.name = string;
            this.type = string2;
            this.encoding = string3;
            this.embedded = bl;
            this.subset = bl2;
            this.toUnicode = bl3;
            this.objnum = n;
            this.glyphcnt = n2;
            this.inpages = string4;
        }
    }

    private static class Stat {
        int cnt = 0;
        int space = 0;
        int wasted = 0;
        int size = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;

        private Stat() {
        }

        public String toString() {
            String string = "#" + this.cnt + ", use=" + this.space;
            if (this.wasted > 0) {
                string = string + ", of which waste=" + this.wasted;
            }
            if (this.size > 0) {
                string = string + ", min/avg/max=" + this.min + ".." + this.size / this.cnt + ".." + this.max;
            }
            return string;
        }
    }
}

