/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.OutputUni;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Cmd;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.io.PrintStreams;
import phelps.lang.Integers;
import phelps.util.Units;

public class Uncompress
implements Observer {
    static final boolean DEBUG = false;
    public static final String VERSION = "2.4 of $Date: 2005/07/26 21:21:17 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Uncompress [<options>] <PDF-file>\n\t[-exact] [-fonts] [-password <OWNER-password>]";
    private boolean fexact_ = false;
    private boolean ffonts_ = false;
    private boolean fverbose_ = false;
    private boolean fquiet_ = false;
    private boolean fmonitor_ = false;
    private PrintStream out_ = PrintStreams.DEVNULL;
    private String password_ = null;
    private PDFReader pdfr_;
    private PDFWriter pdfw_;
    private List<Integer> pagenum_ = null;
    private Set[] objuse_;
    private boolean[] content_;

    public Uncompress(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Uncompress(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Uncompress(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Uncompress(PDFReader pDFReader) {
    }

    public void setExact(boolean bl) {
        this.fexact_ = bl;
    }

    public void setPlainFonts(boolean bl) {
    }

    public boolean setPassword(String string) {
        return this.pdfr_.getEncrypt().getSecurityHandler().authOwner(string);
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void writeFile(File file) throws IOException, ParseException {
        this.writeUni(OutputUni.getInstance(file, null));
    }

    public byte[] writeBytes() throws IOException, ParseException {
        OutputUni outputUni = OutputUni.getInstance(new byte[this.pdfr_.getObjCnt() * 100], null);
        this.writeUni(outputUni);
        return outputUni.toByteArray();
    }

    public void writeUni(OutputUni outputUni) throws IOException, ParseException {
        this.uncompress(new PDFWriter(outputUni, this.pdfr_));
    }

    public PDFReader writePipe() throws IOException, ParseException {
        return null;
    }

    public Object uncompress(PDFWriter pDFWriter) throws IOException, ParseException {
        this.pdfr_.setExact(true);
        if (!this.pdfr_.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        SecurityHandler securityHandler = this.pdfr_.getEncrypt().getSecurityHandler();
        if (securityHandler instanceof SecurityHandlerStandard && (((SecurityHandlerStandard)securityHandler).getPerm() & 1) == 0) {
            throw new ParseException("need OWNER password");
        }
        if (this.fmonitor_) {
            pDFWriter.setMonitor(true);
        }
        pDFWriter.setExact(this.fexact_);
        this.uncompress2(pDFWriter);
        this.pdfw_ = pDFWriter;
        Object object = pDFWriter.writePDF(this);
        this.pdfw_ = null;
        this.pdfr_.close();
        this.pdfr_ = null;
        pDFWriter.close();
        return object;
    }

    public void uncompress2(PDFWriter pDFWriter) throws IOException, ParseException {
        pDFWriter.getTrailer().remove("Compress");
        pDFWriter.getTrailer().remove("Encrypt");
        pDFWriter.setCompress(false);
        if (!this.fexact_) {
            this.markupPages(this.pdfr_, pDFWriter);
        }
        if (this.ffonts_) {
            pDFWriter.convertType1("decrypted");
        }
    }

    public void update(Observable observable, Object object) {
        Object object2;
        int n;
        if (this.fexact_) {
            return;
        }
        Object[] objectArray = (Object[])object;
        Object object3 = objectArray[0];
        int n2 = (Integer)objectArray[1];
        String string = null;
        int n3 = this.pagenum_.indexOf(objectArray[1]);
        if (n3 != -1) {
            string = "page " + (n3 + 1);
        } else if (n2 >= 1 && (n = (object2 = this.objuse_[n2]).size()) != 0) {
            if (n == 1) {
                string = "used by page " + object2.iterator().next();
            } else {
                int[] nArray = new int[n];
                int n4 = 0;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    nArray[n4++] = (Integer)iterator.next();
                }
                string = "used by pages " + Units.toRange(nArray);
            }
        }
        if (COS.CLASS_DICTIONARY == object3.getClass() && ((Dict)object3).get("DATA") != null) {
            try {
                object2 = (Dict)object3;
                if (this.pdfr_.getEncrypt().getCryptFilter((Dict)object2) != CryptFilter.IDENTITY) {
                    this.pdfw_.removeFilter((Dict)object2, "Crypt");
                }
                if (this.content_[n2]) {
                    this.prettyprint((Dict)object2, this.pdfr_, this.pdfw_);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string != null) {
            try {
                this.pdfw_.getOutputStream().writeString8("% " + string + "\n");
            }
            catch (IOException iOException) {
                System.out.println("can't write: " + iOException);
            }
        }
    }

    private void prettyprint(Dict dict, PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        try {
            Cmd[] cmdArray = pDFReader.readCommandArray(dict);
            dict.put("DATA", pDFWriter.writeCommandArray(cmdArray, true));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void markupPages(PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        int n;
        int n2 = pDFReader.getObjCnt();
        int n3 = pDFReader.getPageCnt();
        this.pagenum_ = new ArrayList<Integer>(n3);
        for (n = 0; n < n3; ++n) {
            this.pagenum_.add(Integers.getInteger(pDFReader.getPageRef((int)(n + 1)).id));
        }
        this.objuse_ = new Set[n2];
        for (n = 1; n < n2; ++n) {
            this.objuse_[n] = new LinkedHashSet(5);
        }
        this.content_ = new boolean[n2];
        for (n = 0; n < n3; ++n) {
            IRef iRef = pDFReader.getPageRef(n + 1);
            this.pageOwner(n + 1, pDFReader.getObject(iRef), this.objuse_);
            this.findContent(iRef, pDFReader);
        }
    }

    private void pageOwner(int n, Object object, Set[] setArray) throws IOException {
        block6: {
            Class<?> clazz;
            block5: {
                clazz = object.getClass();
                if (COS.CLASS_IREF != clazz) break block5;
                int n2 = ((IRef)object).id;
                Integer n3 = Integers.getInteger(n);
                if (setArray[n2].contains(n3)) break block6;
                setArray[n2].add(n3);
                break block6;
            }
            if (COS.CLASS_ARRAY == clazz) {
                Object[] objectArray = (Object[])object;
                int n4 = objectArray.length;
                for (int i = 0; i < n4; ++i) {
                    Object object2 = objectArray[i];
                    this.pageOwner(n, object2, setArray);
                }
            } else if (COS.CLASS_DICTIONARY == clazz) {
                Iterator iterator = ((Dict)object).values().iterator();
                while (iterator.hasNext()) {
                    this.pageOwner(n, iterator.next(), setArray);
                }
            }
        }
    }

    private void findContent(Object object, PDFReader pDFReader) throws IOException {
        Dict dict;
        Object[] objectArray;
        Dict dict2 = (Dict)pDFReader.getObject(object);
        Object object2 = dict2.get("Contents");
        Object object3 = pDFReader.getObject(object2);
        if (object3 == null) {
            objectArray = new Object[]{};
        } else if (COS.CLASS_DICTIONARY == object3.getClass()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object2;
        } else {
            objectArray = (Object[])object3;
        }
        Object[] objectArray3 = objectArray;
        int n = objectArray3.length;
        for (int i = 0; i < n; ++i) {
            this.content_[((IRef)objectArray3[i]).id] = true;
        }
        Dict dict3 = (Dict)pDFReader.getObject(dict2.get("Resources"));
        Dict dict4 = dict = dict3 != null ? (Dict)pDFReader.getObject(dict3.get("XObject")) : null;
        if (dict != null) {
            Iterator iterator = dict.values().iterator();
            while (iterator.hasNext()) {
                Dict dict5;
                object2 = iterator.next();
                object3 = pDFReader.getObject(object2);
                if (COS.CLASS_DICTIONARY != object3.getClass() || !"Form".equals((dict5 = (Dict)object3).get("Subtype"))) continue;
                if (COS.CLASS_IREF == object2.getClass()) {
                    this.content_[((IRef)object2).id] = true;
                }
                this.findContent(object3, pDFReader);
            }
        }
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        this.fexact_ = false;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.equals("-exact")) {
                this.setExact(true);
                continue;
            }
            if (string.startsWith("-font")) {
                this.setPlainFonts(true);
                continue;
            }
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fmonitor_ = true;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        Uncompress uncompress = new Uncompress((PDFReader)null);
        int n = uncompress.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                uncompress.pdfr_ = new PDFReader(file);
                boolean bl = uncompress.setPassword(uncompress.password_);
                if (!bl) {
                    System.err.println(file + " -- invalid OWNER password");
                    continue;
                }
                String string = file.getPath();
                if (file.getName().toLowerCase().endsWith(".pdf")) {
                    string = string.substring(0, string.length() - 4);
                }
                File file2 = new File(string + "-u.pdf");
                uncompress.writeFile(file2);
                if (!uncompress.fquiet_) {
                    String string2 = file2.getName();
                    uncompress.out_.println(file2.getName() + " is UNCOMPRESSED" + (uncompress.fexact_ ? "" : " and pretty-printed") + ", and can be edited");
                }
                if (!uncompress.fverbose_) continue;
                uncompress.out_.println("file length " + file.length() + " => " + file2.length());
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
            }
            finally {
                if (uncompress.pdfr_ == null) continue;
                try {
                    uncompress.pdfr_.close();
                }
                catch (IOException iOException) {}
            }
        }
        System.exit(0);
    }
}

