/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IMeta;
import org.xmind.core.IMetaData;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.internal.MetaData;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataImpl
extends MetaData {
    private Element implementation;
    private MetaImpl ownedMeta;

    public MetaDataImpl(Element implementation, MetaImpl ownedMeta) {
        this.implementation = implementation;
        this.ownedMeta = ownedMeta;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MetaDataImpl)) {
            return false;
        }
        MetaDataImpl that = (MetaDataImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.getImplementation());
        }
        return super.getAdapter(adapter);
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public void addMetaData(IMetaData data) {
        Element mdEle = ((MetaDataImpl)data).getImplementation();
        this.implementation.appendChild(mdEle);
    }

    @Override
    public void removeMetaData(IMetaData data) {
        Element mdEle = ((MetaDataImpl)data).getImplementation();
        this.implementation.removeChild(mdEle);
    }

    @Override
    public String getAttribute(String key) {
        return DOMUtils.getAttribute(this.implementation, key);
    }

    @Override
    public String getKey() {
        return this.implementation.getTagName();
    }

    @Override
    public IMetaData[] getMetaData(String key) {
        ArrayList<MetaDataImpl> list = new ArrayList<MetaDataImpl>();
        Iterator<Element> it = DOMUtils.childElementIterByTag(this.implementation, key);
        while (it.hasNext()) {
            Element mdEle = it.next();
            list.add(this.ownedMeta.getMetaData(mdEle));
        }
        return list.toArray(new IMetaData[list.size()]);
    }

    @Override
    public IMeta getOwnedMeta() {
        return this.ownedMeta;
    }

    @Override
    public String getValue() {
        return this.implementation.getTextContent();
    }

    protected String getKeyPath() {
        StringBuilder sb = new StringBuilder(20);
        Element e = this.implementation;
        sb.insert(0, e.getTagName());
        Node p = e.getParentNode();
        Element metaElement = this.ownedMeta.getMetaElement();
        while (p != null && p != e && p != metaElement && p instanceof Element) {
            e = (Element)p;
            sb.insert(0, "/");
            sb.insert(0, e.getTagName());
            p = e.getParentNode();
        }
        return sb.toString();
    }

    @Override
    public void setAttribute(String key, String value) {
        String oldValue = DOMUtils.getAttribute(this.implementation, key);
        DOMUtils.setAttribute(this.implementation, key, value);
        String newValue = DOMUtils.getAttribute(this.implementation, key);
        if (!(oldValue == newValue || oldValue != null && oldValue.equals(newValue))) {
            CoreEvent event = new CoreEvent((ICoreEventSource)this.ownedMeta, "metadataAttribute", (Object)this.getKeyPath(), (Object)oldValue, newValue);
            event.setData(key);
            this.ownedMeta.getCoreEventSupport().dispatch(this.ownedMeta, event);
        }
    }

    @Override
    public void setValue(String value) {
        String oldValue = this.implementation.getTextContent();
        this.implementation.setTextContent(value);
        String newValue = this.implementation.getTextContent();
        if (!oldValue.equals(newValue)) {
            this.ownedMeta.getCoreEventSupport().dispatchTargetValueChange(this.ownedMeta, "metadata", this.getKeyPath(), oldValue, newValue);
        }
    }
}

