/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.json.JSONObject;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.MonitoredOutputTarget;
import org.xmind.seawind.internal.core.SSerializable;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;

public class SyncConstraint {
    private static final String STATES_JSON = "syncState.json";
    private IStorage storage;
    private Map<String, SyncState> states = new HashMap<String, SyncState>();

    public SyncConstraint(IStorage storage) {
        this.storage = storage;
        JSONObject json = this.loadSyncStates();
        Iterator iterator = json.keySet().iterator();
        while (iterator.hasNext()) {
            String workbookId;
            JSONObject stateJson = json.optJSONObject(workbookId = (String)iterator.next());
            this.states.put(workbookId, new SyncState(stateJson == null ? new JSONObject() : stateJson));
        }
    }

    public synchronized void register(String workbookId, SyncState state) {
        this.states.put(workbookId, state);
        this.save(null);
    }

    public synchronized void unregister(String workbookId) {
        this.states.remove(workbookId);
        this.save(null);
    }

    public Set<String> getWorkbookIds() {
        return this.states.keySet();
    }

    public SyncState getSyncState(String workbookId) {
        return this.states.get(workbookId);
    }

    private JSONObject loadSyncStates() {
        try {
            return JSON.readOrCreateObjectWithDamageCheck((IStorage)this.storage, (String)STATES_JSON);
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, e.getMessage());
            return new JSONObject();
        }
    }

    public void save(IProgressMonitor monitor) {
        if (this.storage == null) {
            return;
        }
        JSONObject json = new JSONObject();
        for (String workbookId : this.states.keySet()) {
            json.put(workbookId, (Object)this.states.get(workbookId).toJSON());
        }
        try {
            JSON.writeObject((JSONObject)json, (IOutputTarget)new MonitoredOutputTarget(this.storage.getOutputTarget(), monitor), (String)STATES_JSON);
        }
        catch (IOException | OperationCanceledException e) {
            SeawindUIPlugin.log(e, e.getMessage());
        }
    }

    static class SyncState
    implements SSerializable {
        private static final String KEY_NEW_FILE_GENERATED_BY_CONFLICT = "newFileGeneratedByConflict";
        private static final String ATTR_CONFLICT_SOURCE = "conflictSource";
        private static final String ATTR_SHEETS_MAPPING = "sheetsMapping";
        private static final String KEY_NEW_FILE_GENERATED_BY_OTHER_CLIENT = "newFileGeneratedByOtherClient";
        private static final String ATTR_NEW_FILE_DOWNLOAD_UNFINISHED = "newFileDownloadUnfinished";
        private static final String KEY_LOCAL_FILE = "localFile";
        private static final String ATTR_RESOURCE_UPLOAD_UNFINISHED = "resourceUploadUnfinished";
        private static final String ATTR_CONFLICTING = "conflicting";
        String conflictSource;
        JSONObject sheetsMapping;
        boolean newFileDownloadUnfinished;
        boolean resourceUploadUnfinished;
        boolean conflicting;
        boolean covering;

        public SyncState(JSONObject json) {
            this.init(json);
        }

        void init(JSONObject json) {
            JSONObject localFileJsonObject;
            JSONObject newFileGeneratedByOtherClient;
            JSONObject newFileGeneratedByConflicteJsonObject = json.optJSONObject(KEY_NEW_FILE_GENERATED_BY_CONFLICT);
            if (newFileGeneratedByConflicteJsonObject != null) {
                this.conflictSource = newFileGeneratedByConflicteJsonObject.optString(ATTR_CONFLICT_SOURCE);
                this.sheetsMapping = newFileGeneratedByConflicteJsonObject.optJSONObject(ATTR_SHEETS_MAPPING);
                if (this.sheetsMapping == null) {
                    this.sheetsMapping = new JSONObject();
                }
            }
            if ((newFileGeneratedByOtherClient = json.optJSONObject(KEY_NEW_FILE_GENERATED_BY_OTHER_CLIENT)) != null) {
                this.newFileDownloadUnfinished = newFileGeneratedByOtherClient.optBoolean(ATTR_NEW_FILE_DOWNLOAD_UNFINISHED);
            }
            if ((localFileJsonObject = json.optJSONObject(KEY_LOCAL_FILE)) != null) {
                this.resourceUploadUnfinished = localFileJsonObject.optBoolean(ATTR_RESOURCE_UPLOAD_UNFINISHED);
                this.conflicting = localFileJsonObject.optBoolean(ATTR_CONFLICTING);
            }
        }

        public JSONObject toJSON() {
            JSONObject obj = new JSONObject();
            if (this.conflictSource != null) {
                JSONObject newFileGeneratedByConflicteJsonObject = new JSONObject();
                newFileGeneratedByConflicteJsonObject.put(ATTR_CONFLICT_SOURCE, (Object)this.conflictSource);
                newFileGeneratedByConflicteJsonObject.put(ATTR_SHEETS_MAPPING, (Object)this.sheetsMapping);
                obj.put(KEY_NEW_FILE_GENERATED_BY_CONFLICT, (Object)newFileGeneratedByConflicteJsonObject);
            }
            if (this.newFileDownloadUnfinished) {
                JSONObject newFileGeneratedByOtherClient = new JSONObject();
                newFileGeneratedByOtherClient.put(ATTR_NEW_FILE_DOWNLOAD_UNFINISHED, this.newFileDownloadUnfinished);
                obj.put(KEY_NEW_FILE_GENERATED_BY_OTHER_CLIENT, (Object)newFileGeneratedByOtherClient);
            }
            if (this.conflicting || this.resourceUploadUnfinished) {
                JSONObject localFileJsonObject = new JSONObject();
                localFileJsonObject.put(ATTR_CONFLICTING, this.conflicting);
                localFileJsonObject.put(ATTR_RESOURCE_UPLOAD_UNFINISHED, this.resourceUploadUnfinished);
                obj.put(KEY_LOCAL_FILE, (Object)localFileJsonObject);
            }
            return obj;
        }

        boolean isNone() {
            return this.conflictSource == null && this.sheetsMapping == null && !this.newFileDownloadUnfinished && !this.conflicting && !this.resourceUploadUnfinished;
        }

        void reset() {
            this.conflictSource = null;
            this.sheetsMapping = null;
            this.newFileDownloadUnfinished = false;
            this.conflicting = false;
            this.resourceUploadUnfinished = false;
        }
    }
}

