/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.dashboard;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.xmind.gef.IDecorator;
import org.xmind.gef.IViewer;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FrameBorderLayout;
import org.xmind.ui.gallery.FrameDecorator;
import org.xmind.ui.gallery.FrameFigure;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryPartFactory;
import org.xmind.ui.internal.seawind.dashboard.CloudMapLabelProvider;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class CloudMapGalleryPartFactory
extends GalleryPartFactory {
    protected IPart createFramePart(IPart parent, Object model) {
        return new CloudMapFramePart(model);
    }

    private static class CloudMapFrameDecorator
    extends FrameDecorator {
        public static final CloudMapFrameDecorator DEFAULT = new CloudMapFrameDecorator();

        private CloudMapFrameDecorator() {
        }

        public void decorate(IGraphicalPart part, IFigure figure) {
            super.decorate(part, figure);
            IFigure f = part.getFigure();
            Object model = part.getModel();
            IViewer viewer = part.getSite().getViewer();
            IBaseLabelProvider labelProvider = (IBaseLabelProvider)viewer.getAdapter(IBaseLabelProvider.class);
            if (f instanceof CloudMapFrameFigure && labelProvider instanceof CloudMapLabelProvider) {
                this.decorateSubTitle(((CloudMapFrameFigure)f).getSubTitle(), model, (CloudMapLabelProvider)labelProvider);
            }
        }

        private void decorateSubTitle(ITextFigure subTitle, Object model, CloudMapLabelProvider labelProvider) {
            String text = labelProvider.getSubtitle(model);
            if (text == null) {
                return;
            }
            subTitle.setText(text);
            subTitle.setForegroundColor((Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#8f8f8f")));
            Font countFont = subTitle.getFont();
            if (countFont != null) {
                FontData[] fontData = countFont.getFontData();
                FontData[] newFontData = FontUtils.newHeight((FontData[])fontData, (int)(Util.isMac() ? 9 : 7));
                subTitle.setFont((Font)JFaceResources.getResources().get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])newFontData)));
            }
        }
    }

    private static class CloudMapFrameFigure
    extends FrameFigure {
        private RotatableWrapLabel subTitle;
        Color subTitleColor = (Color)JFaceResources.getResources().get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#8f8f8f"));

        public CloudMapFrameFigure() {
            this.subTitle = new RotatableWrapLabel(0);
            this.subTitle.setTextAlignment(2);
            this.subTitle.setEnabled(false);
            this.subTitle.setAbbreviated(true);
            this.subTitle.setForegroundColor(this.subTitleColor);
            this.getTitleContainer().add((IFigure)this.subTitle, (Object)FrameBorderLayout.BOTTOM);
        }

        public ITextFigure getSubTitle() {
            return this.subTitle;
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            this.subTitle.setForegroundColor(selected ? ColorConstants.white : this.subTitleColor);
        }
    }

    private static class CloudMapFramePart
    extends FramePart {
        public CloudMapFramePart(Object model) {
            super(model);
            this.setDecorator((IDecorator)CloudMapFrameDecorator.DEFAULT);
        }

        protected IFigure createFigure() {
            CloudMapFrameFigure figure = new CloudMapFrameFigure();
            Properties properties = this.getSite().getViewer().getProperties();
            boolean useAdvancedRenderer = properties.getBoolean("renderTextAsPath", false);
            figure.setTitleRenderStyle(useAdvancedRenderer ? 1 : 0);
            return figure;
        }
    }
}

