/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.handlers;

import java.net.URI;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;

public class OpenCloudWorkbooksHandler {
    public static void openFile(URI uri) {
        OpenCloudWorkbooksHandler.executeCommand("org.xmind.ui.command.openWorkbook", "org.xmind.ui.command.openWorkbook.uri", uri);
    }

    private static void executeCommand(String commandId, String parameter, URI uri) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        EHandlerService hs = (EHandlerService)window.getService(EHandlerService.class);
        ECommandService cs = (ECommandService)window.getService(ECommandService.class);
        if (hs == null || cs == null) {
            return;
        }
        Command command = cs.getCommand(commandId);
        if (command == null || !command.isDefined()) {
            return;
        }
        try {
            IParameter param = command.getParameter(parameter);
            if (param == null) {
                return;
            }
            ParameterizedCommand pc = new ParameterizedCommand(command, new Parameterization[]{new Parameterization(param, uri.toString())});
            if (!hs.canExecute(pc)) {
                return;
            }
            hs.executeHandler(pc);
        }
        catch (NotDefinedException e) {
            SeawindUIPlugin.log(e, "-->execute openLocalFileHandler or openCloudFileHandler");
        }
    }
}

