/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.viewers.SWTUtils;

public class CheckListViewer
extends StructuredViewer
implements ICheckable {
    private static Color selectionBackground = null;
    private static Color selectionTextColor = null;
    private Composite list;
    private List<Object> listMap = new ArrayList<Object>();
    private List<CheckItem> items = new ArrayList<CheckItem>();
    private List<ICheckStateListener> checkStateListeners = new ArrayList<ICheckStateListener>();
    private CheckItem selectedItem = null;

    protected static Color getSelectionBackground() {
        if (selectionBackground == null) {
            selectionBackground = ColorConstants.lightBlue;
        }
        return selectionBackground;
    }

    protected static Color getSelectionTextColor() {
        if (selectionTextColor == null) {
            selectionTextColor = Display.getCurrent().getSystemColor(2);
        }
        return selectionTextColor;
    }

    public CheckListViewer(Composite parent, int style) {
        this.list = new Composite(parent, style){

            public boolean setFocus() {
                return super.forceFocus();
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size;
                if (CheckListViewer.this.getItemCount() == 0) {
                    size = new Point(0, 0);
                    if (wHint != -1) {
                        size.x = wHint;
                    }
                    if (hHint != -1) {
                        size.y = hHint;
                    }
                    Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
                    size = new Point(trim.width, trim.height);
                } else {
                    size = super.computeSize(wHint, hHint, changed);
                }
                return size;
            }
        };
        this.list.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                int keyCode = event.keyCode;
                int stateMask = event.stateMask;
                if (keyCode == 9) {
                    if (stateMask == SWT.MOD2) {
                        CheckListViewer.this.list.traverse(8);
                    } else if (stateMask == 0) {
                        CheckListViewer.this.list.traverse(16);
                    }
                } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 13)) {
                    CheckItem item = CheckListViewer.this.getSelectedItem();
                    if (item != null) {
                        item.userOpen(event);
                    }
                } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 32)) {
                    if (CheckListViewer.this.selectedItem != null) {
                        CheckListViewer.this.selectedItem.setChecked(!CheckListViewer.this.selectedItem.isChecked());
                        CheckListViewer.this.fireChecked(CheckListViewer.this.selectedItem);
                    }
                } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000001)) {
                    if (CheckListViewer.this.selectedItem != null) {
                        CheckListViewer.this.userSelectPrevious(CheckListViewer.this.selectedItem, event);
                    } else if (!CheckListViewer.this.items.isEmpty()) {
                        CheckListViewer.this.userSelectItem(0, event);
                    }
                } else if (SWTUtils.matchKey(stateMask, keyCode, 0, 0x1000002)) {
                    if (CheckListViewer.this.selectedItem != null) {
                        CheckListViewer.this.userSelectNext(CheckListViewer.this.selectedItem, event);
                    } else if (!CheckListViewer.this.items.isEmpty()) {
                        CheckListViewer.this.userSelectItem(0, event);
                    }
                }
            }
        });
        this.list.setTabList(new Control[0]);
        this.list.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.list);
        this.list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CheckListViewer.this.handleDispose(e);
            }
        });
    }

    protected void userSelectPrevious(CheckItem item, Event event) {
        int index = this.items.indexOf(item);
        if (index >= 1) {
            this.userSelectItem(--index, event);
        }
    }

    private void userSelectItem(int index, Event event) {
        this.setSelectedItem(this.items.get(index));
        this.handleSelect(new SelectionEvent(event));
    }

    protected void userSelectNext(CheckItem item, Event event) {
        int index = this.items.indexOf(item);
        if (index < this.listGetItemCount() - 1) {
            this.userSelectItem(++index, event);
        }
    }

    protected void setSelectedItem(CheckItem item) {
        if (item == this.selectedItem) {
            return;
        }
        this.selectedItem = item;
        for (CheckItem it : this.items) {
            it.setSelection(it == item);
        }
    }

    protected CheckItem getSelectedItem() {
        return this.selectedItem;
    }

    public Control getControl() {
        return this.list;
    }

    protected Composite getListComposite() {
        return this.list;
    }

    protected List<CheckItem> getItems() {
        return this.items;
    }

    public int getItemCount() {
        return this.listGetItemCount();
    }

    protected CheckItem listAdd(String string, Image image, int index) {
        CheckItem newItem = new CheckItem(this, this.list);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(newItem.getControl());
        newItem.setImage(image);
        newItem.setText(string);
        this.list.layout();
        if (index < 0 || index >= this.listGetItemCount()) {
            this.items.add(newItem);
        } else {
            CheckItem oldItem = this.items.get(index);
            this.items.add(index, newItem);
            newItem.getControl().moveAbove(oldItem.getControl());
        }
        return newItem;
    }

    protected void listDeselectAll() {
        this.setSelectedItem(null);
    }

    protected int listGetItemCount() {
        return this.items.size();
    }

    protected int[] listGetSelectionIndices() {
        int total = this.listGetItemCount();
        int[] counts = new int[total];
        int num = 0;
        int j = 0;
        int i = 0;
        while (i < total) {
            CheckItem item = this.items.get(i);
            if (item.isSelected()) {
                counts[j] = i;
                ++num;
                ++j;
            }
            ++i;
        }
        int[] ixs = new int[num];
        System.arraycopy(counts, 0, ixs, 0, num);
        return ixs;
    }

    protected CheckItem listRemove(int index) {
        if (index < 0 || index >= this.listGetItemCount()) {
            return null;
        }
        CheckItem item = this.items.remove(index);
        if (item != null) {
            item.dispose();
        }
        return item;
    }

    protected void listRemoveAll() {
        for (CheckItem item : this.items) {
            item.dispose();
        }
        this.items.clear();
    }

    protected void listSetItem(int index, String string, Image image) {
        if (index < 0 || index >= this.listGetItemCount()) {
            return;
        }
        CheckItem item = this.items.get(index);
        if (!item.isDisposed()) {
            item.setImage(image);
            item.setText(string);
        }
    }

    protected void listSetSelection(int[] ixs) {
        this.listDeselectAll();
        int total = this.listGetItemCount();
        int[] nArray = ixs;
        int n = ixs.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index >= 0 && index < total) {
                CheckItem item = this.items.get(index);
                if (this.selectedItem == null) {
                    this.selectedItem = item;
                }
                item.setSelection(true);
            }
            ++n2;
        }
    }

    protected void listShowSelection() {
    }

    public void reveal(Object element) {
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add(listener);
    }

    public boolean getChecked(Object element) {
        int index = this.getElementIndex(element);
        if (index >= 0) {
            CheckItem item = this.items.get(index);
            return !item.isDisposed() && item.isChecked();
        }
        return false;
    }

    public Object[] getCheckedElements() {
        int count = this.getItemCount();
        ArrayList<Object> checked = new ArrayList<Object>(count);
        int i = 0;
        while (i < count) {
            CheckItem item = this.items.get(i);
            if (item.isChecked()) {
                checked.add(this.listMap.get(i));
            }
            ++i;
        }
        return checked.toArray();
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove(listener);
    }

    public boolean setChecked(Object element, boolean state) {
        CheckItem item;
        int index = this.getElementIndex(element);
        if (index >= 0 && !(item = this.items.get(index)).isDisposed()) {
            item.setChecked(state);
        }
        return false;
    }

    protected void fireChecked(CheckItem item) {
        Object element = this.getElementAt(this.items.indexOf(item));
        if (element == null) {
            return;
        }
        final CheckStateChangedEvent event = new CheckStateChangedEvent((ICheckable)this, element, item.isChecked());
        Object[] objectArray = this.checkStateListeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object o = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((ICheckStateListener)o).checkStateChanged(event);
                }
            });
            ++n2;
        }
    }

    protected void preservingSelection(Runnable updateCode) {
        Object element;
        HashMap<Object, Boolean> checkStateMap = new HashMap<Object, Boolean>();
        int total = this.listGetItemCount();
        int i = 0;
        while (i < total) {
            element = this.getElementAt(i);
            boolean checked = this.items.get(i).isChecked();
            checkStateMap.put(element, checked);
            ++i;
        }
        super.preservingSelection(updateCode);
        total = this.listGetItemCount();
        i = 0;
        while (i < total) {
            element = this.getElementAt(i);
            Boolean checked = (Boolean)checkStateMap.get(element);
            if (checked != null) {
                this.items.get(i).setChecked(checked);
            }
            ++i;
        }
    }

    public void add(Object[] elements) {
        this.assertElementsNotNull(elements);
        Object[] filtered = this.filter(elements);
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int ix = this.indexForElement(element);
            this.insertItem(labelProvider, element, ix);
            ++i;
        }
    }

    private void insertItem(ILabelProvider labelProvider, Object element, int index) {
        String label = this.getLabelProviderText(labelProvider, element);
        Image image = this.getImage(labelProvider, element);
        CheckItem item = this.listAdd(label, image, index);
        this.listMap.add(index, element);
        this.mapElement(element, (Widget)item.getControl());
    }

    public void insert(Object element, int position) {
        if (this.getComparator() != null || this.hasFilters()) {
            this.add(element);
            return;
        }
        this.insertItem((ILabelProvider)this.getLabelProvider(), element, position);
    }

    private String getLabelProviderText(ILabelProvider labelProvider, Object element) {
        String text = labelProvider.getText(element);
        if (text == null) {
            return "";
        }
        return text;
    }

    private Image getImage(ILabelProvider labelProvider, Object element) {
        return labelProvider.getImage(element);
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    protected Widget doFindInputItem(Object element) {
        if (element != null && this.equals(element, this.getRoot())) {
            return this.getControl();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        int index;
        if (element != null && (index = this.getElementIndex(element)) >= 0) {
            return this.items.get(index).getControl();
        }
        return null;
    }

    protected void doUpdateItem(Widget data, Object element, boolean fullMap) {
        int ix;
        if (element != null && (ix = this.getElementIndex(element)) >= 0) {
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            String label = this.getLabelProviderText(labelProvider, element);
            Image image = this.getImage(labelProvider, element);
            this.listSetItem(ix, label, image);
        }
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.listMap.size()) {
            return this.listMap.get(index);
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        int[] ixs = this.listGetSelectionIndices();
        ArrayList<Object> list = new ArrayList<Object>(ixs.length);
        int i = 0;
        while (i < ixs.length) {
            Object e = this.getElementAt(ixs[i]);
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    protected int indexForElement(Object element) {
        ViewerComparator comparator = this.getComparator();
        if (comparator == null) {
            return this.listGetItemCount();
        }
        int count = this.listGetItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.listMap.get(mid);
            int compare = comparator.compare((Viewer)this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.listMap.get(mid);
                    compare = comparator.compare((Viewer)this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.listMap.clear();
        Object[] children = this.getSortedChildren(this.getRoot());
        int size = children.length;
        this.listRemoveAll();
        int i = 0;
        while (i < size) {
            Object el = children[i];
            String label = this.getLabelProviderText((ILabelProvider)this.getLabelProvider(), el);
            Image image = this.getImage((ILabelProvider)this.getLabelProvider(), el);
            CheckItem item = this.listAdd(label, image, -1);
            this.listMap.add(el);
            this.mapElement(el, (Widget)item.getControl());
            ++i;
        }
    }

    protected void internalRefresh(Object element) {
        Control list = this.getControl();
        if (element == null || this.equals(element, this.getRoot())) {
            if (this.listMap != null) {
                this.listMap.clear();
            }
            this.unmapAllElements();
            List selection = this.getSelectionFromWidget();
            int topIndex = -1;
            if (selection == null || selection.isEmpty()) {
                topIndex = this.listGetTopIndex();
            }
            list.setRedraw(false);
            this.listRemoveAll();
            Object[] children = this.getSortedChildren(this.getRoot());
            ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
            int i = 0;
            while (i < children.length) {
                Object el = children[i];
                String label = this.getLabelProviderText(labelProvider, el);
                Image image = this.getImage(labelProvider, el);
                CheckItem item = this.listAdd(label, image, -1);
                this.listMap.add(el);
                this.mapElement(el, (Widget)item.getControl());
                ++i;
            }
            list.setRedraw(true);
            if (topIndex == -1) {
                this.setSelectionToWidget(selection, false);
            } else {
                this.listSetTopIndex(Math.min(topIndex, children.length));
            }
        } else {
            this.doUpdateItem((Widget)list, element, true);
        }
    }

    protected int listGetTopIndex() {
        return -1;
    }

    protected void listSetTopIndex(int index) {
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            int ix = this.getElementIndex(elements[i]);
            if (ix >= 0) {
                CheckItem item = this.listRemove(ix);
                this.listMap.remove(ix);
                this.unmapElement(elements[i], (Widget)item.getControl());
            }
            ++i;
        }
    }

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        if (elements.length == 0) {
            return;
        }
        this.preservingSelection(new Runnable(){

            @Override
            public void run() {
                CheckListViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    protected void setSelectionToWidget(List in, boolean reveal) {
        if (in == null || in.size() == 0) {
            this.listDeselectAll();
        } else {
            int n = in.size();
            int[] ixs = new int[n];
            int count = 0;
            int i = 0;
            while (i < n) {
                Object el = in.get(i);
                int ix = this.getElementIndex(el);
                if (ix >= 0) {
                    ixs[count++] = ix;
                }
                ++i;
            }
            if (count < n) {
                int[] nArray = ixs;
                ixs = new int[count];
                System.arraycopy(nArray, 0, ixs, 0, count);
            }
            this.listSetSelection(ixs);
            if (reveal) {
                this.listShowSelection();
            }
        }
    }

    protected int getElementIndex(Object element) {
        IElementComparer comparer = this.getComparer();
        if (comparer == null) {
            return this.listMap.indexOf(element);
        }
        int size = this.listMap.size();
        int i = 0;
        while (i < size) {
            if (comparer.equals(element, this.listMap.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static class CheckItem {
        private CheckListViewer listViewer;
        private Object data;
        private Composite bar;
        private Button checkbox;
        private Label imageLabel;
        private Label textLabel;
        private boolean selected;
        private boolean internalSetChecked = false;

        public CheckItem(CheckListViewer listViewer, Composite parent) {
            this.listViewer = listViewer;
            this.bar = new Composite(parent, 524288);
            this.bar.setBackground(parent.getBackground());
            this.bar.setData((Object)this);
            GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(5, 5, 1, 1).applyTo(this.bar);
            this.checkbox = new Button(this.bar, 32);
            this.checkbox.setText("");
            this.checkbox.setBackground(this.bar.getBackground());
            GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)this.checkbox);
            this.imageLabel = new Label(this.bar, 0);
            this.imageLabel.setImage(null);
            this.imageLabel.setBackground(this.bar.getBackground());
            GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)this.imageLabel);
            this.textLabel = new Label(this.bar, 0);
            this.textLabel.setText("");
            this.textLabel.setBackground(this.bar.getBackground());
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.textLabel);
            this.addControlListeners();
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public CheckListViewer getListViewer() {
            return this.listViewer;
        }

        public Control getControl() {
            return this.bar;
        }

        protected Composite getBarComposite() {
            return this.bar;
        }

        protected void addControlListeners() {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    int type = event.type;
                    switch (type) {
                        case 9: {
                            this.paintBackground(event.gc);
                            break;
                        }
                        case 3: {
                            if (event.widget == checkbox) {
                                this.selectSingle();
                                break;
                            }
                            this.userSelect(event);
                            if ((OpenStrategy.getOpenMethod() & 1) == 0) break;
                            this.userOpen(event);
                            break;
                        }
                        case 8: {
                            if (OpenStrategy.getOpenMethod() != 0) break;
                            this.userOpen(event);
                            break;
                        }
                        case 32: {
                            if ((OpenStrategy.getOpenMethod() & 2) == 0) break;
                            this.userSelect(event);
                            break;
                        }
                        case 13: {
                            if (internalSetChecked) break;
                            this.userCheck();
                        }
                    }
                }
            };
            this.bar.addListener(9, listener);
            this.bar.addListener(3, listener);
            this.bar.addListener(8, listener);
            this.bar.addListener(32, listener);
            this.imageLabel.addListener(3, listener);
            this.imageLabel.addListener(8, listener);
            this.imageLabel.addListener(32, listener);
            this.textLabel.addListener(3, listener);
            this.textLabel.addListener(8, listener);
            this.textLabel.addListener(32, listener);
            this.checkbox.addListener(3, listener);
            this.checkbox.addListener(13, listener);
        }

        protected void userCheck() {
            this.getListViewer().fireChecked(this);
        }

        protected void paintBackground(GC gc) {
            if (this.isSelected()) {
                Rectangle bounds = this.bar.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                gc.setBackground(CheckListViewer.getSelectionBackground());
                gc.fillRectangle(bounds);
            }
        }

        protected void userSelect(Event e) {
            this.selectSingle();
            this.getListViewer().getControl().setFocus();
            this.getListViewer().handleSelect(new SelectionEvent(e));
        }

        protected void userOpen(Event e) {
            this.selectSingle();
            this.getListViewer().getControl().setFocus();
            this.getListViewer().handleOpen(new SelectionEvent(e));
        }

        protected void selectSingle() {
            this.getListViewer().setSelectedItem(this);
        }

        public Button getCheckbox() {
            return this.checkbox;
        }

        public Label getLabel() {
            return this.textLabel;
        }

        public boolean isChecked() {
            return this.checkbox.getSelection();
        }

        public void setChecked(boolean checked) {
            this.internalSetChecked = true;
            this.checkbox.setSelection(checked);
            this.internalSetChecked = false;
        }

        public String getText() {
            return this.textLabel.getText();
        }

        public void setText(String text) {
            this.textLabel.setText(text);
        }

        public Image getImage() {
            return this.imageLabel.getImage();
        }

        public void setImage(Image image) {
            this.imageLabel.setImage(image);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelection(boolean selected) {
            if (selected == this.selected) {
                return;
            }
            this.selected = selected;
            this.bar.redraw();
            this.textLabel.redraw();
            if (selected) {
                this.checkbox.setBackground(CheckListViewer.getSelectionBackground());
                this.imageLabel.setBackground(CheckListViewer.getSelectionBackground());
                this.textLabel.setBackground(CheckListViewer.getSelectionBackground());
                this.textLabel.setForeground(CheckListViewer.getSelectionTextColor());
            } else {
                Color background = this.bar.getBackground();
                this.checkbox.setBackground(background);
                this.imageLabel.setBackground(background);
                this.textLabel.setBackground(background);
                this.textLabel.setForeground(null);
            }
        }

        public void dispose() {
            this.bar.dispose();
        }

        public boolean isDisposed() {
            return this.bar.isDisposed();
        }
    }
}

