/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote.export;

import com.evernote.auth.EvernoteService;
import com.evernote.edam.type.Notebook;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.evernote.EvernotePlugin;
import org.xmind.ui.internal.evernote.EvernoteMessages;
import org.xmind.ui.resources.FontUtils;

public class EvernoteExportDialog
extends Dialog {
    private static final String SECTION_NAME = "org.xmind.ui.evernote.export";
    private static final String EVERNOTE_LOGO = "icons/evernote_logo.png";
    private static final String YINXIANG_LOGO = "icons/yinxiang_logo.png";
    private static final String PROPERTY_NAME = "PROPERTY_NAME";
    private final Map<String, Widget> widgets = new HashMap<String, Widget>();
    private Map<Integer, Notebook> notebookMaps = new HashMap<Integer, Notebook>();
    private Set<String> propertyNames;
    private Listener widgetListener = null;
    private List<Notebook> notebooks;
    private EvernoteService evernoteService;
    private Combo notebookCombo;

    public EvernoteExportDialog(Shell parentShell, List<Notebook> notebooks) {
        super(parentShell);
        this.notebooks = notebooks;
    }

    public EvernoteExportDialog(Shell parentShell, List<Notebook> notebooks, EvernoteService evernoteService) {
        this(parentShell, notebooks);
        this.evernoteService = evernoteService;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.updateButtons();
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EvernoteMessages.EvernoteExportDialog_title);
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)super.createButtonBar(parent);
        GridLayout layout = (GridLayout)buttonBar.getLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.marginTop = 0;
        layout.marginBottom = 3;
        Button okButton = this.getButton(0);
        okButton.setText(EvernoteMessages.EvernoteExportDialog_SaveButton_label);
        okButton.setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.marginBottom = -10;
        this.createSettingArea(composite);
        return composite;
    }

    private void createSettingArea(Composite parent) {
        Composite setting = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginBottom = 0;
        setting.setLayout((Layout)layout);
        setting.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContentArea(setting);
        this.createAdditionArea(setting);
    }

    private void createContentArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginRight = 25;
        layout.verticalSpacing = 2;
        content.setLayout((Layout)layout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createOptionArea(content);
        if (EvernoteService.YINXIANG.name().equals(this.evernoteService.name())) {
            this.createImageLabel(content, YINXIANG_LOGO);
        } else {
            this.createImageLabel(content, EVERNOTE_LOGO);
        }
    }

    private void createOptionArea(Composite parent) {
        this.propertyNames = new HashSet<String>();
        Composite option = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginRight = 5;
        option.setLayout((Layout)layout);
        this.createLabel(option, EvernoteMessages.EvernoteExportDialog_Content_label);
        this.createCheckButton(option, "includeImage");
        this.createCheckButton(option, "includeFile");
        this.createCheckButton(option, "includeText");
        this.setDefaultCheckButton();
    }

    private void createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
    }

    private void createCheckButton(Composite parent, String propertyName) {
        this.createCheckButton(parent, propertyName, this.getDefaultLabel(propertyName));
    }

    private void createCheckButton(Composite parent, String propertyName, String text) {
        Button check = new Button(parent, 32);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 16;
        check.setLayoutData((Object)data);
        check.setText(text);
        this.registerPropertyWidget(propertyName, (Widget)check);
        check.setSelection(this.getBoolean(propertyName));
        this.hookWidget((Widget)check, 13);
    }

    private String getDefaultLabel(String propertyName) {
        if ("includeImage".equals(propertyName)) {
            return EvernoteMessages.EvernoteExportDialog_IncludeImage;
        }
        if ("includeFile".equals(propertyName)) {
            return EvernoteMessages.EvernoteExportDialog_IncludeFile;
        }
        if ("includeText".equals(propertyName)) {
            return EvernoteMessages.EvernoteExportDialog_IncludeText;
        }
        return "";
    }

    private void createImageLabel(Composite parent, String imagePath) {
        Label image = new Label(parent, 0);
        URL url = Platform.getBundle((String)"org.xmind.ui.evernote").getEntry(imagePath);
        if (url != null) {
            try {
                image.setImage(new Image(null, url.openStream()));
            }
            catch (IOException iOException) {}
        }
    }

    private void createAdditionArea(Composite parent) {
        Composite addition = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 10;
        layout.marginBottom = 0;
        addition.setLayout((Layout)layout);
        addition.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createNotebookArea(addition);
    }

    private void createNotebookArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        label.setText(EvernoteMessages.EvernoteExportDialog_Notebook_label);
        this.notebookCombo = new Combo(parent, 2060);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 160;
        this.notebookCombo.setLayoutData((Object)data);
        this.notebookCombo.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-1));
        this.notebookCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Notebook notebook = (Notebook)EvernoteExportDialog.this.notebookMaps.get(EvernoteExportDialog.this.notebookCombo.getSelectionIndex());
                EvernoteExportDialog.this.setValue("notebook", notebook.getName());
            }
        });
        for (Notebook notebook : this.notebooks) {
            String name = notebook.getName();
            if (name == null) continue;
            int index = this.notebookCombo.getItemCount();
            this.notebookCombo.add(notebook.getName());
            this.notebookMaps.put(index, notebook);
            if (!notebook.isDefaultNotebook()) continue;
            this.notebookCombo.select(index);
            this.setValue("notebook", notebook.getName());
        }
    }

    private void registerPropertyWidget(String propertyName, Widget widget) {
        widget.setData(PROPERTY_NAME, (Object)propertyName);
        this.widgets.put(propertyName, widget);
        if (this.propertyNames != null) {
            this.propertyNames.add(propertyName);
        }
    }

    private void hookWidget(Widget widget, int eventType) {
        if (this.widgetListener == null) {
            this.widgetListener = new WidgetListener();
        }
        widget.addListener(eventType, this.widgetListener);
    }

    private void handleWidgetEvent(Event event) {
        Object propertyName = event.widget.getData(PROPERTY_NAME);
        if (propertyName instanceof String && event.widget instanceof Button) {
            this.setValue((String)propertyName, ((Button)event.widget).getSelection());
        }
    }

    private void setValue(String propertyName, boolean value) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(propertyName, value);
        this.updateButtons();
    }

    private void setValue(String propertyName, String value) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        dialogSettings.put(propertyName, value);
    }

    public IDialogSettings getDialogSettings() {
        return EvernotePlugin.getDialogSettings(SECTION_NAME);
    }

    private boolean getBoolean(String propertyName) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        return dialogSettings.getBoolean(propertyName);
    }

    private void updateButtons() {
        if (this.getBoolean("includeImage") || this.getBoolean("includeFile") || this.getBoolean("includeText")) {
            this.setOKEnabled(true);
        } else {
            this.setOKEnabled(false);
        }
    }

    private void setOKEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(enabled);
        }
    }

    private void setDefaultCheckButton() {
        if (!(this.getBoolean("includeImage") || this.getBoolean("includeFile") || this.getBoolean("includeText"))) {
            Button btImg = (Button)this.widgets.get("includeImage");
            btImg.setSelection(true);
            this.setValue("includeImage", btImg.getSelection());
            Button btFile = (Button)this.widgets.get("includeFile");
            btFile.setSelection(true);
            this.setValue("includeFile", btFile.getSelection());
        }
    }

    private class WidgetListener
    implements Listener {
        private WidgetListener() {
        }

        public void handleEvent(Event event) {
            EvernoteExportDialog.this.handleWidgetEvent(event);
        }
    }
}

