/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import org.xmind.core.IImage;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.plain.Topic;

public class Image
implements IImage,
ICoreEventSource {
    private Topic parent;
    private String source;
    private int width;
    private int height;
    private String alignment;

    public Image(Topic parent) {
        this.parent = parent;
        this.source = null;
        this.width = -1;
        this.height = -1;
        this.alignment = null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        if (ITopic.class.equals(adapter)) {
            return adapter.cast(this.getParent());
        }
        return null;
    }

    public ITopic getParent() {
        return this.parent;
    }

    public ISheet getOwnedSheet() {
        return this.parent.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.parent.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.parent.isOrphan();
    }

    public String getSource() {
        return this.source;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSource(String source) {
        String oldSource = this.source;
        if (source == oldSource || source != null && source.equals(oldSource)) {
            return;
        }
        this.source = source;
        this.parent.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "imageSource", (Object)oldSource, (Object)source);
    }

    public void setAlignment(String alignment) {
        String oldAlignment = this.alignment;
        if (alignment == oldAlignment || alignment != null && alignment.equals(oldAlignment)) {
            return;
        }
        this.alignment = alignment;
        this.parent.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "imageAlignment", (Object)oldAlignment, (Object)alignment);
    }

    public void setSize(int width, int height) {
        int oldWidth = this.width;
        int oldHeight = this.height;
        if (width == oldWidth && height == oldHeight) {
            return;
        }
        this.width = width;
        this.height = height;
        if (width != oldWidth) {
            this.parent.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "imageWidth", (Object)oldWidth, (Object)width);
        }
        if (height != oldHeight) {
            this.parent.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "imageHeight", (Object)oldHeight, (Object)height);
        }
    }

    public void setWidth(int width) {
        int oldWidth = this.width;
        if (width == oldWidth) {
            return;
        }
        this.width = width;
        this.parent.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "imageWidth", (Object)oldWidth, (Object)width);
    }

    public void setHeight(int height) {
        int oldHeight = this.height;
        if (height == oldHeight) {
            return;
        }
        this.height = height;
        this.parent.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "imageHeight", (Object)oldHeight, (Object)height);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.parent.getCoreEventSupport();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.parent.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }
}

