/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.seawind.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmind.core.Core;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.net.Entity;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpEntityProxy;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;
import org.xmind.core.net.http.IFinishHandler;
import org.xmind.core.net.http.IResponseHandler;
import org.xmind.core.net.http.InvalidResponseValueException;
import org.xmind.core.net.http.JSONEntity;
import org.xmind.core.net.http.MultipartEntity;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.util.Codec;
import org.xmind.core.util.FileUtils;
import org.xmind.seawind.internal.core.SeawindHttpException;
import org.xmind.seawind.internal.core.StorageEntryEntity;

public class SeawindClient {
    private static final boolean HTTPS = true;
    private static final String HOST_NET = "cloud.xmind.net";
    private static final String HOST_CN = "cloud.xmind.cn";
    private static final String BASE_PATH = "/seawind/";
    private static final String API_USER = "user";
    private static final String API_WORKBOOKS = "workbooks";
    private static final String API_FOLDERS = "folder";
    private static final String API_WORKBOOK_WITH_ID = "workbooks/%s";
    private static final String API_SHEET_WITH_WORKBOOK_ID_AND_SHEET_ID = "workbooks/%s/sheets/%s";
    private static final String API_SHEET_CONTENT_WITH_WORKBOOK_ID_AND_SHEET_ID = "workbooks/%s/sheets/%s/content.json";
    private static final String API_SHEET_PREVIEW_IMAGE_WITH_WORKBOOK_ID_AND_SHEET_ID = "workbooks/%s/sheets/%s/preview.png";
    private static final String API_SHEET_THUMBNAIL_IMAGE_WIT_WORKBOOK_ID_AND_SHEET_ID = "workbooks/%s/sheets/%s/thumbnail.png";
    private static final String API_RESOURCES = "attachments";
    private static final String API_RESOURCE_WITH_HASH = "attachments/%s";
    private static final String API_WORKBOOK_EXTENSIONS = "workbooks/%s/extensions.json";
    private static final String API_ACTIVATE = "activate";
    private static final String PARAM_WORKBOOK = "workbook";
    private static final String PARAM_SHEET = "sheet";
    private static final String PARAM_SHEET_CONTENT = "content.json";
    private static final String PARAM_SHEET_CONTENT_WITH_ID = "sheets/%s/content.json";
    private static final String PARAM_SHEET_PREVIEW = "preview.png";
    private static final String PARAM_SHEET_PREVIEW_WITH_ID = "sheets/%s/preview.png";
    private static final String PARAM_REV = "rev";
    private static final String PARAM_VALIDATED = "validated";
    private static final String HASH_SUFFIX = ".sha256";
    private static final int TOTAL_RETRY_NUM = 2;
    private static final int RETRY_DELAY_UNIT = 5000;
    private boolean debugging = false;
    private String authorization = null;
    private String xUserAgent = this.generateXUserAgent();
    private String xClientId;
    private boolean isCnUser;

    private String generateXUserAgent() {
        String productName = "XMind";
        String productVersion = System.getProperty("org.xmind.product.version");
        String buildId = System.getProperty("org.xmind.product.buildid");
        String xUserAgent = String.valueOf(productName) + "/" + productVersion + "/" + buildId;
        return xUserAgent;
    }

    public void setXClientId(String xClientId) {
        this.xClientId = xClientId;
    }

    public void debug() {
        this.debugging = true;
    }

    public boolean isAuthorized() {
        return this.authorization != null;
    }

    public void grantAuthorization(String userName, String authToken) {
        this.authorization = "Basic " + String.valueOf(EncodingUtils.base64Encode((byte[])EncodingUtils.toAsciiBytes((String)(String.valueOf(userName) + ":" + authToken))));
    }

    public void revokeAuthorization() {
        this.authorization = null;
    }

    private FieldSet authorized(FieldSet headers) {
        if (this.authorization == null) {
            return headers;
        }
        return headers.add("Authorization", (Object)this.authorization);
    }

    private FieldSet acceptAPIJSON(FieldSet headers) {
        return headers.add("Accept", (Object)"application/vnd.seawind.api+json; version=1");
    }

    private FieldSet xUserAgent(FieldSet headers) {
        return headers.add("X-User-Agent", (Object)this.xUserAgent);
    }

    private FieldSet xClientId(FieldSet headers) {
        return headers.add("X-Client-ID", (Object)this.xClientId);
    }

    private static JSONObject wrapData(Object data) {
        return new JSONObject().put("data", data);
    }

    private static JSONObject unwrapResponseData(HttpRequest request) throws HttpException {
        try {
            JSONObject response;
            Object data;
            Assert.isTrue((boolean)"application/vnd.seawind.api+json; version=1".equals(request.getResponseHeader("Content-Type")));
            String contentLength = request.getResponseHeader("Content-Length");
            if (contentLength != null && !contentLength.equals("")) {
                Assert.isTrue((request.getResponseBuffer().length == Integer.valueOf(contentLength) ? 1 : 0) != 0);
            }
            if ((data = (response = request.getResponseAsJSONChecked()).get("data")) instanceof String) {
                return new JSONObject((String)data);
            }
            Assert.isTrue((data != null && data instanceof JSONObject ? 1 : 0) != 0);
            return (JSONObject)data;
        }
        catch (InvalidResponseValueException e) {
            throw new HttpException(request, (Throwable)e);
        }
        catch (JSONException e) {
            throw new HttpException(request, (Throwable)e);
        }
        catch (Exception e) {
            throw new HttpException(request, (Throwable)e);
        }
    }

    private static HttpException unwrapErrorInfo(HttpException e) {
        return SeawindHttpException.unwrap(e);
    }

    private static HttpEntity makeEntity(JSONObject meta, String metaName, FieldSet files) {
        Assert.isLegal((metaName != null && !"".equals(metaName) ? 1 : 0) != 0);
        HttpEntityProxy metaEntity = new HttpEntityProxy((HttpEntity)new JSONEntity(SeawindClient.wrapData(meta), false), "application/vnd.seawind.api+json; version=1");
        FieldSet parts = new FieldSet().add(metaName, (Object)metaEntity);
        if (files != null && !files.isEmpty()) {
            parts.addAll(files);
        }
        return new MultipartEntity(parts);
    }

    private JSONObject execute(IProgressMonitor monitor, String api, FieldSet queries, String method, HttpEntity entity, ResponseValidator validator) throws HttpException, InterruptedException {
        HttpRequest request = this.makeRequest(api, queries, method, entity, null, new IFinishHandler(){

            public void handleRequestFinished(IProgressMonitor monitor, HttpRequest request) throws InterruptedException, IOException {
                String contentLength = request.getResponseHeader("Content-Length");
                if (contentLength != null && !contentLength.equals("")) {
                    Assert.isTrue((request.getResponseBuffer().length == Integer.valueOf(contentLength) ? 1 : 0) != 0);
                }
            }
        });
        if (!this.isAuthorized()) {
            throw new HttpException(request, 401, "Unauthorized", null);
        }
        this.executeRequestWithRetry(monitor, request, 0);
        JSONObject data = SeawindClient.unwrapResponseData(request);
        if (validator != null) {
            try {
                validator.validate(request, data);
            }
            catch (Exception e) {
                throw new HttpException(request, (Throwable)e);
            }
        }
        return data;
    }

    private HttpRequest makeRequest(String api, FieldSet queries, String method, HttpEntity entity, IResponseHandler responseHandler) {
        FieldSet headers = this.xClientId(this.xUserAgent(this.authorized(this.acceptAPIJSON(new FieldSet()))));
        HttpRequest request = new HttpRequest(true, this.getHost(), -1, BASE_PATH + api, queries, null, method, headers, entity, new FieldSet().add("connectTimeout", (Object)30000).add("readTimeout", (Object)30000), responseHandler);
        if (this.debugging) {
            request.debug(System.out);
        }
        return request;
    }

    private HttpRequest makeRequest(String api, FieldSet queries, String method, HttpEntity entity, IResponseHandler responseHandler, IFinishHandler finishHandler) {
        FieldSet headers = this.xClientId(this.xUserAgent(this.authorized(this.acceptAPIJSON(new FieldSet()))));
        HttpRequest request = new HttpRequest(true, this.getHost(), -1, BASE_PATH + api, queries, null, method, headers, entity, new FieldSet().add("connectTimeout", (Object)30000).add("readTimeout", (Object)30000), responseHandler);
        request.setFinishHandler(finishHandler);
        if (this.debugging) {
            request.debug(System.out);
        }
        return request;
    }

    public JSONObject downloadUserInfo(IProgressMonitor monitor) throws HttpException, InterruptedException {
        return this.execute(monitor, API_USER, null, "GET", null, null);
    }

    public JSONObject activate(IProgressMonitor monitor, String email, String license, String uuid) throws HttpException, InterruptedException {
        return this.execute(monitor, API_ACTIVATE, null, "POST", (HttpEntity)new HttpEntityProxy((HttpEntity)new JSONEntity(SeawindClient.wrapData(new JSONObject().put("key", (Object)SeawindClient.trimLicenseKey(license)).put("email", (Object)email.toLowerCase()).put("uuid", (Object)uuid)), false), "application/vnd.seawind.api+json; version=1"), null);
    }

    public JSONObject downloadFolderList(IProgressMonitor monitor) throws HttpException, InterruptedException {
        return this.execute(monitor, API_FOLDERS, null, "GET", null, null);
    }

    public JSONObject downloadWorkbookList(IProgressMonitor monitor) throws HttpException, InterruptedException {
        return this.execute(monitor, API_WORKBOOKS, null, "GET", null, null);
    }

    public JSONObject downloadWorkbook(IProgressMonitor monitor, final String workbookId) throws HttpException, InterruptedException {
        return this.execute(monitor, EncodingUtils.format((String)API_WORKBOOK_WITH_ID, (Object[])new Object[]{workbookId}), null, "GET", null, new ResponseValidator(){

            @Override
            public void validate(HttpRequest request, JSONObject data) throws Exception {
                Assert.isTrue((boolean)workbookId.equals(data.getString("id")));
            }
        });
    }

    public JSONObject uploadFolderList(IProgressMonitor monitor, JSONObject folderListObject) throws HttpException, InterruptedException {
        if (folderListObject == null) {
            folderListObject = new JSONObject();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)folderListObject);
        HttpEntityProxy entity = new HttpEntityProxy((HttpEntity)new JSONEntity(jsonObject, false), "application/vnd.seawind.api+json; version=1");
        return this.execute(monitor, API_FOLDERS, null, "PUT", (HttpEntity)entity, null);
    }

    public JSONObject uploadWorkbook(IProgressMonitor monitor, final String workbookId, JSONObject workbookObject, FieldSet files) throws HttpException, InterruptedException, MissingFileException {
        if (workbookObject == null) {
            workbookObject = new JSONObject();
        }
        workbookObject.put("id", (Object)workbookId);
        if (!this.checkWorkbookFiles(workbookObject, files)) {
            throw new MissingFileException();
        }
        return this.execute(monitor, EncodingUtils.format((String)API_WORKBOOK_WITH_ID, (Object[])new Object[]{workbookId}), null, "PUT", SeawindClient.makeEntity(workbookObject, PARAM_WORKBOOK, files), new ResponseValidator(){

            @Override
            public void validate(HttpRequest request, JSONObject data) throws Exception {
                Assert.isTrue((boolean)workbookId.equals(data.getString("id")));
            }
        });
    }

    private boolean checkWorkbookFiles(JSONObject workbookObject, FieldSet files) {
        block9: {
            block10: {
                block7: {
                    String id;
                    block8: {
                        if (workbookObject == null) {
                            return false;
                        }
                        try {
                            JSONObject sheet;
                            Object ele;
                            Iterator ite;
                            JSONArray sheets;
                            if (!workbookObject.has("sheets") || (sheets = workbookObject.getJSONArray("sheets")) == null || sheets.length() == 0 || !(ite = sheets.iterator()).hasNext() || !((ele = ite.next()) instanceof JSONObject) || (id = (sheet = (JSONObject)ele).getString("id")) == null) break block7;
                            if (files != null) break block8;
                            return false;
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            return false;
                        }
                    }
                    Object content = files.get(EncodingUtils.format((String)PARAM_SHEET_CONTENT_WITH_ID, (Object[])new Object[]{id}));
                    Object preview = files.get(EncodingUtils.format((String)PARAM_SHEET_PREVIEW_WITH_ID, (Object[])new Object[]{id}));
                    if (content != null && preview != null) break block7;
                    return false;
                }
                if (!workbookObject.has("extensions")) break block9;
                if (files != null) break block10;
                return false;
            }
            Object extensions = files.get("extensions.json");
            if (extensions == null) {
                return false;
            }
        }
        return true;
    }

    public JSONObject deleteWorkbook(IProgressMonitor monitor, final String workbookId) throws HttpException, InterruptedException {
        return this.execute(monitor, EncodingUtils.format((String)API_WORKBOOK_WITH_ID, (Object[])new Object[]{workbookId}), null, "DELETE", null, new ResponseValidator(){

            @Override
            public void validate(HttpRequest request, JSONObject data) throws Exception {
                Assert.isTrue((boolean)workbookId.equals(data.getString("id")));
            }
        });
    }

    public JSONObject downloadSheet(IProgressMonitor monitor, String workbookId, final String sheetId) throws HttpException, InterruptedException {
        return this.execute(monitor, EncodingUtils.format((String)API_SHEET_WITH_WORKBOOK_ID_AND_SHEET_ID, (Object[])new Object[]{workbookId, sheetId}), null, "GET", null, new ResponseValidator(){

            @Override
            public void validate(HttpRequest request, JSONObject data) throws Exception {
                Assert.isTrue((boolean)sheetId.equals(data.get("id")));
            }
        });
    }

    public void downloadSheetContent(IProgressMonitor monitor, String workbookId, String sheetId, final IOutputTarget target, final String targetPath, String hash) throws HttpException, InterruptedException {
        String api = EncodingUtils.format((String)API_SHEET_CONTENT_WITH_WORKBOOK_ID_AND_SHEET_ID, (Object[])new Object[]{workbookId, sheetId});
        HttpRequest request = this.makeRequest(api, null, "GET", null, new IResponseHandler(){

            public void handleResponseEntity(IProgressMonitor monitor, HttpRequest request, HttpEntity entity) throws InterruptedException, IOException {
                if (request.getStatusCode() == 200) {
                    try {
                        SeawindClient.writeEntityToWithLengthCheck((Entity)entity, target, targetPath, SeawindClient.this.getContentLength(request));
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException("Hash check failed. (with IOException occurred)");
                    }
                }
            }
        });
        this.executeRequestWithRetry(monitor, request, 0);
    }

    public void downloadSheetPreviewImage(IProgressMonitor monitor, String workbookId, String sheetId, final IOutputTarget target, final String targetPath) throws HttpException, InterruptedException {
        String api = EncodingUtils.format((String)API_SHEET_PREVIEW_IMAGE_WITH_WORKBOOK_ID_AND_SHEET_ID, (Object[])new Object[]{workbookId, sheetId});
        HttpRequest request = this.makeRequest(api, null, "GET", null, new IResponseHandler(){

            public void handleResponseEntity(IProgressMonitor monitor, HttpRequest request, HttpEntity entity) throws InterruptedException, IOException {
                if (request.getStatusCode() == 200) {
                    SeawindClient.writeEntityTo((Entity)entity, target, targetPath);
                }
            }
        });
        this.executeRequestWithRetry(monitor, request, 0);
    }

    public void downloadSheetThumbnailImage(IProgressMonitor monitor, String workbookId, String sheetId, final IOutputTarget target, final String targetPath) throws HttpException, InterruptedException {
        String api = EncodingUtils.format((String)API_SHEET_THUMBNAIL_IMAGE_WIT_WORKBOOK_ID_AND_SHEET_ID, (Object[])new Object[]{workbookId, sheetId});
        HttpRequest request = this.makeRequest(api, null, "GET", null, new IResponseHandler(){

            public void handleResponseEntity(IProgressMonitor monitor, HttpRequest request, HttpEntity entity) throws InterruptedException, IOException {
                if (request.getStatusCode() == 200) {
                    SeawindClient.writeEntityTo((Entity)entity, target, targetPath);
                }
            }
        });
        this.executeRequestWithRetry(monitor, request, 0);
    }

    public FieldSet addSheetFiles(FieldSet files, String sheetId, HttpEntity content, HttpEntity previewImage) {
        if (content != null && !"application/vnd.seawind.object+json".equals(content.getContentType())) {
            content = new HttpEntityProxy(content, "application/vnd.seawind.object+json");
        }
        if (previewImage != null && !"image/png".equals(previewImage.getContentType())) {
            previewImage = new HttpEntityProxy(previewImage, "image/png");
        }
        if (sheetId == null) {
            return files.add(PARAM_SHEET_CONTENT, (Object)content).add(PARAM_SHEET_PREVIEW, (Object)previewImage);
        }
        return files.add(EncodingUtils.format((String)PARAM_SHEET_CONTENT_WITH_ID, (Object[])new Object[]{sheetId}), (Object)content).add(EncodingUtils.format((String)PARAM_SHEET_PREVIEW_WITH_ID, (Object[])new Object[]{sheetId}), (Object)previewImage);
    }

    public JSONObject uploadSheet(IProgressMonitor monitor, String workbookId, final String sheetId, JSONObject sheetObject, HttpEntity content, HttpEntity previewImage) throws HttpException, InterruptedException, MissingFileException {
        if (sheetObject == null) {
            sheetObject = new JSONObject();
        }
        sheetObject.put("id", (Object)sheetId);
        FieldSet files = this.addSheetFiles(new FieldSet(), null, content, previewImage);
        if (!this.checkSheetFiles(sheetObject, files)) {
            throw new MissingFileException();
        }
        return this.execute(monitor, EncodingUtils.format((String)API_SHEET_WITH_WORKBOOK_ID_AND_SHEET_ID, (Object[])new Object[]{workbookId, sheetId}), null, "PUT", SeawindClient.makeEntity(sheetObject, PARAM_SHEET, files), new ResponseValidator(){

            @Override
            public void validate(HttpRequest request, JSONObject data) throws Exception {
                Assert.isTrue((boolean)sheetId.equals(data.getString("id")));
                data.getString(SeawindClient.PARAM_REV);
            }
        });
    }

    private boolean checkSheetFiles(JSONObject sheetObject, FieldSet files) {
        return sheetObject != null;
    }

    public JSONObject deleteSheet(IProgressMonitor monitor, String workbookId, final String sheetId, String rev) throws HttpException, InterruptedException {
        return this.execute(monitor, EncodingUtils.format((String)API_SHEET_WITH_WORKBOOK_ID_AND_SHEET_ID, (Object[])new Object[]{workbookId, sheetId}), new FieldSet().add(PARAM_REV, (Object)rev), "DELETE", null, new ResponseValidator(){

            @Override
            public void validate(HttpRequest request, JSONObject data) throws Exception {
                Assert.isTrue((boolean)sheetId.equals(data.getString("id")));
                Assert.isTrue((boolean)data.getBoolean("deleted"));
            }
        });
    }

    public void downloadResource(IProgressMonitor monitor, final String hash, final IOutputTarget target) throws HttpException, InterruptedException {
        String api = EncodingUtils.format((String)API_RESOURCE_WITH_HASH, (Object[])new Object[]{hash});
        HttpRequest request = this.makeRequest(api, null, "GET", null, new IResponseHandler(){

            public void handleResponseEntity(IProgressMonitor monitor, HttpRequest request, HttpEntity entity) throws InterruptedException, IOException {
                if (request.getStatusCode() == 200) {
                    try {
                        SeawindClient.writeEntityToWithLengthCheck((Entity)entity, target, hash, SeawindClient.this.getContentLength(request));
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException("Hash check failed. (with IOException occurred)");
                    }
                }
            }
        });
        this.executeRequestWithRetry(monitor, request, 0);
    }

    public void uploadResources(IProgressMonitor monitor, Set<String> hashes, IInputSource source) throws HttpException, InterruptedException, MissingFileException {
        String api = API_RESOURCES;
        FieldSet parts = new FieldSet();
        for (String hash : hashes) {
            if (!source.hasEntry(hash)) continue;
            StorageEntryEntity entity = new StorageEntryEntity(source, hash);
            entity.setFileName(hash);
            parts.add(PARAM_VALIDATED, (Object)entity);
        }
        if (parts.isEmpty()) {
            return;
        }
        if (!this.checkResourceFiles(hashes, parts)) {
            throw new MissingFileException();
        }
        HttpRequest request = this.makeRequest(api, null, "POST", (HttpEntity)new MultipartEntity(parts), null);
        this.executeRequestWithRetry(monitor, request, 0);
    }

    private boolean checkResourceFiles(Set<String> hashes, FieldSet files) {
        if (hashes == null || files == null) {
            return false;
        }
        return hashes.size() == files.size() && !files.toList().contains(null);
    }

    public void downloadWorkbookExtensions(IProgressMonitor monitor, String workbookId, final IOutputTarget target, final String targetPath, String hash) throws HttpException, InterruptedException {
        String api = EncodingUtils.format((String)API_WORKBOOK_EXTENSIONS, (Object[])new Object[]{workbookId});
        HttpRequest request = this.makeRequest(api, null, "GET", null, new IResponseHandler(){

            public void handleResponseEntity(IProgressMonitor monitor, HttpRequest request, HttpEntity entity) throws InterruptedException, IOException {
                if (request.getStatusCode() == 200) {
                    try {
                        SeawindClient.writeEntityToWithLengthCheck((Entity)entity, target, targetPath, SeawindClient.this.getContentLength(request));
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException("Hash check failed. (with IOException occurred)");
                    }
                }
            }
        });
        this.executeRequestWithRetry(monitor, request, 0);
    }

    private void executeRequestWithRetry(IProgressMonitor monitor, HttpRequest request, int retryCount) throws InterruptedException, HttpException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            request.execute((IProgressMonitor)subMonitor);
        }
        catch (HttpException e) {
            if (retryCount < 2) {
                Thread.sleep(5000 * retryCount);
                this.executeRequestWithRetry(monitor, request, ++retryCount);
            }
            throw SeawindClient.unwrapErrorInfo(e);
        }
    }

    public void setCnUser(boolean isCnUser) {
        this.isCnUser = isCnUser;
    }

    private String getHost() {
        return this.isCnUser ? HOST_CN : HOST_NET;
    }

    private int getContentLength(HttpRequest request) {
        int length = -1;
        String contentLength = request.getResponseHeader("Content-Length");
        if (contentLength != null && !contentLength.equals("")) {
            try {
                length = Integer.valueOf(contentLength);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return length;
    }

    public static void writeEntityTo(Entity entity, IOutputTarget target, String targetPath) throws IOException {
        MessageDigest digest = SeawindClient.getFileHashDigest();
        try (DigestOutputStream targetStream = new DigestOutputStream(target.openEntryStream(targetPath), digest);){
            entity.writeTo((OutputStream)targetStream);
        }
        String hash = String.valueOf(Codec.hexEncode((byte[])digest.digest(), (boolean)false));
        SeawindClient.writeText(hash, target, SeawindClient.toHashPath(targetPath));
    }

    public static void writeEntityToWithHashCheck(Entity entity, IOutputTarget target, String targetPath, String algorithm, String hash) throws IOException {
        String tempPath = Core.getWorkspace().getTempFile("seawind/" + targetPath);
        try (FileOutputStream os = new FileOutputStream(tempPath);){
            entity.writeTo((OutputStream)os);
        }
        if (hash != null && !hash.equals("") && !SeawindClient.checkContentHash(tempPath, hash, algorithm)) {
            new File(tempPath).delete();
            throw new IllegalStateException("Hash check failed. (Did not download the whole file)");
        }
        MessageDigest digest = SeawindClient.getFileHashDigest();
        FileInputStream input = new FileInputStream(tempPath);
        DigestOutputStream targetStream = new DigestOutputStream(target.openEntryStream(targetPath), digest);
        try {
            int numRead;
            byte[] buffer = new byte[4096];
            while ((numRead = ((InputStream)input).read(buffer)) != -1) {
                ((OutputStream)targetStream).write(buffer, 0, numRead);
            }
        }
        finally {
            ((InputStream)input).close();
            ((OutputStream)targetStream).close();
            new File(tempPath).delete();
        }
        String hash2 = String.valueOf(Codec.hexEncode((byte[])digest.digest(), (boolean)false));
        SeawindClient.writeText(hash2, target, SeawindClient.toHashPath(targetPath));
    }

    private static boolean checkContentHash(String filePath, String hash, String algorithm) {
        FileInputStream is = null;
        try {
            int numRead;
            is = new FileInputStream(filePath);
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] bytes = new byte[4096];
            while ((numRead = ((InputStream)is).read(bytes)) != -1) {
                if (numRead == bytes.length) {
                    digest.update(bytes);
                    continue;
                }
                digest.update(Arrays.copyOf(bytes, numRead));
            }
            String contentHash = String.valueOf(Codec.hexEncode((byte[])digest.digest(), (boolean)false));
            boolean bl = hash != null && hash.equals(contentHash);
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeEntityToWithLengthCheck(Entity entity, IOutputTarget target, String targetPath, int length) throws IOException {
        String tempPath = Core.getWorkspace().getTempFile("seawind/" + targetPath);
        try (FileOutputStream os = new FileOutputStream(tempPath);){
            entity.writeTo((OutputStream)os);
        }
        if (length != -1 && !SeawindClient.checkContentLength(tempPath, length)) {
            new File(tempPath).delete();
            throw new IllegalStateException("Length check failed. (Did not download the whole file)");
        }
        MessageDigest digest = SeawindClient.getFileHashDigest();
        FileInputStream input = new FileInputStream(tempPath);
        DigestOutputStream targetStream = new DigestOutputStream(target.openEntryStream(targetPath), digest);
        try {
            int numRead;
            byte[] buffer = new byte[4096];
            while ((numRead = ((InputStream)input).read(buffer)) != -1) {
                ((OutputStream)targetStream).write(buffer, 0, numRead);
            }
        }
        finally {
            ((InputStream)input).close();
            ((OutputStream)targetStream).close();
            new File(tempPath).delete();
        }
        String hash2 = String.valueOf(Codec.hexEncode((byte[])digest.digest(), (boolean)false));
        SeawindClient.writeText(hash2, target, SeawindClient.toHashPath(targetPath));
    }

    private static boolean checkContentLength(String filePath, int length) {
        FileInputStream is = null;
        try {
            int numRead;
            is = new FileInputStream(filePath);
            int contentLength = 0;
            byte[] bytes = new byte[4096];
            while ((numRead = ((InputStream)is).read(bytes)) != -1) {
                contentLength += numRead;
            }
            boolean bl = length == contentLength;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String toHashPath(String entryPath) {
        return String.valueOf(entryPath) + HASH_SUFFIX;
    }

    private static MessageDigest getFileHashDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getFileHash(IInputSource source, String entryPath) throws IOException {
        if (!source.hasEntry(entryPath)) {
            return null;
        }
        String hashPath = SeawindClient.toHashPath(entryPath);
        if (source.hasEntry(hashPath)) {
            return SeawindClient.readText(source, hashPath);
        }
        MessageDigest digest = SeawindClient.getFileHashDigest();
        try (DigestInputStream stream = new DigestInputStream(source.openEntryStream(entryPath), digest);){
            byte[] buffer = new byte[4096];
            while (((InputStream)stream).read(buffer) != -1) {
            }
        }
        return String.valueOf(Codec.hexEncode((byte[])digest.digest(), (boolean)false));
    }

    public static void writeText(String text, IOutputTarget target, String entryPath) throws IOException {
        byte[] bytes = text.getBytes("UTF-8");
        try (OutputStream stream = target.openEntryStream(entryPath);){
            stream.write(bytes);
        }
    }

    public static String readText(IInputSource source, String entryPath) throws IOException {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();
             InputStream stream = source.openEntryStream(entryPath);){
            FileUtils.transfer((InputStream)stream, (OutputStream)bytes, (boolean)false);
        }
        return bytes.toString("UTF-8");
    }

    private static String trimLicenseKey(String key) {
        int startIndex = (key = key.toUpperCase()).indexOf("---BEGIN LICENSE KEY---");
        startIndex = startIndex < 0 ? 0 : (startIndex += 23);
        int endIndex = key.indexOf("---END LICENSE KEY---");
        if (endIndex < 0) {
            endIndex = key.length();
        }
        key = key.substring(startIndex, endIndex).replaceAll("[^A-Z0-9]", "");
        return key;
    }

    public static class MissingFileException
    extends Exception {
        private static final long serialVersionUID = -2680012534002070493L;
    }

    private static interface ResponseValidator {
        public void validate(HttpRequest var1, JSONObject var2) throws Exception;
    }
}

