/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.internal.IconTipContributorProxy;
import org.xmind.ui.mindmap.IIconTipContributor;
import org.xmind.ui.util.Logger;

public class IconTipContributorManager
extends RegistryReader {
    private static final IconTipContributorManager instance = new IconTipContributorManager();
    private List<IIconTipContributor> contributors = null;

    private IconTipContributorManager() {
    }

    public List<IIconTipContributor> getContributors() {
        this.ensureLoaded();
        return this.contributors;
    }

    private void ensureLoaded() {
        if (this.contributors != null) {
            return;
        }
        this.lazyLoad();
        if (this.contributors == null) {
            this.contributors = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        if (Platform.isRunning()) {
            this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "iconTips");
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("iconTip".equals(name)) {
            this.readIconTip(element);
            return true;
        }
        return false;
    }

    private void readIconTip(IConfigurationElement element) {
        IconTipContributorProxy contributor;
        try {
            contributor = new IconTipContributorProxy(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load icon tip: " + element);
            return;
        }
        if (this.contributors == null) {
            this.contributors = new ArrayList<IIconTipContributor>();
        }
        this.contributors.add(contributor);
    }

    public static IconTipContributorManager getInstance() {
        return instance;
    }
}

