/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.mindmap.INumberSeparator;
import org.xmind.ui.mindmap.INumberSeparatorDescriptor;
import org.xmind.ui.mindmap.INumberSeparatorManager;
import org.xmind.ui.util.Logger;

public class NumberSeparatorExtensionManager
extends RegistryReader
implements INumberSeparatorManager {
    private Map<String, NumberSeparatorProxy> separators = null;
    private List<INumberSeparatorDescriptor> list = null;

    @Override
    public List<INumberSeparatorDescriptor> getDescriptors() {
        this.ensureLoaded();
        return this.list;
    }

    @Override
    public INumberSeparatorDescriptor getDescriptor(String separatorId) {
        this.ensureLoaded();
        return this.separators.get(separatorId);
    }

    @Override
    public INumberSeparator getSeparator(String separatorId) {
        this.ensureLoaded();
        return this.separators.get(separatorId);
    }

    @Override
    public String getSeparatorText(String separatorId) {
        INumberSeparator separator = this.getSeparator(separatorId);
        if (separator != null) {
            return separator.getText();
        }
        return null;
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("separator".equals(name)) {
            this.readFormat(element);
            return true;
        }
        return false;
    }

    private void readFormat(IConfigurationElement element) {
        NumberSeparatorProxy proxy;
        try {
            proxy = new NumberSeparatorProxy(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load number separator: " + element);
            return;
        }
        if (this.separators == null) {
            this.separators = new HashMap<String, NumberSeparatorProxy>();
        }
        this.separators.put(proxy.getId(), proxy);
        if (this.list == null) {
            this.list = new ArrayList<INumberSeparatorDescriptor>();
        }
        this.list.add(proxy);
    }

    private void ensureLoaded() {
        if (this.separators != null && this.list != null) {
            return;
        }
        this.lazyLoad();
        if (this.separators == null) {
            this.separators = Collections.emptyMap();
        }
        if (this.list == null) {
            this.list = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "numberSeparators");
    }

    private static class NumberSeparatorProxy
    implements INumberSeparator,
    INumberSeparatorDescriptor {
        private IConfigurationElement element;
        private String id;
        private String name;
        private String description;
        private INumberSeparator implementation;
        private boolean failedInitimplementation = false;

        public NumberSeparatorProxy(IConfigurationElement element) throws CoreException {
            this.element = element;
            this.id = element.getAttribute("id");
            this.name = element.getAttribute("name");
            this.description = element.getAttribute("description");
            if (NumberSeparatorExtensionManager.getClassValue((IConfigurationElement)element, (String)"class") == null) {
                throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
            }
        }

        private INumberSeparator getImplementation() {
            if (this.implementation == null && !this.failedInitimplementation) {
                try {
                    this.implementation = (INumberSeparator)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Logger.log(e, "Failed to create number separator from class: " + NumberSeparatorExtensionManager.getClassValue((IConfigurationElement)this.element, (String)"class"));
                    this.failedInitimplementation = true;
                }
            }
            return this.implementation;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getText() {
            INumberSeparator impl = this.getImplementation();
            if (impl != null) {
                return impl.getText();
            }
            return null;
        }
    }
}

