/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.ui.actions.EditorAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.PasteSheetCommand;
import org.xmind.ui.internal.actions.CopiedSheetStorageSupport;

public class PasteSheetAction
extends EditorAction {
    public PasteSheetAction(IGraphicalEditor editor) {
        super(MindMapActionFactory.PASTE_SHEET.getId(), editor);
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        IGraphicalEditorPage page = this.getActivePage();
        if (page != null) {
            IWorkbook workbook = ((ISheet)page.getAdapter(ISheet.class)).getOwnedWorkbook();
            ISheet copiedSheet = CopiedSheetStorageSupport.getInstance().getCopiedSheet(workbook);
            if (workbook != null) {
                this.saveAndRunPasteSheetCommand(workbook, copiedSheet);
            }
        }
    }

    protected void saveAndRunPasteSheetCommand(IWorkbook workbook, ISheet copiedSheet) {
        PasteSheetCommand command = new PasteSheetCommand(workbook, copiedSheet);
        command.setLabel(CommandMessages.Command_PasteSheet);
        this.saveAndRun(command);
    }
}

