/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.IZoomListener;
import org.xmind.gef.Request;
import org.xmind.gef.ZoomManager;
import org.xmind.gef.ZoomObject;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.viewers.ISliderContentProvider;
import org.xmind.ui.viewers.SliderViewer;

public class MiniZoomContribution
extends ContributionItem
implements IPageChangedListener,
IZoomListener {
    protected static final int SLIDER_WIDTH = 88;
    private ZoomManager zoomManager = null;
    private IGraphicalEditor editor;
    private ToolItem zoomOutItem;
    private ToolItem zoomValueItem;
    private ToolItem zoomInItem;
    private ToolItem zoomDefaultItem;
    private ZoomPopup zoomPopup = null;
    private ToolBar toolBar;

    public MiniZoomContribution(IGraphicalEditor editor) {
        this("org.xmind.ui.minibar.zoom", editor);
    }

    public MiniZoomContribution(String id, IGraphicalEditor editor) {
        super(id);
        this.editor = editor;
        editor.addPageChangedListener((IPageChangedListener)this);
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        if (this.zoomOutItem != null) {
            this.zoomOutItem.dispose();
            this.zoomOutItem = null;
        }
        if (this.zoomValueItem != null) {
            this.zoomValueItem.dispose();
            this.zoomValueItem = null;
        }
        if (this.zoomInItem != null) {
            this.zoomInItem.dispose();
            this.zoomInItem = null;
        }
        if (this.zoomDefaultItem != null) {
            this.zoomDefaultItem.dispose();
            this.zoomDefaultItem = null;
        }
        this.setZoomManager(null);
        if (this.editor != null) {
            this.editor.removePageChangedListener((IPageChangedListener)this);
            this.editor = null;
        }
        super.dispose();
    }

    public void fill(ToolBar parent, int index) {
        this.toolBar = parent;
        if (index < 0) {
            this.zoomOutItem = new ToolItem(parent, 8);
            this.zoomValueItem = new ToolItem(parent, 8);
            this.zoomInItem = new ToolItem(parent, 8);
            this.zoomDefaultItem = new ToolItem(parent, 8);
        } else {
            this.zoomOutItem = new ToolItem(parent, 8, index++);
            this.zoomValueItem = new ToolItem(parent, 8, index++);
            this.zoomInItem = new ToolItem(parent, 8, index++);
            this.zoomDefaultItem = new ToolItem(parent, 8, index++);
        }
        this.zoomValueItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle r = MiniZoomContribution.this.zoomValueItem.getBounds();
                MiniZoomContribution.this.showZoomPopup(event, MiniZoomContribution.this.zoomValueItem.getParent().toDisplay(r.x, r.y));
            }
        });
        this.zoomOutItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MiniZoomContribution.this.sendRequest("zoom_out");
            }
        });
        this.zoomInItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MiniZoomContribution.this.sendRequest("zoom_in");
            }
        });
        this.zoomDefaultItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MiniZoomContribution.this.sendRequest("actual_size");
            }
        });
        this.initItemLabel(this.zoomOutItem, "zoomout_small.png", MindMapMessages.ZoomOut_toolTip);
        this.initItemLabel(this.zoomInItem, "zoomin_small.png", MindMapMessages.ZoomIn_toolTip);
        this.initItemLabel(this.zoomDefaultItem, "actualsize_small.png", MindMapMessages.ActualSize_toolTip);
        this.update(null);
    }

    private void initItemLabel(final ToolItem item, String iconPath, String fallbackText) {
        Image image = this.createImage(iconPath, true);
        if (image != null) {
            item.setImage(image);
            item.setDisabledImage(this.createImage(iconPath, false));
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Image image = item.getImage();
                    if (image != null) {
                        image.dispose();
                    }
                    if ((image = item.getDisabledImage()) != null) {
                        image.dispose();
                    }
                }
            });
        } else {
            item.setText(fallbackText);
        }
    }

    private Image createImage(String iconPath, boolean enabled) {
        ImageDescriptor imageDescriptor = MindMapUI.getImages().get(iconPath, enabled);
        return imageDescriptor == null ? null : imageDescriptor.createImage(false);
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        if (this.zoomValueItem != null && !this.zoomValueItem.isDisposed()) {
            if (this.zoomManager == null) {
                this.zoomValueItem.setText("100%");
            } else {
                double scale = this.zoomManager.getScale();
                int s = (int)Math.round(scale * 100.0);
                this.zoomValueItem.setText(String.format("%4s", String.format("%d%%", s)));
            }
            if (this.toolBar != null && !this.toolBar.isDisposed()) {
                this.toolBar.pack();
            }
        }
    }

    private void refresh() {
        this.update(null);
        this.getParent().update(true);
    }

    public void pageChanged(PageChangedEvent event) {
        this.setZoomManager(this.getZoomManager(event.getSelectedPage()));
    }

    public void scaleChanged(ZoomObject source, double oldValue, double newValue) {
        this.refresh();
    }

    private ZoomManager getZoomManager(Object page) {
        if (page == null || !(page instanceof IGraphicalEditorPage)) {
            return null;
        }
        IGraphicalViewer viewer = ((IGraphicalEditorPage)page).getViewer();
        if (viewer == null) {
            return null;
        }
        return viewer.getZoomManager();
    }

    private void setZoomManager(ZoomManager zoomManager) {
        if (zoomManager == this.zoomManager) {
            return;
        }
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((IZoomListener)this);
        }
        this.zoomManager = zoomManager;
        if (zoomManager != null) {
            zoomManager.addZoomListener((IZoomListener)this);
        }
        this.refresh();
    }

    private void showZoomPopup(Event event, Point itemLocation) {
        if (this.zoomManager == null) {
            return;
        }
        if (this.zoomPopup == null) {
            this.zoomPopup = new ZoomPopup(this.editor.getSite().getShell());
        }
        this.zoomPopup.update(this.editor.getActivePageInstance(), this.zoomManager, itemLocation);
        this.zoomPopup.open();
    }

    private void sendRequest(final String reqType) {
        if (this.editor == null) {
            return;
        }
        final IGraphicalEditorPage page = this.editor.getActivePageInstance();
        if (page == null) {
            return;
        }
        final EditDomain domain = page.getEditDomain();
        if (domain == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                domain.handleRequest(reqType, (IViewer)page.getViewer());
            }
        });
    }

    private static class ZoomPopup
    extends PopupDialog {
        private static final double[] directSelectorInput = new double[]{2.0, 1.5, 1.2, 1.0, 0.8, 0.5};
        private Text valueInput;
        private SliderViewer slider;
        private IGraphicalEditorPage page;
        private ZoomManager zoomManager;
        private Point triggerPosition = null;
        private boolean internalModifying = false;
        private Listener directSelectorItemListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof ToolItem) {
                    Double value = (Double)((ToolItem)event.widget).getData();
                    ZoomPopup.this.confirmValue(value);
                }
            }
        };

        public ZoomPopup(Shell parent) {
            super(parent, 4, true, false, false, false, false, null, null);
        }

        public void update(IGraphicalEditorPage page, ZoomManager zoomManager, Point pos) {
            this.page = page;
            this.zoomManager = zoomManager;
            this.triggerPosition = pos;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.fillValueInput(composite);
            Composite composite2 = new Composite(composite, 0);
            GridLayout layout2 = new GridLayout(2, false);
            layout2.marginWidth = 0;
            layout2.marginHeight = 0;
            layout2.verticalSpacing = 0;
            layout2.horizontalSpacing = 0;
            composite2.setLayout((Layout)layout2);
            composite2.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fillDirectSelector(composite2);
            this.fillSlider(composite2);
            return composite;
        }

        private void fillValueInput(Composite parent) {
            this.valueInput = new Text(parent, 2052);
            this.valueInput.setLayoutData((Object)new GridData(4, 4, true, false));
            this.valueInput.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    if (ZoomPopup.this.internalModifying) {
                        return;
                    }
                    ZoomPopup.this.internalModifying = true;
                    try {
                        try {
                            int intValue = Integer.parseInt(ZoomPopup.this.valueInput.getText(), 10);
                            ZoomPopup.this.updateSlider((double)intValue / 100.0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ZoomPopup.this.internalModifying = false;
                        }
                    }
                    finally {
                        ZoomPopup.this.internalModifying = false;
                    }
                }
            });
            Listener inputConfirmListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 14 || event.type == 31 && event.detail == 4) {
                        try {
                            int intValue = Integer.parseInt(ZoomPopup.this.valueInput.getText(), 10);
                            ZoomPopup.this.confirmValue((double)intValue / 100.0);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        event.doit = false;
                    }
                }
            };
            this.valueInput.addListener(14, inputConfirmListener);
            this.valueInput.addListener(31, inputConfirmListener);
            this.valueInput.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (e.display.getActiveShell() != ZoomPopup.this.getShell()) {
                        ZoomPopup.this.close();
                    }
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }

        private void fillDirectSelector(Composite parent) {
            ToolBar toolbar = new ToolBar(parent, 512);
            toolbar.setLayoutData((Object)new GridData(4, 4, true, true));
            this.addDirectSelectorItems(toolbar, directSelectorInput);
        }

        private void addDirectSelectorItems(ToolBar parent, double[] values) {
            double[] dArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                this.addDirectSelectorItem(parent, value);
                ++n2;
            }
        }

        private void addDirectSelectorItem(ToolBar parent, double value) {
            ToolItem item = new ToolItem(parent, 8);
            item.setText(String.valueOf((int)Math.round(value * 100.0)));
            item.setData((Object)value);
            item.addListener(13, this.directSelectorItemListener);
        }

        private void fillSlider(Composite parent) {
            this.slider = new SliderViewer(parent, 512);
            this.slider.getControl().setLayoutData((Object)new GridData(4, 4, false, true));
            ((GridData)this.slider.getControl().getLayoutData()).heightHint = 40;
            this.slider.setContentProvider((IContentProvider)new ZoomSliderContentProvider());
            this.slider.setLabelProvider((IBaseLabelProvider)new ZoomSliderLabelProvider());
            this.slider.setInput((Object)this);
            this.slider.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ZoomPopup.this.internalModifying) {
                        return;
                    }
                    ZoomPopup.this.internalModifying = true;
                    try {
                        try {
                            Double value = (Double)ZoomPopup.this.slider.getSelectionValue();
                            ZoomPopup.this.updateValueInput(value);
                        }
                        catch (NumberFormatException numberFormatException) {
                            ZoomPopup.this.internalModifying = false;
                        }
                    }
                    finally {
                        ZoomPopup.this.internalModifying = false;
                    }
                }
            });
            this.slider.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ZoomPopup.this.internalModifying) {
                        return;
                    }
                    Double value = (Double)ZoomPopup.this.slider.getSelectionValue();
                    if (value != null) {
                        ZoomPopup.this.confirmValue(value);
                    }
                }
            });
            this.slider.getControl().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if (e.display.getActiveShell() != ZoomPopup.this.getShell()) {
                        ZoomPopup.this.close();
                    }
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }

        protected Control getFocusControl() {
            return this.valueInput;
        }

        protected void adjustBounds() {
            this.internalModifying = true;
            try {
                double doubleValue = this.zoomManager.getScale();
                this.updateValueInput(doubleValue);
                this.updateSlider(doubleValue);
            }
            finally {
                this.internalModifying = false;
            }
            this.getShell().pack();
            Point size = this.getShell().getSize();
            if (this.triggerPosition != null) {
                this.getShell().setLocation(this.triggerPosition.x, this.triggerPosition.y - size.y);
            }
        }

        private void confirmValue(final double newValue) {
            this.close();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (ZoomPopup.this.page == null) {
                        return;
                    }
                    EditDomain domain = ZoomPopup.this.page.getEditDomain();
                    if (domain == null) {
                        return;
                    }
                    Request request = new Request("zoom");
                    request.setViewer((IViewer)ZoomPopup.this.page.getViewer());
                    request.setParameter("zoomScale", (Object)newValue);
                    domain.handleRequest(request);
                }
            });
        }

        private void updateValueInput(double doubleValue) {
            this.valueInput.setText(String.valueOf((int)Math.round(doubleValue * 100.0)));
            this.valueInput.setSelection(this.valueInput.getText().length());
        }

        private void updateSlider(double doubleValue) {
            this.slider.setSelection((ISelection)new StructuredSelection((Object)doubleValue));
        }

        protected List getBackgroundColorExclusions() {
            List list = super.getBackgroundColorExclusions();
            list.add(this.valueInput);
            return list;
        }

        private static class ZoomSliderContentProvider
        implements ISliderContentProvider {
            private static final int intervalNum = ZoomPopup.access$1().length - 1;

            private ZoomSliderContentProvider() {
            }

            public double getRatio(Object input, Object value) {
                if (value instanceof Double) {
                    double doubleValue = (Double)value;
                    return this.transformValueToRatio(doubleValue);
                }
                return 0.0;
            }

            private double transformValueToRatio(double value) {
                if (value > directSelectorInput[0]) {
                    return 1.0;
                }
                if (value < directSelectorInput[intervalNum]) {
                    return 0.0;
                }
                int index = intervalNum;
                while (index > 0) {
                    if (this.isInternal(value, directSelectorInput[index], directSelectorInput[index - 1])) {
                        double minRatio = (double)(intervalNum - index) * 1.0 / (double)intervalNum;
                        double maxRatio = minRatio + 1.0 / (double)intervalNum;
                        return this.calRatio(value, directSelectorInput[index], directSelectorInput[index - 1], minRatio, maxRatio);
                    }
                    --index;
                }
                return 0.0;
            }

            private boolean isInternal(double value, double minValue, double maxValue) {
                return value <= maxValue && value >= minValue;
            }

            private double calRatio(double value, double minValue, double maxValue, double minRatio, double maxRatio) {
                return minRatio + (value - minValue) / (maxValue - minValue) * (maxRatio - minRatio);
            }

            private double calValue(double ratio, double minRatio, double maxRatio, double minValue, double maxValue) {
                return minValue + (ratio - minRatio) / (maxRatio - minRatio) * (maxValue - minValue);
            }

            public Object getValue(Object input, double ratio) {
                return this.transformRatioToValue(ratio);
            }

            private double transformRatioToValue(double ratio) {
                if (ratio > 1.0) {
                    return directSelectorInput[0] * ratio;
                }
                if (ratio < 0.0) {
                    return 0.0;
                }
                int index = intervalNum;
                while (index > 0) {
                    double minRatio = (double)(intervalNum - index) * 1.0 / (double)intervalNum;
                    double maxRatio = minRatio + 1.0 / (double)intervalNum;
                    if (this.isInternal(ratio, minRatio, maxRatio)) {
                        return this.calValue(ratio, minRatio, maxRatio, directSelectorInput[index], directSelectorInput[index - 1]);
                    }
                    --index;
                }
                return 0.5;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        }

        private static class ZoomSliderLabelProvider
        extends LabelProvider {
            private ZoomSliderLabelProvider() {
            }

            public String getText(Object element) {
                if (element instanceof Double) {
                    double scale = (Double)element;
                    return String.format("%.0f%%", scale * 100.0);
                }
                return super.getText(element);
            }
        }
    }
}

