/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print;

import java.util.List;
import java.util.Stack;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.draw2d.graphics.Rotate90Graphics;
import org.xmind.gef.draw2d.graphics.ScaledGraphics;
import org.xmind.gef.image.FigureRenderer;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.image.IExportSourceProvider;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.internal.print.PrintUtils;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.UnitConvertor;

public class PrintClient
extends FigureRenderer {
    private static final int VIEWER_MARGIN = 15;
    private static final int TEXT_MARGIN = 0;
    private String jobName;
    private PrinterData printerData;
    private IDialogSettings settings;
    private Shell parentShell;
    private Printer printer = null;
    private Rectangle pageBounds = null;
    private Rectangle pageClientArea = null;
    private Point dpi = null;
    private boolean needRotate = false;
    private boolean jobStarted = false;
    private IExportSourceProvider source = null;
    private IExportAreaProvider area = null;
    private GhostShellProvider shell = null;
    private Transform transform;

    public PrintClient(String jobName, Shell parentShell, PrinterData printerData, IDialogSettings settings) {
        this.jobName = jobName;
        this.parentShell = parentShell;
        this.printerData = printerData;
        this.settings = settings;
    }

    public void print(IMindMap sourceMap) {
        if (!this.start()) {
            return;
        }
        this.printMap(sourceMap);
    }

    protected void printMap(IMindMap sourceMap) {
        if (this.shell == null) {
            this.shell = new GhostShellProvider(this.parentShell.getDisplay());
        }
        Properties properties = new Properties();
        properties.set("margin", Math.max(this.pageBounds.width, this.pageBounds.height));
        int margin = 15 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        properties.set("gradient", (Object)Boolean.FALSE);
        boolean plusVisible = this.getBoolean(this.settings, "plusVisible", true);
        boolean minusVisible = this.getBoolean(this.settings, "minusVisible", true);
        properties.set("plusVisible", plusVisible);
        properties.set("minusVisible", minusVisible);
        MindMapExportViewer exportViewer = new MindMapExportViewer(this.shell, (Object)sourceMap, properties);
        this.source = new MindMapViewerPrintSourceProvider(exportViewer, margin);
        this.render();
    }

    private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (settings.get(key) != null) {
            value = settings.getBoolean(key);
        }
        return value;
    }

    public void print(IGraphicalViewer sourceViewer) {
        if (!this.start()) {
            return;
        }
        int margin = 15 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        this.source = new MindMapViewerPrintSourceProvider(sourceViewer, margin);
        this.render();
    }

    private boolean start() {
        if (this.printer == null) {
            this.printer = new Printer(this.printerData);
        }
        this.receivePrinterInfo();
        if (!this.jobStarted) {
            if (!this.printer.startJob(this.jobName)) {
                return false;
            }
            this.jobStarted = true;
        }
        return this.printer.startPage();
    }

    private void render() {
        this.area = ImageExportUtils.createExportAreaProvider((Rectangle)this.source.getSourceArea(), (int)1, (int)(this.needRotate ? this.pageClientArea.height : this.pageClientArea.width), (int)(this.needRotate ? this.pageClientArea.width : this.pageClientArea.height), (Insets)this.source.getMargins());
        this.init(this.source, this.area);
        GC gc = new GC((Drawable)this.printer);
        try {
            this.render(gc);
        }
        finally {
            gc.dispose();
        }
        this.printer.endPage();
    }

    public void render(GC gc) {
        String footerText;
        gc.setClipping(this.pageClientArea.x, this.pageClientArea.y, this.pageClientArea.width, this.pageClientArea.height);
        this.pushState(gc);
        this.drawSourceContent(gc);
        this.popState(gc);
        gc.setClipping(this.pageClientArea.x, this.pageClientArea.y, this.pageClientArea.width, this.pageClientArea.height);
        if (this.settings.getBoolean("border")) {
            this.drawBorder(gc);
        }
        org.eclipse.swt.graphics.Rectangle pageBounds = this.printer.getClientArea();
        gc.setClipping(pageBounds.x, pageBounds.y, pageBounds.width, pageBounds.height);
        String headerText = this.settings.get("headerText");
        if (headerText != null && !"".equals(headerText)) {
            this.drawHeader(gc, headerText);
        }
        if ((footerText = this.settings.get("footerText")) != null && !"".equals(footerText)) {
            this.drawFooter(gc, footerText);
        }
    }

    public void drawSourceContent(GC gc) {
        super.render(gc);
    }

    private void pushState(GC gc) {
        Transform tempTransform = new Transform(gc.getDevice());
        gc.getTransform(tempTransform);
        float[] elements = new float[6];
        tempTransform.getElements(elements);
        if (this.transform != null && !this.transform.isDisposed()) {
            this.transform.dispose();
        }
        this.transform = new Transform(gc.getDevice(), elements);
        tempTransform.dispose();
    }

    private void popState(GC gc) {
        gc.setTransform(this.transform);
    }

    protected void createGraphics(Graphics graphics, Stack<Graphics> stack) {
        Rectangle bounds = this.getBounds();
        graphics.translate(this.pageClientArea.x - (this.needRotate ? -bounds.y - bounds.height : bounds.x), this.pageClientArea.y - (this.needRotate ? bounds.x : bounds.y));
        if (this.getScale() > 0.0) {
            if (ScaledGraphics.SCALED_GRAPHICS_ENABLED) {
                ScaledGraphics scaledGraphics = new ScaledGraphics(graphics);
                scaledGraphics.scale(this.getScale());
                stack.push((Graphics)scaledGraphics);
                graphics = scaledGraphics;
            } else {
                graphics.scale(this.getScale());
            }
        }
        if (this.needRotate) {
            Rotate90Graphics rotatedGraphics = new Rotate90Graphics(graphics);
            stack.push((Graphics)rotatedGraphics);
            graphics = rotatedGraphics;
        }
    }

    private void drawHeader(GC gc, String text) {
        Font font = this.getFont("headerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("headerAlign", 2), true);
        }
        finally {
            font.dispose();
        }
    }

    private void drawFooter(GC gc, String text) {
        Font font = this.getFont("footerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("footerAlign", 4), false);
        }
        finally {
            font.dispose();
        }
    }

    private int getAlign(String alignKey, int defaultAlign) {
        return PrintConstants.toDraw2DAlignment(this.settings.get(alignKey), defaultAlign);
    }

    private Font getFont(String fontKey) {
        FontData[] fontData;
        Font font = null;
        String fontValue = this.settings.get(fontKey);
        if (fontValue != null && (fontData = FontUtils.toFontData((String)fontValue)) != null) {
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setHeight(fd.getHeight() * this.dpi.y / UnitConvertor.getScreenDpi().y);
                ++n2;
            }
            font = new Font((Device)Display.getCurrent(), fontData);
        }
        if (font == null) {
            FontData[] defaultFontData = JFaceResources.getDefaultFontDescriptor().getFontData();
            int defaultHeight = defaultFontData[0].getHeight();
            font = new Font((Device)Display.getCurrent(), FontUtils.newHeight((FontData[])defaultFontData, (int)(defaultHeight * this.dpi.y / UnitConvertor.getScreenDpi().y)));
        }
        return font;
    }

    private void drawText(GC gc, String text, Font font, int alignment, boolean top) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(this.parentShell.getDisplay().getSystemColor(2));
        Rectangle pageBounds = new Rectangle(this.printer.getClientArea());
        int width = this.needRotate ? this.pageClientArea.height : this.pageClientArea.width;
        int marginWidth = 0 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        int marginHeight = 0 * this.dpi.y / UnitConvertor.getScreenDpi().y;
        if (this.needRotate) {
            int temp = marginWidth;
            marginWidth = marginHeight;
            marginHeight = temp;
        }
        Dimension size = label.getPreferredSize(width -= marginWidth * 2, -1);
        int x = -width / 2;
        int y = top ? -this.pageClientArea.height / 2 - (this.pageClientArea.y - pageBounds.y) + Math.max((this.pageClientArea.y - pageBounds.y - size.height) / 2, marginWidth) : this.pageClientArea.height / 2 + (pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height)) - size.height - Math.max((pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height) - size.height) / 2, marginWidth);
        label.setBounds(new Rectangle(x, y, width, size.height));
        SWTGraphics baseGraphics = new SWTGraphics(gc);
        baseGraphics.translate(this.pageClientArea.x + this.pageClientArea.width / 2, this.pageClientArea.y + this.pageClientArea.height / 2);
        SWTGraphics graphics = baseGraphics;
        Rotate90Graphics rotatedGraphics = null;
        if (this.needRotate) {
            rotatedGraphics = new Rotate90Graphics((Graphics)graphics);
            graphics = rotatedGraphics;
        }
        try {
            try {
                label.paint((Graphics)graphics);
            }
            catch (Throwable e) {
                Logger.log(e, "Error occurred while printing");
                if (rotatedGraphics != null) {
                    rotatedGraphics.dispose();
                }
                baseGraphics.dispose();
            }
        }
        finally {
            if (rotatedGraphics != null) {
                rotatedGraphics.dispose();
            }
            baseGraphics.dispose();
        }
    }

    private void drawBorder(GC gc) {
        gc.setForeground(this.parentShell.getDisplay().getSystemColor(2));
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.drawRectangle(this.pageClientArea.x, this.pageClientArea.y, this.pageClientArea.width - 1, this.pageClientArea.height - 1);
    }

    private void receivePrinterInfo() {
        this.dpi = new Point(this.printer.getDPI());
        this.pageBounds = new Rectangle(this.printer.getBounds());
        this.pageClientArea = new Rectangle(this.printer.getClientArea());
        int leftMargin = this.getUserMargin("leftMargin");
        int rightMargin = this.getUserMargin("rightMargin");
        int topMargin = this.getUserMargin("topMargin");
        int bottomMargin = this.getUserMargin("bottomMargin");
        this.pageClientArea.x += leftMargin;
        this.pageClientArea.y += topMargin;
        this.pageClientArea.width -= leftMargin + rightMargin;
        this.pageClientArea.height -= topMargin + bottomMargin;
        this.needRotate = false;
        int headerHeight = PrintUtils.getHeaderHeight(this.settings, this.dpi.y);
        int footerHeight = PrintUtils.getBottomHeight(this.settings, this.dpi.y);
        this.pageClientArea.expand(new Insets(-headerHeight, 0, -footerHeight, 0));
    }

    private int getUserMargin(String key) {
        double margin;
        try {
            margin = this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            margin = 0.2;
        }
        double dpi = "leftMargin".equals(key) || "rightMargin".equals(key) ? (double)this.dpi.x : (double)this.dpi.y;
        return (int)(margin * dpi);
    }

    public void dispose() {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        if (this.printer != null) {
            if (!this.printer.isDisposed()) {
                this.printer.endJob();
            }
            this.printer.dispose();
            this.printer = null;
        }
        if (this.transform != null) {
            this.transform.dispose();
            this.transform = null;
        }
        this.jobStarted = false;
    }

    private class MindMapViewerPrintSourceProvider
    extends MindMapViewerExportSourceProvider {
        public MindMapViewerPrintSourceProvider(IGraphicalViewer viewer) {
            super(viewer);
        }

        public MindMapViewerPrintSourceProvider(IGraphicalViewer viewer, int margins) {
            super(viewer, margins);
        }

        @Override
        protected void collectContents(List<IFigure> figures) {
            if (!PrintClient.this.settings.getBoolean("noBackground")) {
                figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_BACKGROUND));
            }
            figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_CONTENTS));
            figures.add((IFigure)this.getViewer().getLayer(MindMapUI.LAYER_TITLE));
        }
    }
}

