/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.service.event.Event;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.resourcemanager.ResourceManagerDialogPage;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;
import org.xmind.ui.internal.resourcemanager.ThemeResourceManagerViewer;
import org.xmind.ui.internal.utils.ResourceUtils;
import org.xmind.ui.mindmap.MindMapUI;

public class ThemeResourceManagerPage
extends ResourceManagerDialogPage
implements ICoreEventListener,
IPageChangedListener {
    private static final String EDIT_THEME_COMMAND_ID = "org.xmind.ui.command.theme.edit";
    private static final String NEW_THEME_COMMAND_ID = "org.xmind.ui.command.newTheme";
    private static final int NEW_THEME_BUTTON_ID = 1025;
    private static final int EDIT_THEME_BUTTON_ID = 1026;
    private CoreEventRegister coreEventRegister;
    private Button newThemeButton;
    private Button editThemeButton;
    private ThemeResourceManagerViewer viewer;
    private IGraphicalEditor sourceEditor;
    private ICoreEventRegister topicRegister = null;
    private ITopic rootTopic;

    @Override
    protected ResourceManagerViewer createViewer() {
        this.viewer = new ThemeResourceManagerViewer();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel;
                Object obj;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) != null && obj instanceof IStyle && "theme".equals(((IStyle)obj).getType())) {
                    ThemeResourceManagerPage.this.editThemeButton.setEnabled(true);
                    return;
                }
                ThemeResourceManagerPage.this.editThemeButton.setEnabled(false);
            }
        });
        this.registerCoreEvent();
        return this.viewer;
    }

    @Override
    protected void registerRunnable(IEclipseContext eclipseContext) {
        super.registerRunnable(eclipseContext);
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.rename", (Object)new IContextRunnable(){

            public void run() {
                List themes;
                if (ThemeResourceManagerPage.this.viewer != null && ThemeResourceManagerPage.this.viewer.getControl() != null && !ThemeResourceManagerPage.this.viewer.getControl().isDisposed() && (themes = ThemeResourceManagerPage.this.getSelectedThemes()).size() == 1) {
                    ThemeResourceManagerPage.this.viewer.startEditing((IStyle)themes.get(0));
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List themes = ThemeResourceManagerPage.this.getSelectedThemes();
                Set systemThemeSets = MindMapUI.getResourceManager().getSystemThemeSheet().getStyles("master-styles");
                boolean canExecute = themes.size() == 1;
                for (IStyle theme : themes) {
                    boolean bl = canExecute = canExecute && !systemThemeSets.contains(theme);
                }
                return canExecute;
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.duplicate", (Object)new IContextRunnable(){

            public void run() {
                List themes;
                if (ThemeResourceManagerPage.this.viewer != null && ThemeResourceManagerPage.this.viewer.getControl() != null && !ThemeResourceManagerPage.this.viewer.getControl().isDisposed() && !(themes = ThemeResourceManagerPage.this.getSelectedThemes()).isEmpty()) {
                    ResourceUtils.duplicateThemes(themes);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List themes = ThemeResourceManagerPage.this.getSelectedThemes();
                boolean canExecute = !themes.isEmpty();
                return canExecute;
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.delete", (Object)new IContextRunnable(){

            public void run() {
                List themes;
                if (ThemeResourceManagerPage.this.viewer != null && ThemeResourceManagerPage.this.viewer.getControl() != null && !ThemeResourceManagerPage.this.viewer.getControl().isDisposed() && !(themes = ThemeResourceManagerPage.this.getSelectedThemes()).isEmpty() && ResourceUtils.confirmToDeleteStyles(ThemeResourceManagerPage.this.viewer.getControl().getShell(), themes)) {
                    ResourceUtils.deleteStyles(themes);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List themes = ThemeResourceManagerPage.this.getSelectedThemes();
                IStyleSheet userThemeSheet = MindMapUI.getResourceManager().getUserThemeSheet();
                Set styles = userThemeSheet.getStyles("master-styles");
                boolean canExecute = !themes.isEmpty();
                for (IStyle theme : themes) {
                    boolean bl = canExecute = canExecute && styles.contains(theme);
                }
                return canExecute;
            }
        });
    }

    private List<IStyle> getSelectedThemes() {
        IStructuredSelection selection;
        ArrayList<IStyle> styles = new ArrayList<IStyle>();
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && (selection = this.viewer.getStructuredSelection()) instanceof IStructuredSelection) {
            for (Object element : selection.toList()) {
                styles.add((IStyle)element);
            }
        }
        return styles;
    }

    @Override
    protected void createButtonsForButtonBar(final Composite composite) {
        final ThemeResourceManagerViewer themeViewer = this.viewer;
        this.newThemeButton = this.createButton(composite, 1025, MindMapMessages.ThemeResourceManagerPage_New_button, false);
        this.newThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                composite.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ThemeResourceManagerPage.this.newTheme();
                    }
                });
            }
        });
        this.editThemeButton = this.createButton(composite, 1026, MindMapMessages.ThemeResourceManagerPage_Edit_button, false);
        this.editThemeButton.setEnabled(false);
        this.editThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objs;
                IStructuredSelection selection = (IStructuredSelection)themeViewer.getSelection();
                Object[] objectArray = objs = selection.toArray();
                int n = objs.length;
                int n2 = 0;
                while (n2 < n) {
                    IStyle theme;
                    Object obj = objectArray[n2];
                    if (obj instanceof IStyle && "theme".equals((theme = (IStyle)obj).getType())) {
                        ThemeResourceManagerPage.this.editTheme(theme);
                    }
                    ++n2;
                }
            }
        });
    }

    private void newTheme() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
        try {
            handlerService.executeCommand(NEW_THEME_COMMAND_ID, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
        }
        catch (NotEnabledException e) {
            e.printStackTrace();
        }
        catch (NotHandledException e) {
            e.printStackTrace();
        }
    }

    private void editTheme(final IStyle theme) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        final IHandlerService handlers = (IHandlerService)window.getService(IHandlerService.class);
        ICommandService commands = (ICommandService)window.getService(ICommandService.class);
        if (handlers == null || commands == null) {
            return;
        }
        final Command command = commands.getCommand(EDIT_THEME_COMMAND_ID);
        if (command == null || !command.isDefined()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                IParameter param = command.getParameter("org.xmind.ui.resource.uri");
                if (param == null) {
                    return;
                }
                ParameterizedCommand pc = new ParameterizedCommand(command, new Parameterization[]{new Parameterization(param, MindMapUI.getResourceManager().toResourceURI(theme))});
                handlers.executeCommand(pc, null);
            }
        });
    }

    private void registerCoreEvent() {
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserThemeSheet().getAdapter(ICoreEventSupport.class);
        if (ces != null) {
            this.coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
            this.coreEventRegister.setNextSupport(ces);
            this.coreEventRegister.register("styleAdd");
            this.coreEventRegister.register("styleRemove");
            this.coreEventRegister.register("titleText");
            this.coreEventRegister.register("name");
        }
    }

    @Inject
    @Optional
    public void activePartChanged(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MPart)) {
            return;
        }
        MPart part = (MPart)element;
        final IEditorPart editorPart = (IEditorPart)part.getContext().get(IEditorPart.class);
        if (editorPart instanceof MindMapEditor) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThemeResourceManagerPage.this.setEditor((IGraphicalEditor)((MindMapEditor)editorPart));
                }
            });
        }
    }

    private void setRootTopic(ITopic topic) {
        if (topic == this.rootTopic) {
            return;
        }
        if (this.topicRegister == null) {
            this.topicRegister = new CoreEventRegister((ICoreEventListener)this);
        }
        if (this.rootTopic != null) {
            this.topicRegister.unregisterAll();
        }
        if (topic != null) {
            if (this.viewer != null) {
                this.viewer.refresh(true);
            }
            this.topicRegister.setNextSourceFrom((Object)topic);
            this.topicRegister.register("structureClass");
        }
    }

    private void setEditor(IGraphicalEditor editor) {
        if (editor == this.sourceEditor) {
            return;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
        }
        this.sourceEditor = editor;
        if (this.sourceEditor != null) {
            this.sourceEditor.addPageChangedListener((IPageChangedListener)this);
            IGraphicalEditorPage page = this.sourceEditor.getActivePageInstance();
            if (page != null) {
                this.setRootTopic(this.findRootTopic(page));
            }
        }
    }

    private ITopic findRootTopic(IGraphicalEditorPage page) {
        ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
        if (sheet != null) {
            return sheet.getRootTopic();
        }
        return null;
    }

    public void pageChanged(PageChangedEvent event) {
        final IGraphicalEditorPage page = (IGraphicalEditorPage)event.getSelectedPage();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (page.isDisposed() || page.getControl() == null || page.getControl().isDisposed()) {
                    return;
                }
                ThemeResourceManagerPage.this.setRootTopic(ThemeResourceManagerPage.this.findRootTopic(page));
            }
        });
    }

    public void handleCoreEvent(final CoreEvent event) {
        if (this.viewer == null) {
            return;
        }
        Control c = this.viewer.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!"themeId".equals(event.getType())) {
                    if ("name".equals(event.getType())) {
                        ThemeResourceManagerPage.this.viewer.update(new Object[]{event.getSource()});
                    } else if ("styleAdd".equals(event.getType())) {
                        ThemeResourceManagerPage.this.viewer.refresh();
                        Object target = event.getTarget();
                        ThemeResourceManagerPage.this.viewer.setSelection((ISelection)(target == null ? StructuredSelection.EMPTY : new StructuredSelection(target)), true);
                    } else if ("styleRemove".equals(event.getType())) {
                        ThemeResourceManagerPage.this.viewer.setInput(ThemeResourceManagerPage.this.viewer.getInput());
                    } else if ("structureClass".endsWith(event.getType())) {
                        ThemeResourceManagerPage.this.viewer.refresh(true);
                    }
                }
            }
        });
    }

    @Override
    public void dispose() {
        if (this.coreEventRegister != null) {
            this.coreEventRegister.unregisterAll();
            this.coreEventRegister = null;
        }
        if (this.topicRegister != null) {
            this.topicRegister.unregisterAll();
            this.topicRegister = null;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
            this.sourceEditor = null;
        }
        super.dispose();
    }

    @Override
    protected String getContextMenuId() {
        return "org.xmind.ui.dialogPart.resourceManager.theme.popupMenu";
    }

    public String getModelPageId() {
        return "org.xmind.ui.dialogPart.resourceManager.theme";
    }

    public String getModelPageTitle() {
        return null;
    }
}

