# -*- coding:utf-8 -*-
import pytest
# node-semver/test/index.js
# import logging
# logging.basicConfig(level=logging.DEBUG, format="%(message)s")

cands =  [
    ['1.0.0 - 2.0.0', '1.2.3', False],
    ['1.0.0', '1.0.0', False],
    ['>=*', '0.2.4', False],
    ['', '1.0.0', False],
    ['*', '1.2.3', False],
    ['*', 'v1.2.3-foo', True],
    ['>=1.0.0', '1.0.0', False],
    ['>=1.0.0', '1.0.1', False],
    ['>=1.0.0', '1.1.0', False],
    ['>1.0.0', '1.0.1', False],
    ['>1.0.0', '1.1.0', False],
    ['<=2.0.0', '2.0.0', False],
    ['<=2.0.0', '1.9999.9999', False],
    ['<=2.0.0', '0.2.9', False],
    ['<2.0.0', '1.9999.9999', False],
    ['<2.0.0', '0.2.9', False],
    ['>= 1.0.0', '1.0.0', False],
    ['>=  1.0.0', '1.0.1', False],
    ['>=   1.0.0', '1.1.0', False],
    ['> 1.0.0', '1.0.1', False],
    ['>  1.0.0', '1.1.0', False],
    ['<=   2.0.0', '2.0.0', False],
    ['<= 2.0.0', '1.9999.9999', False],
    ['<=  2.0.0', '0.2.9', False],
    ['<    2.0.0', '1.9999.9999', False],
    ['<\t2.0.0', '0.2.9', False],
    ['>=0.1.97', 'v0.1.97', True],
    ['>=0.1.97', '0.1.97', False],
    ['0.1.20 || 1.2.4', '1.2.4', False],
    ['>=0.2.3 || <0.0.1', '0.0.0', False],
    ['>=0.2.3 || <0.0.1', '0.2.3', False],
    ['>=0.2.3 || <0.0.1', '0.2.4', False],
    ['||', '1.3.4', False],
    ['2.x.x', '2.1.3', False],
    ['1.2.x', '1.2.3', False],
    ['1.2.x || 2.x', '2.1.3', False],
    ['1.2.x || 2.x', '1.2.3', False],
    ['x', '1.2.3', False],
    ['2.*.*', '2.1.3', False],
    ['1.2.*', '1.2.3', False],
    ['1.2.* || 2.*', '2.1.3', False],
    ['1.2.* || 2.*', '1.2.3', False],
    ['*', '1.2.3', False],
    ['2', '2.1.2', False],
    ['2.3', '2.3.1', False],
    ['~2.4', '2.4.0', False],  # >=2.4.0 <2.5.0
    ['~2.4', '2.4.5', False],
    ['~>3.2.1', '3.2.2', False],  # >=3.2.1 <3.3.0,
    ['~1', '1.2.3', False],  # >=1.0.0 <2.0.0
    ['~>1', '1.2.3', False],
    ['~> 1', '1.2.3', False],
    ['~1.0', '1.0.2', False],  # >=1.0.0 <1.1.0,
    ['~ 1.0', '1.0.2', False],
    ['~ 1.0.3', '1.0.12', False],
    ['>=1', '1.0.0', False],
    ['>= 1', '1.0.0', False],
    ['<1.2', '1.1.1', False],
    ['< 1.2', '1.1.1', False],
    ['1', '1.0.0beta', True],
    ['~v0.5.4-pre', '0.5.5', False],
    ['~v0.5.4-pre', '0.5.4', False],
    ['=0.7.x', '0.7.2', False],
    ['>=0.7.x', '0.7.2', False],
    ['=0.7.x', '0.7.0-asdf', False],
    ['>=0.7.x', '0.7.0-asdf', False],
    ['<=0.7.x', '0.6.2', False],
    ['~1.2.1 >=1.2.3', '1.2.3', False],
    ['~1.2.1 =1.2.3', '1.2.3', False],
    ['~1.2.1 1.2.3', '1.2.3', False],
    ['~1.2.1 >=1.2.3 1.2.3', '1.2.3', False],
    ['~1.2.1 1.2.3 >=1.2.3', '1.2.3', False],
    ['~1.2.1 1.2.3', '1.2.3', False],
    ['>=1.2.1 1.2.3', '1.2.3', False],
    ['1.2.3 >=1.2.1', '1.2.3', False],
    ['>=1.2.3 >=1.2.1', '1.2.3', False],
    ['>=1.2.1 >=1.2.3', '1.2.3', False],
    ['<=1.2.3', '1.2.3-beta', False],
    ['>1.2', '1.3.0-beta', False],
    ['>=1.2', '1.2.8', False],
    ['^1.2.3', '1.8.1', False],
    ['^1.2.3', '1.2.3-beta', False],
    ['^0.1.2', '0.1.2', False],
    ['^0.1', '0.1.2', False],
    ['^1.2', '1.4.2', False],
    ['^1.2 ^1', '1.4.2', False],
    ['^1.2', '1.2.0-pre', False],
    ['^1.2.3', '1.2.3-pre', False]
]
# cands =  [
#     ['^1.2', '1.4.2', False],
# ]

@pytest.mark.parametrize("range_, version, loose", cands)
def test_it(range_, version, loose):
    from semver import satisfies
    assert satisfies(version, range_, loose) is True
