# -*- coding:utf-8 -*-
import pytest
# node-semver/test/index.js
# import logging
# logging.basicConfig(level=logging.DEBUG, format="%(message)s")

# // validRange(range) -> result
# // translate ranges into their canonical form
cands =   [
    ['1.0.0 - 2.0.0', '>=1.0.0 <=2.0.0', False],
    ['1.0.0', '1.0.0', False],
    ['>=*', '>=0.0.0-0', False],
    ['', '*', False],
    ['*', '*', False],
    ['*', '*', False],
    ['>=1.0.0', '>=1.0.0', False],
    ['>1.0.0', '>1.0.0', False],
    ['<=2.0.0', '<=2.0.0', False],
    ['1', '>=1.0.0-0 <2.0.0-0', False],
    ['<=2.0.0', '<=2.0.0', False],
    ['<=2.0.0', '<=2.0.0', False],
    ['<2.0.0', '<2.0.0-0', False],
    ['<2.0.0', '<2.0.0-0', False],
    ['>= 1.0.0', '>=1.0.0', False],
    ['>=  1.0.0', '>=1.0.0', False],
    ['>=   1.0.0', '>=1.0.0', False],
    ['> 1.0.0', '>1.0.0', False],
    ['>  1.0.0', '>1.0.0', False],
    ['<=   2.0.0', '<=2.0.0', False],
    ['<= 2.0.0', '<=2.0.0', False],
    ['<=  2.0.0', '<=2.0.0', False],
    ['<    2.0.0', '<2.0.0-0', False],
    ['<	2.0.0', '<2.0.0-0', False],
    ['>=0.1.97', '>=0.1.97', False],
    ['>=0.1.97', '>=0.1.97', False],
    ['0.1.20 || 1.2.4', '0.1.20||1.2.4', False],
    ['>=0.2.3 || <0.0.1', '>=0.2.3||<0.0.1-0', False],
    ['>=0.2.3 || <0.0.1', '>=0.2.3||<0.0.1-0', False],
    ['>=0.2.3 || <0.0.1', '>=0.2.3||<0.0.1-0', False],
    ['||', '||', False],
    ['2.x.x', '>=2.0.0-0 <3.0.0-0', False],
    ['1.2.x', '>=1.2.0-0 <1.3.0-0', False],
    ['1.2.x || 2.x', '>=1.2.0-0 <1.3.0-0||>=2.0.0-0 <3.0.0-0', False],
    ['1.2.x || 2.x', '>=1.2.0-0 <1.3.0-0||>=2.0.0-0 <3.0.0-0', False],
    ['x', '*', False],
    ['2.*.*', '>=2.0.0-0 <3.0.0-0', False],
    ['1.2.*', '>=1.2.0-0 <1.3.0-0', False],
    ['1.2.* || 2.*', '>=1.2.0-0 <1.3.0-0||>=2.0.0-0 <3.0.0-0', False],
    ['*', '*', False],
    ['2', '>=2.0.0-0 <3.0.0-0', False],
    ['2.3', '>=2.3.0-0 <2.4.0-0', False],
    ['~2.4', '>=2.4.0-0 <2.5.0-0', False],
    ['~2.4', '>=2.4.0-0 <2.5.0-0', False],
    ['~>3.2.1', '>=3.2.1-0 <3.3.0-0', False],
    ['~1', '>=1.0.0-0 <2.0.0-0', False],
    ['~>1', '>=1.0.0-0 <2.0.0-0', False],
    ['~> 1', '>=1.0.0-0 <2.0.0-0', False],
    ['~1.0', '>=1.0.0-0 <1.1.0-0', False],
    ['~ 1.0', '>=1.0.0-0 <1.1.0-0', False],
    ['^0', '>=0.0.0-0 <1.0.0-0', False],
    ['^ 1', '>=1.0.0-0 <2.0.0-0', False],
    ['^0.1', '>=0.1.0-0 <0.2.0-0', False],
    ['^1.0', '>=1.0.0-0 <2.0.0-0', False],
    ['^1.2', '>=1.2.0-0 <2.0.0-0', False],
    ['^0.0.1', '=0.0.1', False],
    ['^0.0.1-beta', '=0.0.1-beta', False],
    ['^0.1.2', '>=0.1.2-0 <0.2.0-0', False],
    ['^1.2.3', '>=1.2.3-0 <2.0.0-0', False],
    ['^1.2.3-beta.4', '>=1.2.3-beta.4 <2.0.0-0', False],
    ['<1', '<1.0.0-0', False],
    ['< 1', '<1.0.0-0', False],
    ['>=1', '>=1.0.0-0', False],
    ['>= 1', '>=1.0.0-0', False],
    ['<1.2', '<1.2.0-0', False],
    ['< 1.2', '<1.2.0-0', False],
    ['1', '>=1.0.0-0 <2.0.0-0', False],
    ['>01.02.03', '>1.2.3', True],
    ['>01.02.03', None, False],
    ['~1.2.3beta', '>=1.2.3-beta <1.3.0-0', True],
    ['~1.2.3beta', None, False],
    ['^ 1.2 ^ 1', '>=1.2.0-0 <2.0.0-0 >=1.0.0-0 <2.0.0-0', False]
]

# cands =   [
#     ['^0.0.1', '=0.0.1', False],
# ]


@pytest.mark.parametrize("pre, wanted, loose", cands)
def test_it(pre, wanted, loose):
    from semver import valid_range
    assert valid_range(pre, loose) == wanted



