# Copyright 2019 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <https://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json
import pytest
from mock import ANY
from ansible.module_utils.network.fortios.fortios import FortiOSHandler

try:
    from ansible.modules.network.fortios import fortios_system_interface
except ImportError:
    pytest.skip("Could not load required modules for testing", allow_module_level=True)


@pytest.fixture(autouse=True)
def connection_mock(mocker):
    connection_class_mock = mocker.patch('ansible.modules.network.fortios.fortios_system_interface.Connection')
    return connection_class_mock


fos_instance = FortiOSHandler(connection_mock)


def test_system_interface_creation(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_interface': {
            'ac_name': 'test_value_3',
            'aggregate': 'test_value_4',
            'algorithm': 'L2',
            'alias': 'test_value_6',
            'ap_discover': 'enable',
            'arpforward': 'enable',
            'auth_type': 'auto',
            'auto_auth_extension_device': 'enable',
            'bfd': 'global',
            'bfd_desired_min_tx': '12',
            'bfd_detect_mult': '13',
            'bfd_required_min_rx': '14',
            'broadcast_forticlient_discovery': 'enable',
            'broadcast_forward': 'enable',
            'captive_portal': '17',
            'cli_conn_status': '18',
            'color': '19',
            'dedicated_to': 'none',
            'defaultgw': 'enable',
            'description': 'test_value_22',
            'detected_peer_mtu': '23',
            'detectprotocol': 'ping',
            'detectserver': 'test_value_25',
            'device_access_list': 'test_value_26',
            'device_identification': 'enable',
            'device_identification_active_scan': 'enable',
            'device_netscan': 'disable',
            'device_user_identification': 'enable',
            'devindex': '31',
            'dhcp_client_identifier': 'myId_32',
            'dhcp_relay_agent_option': 'enable',
            'dhcp_relay_ip': 'test_value_34',
            'dhcp_relay_service': 'disable',
            'dhcp_relay_type': 'regular',
            'dhcp_renew_time': '37',
            'disc_retry_timeout': '38',
            'disconnect_threshold': '39',
            'distance': '40',
            'dns_server_override': 'enable',
            'drop_fragment': 'enable',
            'drop_overlapped_fragment': 'enable',
            'egress_shaping_profile': 'test_value_44',
            'endpoint_compliance': 'enable',
            'estimated_downstream_bandwidth': '46',
            'estimated_upstream_bandwidth': '47',
            'explicit_ftp_proxy': 'enable',
            'explicit_web_proxy': 'enable',
            'external': 'enable',
            'fail_action_on_extender': 'soft-restart',
            'fail_alert_method': 'link-failed-signal',
            'fail_detect': 'enable',
            'fail_detect_option': 'detectserver',
            'fortiheartbeat': 'enable',
            'fortilink': 'enable',
            'fortilink_backup_link': '57',
            'fortilink_split_interface': 'enable',
            'fortilink_stacking': 'enable',
            'forward_domain': '60',
            'gwdetect': 'enable',
            'ha_priority': '62',
            'icmp_accept_redirect': 'enable',
            'icmp_send_redirect': 'enable',
            'ident_accept': 'enable',
            'idle_timeout': '66',
            'inbandwidth': '67',
            'ingress_spillover_threshold': '68',
            'interface': 'test_value_69',
            'internal': '70',
            'ip': 'test_value_71',
            'ipmac': 'enable',
            'ips_sniffer_mode': 'enable',
            'ipunnumbered': 'test_value_74',
            'l2forward': 'enable',
            'lacp_ha_slave': 'enable',
            'lacp_mode': 'static',
            'lacp_speed': 'slow',
            'lcp_echo_interval': '79',
            'lcp_max_echo_fails': '80',
            'link_up_delay': '81',
            'lldp_transmission': 'enable',
            'macaddr': 'test_value_83',
            'management_ip': 'test_value_84',
            'min_links': '85',
            'min_links_down': 'operational',
            'mode': 'static',
            'mtu': '88',
            'mtu_override': 'enable',
            'name': 'default_name_90',
            'ndiscforward': 'enable',
            'netbios_forward': 'disable',
            'netflow_sampler': 'disable',
            'outbandwidth': '94',
            'padt_retry_timeout': '95',
            'password': 'test_value_96',
            'ping_serv_status': '97',
            'polling_interval': '98',
            'pppoe_unnumbered_negotiate': 'enable',
            'pptp_auth_type': 'auto',
            'pptp_client': 'enable',
            'pptp_password': 'test_value_102',
            'pptp_server_ip': 'test_value_103',
            'pptp_timeout': '104',
            'pptp_user': 'test_value_105',
            'preserve_session_route': 'enable',
            'priority': '107',
            'priority_override': 'enable',
            'proxy_captive_portal': 'enable',
            'redundant_interface': 'test_value_110',
            'remote_ip': 'test_value_111',
            'replacemsg_override_group': 'test_value_112',
            'role': 'lan',
            'sample_direction': 'tx',
            'sample_rate': '115',
            'scan_botnet_connections': 'disable',
            'secondary_IP': 'enable',
            'security_exempt_list': 'test_value_118',
            'security_external_logout': 'test_value_119',
            'security_external_web': 'test_value_120',
            'security_mac_auth_bypass': 'enable',
            'security_mode': 'none',
            'security_redirect_url': 'test_value_123',
            'service_name': 'test_value_124',
            'sflow_sampler': 'enable',
            'snmp_index': '126',
            'speed': 'auto',
            'spillover_threshold': '128',
            'src_check': 'enable',
            'status': 'up',
            'stpforward': 'enable',
            'stpforward_mode': 'rpl-all-ext-id',
            'subst': 'enable',
            'substitute_dst_mac': 'test_value_134',
            'switch': 'test_value_135',
            'switch_controller_access_vlan': 'enable',
            'switch_controller_arp_inspection': 'enable',
            'switch_controller_dhcp_snooping': 'enable',
            'switch_controller_dhcp_snooping_option82': 'enable',
            'switch_controller_dhcp_snooping_verify_mac': 'enable',
            'switch_controller_igmp_snooping': 'enable',
            'switch_controller_learning_limit': '142',
            'tcp_mss': '143',
            'trust_ip_1': 'test_value_144',
            'trust_ip_2': 'test_value_145',
            'trust_ip_3': 'test_value_146',
            'trust_ip6_1': 'test_value_147',
            'trust_ip6_2': 'test_value_148',
            'trust_ip6_3': 'test_value_149',
            'type': 'physical',
            'username': 'test_value_151',
            'vdom': 'test_value_152',
            'vindex': '153',
            'vlanforward': 'enable',
            'vlanid': '155',
            'vrf': '156',
            'vrrp_virtual_mac': 'enable',
            'wccp': 'enable',
            'weight': '159',
            'wins_ip': 'test_value_160'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_interface.fortios_system(input_data, fos_instance)

    expected_data = {
        'ac-name': 'test_value_3',
        'aggregate': 'test_value_4',
        'algorithm': 'L2',
        'alias': 'test_value_6',
        'ap-discover': 'enable',
        'arpforward': 'enable',
        'auth-type': 'auto',
        'auto-auth-extension-device': 'enable',
        'bfd': 'global',
        'bfd-desired-min-tx': '12',
        'bfd-detect-mult': '13',
        'bfd-required-min-rx': '14',
        'broadcast-forticlient-discovery': 'enable',
        'broadcast-forward': 'enable',
        'captive-portal': '17',
        'cli-conn-status': '18',
        'color': '19',
        'dedicated-to': 'none',
        'defaultgw': 'enable',
        'description': 'test_value_22',
        'detected-peer-mtu': '23',
        'detectprotocol': 'ping',
        'detectserver': 'test_value_25',
        'device-access-list': 'test_value_26',
        'device-identification': 'enable',
        'device-identification-active-scan': 'enable',
        'device-netscan': 'disable',
        'device-user-identification': 'enable',
        'devindex': '31',
        'dhcp-client-identifier': 'myId_32',
        'dhcp-relay-agent-option': 'enable',
        'dhcp-relay-ip': 'test_value_34',
        'dhcp-relay-service': 'disable',
        'dhcp-relay-type': 'regular',
        'dhcp-renew-time': '37',
        'disc-retry-timeout': '38',
        'disconnect-threshold': '39',
        'distance': '40',
        'dns-server-override': 'enable',
        'drop-fragment': 'enable',
        'drop-overlapped-fragment': 'enable',
        'egress-shaping-profile': 'test_value_44',
        'endpoint-compliance': 'enable',
        'estimated-downstream-bandwidth': '46',
        'estimated-upstream-bandwidth': '47',
        'explicit-ftp-proxy': 'enable',
        'explicit-web-proxy': 'enable',
        'external': 'enable',
        'fail-action-on-extender': 'soft-restart',
        'fail-alert-method': 'link-failed-signal',
        'fail-detect': 'enable',
        'fail-detect-option': 'detectserver',
        'fortiheartbeat': 'enable',
        'fortilink': 'enable',
        'fortilink-backup-link': '57',
        'fortilink-split-interface': 'enable',
        'fortilink-stacking': 'enable',
        'forward-domain': '60',
        'gwdetect': 'enable',
        'ha-priority': '62',
        'icmp-accept-redirect': 'enable',
        'icmp-send-redirect': 'enable',
        'ident-accept': 'enable',
        'idle-timeout': '66',
        'inbandwidth': '67',
        'ingress-spillover-threshold': '68',
        'interface': 'test_value_69',
        'internal': '70',
        'ip': 'test_value_71',
        'ipmac': 'enable',
        'ips-sniffer-mode': 'enable',
        'ipunnumbered': 'test_value_74',
        'l2forward': 'enable',
        'lacp-ha-slave': 'enable',
        'lacp-mode': 'static',
        'lacp-speed': 'slow',
        'lcp-echo-interval': '79',
        'lcp-max-echo-fails': '80',
        'link-up-delay': '81',
        'lldp-transmission': 'enable',
        'macaddr': 'test_value_83',
        'management-ip': 'test_value_84',
        'min-links': '85',
        'min-links-down': 'operational',
        'mode': 'static',
                'mtu': '88',
                'mtu-override': 'enable',
                'name': 'default_name_90',
                'ndiscforward': 'enable',
                'netbios-forward': 'disable',
                'netflow-sampler': 'disable',
                'outbandwidth': '94',
                'padt-retry-timeout': '95',
                'password': 'test_value_96',
                'ping-serv-status': '97',
                'polling-interval': '98',
                'pppoe-unnumbered-negotiate': 'enable',
                'pptp-auth-type': 'auto',
                'pptp-client': 'enable',
                'pptp-password': 'test_value_102',
                'pptp-server-ip': 'test_value_103',
                'pptp-timeout': '104',
                'pptp-user': 'test_value_105',
                'preserve-session-route': 'enable',
                'priority': '107',
                'priority-override': 'enable',
                'proxy-captive-portal': 'enable',
                'redundant-interface': 'test_value_110',
                'remote-ip': 'test_value_111',
                'replacemsg-override-group': 'test_value_112',
                'role': 'lan',
                'sample-direction': 'tx',
                'sample-rate': '115',
                'scan-botnet-connections': 'disable',
                'secondary-IP': 'enable',
                'security-exempt-list': 'test_value_118',
                'security-external-logout': 'test_value_119',
                'security-external-web': 'test_value_120',
                'security-mac-auth-bypass': 'enable',
                'security-mode': 'none',
                'security-redirect-url': 'test_value_123',
                'service-name': 'test_value_124',
                'sflow-sampler': 'enable',
                'snmp-index': '126',
                'speed': 'auto',
                'spillover-threshold': '128',
                'src-check': 'enable',
                'status': 'up',
                'stpforward': 'enable',
                'stpforward-mode': 'rpl-all-ext-id',
                'subst': 'enable',
                'substitute-dst-mac': 'test_value_134',
                'switch': 'test_value_135',
                'switch-controller-access-vlan': 'enable',
                'switch-controller-arp-inspection': 'enable',
                'switch-controller-dhcp-snooping': 'enable',
                'switch-controller-dhcp-snooping-option82': 'enable',
                'switch-controller-dhcp-snooping-verify-mac': 'enable',
                'switch-controller-igmp-snooping': 'enable',
                'switch-controller-learning-limit': '142',
                'tcp-mss': '143',
                'trust-ip-1': 'test_value_144',
                'trust-ip-2': 'test_value_145',
                'trust-ip-3': 'test_value_146',
                'trust-ip6-1': 'test_value_147',
                'trust-ip6-2': 'test_value_148',
                'trust-ip6-3': 'test_value_149',
                'type': 'physical',
                'username': 'test_value_151',
                'vdom': 'test_value_152',
                'vindex': '153',
                'vlanforward': 'enable',
                'vlanid': '155',
                'vrf': '156',
                'vrrp-virtual-mac': 'enable',
                'wccp': 'enable',
                'weight': '159',
                'wins-ip': 'test_value_160'
    }

    set_method_mock.assert_called_with('system', 'interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_system_interface_creation_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_interface': {
            'ac_name': 'test_value_3',
            'aggregate': 'test_value_4',
            'algorithm': 'L2',
            'alias': 'test_value_6',
            'ap_discover': 'enable',
            'arpforward': 'enable',
            'auth_type': 'auto',
            'auto_auth_extension_device': 'enable',
            'bfd': 'global',
            'bfd_desired_min_tx': '12',
            'bfd_detect_mult': '13',
            'bfd_required_min_rx': '14',
            'broadcast_forticlient_discovery': 'enable',
            'broadcast_forward': 'enable',
            'captive_portal': '17',
            'cli_conn_status': '18',
            'color': '19',
            'dedicated_to': 'none',
            'defaultgw': 'enable',
            'description': 'test_value_22',
            'detected_peer_mtu': '23',
            'detectprotocol': 'ping',
            'detectserver': 'test_value_25',
            'device_access_list': 'test_value_26',
            'device_identification': 'enable',
            'device_identification_active_scan': 'enable',
            'device_netscan': 'disable',
            'device_user_identification': 'enable',
            'devindex': '31',
            'dhcp_client_identifier': 'myId_32',
            'dhcp_relay_agent_option': 'enable',
            'dhcp_relay_ip': 'test_value_34',
            'dhcp_relay_service': 'disable',
            'dhcp_relay_type': 'regular',
            'dhcp_renew_time': '37',
            'disc_retry_timeout': '38',
            'disconnect_threshold': '39',
            'distance': '40',
            'dns_server_override': 'enable',
            'drop_fragment': 'enable',
            'drop_overlapped_fragment': 'enable',
            'egress_shaping_profile': 'test_value_44',
            'endpoint_compliance': 'enable',
            'estimated_downstream_bandwidth': '46',
            'estimated_upstream_bandwidth': '47',
            'explicit_ftp_proxy': 'enable',
            'explicit_web_proxy': 'enable',
            'external': 'enable',
            'fail_action_on_extender': 'soft-restart',
            'fail_alert_method': 'link-failed-signal',
            'fail_detect': 'enable',
            'fail_detect_option': 'detectserver',
            'fortiheartbeat': 'enable',
            'fortilink': 'enable',
            'fortilink_backup_link': '57',
            'fortilink_split_interface': 'enable',
            'fortilink_stacking': 'enable',
            'forward_domain': '60',
            'gwdetect': 'enable',
            'ha_priority': '62',
            'icmp_accept_redirect': 'enable',
            'icmp_send_redirect': 'enable',
            'ident_accept': 'enable',
            'idle_timeout': '66',
            'inbandwidth': '67',
            'ingress_spillover_threshold': '68',
            'interface': 'test_value_69',
            'internal': '70',
            'ip': 'test_value_71',
            'ipmac': 'enable',
            'ips_sniffer_mode': 'enable',
            'ipunnumbered': 'test_value_74',
            'l2forward': 'enable',
            'lacp_ha_slave': 'enable',
            'lacp_mode': 'static',
            'lacp_speed': 'slow',
            'lcp_echo_interval': '79',
            'lcp_max_echo_fails': '80',
            'link_up_delay': '81',
            'lldp_transmission': 'enable',
            'macaddr': 'test_value_83',
            'management_ip': 'test_value_84',
            'min_links': '85',
            'min_links_down': 'operational',
            'mode': 'static',
            'mtu': '88',
            'mtu_override': 'enable',
            'name': 'default_name_90',
            'ndiscforward': 'enable',
            'netbios_forward': 'disable',
            'netflow_sampler': 'disable',
            'outbandwidth': '94',
            'padt_retry_timeout': '95',
            'password': 'test_value_96',
            'ping_serv_status': '97',
            'polling_interval': '98',
            'pppoe_unnumbered_negotiate': 'enable',
            'pptp_auth_type': 'auto',
            'pptp_client': 'enable',
            'pptp_password': 'test_value_102',
            'pptp_server_ip': 'test_value_103',
            'pptp_timeout': '104',
            'pptp_user': 'test_value_105',
            'preserve_session_route': 'enable',
            'priority': '107',
            'priority_override': 'enable',
            'proxy_captive_portal': 'enable',
            'redundant_interface': 'test_value_110',
            'remote_ip': 'test_value_111',
            'replacemsg_override_group': 'test_value_112',
            'role': 'lan',
            'sample_direction': 'tx',
            'sample_rate': '115',
            'scan_botnet_connections': 'disable',
            'secondary_IP': 'enable',
            'security_exempt_list': 'test_value_118',
            'security_external_logout': 'test_value_119',
            'security_external_web': 'test_value_120',
            'security_mac_auth_bypass': 'enable',
            'security_mode': 'none',
            'security_redirect_url': 'test_value_123',
            'service_name': 'test_value_124',
            'sflow_sampler': 'enable',
            'snmp_index': '126',
            'speed': 'auto',
            'spillover_threshold': '128',
            'src_check': 'enable',
            'status': 'up',
            'stpforward': 'enable',
            'stpforward_mode': 'rpl-all-ext-id',
            'subst': 'enable',
            'substitute_dst_mac': 'test_value_134',
            'switch': 'test_value_135',
            'switch_controller_access_vlan': 'enable',
            'switch_controller_arp_inspection': 'enable',
            'switch_controller_dhcp_snooping': 'enable',
            'switch_controller_dhcp_snooping_option82': 'enable',
            'switch_controller_dhcp_snooping_verify_mac': 'enable',
            'switch_controller_igmp_snooping': 'enable',
            'switch_controller_learning_limit': '142',
            'tcp_mss': '143',
            'trust_ip_1': 'test_value_144',
            'trust_ip_2': 'test_value_145',
            'trust_ip_3': 'test_value_146',
            'trust_ip6_1': 'test_value_147',
            'trust_ip6_2': 'test_value_148',
            'trust_ip6_3': 'test_value_149',
            'type': 'physical',
            'username': 'test_value_151',
            'vdom': 'test_value_152',
            'vindex': '153',
            'vlanforward': 'enable',
            'vlanid': '155',
            'vrf': '156',
            'vrrp_virtual_mac': 'enable',
            'wccp': 'enable',
            'weight': '159',
            'wins_ip': 'test_value_160'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_interface.fortios_system(input_data, fos_instance)

    expected_data = {
        'ac-name': 'test_value_3',
        'aggregate': 'test_value_4',
        'algorithm': 'L2',
        'alias': 'test_value_6',
        'ap-discover': 'enable',
        'arpforward': 'enable',
        'auth-type': 'auto',
        'auto-auth-extension-device': 'enable',
        'bfd': 'global',
        'bfd-desired-min-tx': '12',
        'bfd-detect-mult': '13',
        'bfd-required-min-rx': '14',
        'broadcast-forticlient-discovery': 'enable',
        'broadcast-forward': 'enable',
        'captive-portal': '17',
        'cli-conn-status': '18',
        'color': '19',
        'dedicated-to': 'none',
        'defaultgw': 'enable',
        'description': 'test_value_22',
        'detected-peer-mtu': '23',
        'detectprotocol': 'ping',
        'detectserver': 'test_value_25',
        'device-access-list': 'test_value_26',
        'device-identification': 'enable',
        'device-identification-active-scan': 'enable',
        'device-netscan': 'disable',
        'device-user-identification': 'enable',
        'devindex': '31',
        'dhcp-client-identifier': 'myId_32',
        'dhcp-relay-agent-option': 'enable',
        'dhcp-relay-ip': 'test_value_34',
        'dhcp-relay-service': 'disable',
        'dhcp-relay-type': 'regular',
        'dhcp-renew-time': '37',
        'disc-retry-timeout': '38',
        'disconnect-threshold': '39',
        'distance': '40',
        'dns-server-override': 'enable',
        'drop-fragment': 'enable',
        'drop-overlapped-fragment': 'enable',
        'egress-shaping-profile': 'test_value_44',
        'endpoint-compliance': 'enable',
        'estimated-downstream-bandwidth': '46',
        'estimated-upstream-bandwidth': '47',
        'explicit-ftp-proxy': 'enable',
        'explicit-web-proxy': 'enable',
        'external': 'enable',
        'fail-action-on-extender': 'soft-restart',
        'fail-alert-method': 'link-failed-signal',
        'fail-detect': 'enable',
        'fail-detect-option': 'detectserver',
        'fortiheartbeat': 'enable',
        'fortilink': 'enable',
        'fortilink-backup-link': '57',
        'fortilink-split-interface': 'enable',
        'fortilink-stacking': 'enable',
        'forward-domain': '60',
        'gwdetect': 'enable',
        'ha-priority': '62',
        'icmp-accept-redirect': 'enable',
        'icmp-send-redirect': 'enable',
        'ident-accept': 'enable',
        'idle-timeout': '66',
        'inbandwidth': '67',
        'ingress-spillover-threshold': '68',
        'interface': 'test_value_69',
        'internal': '70',
        'ip': 'test_value_71',
        'ipmac': 'enable',
        'ips-sniffer-mode': 'enable',
        'ipunnumbered': 'test_value_74',
        'l2forward': 'enable',
        'lacp-ha-slave': 'enable',
        'lacp-mode': 'static',
        'lacp-speed': 'slow',
        'lcp-echo-interval': '79',
        'lcp-max-echo-fails': '80',
        'link-up-delay': '81',
        'lldp-transmission': 'enable',
        'macaddr': 'test_value_83',
        'management-ip': 'test_value_84',
        'min-links': '85',
        'min-links-down': 'operational',
        'mode': 'static',
                'mtu': '88',
                'mtu-override': 'enable',
                'name': 'default_name_90',
                'ndiscforward': 'enable',
                'netbios-forward': 'disable',
                'netflow-sampler': 'disable',
                'outbandwidth': '94',
                'padt-retry-timeout': '95',
                'password': 'test_value_96',
                'ping-serv-status': '97',
                'polling-interval': '98',
                'pppoe-unnumbered-negotiate': 'enable',
                'pptp-auth-type': 'auto',
                'pptp-client': 'enable',
                'pptp-password': 'test_value_102',
                'pptp-server-ip': 'test_value_103',
                'pptp-timeout': '104',
                'pptp-user': 'test_value_105',
                'preserve-session-route': 'enable',
                'priority': '107',
                'priority-override': 'enable',
                'proxy-captive-portal': 'enable',
                'redundant-interface': 'test_value_110',
                'remote-ip': 'test_value_111',
                'replacemsg-override-group': 'test_value_112',
                'role': 'lan',
                'sample-direction': 'tx',
                'sample-rate': '115',
                'scan-botnet-connections': 'disable',
                'secondary-IP': 'enable',
                'security-exempt-list': 'test_value_118',
                'security-external-logout': 'test_value_119',
                'security-external-web': 'test_value_120',
                'security-mac-auth-bypass': 'enable',
                'security-mode': 'none',
                'security-redirect-url': 'test_value_123',
                'service-name': 'test_value_124',
                'sflow-sampler': 'enable',
                'snmp-index': '126',
                'speed': 'auto',
                'spillover-threshold': '128',
                'src-check': 'enable',
                'status': 'up',
                'stpforward': 'enable',
                'stpforward-mode': 'rpl-all-ext-id',
                'subst': 'enable',
                'substitute-dst-mac': 'test_value_134',
                'switch': 'test_value_135',
                'switch-controller-access-vlan': 'enable',
                'switch-controller-arp-inspection': 'enable',
                'switch-controller-dhcp-snooping': 'enable',
                'switch-controller-dhcp-snooping-option82': 'enable',
                'switch-controller-dhcp-snooping-verify-mac': 'enable',
                'switch-controller-igmp-snooping': 'enable',
                'switch-controller-learning-limit': '142',
                'tcp-mss': '143',
                'trust-ip-1': 'test_value_144',
                'trust-ip-2': 'test_value_145',
                'trust-ip-3': 'test_value_146',
                'trust-ip6-1': 'test_value_147',
                'trust-ip6-2': 'test_value_148',
                'trust-ip6-3': 'test_value_149',
                'type': 'physical',
                'username': 'test_value_151',
                'vdom': 'test_value_152',
                'vindex': '153',
                'vlanforward': 'enable',
                'vlanid': '155',
                'vrf': '156',
                'vrrp-virtual-mac': 'enable',
                'wccp': 'enable',
                'weight': '159',
                'wins-ip': 'test_value_160'
    }

    set_method_mock.assert_called_with('system', 'interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_system_interface_removal(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'system_interface': {
            'ac_name': 'test_value_3',
            'aggregate': 'test_value_4',
            'algorithm': 'L2',
            'alias': 'test_value_6',
            'ap_discover': 'enable',
            'arpforward': 'enable',
            'auth_type': 'auto',
            'auto_auth_extension_device': 'enable',
            'bfd': 'global',
            'bfd_desired_min_tx': '12',
            'bfd_detect_mult': '13',
            'bfd_required_min_rx': '14',
            'broadcast_forticlient_discovery': 'enable',
            'broadcast_forward': 'enable',
            'captive_portal': '17',
            'cli_conn_status': '18',
            'color': '19',
            'dedicated_to': 'none',
            'defaultgw': 'enable',
            'description': 'test_value_22',
            'detected_peer_mtu': '23',
            'detectprotocol': 'ping',
            'detectserver': 'test_value_25',
            'device_access_list': 'test_value_26',
            'device_identification': 'enable',
            'device_identification_active_scan': 'enable',
            'device_netscan': 'disable',
            'device_user_identification': 'enable',
            'devindex': '31',
            'dhcp_client_identifier': 'myId_32',
            'dhcp_relay_agent_option': 'enable',
            'dhcp_relay_ip': 'test_value_34',
            'dhcp_relay_service': 'disable',
            'dhcp_relay_type': 'regular',
            'dhcp_renew_time': '37',
            'disc_retry_timeout': '38',
            'disconnect_threshold': '39',
            'distance': '40',
            'dns_server_override': 'enable',
            'drop_fragment': 'enable',
            'drop_overlapped_fragment': 'enable',
            'egress_shaping_profile': 'test_value_44',
            'endpoint_compliance': 'enable',
            'estimated_downstream_bandwidth': '46',
            'estimated_upstream_bandwidth': '47',
            'explicit_ftp_proxy': 'enable',
            'explicit_web_proxy': 'enable',
            'external': 'enable',
            'fail_action_on_extender': 'soft-restart',
            'fail_alert_method': 'link-failed-signal',
            'fail_detect': 'enable',
            'fail_detect_option': 'detectserver',
            'fortiheartbeat': 'enable',
            'fortilink': 'enable',
            'fortilink_backup_link': '57',
            'fortilink_split_interface': 'enable',
            'fortilink_stacking': 'enable',
            'forward_domain': '60',
            'gwdetect': 'enable',
            'ha_priority': '62',
            'icmp_accept_redirect': 'enable',
            'icmp_send_redirect': 'enable',
            'ident_accept': 'enable',
            'idle_timeout': '66',
            'inbandwidth': '67',
            'ingress_spillover_threshold': '68',
            'interface': 'test_value_69',
            'internal': '70',
            'ip': 'test_value_71',
            'ipmac': 'enable',
            'ips_sniffer_mode': 'enable',
            'ipunnumbered': 'test_value_74',
            'l2forward': 'enable',
            'lacp_ha_slave': 'enable',
            'lacp_mode': 'static',
            'lacp_speed': 'slow',
            'lcp_echo_interval': '79',
            'lcp_max_echo_fails': '80',
            'link_up_delay': '81',
            'lldp_transmission': 'enable',
            'macaddr': 'test_value_83',
            'management_ip': 'test_value_84',
            'min_links': '85',
            'min_links_down': 'operational',
            'mode': 'static',
            'mtu': '88',
            'mtu_override': 'enable',
            'name': 'default_name_90',
            'ndiscforward': 'enable',
            'netbios_forward': 'disable',
            'netflow_sampler': 'disable',
            'outbandwidth': '94',
            'padt_retry_timeout': '95',
            'password': 'test_value_96',
            'ping_serv_status': '97',
            'polling_interval': '98',
            'pppoe_unnumbered_negotiate': 'enable',
            'pptp_auth_type': 'auto',
            'pptp_client': 'enable',
            'pptp_password': 'test_value_102',
            'pptp_server_ip': 'test_value_103',
            'pptp_timeout': '104',
            'pptp_user': 'test_value_105',
            'preserve_session_route': 'enable',
            'priority': '107',
            'priority_override': 'enable',
            'proxy_captive_portal': 'enable',
            'redundant_interface': 'test_value_110',
            'remote_ip': 'test_value_111',
            'replacemsg_override_group': 'test_value_112',
            'role': 'lan',
            'sample_direction': 'tx',
            'sample_rate': '115',
            'scan_botnet_connections': 'disable',
            'secondary_IP': 'enable',
            'security_exempt_list': 'test_value_118',
            'security_external_logout': 'test_value_119',
            'security_external_web': 'test_value_120',
            'security_mac_auth_bypass': 'enable',
            'security_mode': 'none',
            'security_redirect_url': 'test_value_123',
            'service_name': 'test_value_124',
            'sflow_sampler': 'enable',
            'snmp_index': '126',
            'speed': 'auto',
            'spillover_threshold': '128',
            'src_check': 'enable',
            'status': 'up',
            'stpforward': 'enable',
            'stpforward_mode': 'rpl-all-ext-id',
            'subst': 'enable',
            'substitute_dst_mac': 'test_value_134',
            'switch': 'test_value_135',
            'switch_controller_access_vlan': 'enable',
            'switch_controller_arp_inspection': 'enable',
            'switch_controller_dhcp_snooping': 'enable',
            'switch_controller_dhcp_snooping_option82': 'enable',
            'switch_controller_dhcp_snooping_verify_mac': 'enable',
            'switch_controller_igmp_snooping': 'enable',
            'switch_controller_learning_limit': '142',
            'tcp_mss': '143',
            'trust_ip_1': 'test_value_144',
            'trust_ip_2': 'test_value_145',
            'trust_ip_3': 'test_value_146',
            'trust_ip6_1': 'test_value_147',
            'trust_ip6_2': 'test_value_148',
            'trust_ip6_3': 'test_value_149',
            'type': 'physical',
            'username': 'test_value_151',
            'vdom': 'test_value_152',
            'vindex': '153',
            'vlanforward': 'enable',
            'vlanid': '155',
            'vrf': '156',
            'vrrp_virtual_mac': 'enable',
            'wccp': 'enable',
            'weight': '159',
            'wins_ip': 'test_value_160'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_interface.fortios_system(input_data, fos_instance)

    delete_method_mock.assert_called_with('system', 'interface', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_system_interface_deletion_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'system_interface': {
            'ac_name': 'test_value_3',
            'aggregate': 'test_value_4',
            'algorithm': 'L2',
            'alias': 'test_value_6',
            'ap_discover': 'enable',
            'arpforward': 'enable',
            'auth_type': 'auto',
            'auto_auth_extension_device': 'enable',
            'bfd': 'global',
            'bfd_desired_min_tx': '12',
            'bfd_detect_mult': '13',
            'bfd_required_min_rx': '14',
            'broadcast_forticlient_discovery': 'enable',
            'broadcast_forward': 'enable',
            'captive_portal': '17',
            'cli_conn_status': '18',
            'color': '19',
            'dedicated_to': 'none',
            'defaultgw': 'enable',
            'description': 'test_value_22',
            'detected_peer_mtu': '23',
            'detectprotocol': 'ping',
            'detectserver': 'test_value_25',
            'device_access_list': 'test_value_26',
            'device_identification': 'enable',
            'device_identification_active_scan': 'enable',
            'device_netscan': 'disable',
            'device_user_identification': 'enable',
            'devindex': '31',
            'dhcp_client_identifier': 'myId_32',
            'dhcp_relay_agent_option': 'enable',
            'dhcp_relay_ip': 'test_value_34',
            'dhcp_relay_service': 'disable',
            'dhcp_relay_type': 'regular',
            'dhcp_renew_time': '37',
            'disc_retry_timeout': '38',
            'disconnect_threshold': '39',
            'distance': '40',
            'dns_server_override': 'enable',
            'drop_fragment': 'enable',
            'drop_overlapped_fragment': 'enable',
            'egress_shaping_profile': 'test_value_44',
            'endpoint_compliance': 'enable',
            'estimated_downstream_bandwidth': '46',
            'estimated_upstream_bandwidth': '47',
            'explicit_ftp_proxy': 'enable',
            'explicit_web_proxy': 'enable',
            'external': 'enable',
            'fail_action_on_extender': 'soft-restart',
            'fail_alert_method': 'link-failed-signal',
            'fail_detect': 'enable',
            'fail_detect_option': 'detectserver',
            'fortiheartbeat': 'enable',
            'fortilink': 'enable',
            'fortilink_backup_link': '57',
            'fortilink_split_interface': 'enable',
            'fortilink_stacking': 'enable',
            'forward_domain': '60',
            'gwdetect': 'enable',
            'ha_priority': '62',
            'icmp_accept_redirect': 'enable',
            'icmp_send_redirect': 'enable',
            'ident_accept': 'enable',
            'idle_timeout': '66',
            'inbandwidth': '67',
            'ingress_spillover_threshold': '68',
            'interface': 'test_value_69',
            'internal': '70',
            'ip': 'test_value_71',
            'ipmac': 'enable',
            'ips_sniffer_mode': 'enable',
            'ipunnumbered': 'test_value_74',
            'l2forward': 'enable',
            'lacp_ha_slave': 'enable',
            'lacp_mode': 'static',
            'lacp_speed': 'slow',
            'lcp_echo_interval': '79',
            'lcp_max_echo_fails': '80',
            'link_up_delay': '81',
            'lldp_transmission': 'enable',
            'macaddr': 'test_value_83',
            'management_ip': 'test_value_84',
            'min_links': '85',
            'min_links_down': 'operational',
            'mode': 'static',
            'mtu': '88',
            'mtu_override': 'enable',
            'name': 'default_name_90',
            'ndiscforward': 'enable',
            'netbios_forward': 'disable',
            'netflow_sampler': 'disable',
            'outbandwidth': '94',
            'padt_retry_timeout': '95',
            'password': 'test_value_96',
            'ping_serv_status': '97',
            'polling_interval': '98',
            'pppoe_unnumbered_negotiate': 'enable',
            'pptp_auth_type': 'auto',
            'pptp_client': 'enable',
            'pptp_password': 'test_value_102',
            'pptp_server_ip': 'test_value_103',
            'pptp_timeout': '104',
            'pptp_user': 'test_value_105',
            'preserve_session_route': 'enable',
            'priority': '107',
            'priority_override': 'enable',
            'proxy_captive_portal': 'enable',
            'redundant_interface': 'test_value_110',
            'remote_ip': 'test_value_111',
            'replacemsg_override_group': 'test_value_112',
            'role': 'lan',
            'sample_direction': 'tx',
            'sample_rate': '115',
            'scan_botnet_connections': 'disable',
            'secondary_IP': 'enable',
            'security_exempt_list': 'test_value_118',
            'security_external_logout': 'test_value_119',
            'security_external_web': 'test_value_120',
            'security_mac_auth_bypass': 'enable',
            'security_mode': 'none',
            'security_redirect_url': 'test_value_123',
            'service_name': 'test_value_124',
            'sflow_sampler': 'enable',
            'snmp_index': '126',
            'speed': 'auto',
            'spillover_threshold': '128',
            'src_check': 'enable',
            'status': 'up',
            'stpforward': 'enable',
            'stpforward_mode': 'rpl-all-ext-id',
            'subst': 'enable',
            'substitute_dst_mac': 'test_value_134',
            'switch': 'test_value_135',
            'switch_controller_access_vlan': 'enable',
            'switch_controller_arp_inspection': 'enable',
            'switch_controller_dhcp_snooping': 'enable',
            'switch_controller_dhcp_snooping_option82': 'enable',
            'switch_controller_dhcp_snooping_verify_mac': 'enable',
            'switch_controller_igmp_snooping': 'enable',
            'switch_controller_learning_limit': '142',
            'tcp_mss': '143',
            'trust_ip_1': 'test_value_144',
            'trust_ip_2': 'test_value_145',
            'trust_ip_3': 'test_value_146',
            'trust_ip6_1': 'test_value_147',
            'trust_ip6_2': 'test_value_148',
            'trust_ip6_3': 'test_value_149',
            'type': 'physical',
            'username': 'test_value_151',
            'vdom': 'test_value_152',
            'vindex': '153',
            'vlanforward': 'enable',
            'vlanid': '155',
            'vrf': '156',
            'vrrp_virtual_mac': 'enable',
            'wccp': 'enable',
            'weight': '159',
            'wins_ip': 'test_value_160'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_interface.fortios_system(input_data, fos_instance)

    delete_method_mock.assert_called_with('system', 'interface', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_system_interface_idempotent(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'DELETE', 'http_status': 404}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_interface': {
            'ac_name': 'test_value_3',
            'aggregate': 'test_value_4',
            'algorithm': 'L2',
            'alias': 'test_value_6',
            'ap_discover': 'enable',
            'arpforward': 'enable',
            'auth_type': 'auto',
            'auto_auth_extension_device': 'enable',
            'bfd': 'global',
            'bfd_desired_min_tx': '12',
            'bfd_detect_mult': '13',
            'bfd_required_min_rx': '14',
            'broadcast_forticlient_discovery': 'enable',
            'broadcast_forward': 'enable',
            'captive_portal': '17',
            'cli_conn_status': '18',
            'color': '19',
            'dedicated_to': 'none',
            'defaultgw': 'enable',
            'description': 'test_value_22',
            'detected_peer_mtu': '23',
            'detectprotocol': 'ping',
            'detectserver': 'test_value_25',
            'device_access_list': 'test_value_26',
            'device_identification': 'enable',
            'device_identification_active_scan': 'enable',
            'device_netscan': 'disable',
            'device_user_identification': 'enable',
            'devindex': '31',
            'dhcp_client_identifier': 'myId_32',
            'dhcp_relay_agent_option': 'enable',
            'dhcp_relay_ip': 'test_value_34',
            'dhcp_relay_service': 'disable',
            'dhcp_relay_type': 'regular',
            'dhcp_renew_time': '37',
            'disc_retry_timeout': '38',
            'disconnect_threshold': '39',
            'distance': '40',
            'dns_server_override': 'enable',
            'drop_fragment': 'enable',
            'drop_overlapped_fragment': 'enable',
            'egress_shaping_profile': 'test_value_44',
            'endpoint_compliance': 'enable',
            'estimated_downstream_bandwidth': '46',
            'estimated_upstream_bandwidth': '47',
            'explicit_ftp_proxy': 'enable',
            'explicit_web_proxy': 'enable',
            'external': 'enable',
            'fail_action_on_extender': 'soft-restart',
            'fail_alert_method': 'link-failed-signal',
            'fail_detect': 'enable',
            'fail_detect_option': 'detectserver',
            'fortiheartbeat': 'enable',
            'fortilink': 'enable',
            'fortilink_backup_link': '57',
            'fortilink_split_interface': 'enable',
            'fortilink_stacking': 'enable',
            'forward_domain': '60',
            'gwdetect': 'enable',
            'ha_priority': '62',
            'icmp_accept_redirect': 'enable',
            'icmp_send_redirect': 'enable',
            'ident_accept': 'enable',
            'idle_timeout': '66',
            'inbandwidth': '67',
            'ingress_spillover_threshold': '68',
            'interface': 'test_value_69',
            'internal': '70',
            'ip': 'test_value_71',
            'ipmac': 'enable',
            'ips_sniffer_mode': 'enable',
            'ipunnumbered': 'test_value_74',
            'l2forward': 'enable',
            'lacp_ha_slave': 'enable',
            'lacp_mode': 'static',
            'lacp_speed': 'slow',
            'lcp_echo_interval': '79',
            'lcp_max_echo_fails': '80',
            'link_up_delay': '81',
            'lldp_transmission': 'enable',
            'macaddr': 'test_value_83',
            'management_ip': 'test_value_84',
            'min_links': '85',
            'min_links_down': 'operational',
            'mode': 'static',
            'mtu': '88',
            'mtu_override': 'enable',
            'name': 'default_name_90',
            'ndiscforward': 'enable',
            'netbios_forward': 'disable',
            'netflow_sampler': 'disable',
            'outbandwidth': '94',
            'padt_retry_timeout': '95',
            'password': 'test_value_96',
            'ping_serv_status': '97',
            'polling_interval': '98',
            'pppoe_unnumbered_negotiate': 'enable',
            'pptp_auth_type': 'auto',
            'pptp_client': 'enable',
            'pptp_password': 'test_value_102',
            'pptp_server_ip': 'test_value_103',
            'pptp_timeout': '104',
            'pptp_user': 'test_value_105',
            'preserve_session_route': 'enable',
            'priority': '107',
            'priority_override': 'enable',
            'proxy_captive_portal': 'enable',
            'redundant_interface': 'test_value_110',
            'remote_ip': 'test_value_111',
            'replacemsg_override_group': 'test_value_112',
            'role': 'lan',
            'sample_direction': 'tx',
            'sample_rate': '115',
            'scan_botnet_connections': 'disable',
            'secondary_IP': 'enable',
            'security_exempt_list': 'test_value_118',
            'security_external_logout': 'test_value_119',
            'security_external_web': 'test_value_120',
            'security_mac_auth_bypass': 'enable',
            'security_mode': 'none',
            'security_redirect_url': 'test_value_123',
            'service_name': 'test_value_124',
            'sflow_sampler': 'enable',
            'snmp_index': '126',
            'speed': 'auto',
            'spillover_threshold': '128',
            'src_check': 'enable',
            'status': 'up',
            'stpforward': 'enable',
            'stpforward_mode': 'rpl-all-ext-id',
            'subst': 'enable',
            'substitute_dst_mac': 'test_value_134',
            'switch': 'test_value_135',
            'switch_controller_access_vlan': 'enable',
            'switch_controller_arp_inspection': 'enable',
            'switch_controller_dhcp_snooping': 'enable',
            'switch_controller_dhcp_snooping_option82': 'enable',
            'switch_controller_dhcp_snooping_verify_mac': 'enable',
            'switch_controller_igmp_snooping': 'enable',
            'switch_controller_learning_limit': '142',
            'tcp_mss': '143',
            'trust_ip_1': 'test_value_144',
            'trust_ip_2': 'test_value_145',
            'trust_ip_3': 'test_value_146',
            'trust_ip6_1': 'test_value_147',
            'trust_ip6_2': 'test_value_148',
            'trust_ip6_3': 'test_value_149',
            'type': 'physical',
            'username': 'test_value_151',
            'vdom': 'test_value_152',
            'vindex': '153',
            'vlanforward': 'enable',
            'vlanid': '155',
            'vrf': '156',
            'vrrp_virtual_mac': 'enable',
            'wccp': 'enable',
            'weight': '159',
            'wins_ip': 'test_value_160'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_interface.fortios_system(input_data, fos_instance)

    expected_data = {
        'ac-name': 'test_value_3',
        'aggregate': 'test_value_4',
        'algorithm': 'L2',
        'alias': 'test_value_6',
        'ap-discover': 'enable',
        'arpforward': 'enable',
        'auth-type': 'auto',
        'auto-auth-extension-device': 'enable',
        'bfd': 'global',
        'bfd-desired-min-tx': '12',
        'bfd-detect-mult': '13',
        'bfd-required-min-rx': '14',
        'broadcast-forticlient-discovery': 'enable',
        'broadcast-forward': 'enable',
        'captive-portal': '17',
        'cli-conn-status': '18',
        'color': '19',
        'dedicated-to': 'none',
        'defaultgw': 'enable',
        'description': 'test_value_22',
        'detected-peer-mtu': '23',
        'detectprotocol': 'ping',
        'detectserver': 'test_value_25',
        'device-access-list': 'test_value_26',
        'device-identification': 'enable',
        'device-identification-active-scan': 'enable',
        'device-netscan': 'disable',
        'device-user-identification': 'enable',
        'devindex': '31',
        'dhcp-client-identifier': 'myId_32',
        'dhcp-relay-agent-option': 'enable',
        'dhcp-relay-ip': 'test_value_34',
        'dhcp-relay-service': 'disable',
        'dhcp-relay-type': 'regular',
        'dhcp-renew-time': '37',
        'disc-retry-timeout': '38',
        'disconnect-threshold': '39',
        'distance': '40',
        'dns-server-override': 'enable',
        'drop-fragment': 'enable',
        'drop-overlapped-fragment': 'enable',
        'egress-shaping-profile': 'test_value_44',
        'endpoint-compliance': 'enable',
        'estimated-downstream-bandwidth': '46',
        'estimated-upstream-bandwidth': '47',
        'explicit-ftp-proxy': 'enable',
        'explicit-web-proxy': 'enable',
        'external': 'enable',
        'fail-action-on-extender': 'soft-restart',
        'fail-alert-method': 'link-failed-signal',
        'fail-detect': 'enable',
        'fail-detect-option': 'detectserver',
        'fortiheartbeat': 'enable',
        'fortilink': 'enable',
        'fortilink-backup-link': '57',
        'fortilink-split-interface': 'enable',
        'fortilink-stacking': 'enable',
        'forward-domain': '60',
        'gwdetect': 'enable',
        'ha-priority': '62',
        'icmp-accept-redirect': 'enable',
        'icmp-send-redirect': 'enable',
        'ident-accept': 'enable',
        'idle-timeout': '66',
        'inbandwidth': '67',
        'ingress-spillover-threshold': '68',
        'interface': 'test_value_69',
        'internal': '70',
        'ip': 'test_value_71',
        'ipmac': 'enable',
        'ips-sniffer-mode': 'enable',
        'ipunnumbered': 'test_value_74',
        'l2forward': 'enable',
        'lacp-ha-slave': 'enable',
        'lacp-mode': 'static',
        'lacp-speed': 'slow',
        'lcp-echo-interval': '79',
        'lcp-max-echo-fails': '80',
        'link-up-delay': '81',
        'lldp-transmission': 'enable',
        'macaddr': 'test_value_83',
        'management-ip': 'test_value_84',
        'min-links': '85',
        'min-links-down': 'operational',
        'mode': 'static',
                'mtu': '88',
                'mtu-override': 'enable',
                'name': 'default_name_90',
                'ndiscforward': 'enable',
                'netbios-forward': 'disable',
                'netflow-sampler': 'disable',
                'outbandwidth': '94',
                'padt-retry-timeout': '95',
                'password': 'test_value_96',
                'ping-serv-status': '97',
                'polling-interval': '98',
                'pppoe-unnumbered-negotiate': 'enable',
                'pptp-auth-type': 'auto',
                'pptp-client': 'enable',
                'pptp-password': 'test_value_102',
                'pptp-server-ip': 'test_value_103',
                'pptp-timeout': '104',
                'pptp-user': 'test_value_105',
                'preserve-session-route': 'enable',
                'priority': '107',
                'priority-override': 'enable',
                'proxy-captive-portal': 'enable',
                'redundant-interface': 'test_value_110',
                'remote-ip': 'test_value_111',
                'replacemsg-override-group': 'test_value_112',
                'role': 'lan',
                'sample-direction': 'tx',
                'sample-rate': '115',
                'scan-botnet-connections': 'disable',
                'secondary-IP': 'enable',
                'security-exempt-list': 'test_value_118',
                'security-external-logout': 'test_value_119',
                'security-external-web': 'test_value_120',
                'security-mac-auth-bypass': 'enable',
                'security-mode': 'none',
                'security-redirect-url': 'test_value_123',
                'service-name': 'test_value_124',
                'sflow-sampler': 'enable',
                'snmp-index': '126',
                'speed': 'auto',
                'spillover-threshold': '128',
                'src-check': 'enable',
                'status': 'up',
                'stpforward': 'enable',
                'stpforward-mode': 'rpl-all-ext-id',
                'subst': 'enable',
                'substitute-dst-mac': 'test_value_134',
                'switch': 'test_value_135',
                'switch-controller-access-vlan': 'enable',
                'switch-controller-arp-inspection': 'enable',
                'switch-controller-dhcp-snooping': 'enable',
                'switch-controller-dhcp-snooping-option82': 'enable',
                'switch-controller-dhcp-snooping-verify-mac': 'enable',
                'switch-controller-igmp-snooping': 'enable',
                'switch-controller-learning-limit': '142',
                'tcp-mss': '143',
                'trust-ip-1': 'test_value_144',
                'trust-ip-2': 'test_value_145',
                'trust-ip-3': 'test_value_146',
                'trust-ip6-1': 'test_value_147',
                'trust-ip6-2': 'test_value_148',
                'trust-ip6-3': 'test_value_149',
                'type': 'physical',
                'username': 'test_value_151',
                'vdom': 'test_value_152',
                'vindex': '153',
                'vlanforward': 'enable',
                'vlanid': '155',
                'vrf': '156',
                'vrrp-virtual-mac': 'enable',
                'wccp': 'enable',
                'weight': '159',
                'wins-ip': 'test_value_160'
    }

    set_method_mock.assert_called_with('system', 'interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 404


def test_system_interface_filter_foreign_attributes(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_interface': {
            'random_attribute_not_valid': 'tag',
            'ac_name': 'test_value_3',
            'aggregate': 'test_value_4',
            'algorithm': 'L2',
            'alias': 'test_value_6',
            'ap_discover': 'enable',
            'arpforward': 'enable',
            'auth_type': 'auto',
            'auto_auth_extension_device': 'enable',
            'bfd': 'global',
            'bfd_desired_min_tx': '12',
            'bfd_detect_mult': '13',
            'bfd_required_min_rx': '14',
            'broadcast_forticlient_discovery': 'enable',
            'broadcast_forward': 'enable',
            'captive_portal': '17',
            'cli_conn_status': '18',
            'color': '19',
            'dedicated_to': 'none',
            'defaultgw': 'enable',
            'description': 'test_value_22',
            'detected_peer_mtu': '23',
            'detectprotocol': 'ping',
            'detectserver': 'test_value_25',
            'device_access_list': 'test_value_26',
            'device_identification': 'enable',
            'device_identification_active_scan': 'enable',
            'device_netscan': 'disable',
            'device_user_identification': 'enable',
            'devindex': '31',
            'dhcp_client_identifier': 'myId_32',
            'dhcp_relay_agent_option': 'enable',
            'dhcp_relay_ip': 'test_value_34',
            'dhcp_relay_service': 'disable',
            'dhcp_relay_type': 'regular',
            'dhcp_renew_time': '37',
            'disc_retry_timeout': '38',
            'disconnect_threshold': '39',
            'distance': '40',
            'dns_server_override': 'enable',
            'drop_fragment': 'enable',
            'drop_overlapped_fragment': 'enable',
            'egress_shaping_profile': 'test_value_44',
            'endpoint_compliance': 'enable',
            'estimated_downstream_bandwidth': '46',
            'estimated_upstream_bandwidth': '47',
            'explicit_ftp_proxy': 'enable',
            'explicit_web_proxy': 'enable',
            'external': 'enable',
            'fail_action_on_extender': 'soft-restart',
            'fail_alert_method': 'link-failed-signal',
            'fail_detect': 'enable',
            'fail_detect_option': 'detectserver',
            'fortiheartbeat': 'enable',
            'fortilink': 'enable',
            'fortilink_backup_link': '57',
            'fortilink_split_interface': 'enable',
            'fortilink_stacking': 'enable',
            'forward_domain': '60',
            'gwdetect': 'enable',
            'ha_priority': '62',
            'icmp_accept_redirect': 'enable',
            'icmp_send_redirect': 'enable',
            'ident_accept': 'enable',
            'idle_timeout': '66',
            'inbandwidth': '67',
            'ingress_spillover_threshold': '68',
            'interface': 'test_value_69',
            'internal': '70',
            'ip': 'test_value_71',
            'ipmac': 'enable',
            'ips_sniffer_mode': 'enable',
            'ipunnumbered': 'test_value_74',
            'l2forward': 'enable',
            'lacp_ha_slave': 'enable',
            'lacp_mode': 'static',
            'lacp_speed': 'slow',
            'lcp_echo_interval': '79',
            'lcp_max_echo_fails': '80',
            'link_up_delay': '81',
            'lldp_transmission': 'enable',
            'macaddr': 'test_value_83',
            'management_ip': 'test_value_84',
            'min_links': '85',
            'min_links_down': 'operational',
            'mode': 'static',
            'mtu': '88',
            'mtu_override': 'enable',
            'name': 'default_name_90',
            'ndiscforward': 'enable',
            'netbios_forward': 'disable',
            'netflow_sampler': 'disable',
            'outbandwidth': '94',
            'padt_retry_timeout': '95',
            'password': 'test_value_96',
            'ping_serv_status': '97',
            'polling_interval': '98',
            'pppoe_unnumbered_negotiate': 'enable',
            'pptp_auth_type': 'auto',
            'pptp_client': 'enable',
            'pptp_password': 'test_value_102',
            'pptp_server_ip': 'test_value_103',
            'pptp_timeout': '104',
            'pptp_user': 'test_value_105',
            'preserve_session_route': 'enable',
            'priority': '107',
            'priority_override': 'enable',
            'proxy_captive_portal': 'enable',
            'redundant_interface': 'test_value_110',
            'remote_ip': 'test_value_111',
            'replacemsg_override_group': 'test_value_112',
            'role': 'lan',
            'sample_direction': 'tx',
            'sample_rate': '115',
            'scan_botnet_connections': 'disable',
            'secondary_IP': 'enable',
            'security_exempt_list': 'test_value_118',
            'security_external_logout': 'test_value_119',
            'security_external_web': 'test_value_120',
            'security_mac_auth_bypass': 'enable',
            'security_mode': 'none',
            'security_redirect_url': 'test_value_123',
            'service_name': 'test_value_124',
            'sflow_sampler': 'enable',
            'snmp_index': '126',
            'speed': 'auto',
            'spillover_threshold': '128',
            'src_check': 'enable',
            'status': 'up',
            'stpforward': 'enable',
            'stpforward_mode': 'rpl-all-ext-id',
            'subst': 'enable',
            'substitute_dst_mac': 'test_value_134',
            'switch': 'test_value_135',
            'switch_controller_access_vlan': 'enable',
            'switch_controller_arp_inspection': 'enable',
            'switch_controller_dhcp_snooping': 'enable',
            'switch_controller_dhcp_snooping_option82': 'enable',
            'switch_controller_dhcp_snooping_verify_mac': 'enable',
            'switch_controller_igmp_snooping': 'enable',
            'switch_controller_learning_limit': '142',
            'tcp_mss': '143',
            'trust_ip_1': 'test_value_144',
            'trust_ip_2': 'test_value_145',
            'trust_ip_3': 'test_value_146',
            'trust_ip6_1': 'test_value_147',
            'trust_ip6_2': 'test_value_148',
            'trust_ip6_3': 'test_value_149',
            'type': 'physical',
            'username': 'test_value_151',
            'vdom': 'test_value_152',
            'vindex': '153',
            'vlanforward': 'enable',
            'vlanid': '155',
            'vrf': '156',
            'vrrp_virtual_mac': 'enable',
            'wccp': 'enable',
            'weight': '159',
            'wins_ip': 'test_value_160'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_interface.fortios_system(input_data, fos_instance)

    expected_data = {
        'ac-name': 'test_value_3',
        'aggregate': 'test_value_4',
        'algorithm': 'L2',
        'alias': 'test_value_6',
        'ap-discover': 'enable',
        'arpforward': 'enable',
        'auth-type': 'auto',
        'auto-auth-extension-device': 'enable',
        'bfd': 'global',
        'bfd-desired-min-tx': '12',
        'bfd-detect-mult': '13',
        'bfd-required-min-rx': '14',
        'broadcast-forticlient-discovery': 'enable',
        'broadcast-forward': 'enable',
        'captive-portal': '17',
        'cli-conn-status': '18',
        'color': '19',
        'dedicated-to': 'none',
        'defaultgw': 'enable',
        'description': 'test_value_22',
        'detected-peer-mtu': '23',
        'detectprotocol': 'ping',
        'detectserver': 'test_value_25',
        'device-access-list': 'test_value_26',
        'device-identification': 'enable',
        'device-identification-active-scan': 'enable',
        'device-netscan': 'disable',
        'device-user-identification': 'enable',
        'devindex': '31',
        'dhcp-client-identifier': 'myId_32',
        'dhcp-relay-agent-option': 'enable',
        'dhcp-relay-ip': 'test_value_34',
        'dhcp-relay-service': 'disable',
        'dhcp-relay-type': 'regular',
        'dhcp-renew-time': '37',
        'disc-retry-timeout': '38',
        'disconnect-threshold': '39',
        'distance': '40',
        'dns-server-override': 'enable',
        'drop-fragment': 'enable',
        'drop-overlapped-fragment': 'enable',
        'egress-shaping-profile': 'test_value_44',
        'endpoint-compliance': 'enable',
        'estimated-downstream-bandwidth': '46',
        'estimated-upstream-bandwidth': '47',
        'explicit-ftp-proxy': 'enable',
        'explicit-web-proxy': 'enable',
        'external': 'enable',
        'fail-action-on-extender': 'soft-restart',
        'fail-alert-method': 'link-failed-signal',
        'fail-detect': 'enable',
        'fail-detect-option': 'detectserver',
        'fortiheartbeat': 'enable',
        'fortilink': 'enable',
        'fortilink-backup-link': '57',
        'fortilink-split-interface': 'enable',
        'fortilink-stacking': 'enable',
        'forward-domain': '60',
        'gwdetect': 'enable',
        'ha-priority': '62',
        'icmp-accept-redirect': 'enable',
        'icmp-send-redirect': 'enable',
        'ident-accept': 'enable',
        'idle-timeout': '66',
        'inbandwidth': '67',
        'ingress-spillover-threshold': '68',
        'interface': 'test_value_69',
        'internal': '70',
        'ip': 'test_value_71',
        'ipmac': 'enable',
        'ips-sniffer-mode': 'enable',
        'ipunnumbered': 'test_value_74',
        'l2forward': 'enable',
        'lacp-ha-slave': 'enable',
        'lacp-mode': 'static',
        'lacp-speed': 'slow',
        'lcp-echo-interval': '79',
        'lcp-max-echo-fails': '80',
        'link-up-delay': '81',
        'lldp-transmission': 'enable',
        'macaddr': 'test_value_83',
        'management-ip': 'test_value_84',
        'min-links': '85',
        'min-links-down': 'operational',
        'mode': 'static',
                'mtu': '88',
                'mtu-override': 'enable',
                'name': 'default_name_90',
                'ndiscforward': 'enable',
                'netbios-forward': 'disable',
                'netflow-sampler': 'disable',
                'outbandwidth': '94',
                'padt-retry-timeout': '95',
                'password': 'test_value_96',
                'ping-serv-status': '97',
                'polling-interval': '98',
                'pppoe-unnumbered-negotiate': 'enable',
                'pptp-auth-type': 'auto',
                'pptp-client': 'enable',
                'pptp-password': 'test_value_102',
                'pptp-server-ip': 'test_value_103',
                'pptp-timeout': '104',
                'pptp-user': 'test_value_105',
                'preserve-session-route': 'enable',
                'priority': '107',
                'priority-override': 'enable',
                'proxy-captive-portal': 'enable',
                'redundant-interface': 'test_value_110',
                'remote-ip': 'test_value_111',
                'replacemsg-override-group': 'test_value_112',
                'role': 'lan',
                'sample-direction': 'tx',
                'sample-rate': '115',
                'scan-botnet-connections': 'disable',
                'secondary-IP': 'enable',
                'security-exempt-list': 'test_value_118',
                'security-external-logout': 'test_value_119',
                'security-external-web': 'test_value_120',
                'security-mac-auth-bypass': 'enable',
                'security-mode': 'none',
                'security-redirect-url': 'test_value_123',
                'service-name': 'test_value_124',
                'sflow-sampler': 'enable',
                'snmp-index': '126',
                'speed': 'auto',
                'spillover-threshold': '128',
                'src-check': 'enable',
                'status': 'up',
                'stpforward': 'enable',
                'stpforward-mode': 'rpl-all-ext-id',
                'subst': 'enable',
                'substitute-dst-mac': 'test_value_134',
                'switch': 'test_value_135',
                'switch-controller-access-vlan': 'enable',
                'switch-controller-arp-inspection': 'enable',
                'switch-controller-dhcp-snooping': 'enable',
                'switch-controller-dhcp-snooping-option82': 'enable',
                'switch-controller-dhcp-snooping-verify-mac': 'enable',
                'switch-controller-igmp-snooping': 'enable',
                'switch-controller-learning-limit': '142',
                'tcp-mss': '143',
                'trust-ip-1': 'test_value_144',
                'trust-ip-2': 'test_value_145',
                'trust-ip-3': 'test_value_146',
                'trust-ip6-1': 'test_value_147',
                'trust-ip6-2': 'test_value_148',
                'trust-ip6-3': 'test_value_149',
                'type': 'physical',
                'username': 'test_value_151',
                'vdom': 'test_value_152',
                'vindex': '153',
                'vlanforward': 'enable',
                'vlanid': '155',
                'vrf': '156',
                'vrrp-virtual-mac': 'enable',
                'wccp': 'enable',
                'weight': '159',
                'wins-ip': 'test_value_160'
    }

    set_method_mock.assert_called_with('system', 'interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200
