(*
Module: Test_LVM
  Provides unit tests and examples for the <LVM> lens.
*)

module Test_LVM =

(* Variable: conf
   A full configuration file *)
let conf = "# Generated by LVM2: date

contents = \"Text Format Volume Group\"
version = 1

description = \"Created *after* executing 'eek'\"

creation_host = \"eek\"		# Linux eek
creation_time = 6666666666	# eeeek

VG1 {
	id = \"uuid-uuid-uuid-uuid\"
	seqno = 2
	status = [\"RESIZEABLE\", \"READ\", \"WRITE\"]
	extent_size = 8192		# 4 Megabytes
	max_lv = 0
	max_pv = 0

	physical_volumes {
		pv0 {
			id = \"uuid-uuid-uuid-uuid\"
			device = \"/dev/sda6\"	# Hint only

			status = [\"ALLOCATABLE\"]
			pe_start = 123
			pe_count = 123456	# many Gigabytes
		}
	}

	logical_volumes {
		LogicalEek {
			id = \"uuid-uuid-uuid-uuid\"
			status = [\"READ\", \"WRITE\", \"VISIBLE\"]
			segment_count = 1

			segment1 {
				start_extent = 0
				extent_count = 123456	# beaucoup Gigabytes

				type = \"striped\"
				stripe_count = 1	# linear

				stripes = [
					\"pv0\", 0
				]
			}
		}
	}
}
"

test LVM.int get "5" = { "int" = "5" }
test LVM.str get "\"abc\"" = { "str" = "abc"}
test LVM.lns get "\n" = {}
test LVM.lns get "#foo\n" = { "#comment" = "foo"}

test LVM.lns get "# Generated by LVM2: date

contents = \"Text Format Volume Group\"
version = 1

description = \"Created *after* executing 'eek'\"

creation_host = \"eek\"		# Linux eek
creation_time = 6666666666	# eeeek\n" =
	{ "#comment" = "Generated by LVM2: date" }
	{}
	{ "contents"
		{ "str" = "Text Format Volume Group" }
	}
	{ "version"
		{ "int" = "1" }
	}
	{}
	{ "description"
		{ "str" = "Created *after* executing 'eek'" }
	}
	{}
	{ "creation_host"
		{ "str" = "eek" }
		{ "#comment" = "Linux eek" }
	}
	{ "creation_time"
		{ "int" = "6666666666" }
		{ "#comment" = "eeeek" }
	}

(* Test: LVM.lns
   Test the full <conf> *)
test LVM.lns get conf =
	{ "#comment" = "Generated by LVM2: date" }
	{}
	{ "contents"
		{ "str" = "Text Format Volume Group" }
	}
	{ "version"
		{ "int" = "1" }
	}
	{}
	{ "description"
		{ "str" = "Created *after* executing 'eek'" }
	}
	{}
	{ "creation_host"
		{ "str" = "eek" }
		{ "#comment" = "Linux eek" }
	}
	{ "creation_time"
		{ "int" = "6666666666" }
		{ "#comment" = "eeeek" }
	}
	{}
	{ "VG1"
		{ "dict"
			{ "id"
				{ "str" = "uuid-uuid-uuid-uuid" }
			}
			{ "seqno"
				{ "int" = "2" }
			}
			{ "status"
				{ "list"
					{ "1"
						{ "str" = "RESIZEABLE" }
					}
					{ "2"
						{ "str" = "READ" }
					}
					{ "3"
						{ "str" = "WRITE" }
					}
				}
			}
			{ "extent_size"
				{ "int" = "8192" }
				{ "#comment" = "4 Megabytes" }
			}
			{ "max_lv"
				{ "int" = "0" }
			}
			{ "max_pv"
				{ "int" = "0" }
			}
			{}
			{ "physical_volumes"
				{ "dict"
					{ "pv0"
						{ "dict"
							{ "id"
								{ "str" = "uuid-uuid-uuid-uuid" }
							}
							{ "device"
								{ "str" = "/dev/sda6" }
								{ "#comment" = "Hint only" }
							}
							{}
							{ "status"
								{ "list"
									{ "1"
										{ "str" = "ALLOCATABLE" }
									}
								}
							}
							{ "pe_start"
								{ "int" = "123" }
							}
							{ "pe_count"
								{ "int" = "123456" }
								{ "#comment" = "many Gigabytes" }
							}
						}
					}
				}
			}
			{}
			{ "logical_volumes"
				{ "dict"
					{ "LogicalEek"
						{ "dict"
							{ "id"
								{ "str" = "uuid-uuid-uuid-uuid" }
							}
							{ "status"
								{ "list"
									{ "1"
										{ "str" = "READ" }
									}
									{ "2"
										{ "str" = "WRITE" }
									}
									{ "3"
										{ "str" = "VISIBLE" }
									}
								}
							}
							{ "segment_count"
								{ "int" = "1" }
							}
							{}
							{ "segment1"
								{ "dict"
									{ "start_extent"
										{ "int" = "0" }
									}
									{ "extent_count"
										{ "int" = "123456" }
										{ "#comment" = "beaucoup Gigabytes" }
									}
									{}
									{ "type"
										{ "str" = "striped" }
									}
									{ "stripe_count"
										{ "int" = "1" }
										{ "#comment" = "linear" }
									}
									{}
									{ "stripes"
										{ "list"
											{ "1"
												{ "str" = "pv0" }
											}
											{ "2"
												{ "int" = "0" }
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

