/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/cbmfs.cpp,v 1.2 2006/07/21 14:46:04 doj Exp $ */

#include "cbmfs.hpp"
#include <string.h>
#include <stdio.h>

void set_bit(BYTE& p, const int num, const int b)
{
  fuse_assert(num>=0 && num<8);
  if(b)
    p |= (1<<num);
  else
    p &= (~(1<<num));
}

int get_bit(const BYTE& p, const int num)
{
  fuse_assert(num>=0 && num<8);
  return p & (1<<num);
}

int d64strlen(const BYTE *s)
{
  fuse_assert(s);
  int l=0;
  while(l<16 && *s!=160) ++l, ++s;
  return l;
}

char *d64strdup(const BYTE *s)
{
  const int l=d64strlen(s);
  char *p=(char*)malloc(l+1);
  fuse_assert(p);
  memcpy(p, s, l);
  p[l]=0;
  return p;
}

int d64strcmp(const BYTE *s1, const char *s2_)
{
  fuse_assert(s1);
  fuse_assert(s2_);
  const BYTE *s2=(const BYTE*)s2_;
  int i=0;
  while(i<16)
    {
      //SYSLOG(LOG_DEBUG, "d64strcmp('%s','%s'): 0x%02X %c 0x%02X %c\n", s1_,s2_,*s1,*s1,*s2,*s2);
      if(*s1==0xA0 && *s2==0)
	return 0;
      if(*s1<*s2)
	return -1;
      if(*s1>*s2)
	return 1;
      ++s1;
      ++s2;
      ++i;
    }
  return 0;
}
