/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/cbmfs.hpp,v 1.3 2006/07/21 15:05:58 doj Exp $ */

#ifndef CBMFS__HPP
#define CBMFS__HPP

#ifdef DOJDEBUG
#include <boost/static_assert.hpp>
#else
#define BOOST_STATIC_ASSERT(x)
#endif

#define FUSE_USE_VERSION 25
#include <fuse.h>
#include <stdlib.h>

#define fuse_assert(x) \
  do { \
    if(!(x)) { \
      struct fuse_context *c=fuse_get_context(); \
      if(c) fuse_exit(c->fuse); \
      else exit(1); \
    } \
  } while(0)

typedef unsigned char BYTE;

#define SECTOR_SIZE 256
#define SECTOR_DATA_SIZE 254

#include <string.h>
#define fix_filename(fn) \
  int len_##fn=strlen(fn); \
  char *fn_##fn=(char*)alloca(len_##fn+1); \
  { \
    int i; \
    if(fn[0] == '/') \
      ++fn, --len_##fn; \
    for(i=0; i<=len_##fn; ++i) \
      if(fn[i] != -1) \
        fn_##fn[i]=fn[i]; \
      else \
        fn_##fn[i]='/'; \
  } \
  fn=fn_##fn;

#include <syslog.h>
#ifdef DOJDEBUG
#define SYSLOG(level, format, a...) syslog(level, format, ## a)
#else
#define SYSLOG(level, format, a...)
#endif

extern uid_t cbmfs_uid;
extern gid_t cbmfs_gid;
extern "C" struct fuse_operations cbmfs_ops;

void set_bit(BYTE& p, const int num, const int b);
int get_bit(const BYTE& p, const int num);
int d64strlen(const BYTE *s);
char *d64strdup(const BYTE *s);
int d64strcmp(const BYTE *s1, const char *s2_);

#endif
